/*
 * Decompiled with CFR 0.152.
 */
package net.regions_unexplored.world.level.feature.tree;

import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.regions_unexplored.block.RuBlocks;
import net.regions_unexplored.data.tags.RuTags;
import net.regions_unexplored.world.level.block.plant.branch.BranchBlock;
import net.regions_unexplored.world.level.feature.configuration.RuTreeConfiguration;

public class PalmTreeFeature
extends Feature<RuTreeConfiguration> {
    public PalmTreeFeature(Codec<RuTreeConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<RuTreeConfiguration> context) {
        RuTreeConfiguration treeConfiguration = (RuTreeConfiguration)context.config();
        BlockPos pos = context.origin();
        RandomSource randomSource = context.random();
        WorldGenLevel level = context.level();
        int height_main = context.random().nextInt(treeConfiguration.sizeVariation) + treeConfiguration.minimumSize;
        int bendChance = randomSource.nextInt(3);
        Direction direction = randomSource.nextInt(4) == 0 ? Direction.NORTH : (randomSource.nextInt(4) == 0 ? Direction.SOUTH : (randomSource.nextInt(4) == 0 ? Direction.EAST : Direction.WEST));
        BlockPos.MutableBlockPos checkPos = pos.mutable();
        for (int check = 0; check <= height_main; ++check) {
            if (!this.checkReplaceable((LevelAccessor)level, (BlockPos)checkPos)) {
                return false;
            }
            checkPos.move(Direction.UP);
            if (check % 3 != 0 || bendChance == 0) continue;
            checkPos.move(direction);
        }
        BlockPos.MutableBlockPos placePos = pos.mutable();
        for (int placeCheck = 0; placeCheck <= height_main; ++placeCheck) {
            this.placeLog((LevelAccessor)level, (BlockPos)placePos, randomSource, treeConfiguration, Direction.Axis.Y);
            if (placeCheck == 0) {
                this.placeRoot((LevelAccessor)level, (BlockPos)placePos, randomSource, treeConfiguration);
                if (bendChance == 0 || randomSource.nextInt(2) == 0) {
                    // empty if block
                }
            }
            if (placeCheck == height_main) {
                this.placeTop((LevelAccessor)level, (BlockPos)placePos, randomSource, treeConfiguration);
            }
            placePos.move(Direction.UP);
            if (placeCheck == 0 || placeCheck % 3 != 0 || bendChance == 0) continue;
            placePos.move(direction);
        }
        return true;
    }

    public void placeTop(LevelAccessor level, BlockPos pos, RandomSource randomSource, RuTreeConfiguration treeConfiguration) {
        if (level.getBlockState(pos.north()).canBeReplaced() && !level.isOutsideBuildHeight(pos.north())) {
            level.setBlock(pos.north(), (BlockState)treeConfiguration.branchProvider.getState(randomSource, pos).setValue((Property)BranchBlock.FACING, (Comparable)Direction.NORTH), 2);
        }
        if (level.getBlockState(pos.south()).canBeReplaced() && !level.isOutsideBuildHeight(pos.south())) {
            level.setBlock(pos.south(), (BlockState)treeConfiguration.branchProvider.getState(randomSource, pos).setValue((Property)BranchBlock.FACING, (Comparable)Direction.SOUTH), 2);
        }
        if (level.getBlockState(pos.east()).canBeReplaced() && !level.isOutsideBuildHeight(pos.east())) {
            level.setBlock(pos.east(), (BlockState)treeConfiguration.branchProvider.getState(randomSource, pos).setValue((Property)BranchBlock.FACING, (Comparable)Direction.EAST), 2);
        }
        if (level.getBlockState(pos.west()).canBeReplaced() && !level.isOutsideBuildHeight(pos.west())) {
            level.setBlock(pos.west(), (BlockState)treeConfiguration.branchProvider.getState(randomSource, pos).setValue((Property)BranchBlock.FACING, (Comparable)Direction.WEST), 2);
        }
        this.placeLeavesBlock(level, pos.north().east(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.north().west(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.south().east(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.south().west(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.above(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.above().north(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.above().south(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.above().east(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.above().west(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.above().north().east(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.above().north().west(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.above().south().east(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.above().south().west(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.above().above().north(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.above().above().south(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.above().above().east(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.above().above().west(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.above().above().north().north(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.above().above().south().south(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.above().above().east().east(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.above().above().west().west(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.above().above().above().north().north(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.above().above().above().south().south(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.above().above().above().east().east(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.above().above().above().west().west(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.above().above().north().north().north(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.above().above().south().south().south(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.above().above().east().east().east(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.above().above().west().west().west(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.above().north().north().north(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.above().south().south().south(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.above().east().east().east(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.above().west().west().west(), randomSource, treeConfiguration);
    }

    public boolean placeLog(LevelAccessor level, BlockPos pos, RandomSource randomSource, RuTreeConfiguration treeConfiguration, Direction.Axis axis) {
        Random random = new Random();
        if (level.isOutsideBuildHeight(pos)) {
            return true;
        }
        if (level.getBlockState(pos).is(RuBlocks.PEAT_GRASS_BLOCK.get())) {
            level.setBlock(pos, RuBlocks.PEAT_DIRT.get().defaultBlockState(), 2);
        } else if (level.getBlockState(pos).is(RuBlocks.SILT_GRASS_BLOCK.get())) {
            level.setBlock(pos, RuBlocks.SILT_DIRT.get().defaultBlockState(), 2);
        } else if (level.getBlockState(pos).is(RuBlocks.ALPHA_GRASS_BLOCK.get())) {
            level.setBlock(pos, Blocks.DIRT.defaultBlockState(), 2);
        } else if (level.getBlockState(pos).is(Blocks.GRASS_BLOCK)) {
            level.setBlock(pos, Blocks.DIRT.defaultBlockState(), 2);
        } else if (PalmTreeFeature.isReplaceable((LevelSimulatedReader)level, pos)) {
            level.setBlock(pos, (BlockState)treeConfiguration.trunkProvider.getState(randomSource, pos).setValue((Property)RotatedPillarBlock.AXIS, (Comparable)axis), 2);
        } else {
            return true;
        }
        if (level.getBlockState(pos.below()).is(RuBlocks.PEAT_GRASS_BLOCK.get())) {
            level.setBlock(pos.below(), RuBlocks.PEAT_DIRT.get().defaultBlockState(), 2);
        } else if (level.getBlockState(pos.below()).is(RuBlocks.SILT_GRASS_BLOCK.get())) {
            level.setBlock(pos.below(), RuBlocks.SILT_DIRT.get().defaultBlockState(), 2);
        } else if (level.getBlockState(pos.below()).is(RuBlocks.ALPHA_GRASS_BLOCK.get())) {
            level.setBlock(pos.below(), Blocks.DIRT.defaultBlockState(), 2);
        } else if (level.getBlockState(pos.below()).is(Blocks.GRASS_BLOCK)) {
            level.setBlock(pos.below(), Blocks.DIRT.defaultBlockState(), 2);
        }
        return true;
    }

    public boolean placeLeavesBlock(LevelAccessor level, BlockPos pos, RandomSource randomSource, RuTreeConfiguration treeConfiguration) {
        Random random = new Random();
        if (level.isOutsideBuildHeight(pos)) {
            return true;
        }
        if (level.getBlockState(pos).canBeReplaced()) {
            level.setBlock(pos, (BlockState)treeConfiguration.foliageProvider.getState(randomSource, pos).setValue((Property)LeavesBlock.DISTANCE, (Comparable)Integer.valueOf(1)), 2);
        }
        return true;
    }

    public void placeRoot(LevelAccessor level, BlockPos pos, RandomSource randomSource, RuTreeConfiguration treeConfiguration) {
        Random random = new Random();
        int rd = random.nextInt(2) + 4;
        BlockPos.MutableBlockPos placePos = pos.mutable();
        for (int i = 0; i <= rd; ++i) {
            if (level.getBlockState((BlockPos)placePos).canBeReplaced() && level.getBlockState(placePos.above()).is(BlockTags.DIRT)) {
                level.setBlock((BlockPos)placePos, Blocks.HANGING_ROOTS.defaultBlockState(), 2);
                break;
            }
            if (!level.getBlockState((BlockPos)placePos).is(BlockTags.DIRT) && !level.getBlockState((BlockPos)placePos).is(BlockTags.REPLACEABLE_BY_TREES) && !level.isEmptyBlock((BlockPos)placePos)) break;
            this.placeLog(level, (BlockPos)placePos, randomSource, treeConfiguration, Direction.Axis.Y);
            placePos.move(Direction.DOWN);
        }
    }

    public boolean checkReplaceable(LevelAccessor level, BlockPos pos) {
        if (level.isOutsideBuildHeight(pos)) {
            return false;
        }
        return PalmTreeFeature.isReplaceable((LevelSimulatedReader)level, pos);
    }

    public static boolean isReplaceableDirtBlock(BlockState state) {
        return state.is(RuTags.TREE_GRASS_REPLACEABLES);
    }

    public static boolean isReplaceableDirt(LevelSimulatedReader reader, BlockPos pos) {
        return reader.isStateAtPosition(pos, PalmTreeFeature::isReplaceableDirtBlock);
    }

    public static boolean isReplaceableBlock(BlockState state) {
        return state.is(RuTags.REPLACEABLE_BLOCKS);
    }

    public static boolean isReplaceable(LevelSimulatedReader reader, BlockPos pos) {
        return reader.isStateAtPosition(pos, PalmTreeFeature::isReplaceableBlock);
    }
}

