/*
 * Decompiled with CFR 0.152.
 */
package net.regions_unexplored.registry;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.grower.TreeGrower;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.regions_unexplored.block.sapling.RuUltraFromMegaTreeGrower;
import net.regions_unexplored.block.sapling.RuUltraFromSuperTreeGrower;
import net.regions_unexplored.platform.Services;
import net.regions_unexplored.registry.ItemRegistry;
import net.regions_unexplored.world.level.block.leaves.AppleLeavesBlock;
import net.regions_unexplored.world.level.block.leaves.BlueMagnoliaLeavesBlock;
import net.regions_unexplored.world.level.block.leaves.BrimwoodLeavesBlock;
import net.regions_unexplored.world.level.block.leaves.EnchantedBirchLeavesBlock;
import net.regions_unexplored.world.level.block.leaves.JoshuaLeavesBlock;
import net.regions_unexplored.world.level.block.leaves.MauveLeavesBlock;
import net.regions_unexplored.world.level.block.leaves.OrangeMapleLeavesBlock;
import net.regions_unexplored.world.level.block.leaves.PinkMagnoliaLeavesBlock;
import net.regions_unexplored.world.level.block.leaves.RedMapleLeavesBlock;
import net.regions_unexplored.world.level.block.leaves.SilverBirchLeavesBlock;
import net.regions_unexplored.world.level.block.leaves.WhiteMagnoliaLeavesBlock;
import net.regions_unexplored.world.level.block.plant.sapling.RuUltraFromMegaSaplingBlock;
import net.regions_unexplored.world.level.block.plant.sapling.RuUltraFromSuperSaplingBlock;
import net.regions_unexplored.world.level.block.sign.RuCeilingHangingSignBlock;
import net.regions_unexplored.world.level.block.sign.RuStandingSignBlock;
import net.regions_unexplored.world.level.block.sign.RuWallHangingSignBlock;
import net.regions_unexplored.world.level.block.sign.RuWallSignBlock;
import net.regions_unexplored.world.level.block.wood.AspenLogBlock;
import net.regions_unexplored.world.level.block.wood.MagmaLogBlock;
import net.regions_unexplored.world.level.block.wood.PineLogBlock;

public class BlockRegistry {
    public static Supplier<Block> registerDefaultBlock(String name, Supplier<Block> block) {
        Supplier<Block> toReturn = Services.REGISTAR.registerBlock(name, block);
        ItemRegistry.registerDefaultBlockItem(name, toReturn);
        return toReturn;
    }

    public static Supplier<Block> registerDefaultBlockNoItem(String name, Supplier<Block> block) {
        return Services.REGISTAR.registerBlock(name, block);
    }

    public static Supplier<Block> registerSaplingBlock(String name, TreeGrower grower) {
        return BlockRegistry.registerDefaultBlock(name, () -> new SaplingBlock(grower, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_SAPLING)));
    }

    public static Supplier<Block> registerMegaSaplingBlock(String name, RuUltraFromMegaTreeGrower grower) {
        return BlockRegistry.registerDefaultBlock(name, () -> new RuUltraFromMegaSaplingBlock(grower, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_SAPLING)));
    }

    public static Supplier<Block> registerSuperSaplingBlock(String name, RuUltraFromSuperTreeGrower grower) {
        return BlockRegistry.registerDefaultBlock(name, () -> new RuUltraFromSuperSaplingBlock(grower, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_SAPLING)));
    }

    public static Supplier<Block> registerNetherSaplingBlock(String name, TreeGrower grower) {
        return BlockRegistry.registerDefaultBlock(name, () -> new SaplingBlock(grower, BlockBehaviour.Properties.of().pushReaction(PushReaction.DESTROY).noCollission().instabreak().sound(SoundType.NETHER_SPROUTS).randomTicks()));
    }

    public static Supplier<Block> registerPlaceOnWaterBlock(String name, Supplier<Block> block) {
        Supplier<Block> toReturn = Services.REGISTAR.registerBlock(name, block);
        ItemRegistry.registerPlaceOnWaterItem(name, toReturn);
        return toReturn;
    }

    public static PineLogBlock pineLog(MapColor colour, MapColor colour2, SoundType sound) {
        return new PineLogBlock(BlockBehaviour.Properties.of().mapColor(p_152624_ -> p_152624_.getValue((Property)RotatedPillarBlock.AXIS) == Direction.Axis.Y ? colour : colour2).instrument(NoteBlockInstrument.BASS).strength(2.0f).sound(sound).ignitedByLava());
    }

    public static AspenLogBlock aspenLogBlock(MapColor colour, MapColor colour2, SoundType sound) {
        return new AspenLogBlock(BlockBehaviour.Properties.of().mapColor(p_152624_ -> p_152624_.getValue((Property)RotatedPillarBlock.AXIS) == Direction.Axis.Y ? colour : colour2).instrument(NoteBlockInstrument.BASS).strength(2.0f).sound(sound).ignitedByLava());
    }

    public static RotatedPillarBlock log(MapColor colour, MapColor colour2, SoundType sound) {
        return new RotatedPillarBlock(BlockBehaviour.Properties.of().mapColor(p_152624_ -> p_152624_.getValue((Property)RotatedPillarBlock.AXIS) == Direction.Axis.Y ? colour : colour2).instrument(NoteBlockInstrument.BASS).strength(2.0f).sound(sound).ignitedByLava());
    }

    public static RotatedPillarBlock woodBlock(MapColor colour, SoundType sound) {
        return new RotatedPillarBlock(BlockBehaviour.Properties.of().mapColor(colour).instrument(NoteBlockInstrument.BASS).strength(2.0f, 3.0f).sound(sound).ignitedByLava());
    }

    public static Block woodPlanks(MapColor colour, SoundType sound) {
        return new Block(BlockBehaviour.Properties.of().mapColor(colour).instrument(NoteBlockInstrument.BASS).strength(2.0f, 3.0f).sound(sound).ignitedByLava());
    }

    public static StairBlock woodStairs(MapColor colour, SoundType sound) {
        return new StairBlock(Blocks.OAK_PLANKS.defaultBlockState(), BlockBehaviour.Properties.of().mapColor(colour).instrument(NoteBlockInstrument.BASS).strength(2.0f, 3.0f).sound(sound).ignitedByLava());
    }

    public static SlabBlock woodSlab(MapColor colour, SoundType sound) {
        return new SlabBlock(BlockBehaviour.Properties.of().mapColor(colour).instrument(NoteBlockInstrument.BASS).strength(2.0f, 3.0f).sound(sound).ignitedByLava());
    }

    public static DoorBlock woodDoor(MapColor colour, SoundType sound, BlockSetType blockSetType) {
        return new DoorBlock(blockSetType, BlockBehaviour.Properties.of().mapColor(colour).instrument(NoteBlockInstrument.BASS).strength(3.0f).sound(sound).noOcclusion().ignitedByLava());
    }

    public static TrapDoorBlock woodTrapDoor(MapColor colour, SoundType sound, BlockSetType blockSetType) {
        return new TrapDoorBlock(blockSetType, BlockBehaviour.Properties.of().mapColor(colour).instrument(NoteBlockInstrument.BASS).strength(3.0f).sound(sound).noOcclusion().ignitedByLava());
    }

    public static FenceBlock woodFence(MapColor colour, SoundType sound) {
        return new FenceBlock(BlockBehaviour.Properties.of().mapColor(colour).instrument(NoteBlockInstrument.BASS).strength(2.0f, 3.0f).sound(sound).ignitedByLava());
    }

    public static FenceGateBlock woodFenceGate(MapColor colour, WoodType type, SoundType sound) {
        return new FenceGateBlock(type, BlockBehaviour.Properties.of().mapColor(colour).instrument(NoteBlockInstrument.BASS).strength(2.0f, 3.0f).sound(sound).ignitedByLava());
    }

    public static PressurePlateBlock woodPressurePlate(MapColor colour, SoundType sound, BlockSetType blockSetType) {
        return new PressurePlateBlock(blockSetType, BlockBehaviour.Properties.of().mapColor(colour).instrument(NoteBlockInstrument.BASS).noCollission().strength(0.5f).sound(sound).ignitedByLava());
    }

    public static ButtonBlock woodButton(SoundType sound, BlockSetType blockSetType) {
        return new ButtonBlock(blockSetType, 30, BlockBehaviour.Properties.of().noCollission().strength(0.5f).sound(sound));
    }

    public static RuStandingSignBlock sign(SoundType sound, WoodType woodType) {
        return new RuStandingSignBlock(BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.BASS).noCollission().strength(1.0f).sound(sound).ignitedByLava(), woodType);
    }

    public static RuWallSignBlock wallSign(SoundType sound, Block block, WoodType woodType) {
        return new RuWallSignBlock(BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.BASS).noCollission().strength(1.0f).sound(sound).ignitedByLava().dropsLike(block), woodType);
    }

    public static RuCeilingHangingSignBlock hangingSign(MapColor color, SoundType sound, WoodType woodType) {
        return new RuCeilingHangingSignBlock(BlockBehaviour.Properties.of().mapColor(color).forceSolidOn().instrument(NoteBlockInstrument.BASS).noCollission().strength(1.0f).ignitedByLava().sound(sound), woodType);
    }

    public static RuWallHangingSignBlock wallHangingSign(MapColor color, SoundType sound, Block block, WoodType woodType) {
        return new RuWallHangingSignBlock(BlockBehaviour.Properties.of().mapColor(color).forceSolidOn().instrument(NoteBlockInstrument.BASS).noCollission().strength(1.0f).ignitedByLava().sound(sound).dropsLike(block), woodType);
    }

    public static RotatedPillarBlock fireproofLog(MapColor colour, MapColor colour2, SoundType sound) {
        return new RotatedPillarBlock(BlockBehaviour.Properties.of().mapColor(p_152624_ -> p_152624_.getValue((Property)RotatedPillarBlock.AXIS) == Direction.Axis.Y ? colour : colour2).instrument(NoteBlockInstrument.BASS).strength(2.0f).sound(sound));
    }

    public static MagmaLogBlock fireproofMagmaLog(MapColor colour, SoundType sound) {
        return new MagmaLogBlock(BlockBehaviour.Properties.of().mapColor(colour).instrument(NoteBlockInstrument.BASS).strength(2.0f).sound(sound));
    }

    public static RotatedPillarBlock fireproofWoodBlock(MapColor colour, SoundType sound) {
        return new RotatedPillarBlock(BlockBehaviour.Properties.of().mapColor(colour).instrument(NoteBlockInstrument.BASS).strength(2.0f, 3.0f).sound(sound));
    }

    public static Block fireproofWoodPlanks(MapColor colour, SoundType sound) {
        return new Block(BlockBehaviour.Properties.of().mapColor(colour).instrument(NoteBlockInstrument.BASS).strength(2.0f, 3.0f).sound(sound));
    }

    public static StairBlock fireproofWoodStairs(MapColor colour, SoundType sound) {
        return new StairBlock(Blocks.OAK_PLANKS.defaultBlockState(), BlockBehaviour.Properties.of().mapColor(colour).instrument(NoteBlockInstrument.BASS).strength(2.0f, 3.0f).sound(sound));
    }

    public static SlabBlock fireproofWoodSlab(MapColor colour, SoundType sound) {
        return new SlabBlock(BlockBehaviour.Properties.of().mapColor(colour).instrument(NoteBlockInstrument.BASS).strength(2.0f, 3.0f).sound(sound));
    }

    public static DoorBlock fireproofWoodDoor(MapColor colour, SoundType sound, BlockSetType blockSetType) {
        return new DoorBlock(blockSetType, BlockBehaviour.Properties.of().mapColor(colour).instrument(NoteBlockInstrument.BASS).strength(3.0f).sound(sound).noOcclusion());
    }

    public static TrapDoorBlock fireproofWoodTrapDoor(MapColor colour, SoundType sound, BlockSetType blockSetType) {
        return new TrapDoorBlock(blockSetType, BlockBehaviour.Properties.of().mapColor(colour).instrument(NoteBlockInstrument.BASS).strength(3.0f).sound(sound).noOcclusion());
    }

    public static FenceBlock fireproofWoodFence(MapColor colour, SoundType sound) {
        return new FenceBlock(BlockBehaviour.Properties.of().mapColor(colour).instrument(NoteBlockInstrument.BASS).strength(2.0f, 3.0f).sound(sound).ignitedByLava());
    }

    public static FenceGateBlock fireproofWoodFenceGate(MapColor colour, WoodType type, SoundType sound) {
        return new FenceGateBlock(type, BlockBehaviour.Properties.of().mapColor(colour).instrument(NoteBlockInstrument.BASS).strength(2.0f, 3.0f).sound(sound));
    }

    public static PressurePlateBlock fireproofWoodPressurePlate(MapColor colour, SoundType sound, BlockSetType blockSetType) {
        return new PressurePlateBlock(blockSetType, BlockBehaviour.Properties.of().mapColor(colour).instrument(NoteBlockInstrument.BASS).noCollission().strength(0.5f).sound(sound));
    }

    public static ButtonBlock fireproofWoodButton(SoundType sound, BlockSetType blockSetType) {
        return new ButtonBlock(blockSetType, 30, BlockBehaviour.Properties.of().noCollission().strength(0.5f).sound(sound));
    }

    public static RuStandingSignBlock fireproofSign(SoundType sound, WoodType woodType) {
        return new RuStandingSignBlock(BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.BASS).noCollission().strength(1.0f).sound(sound), woodType);
    }

    public static RuWallSignBlock fireproofWallSign(SoundType sound, Block block, WoodType woodType) {
        return new RuWallSignBlock(BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.BASS).noCollission().strength(1.0f).sound(sound).dropsLike(block), woodType);
    }

    public static RuCeilingHangingSignBlock fireproofHangingSign(MapColor color, SoundType sound, WoodType woodType) {
        return new RuCeilingHangingSignBlock(BlockBehaviour.Properties.of().mapColor(color).forceSolidOn().instrument(NoteBlockInstrument.BASS).noCollission().strength(1.0f).sound(sound), woodType);
    }

    public static RuWallHangingSignBlock fireproofWallHangingSign(MapColor color, SoundType sound, Block block, WoodType woodType) {
        return new RuWallHangingSignBlock(BlockBehaviour.Properties.of().mapColor(color).forceSolidOn().instrument(NoteBlockInstrument.BASS).noCollission().strength(1.0f).sound(sound).dropsLike(block), woodType);
    }

    public static LeavesBlock leaves(MapColor colour) {
        return new LeavesBlock(BlockBehaviour.Properties.of().mapColor(colour).ignitedByLava().strength(0.2f).randomTicks().sound(SoundType.GRASS).noOcclusion().isValidSpawn(BlockRegistry::ocelotOrParrot).isSuffocating(BlockRegistry::never).isViewBlocking(BlockRegistry::never).pushReaction(PushReaction.DESTROY).isRedstoneConductor(BlockRegistry::never));
    }

    public static LeavesBlock fireproofLeaves(MapColor colour) {
        return new LeavesBlock(BlockBehaviour.Properties.of().mapColor(colour).strength(0.2f).randomTicks().sound(SoundType.GRASS).noOcclusion().isValidSpawn(BlockRegistry::ocelotOrParrot).isSuffocating(BlockRegistry::never).isViewBlocking(BlockRegistry::never).pushReaction(PushReaction.DESTROY).isRedstoneConductor(BlockRegistry::never));
    }

    public static MauveLeavesBlock mauveLeaves(MapColor colour) {
        return new MauveLeavesBlock(BlockBehaviour.Properties.of().mapColor(colour).ignitedByLava().strength(0.2f).randomTicks().sound(SoundType.GRASS).noOcclusion().isValidSpawn(BlockRegistry::ocelotOrParrot).isSuffocating(BlockRegistry::never).isViewBlocking(BlockRegistry::never).pushReaction(PushReaction.DESTROY).isRedstoneConductor(BlockRegistry::never));
    }

    public static BlueMagnoliaLeavesBlock blueMagnoliaLeaves(MapColor colour) {
        return new BlueMagnoliaLeavesBlock(BlockBehaviour.Properties.of().mapColor(colour).ignitedByLava().strength(0.2f).randomTicks().sound(SoundType.GRASS).noOcclusion().isValidSpawn(BlockRegistry::ocelotOrParrot).isSuffocating(BlockRegistry::never).isViewBlocking(BlockRegistry::never).pushReaction(PushReaction.DESTROY).isRedstoneConductor(BlockRegistry::never));
    }

    public static PinkMagnoliaLeavesBlock pinkMagnoliaLeaves(MapColor colour) {
        return new PinkMagnoliaLeavesBlock(BlockBehaviour.Properties.of().mapColor(colour).ignitedByLava().strength(0.2f).randomTicks().sound(SoundType.GRASS).noOcclusion().isValidSpawn(BlockRegistry::ocelotOrParrot).isSuffocating(BlockRegistry::never).isViewBlocking(BlockRegistry::never).pushReaction(PushReaction.DESTROY).isRedstoneConductor(BlockRegistry::never));
    }

    public static WhiteMagnoliaLeavesBlock whiteMagnoliaLeaves(MapColor colour) {
        return new WhiteMagnoliaLeavesBlock(BlockBehaviour.Properties.of().mapColor(colour).ignitedByLava().strength(0.2f).randomTicks().sound(SoundType.GRASS).noOcclusion().isValidSpawn(BlockRegistry::ocelotOrParrot).isSuffocating(BlockRegistry::never).isViewBlocking(BlockRegistry::never).pushReaction(PushReaction.DESTROY).isRedstoneConductor(BlockRegistry::never));
    }

    public static SilverBirchLeavesBlock silverBirchLeaves(MapColor colour) {
        return new SilverBirchLeavesBlock(BlockBehaviour.Properties.of().mapColor(colour).ignitedByLava().strength(0.2f).randomTicks().sound(SoundType.GRASS).noOcclusion().isValidSpawn(BlockRegistry::ocelotOrParrot).isSuffocating(BlockRegistry::never).isViewBlocking(BlockRegistry::never).pushReaction(PushReaction.DESTROY).isRedstoneConductor(BlockRegistry::never));
    }

    public static EnchantedBirchLeavesBlock enchantedBirchLeaves(MapColor colour) {
        return new EnchantedBirchLeavesBlock(BlockBehaviour.Properties.of().mapColor(colour).ignitedByLava().strength(0.2f).randomTicks().sound(SoundType.GRASS).noOcclusion().isValidSpawn(BlockRegistry::ocelotOrParrot).isSuffocating(BlockRegistry::never).isViewBlocking(BlockRegistry::never).pushReaction(PushReaction.DESTROY).isRedstoneConductor(BlockRegistry::never));
    }

    public static RedMapleLeavesBlock redMapleLeaves(MapColor colour) {
        return new RedMapleLeavesBlock(BlockBehaviour.Properties.of().mapColor(colour).ignitedByLava().strength(0.2f).randomTicks().sound(SoundType.GRASS).noOcclusion().isValidSpawn(BlockRegistry::ocelotOrParrot).isSuffocating(BlockRegistry::never).isViewBlocking(BlockRegistry::never).pushReaction(PushReaction.DESTROY).isRedstoneConductor(BlockRegistry::never));
    }

    public static OrangeMapleLeavesBlock orangeMapleLeaves(MapColor colour) {
        return new OrangeMapleLeavesBlock(BlockBehaviour.Properties.of().mapColor(colour).ignitedByLava().strength(0.2f).randomTicks().sound(SoundType.GRASS).noOcclusion().isValidSpawn(BlockRegistry::ocelotOrParrot).isSuffocating(BlockRegistry::never).isViewBlocking(BlockRegistry::never).pushReaction(PushReaction.DESTROY).isRedstoneConductor(BlockRegistry::never));
    }

    public static JoshuaLeavesBlock joshuaLeaves(MapColor colour) {
        return new JoshuaLeavesBlock(BlockBehaviour.Properties.of().pushReaction(PushReaction.BLOCK).mapColor(colour).ignitedByLava().strength(0.2f).randomTicks().sound(SoundType.GRASS).noOcclusion().noCollission().pushReaction(PushReaction.DESTROY).isRedstoneConductor(BlockRegistry::never));
    }

    public static LeavesBlock appleLeaves(MapColor colour) {
        return new AppleLeavesBlock(BlockBehaviour.Properties.of().mapColor(colour).ignitedByLava().strength(0.2f).randomTicks().sound(SoundType.GRASS).noOcclusion().isValidSpawn(BlockRegistry::ocelotOrParrot).isSuffocating(BlockRegistry::never).isViewBlocking(BlockRegistry::never).pushReaction(PushReaction.DESTROY).isRedstoneConductor(BlockRegistry::never));
    }

    public static BrimwoodLeavesBlock brimLeaves(MapColor colour) {
        return new BrimwoodLeavesBlock(colour);
    }

    public static Boolean always(BlockState state, BlockGetter getter, BlockPos pos, EntityType<?> type) {
        return true;
    }

    public static boolean always(BlockState state, BlockGetter getter, BlockPos pos) {
        return true;
    }

    public static Boolean never(BlockState state, BlockGetter getter, BlockPos pos, EntityType<?> type) {
        return false;
    }

    public static boolean never(BlockState state, BlockGetter getter, BlockPos pos) {
        return false;
    }

    public static Boolean ocelotOrParrot(BlockState state, BlockGetter getter, BlockPos pos, EntityType<?> type) {
        return type == EntityType.OCELOT || type == EntityType.PARROT;
    }
}

