/*
 * Decompiled with CFR 0.152.
 */
package net.regions_unexplored.registry;

import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.SurfaceRules;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.regions_unexplored.config.RuCommonConfig;
import net.regions_unexplored.data.worldgen.biome.RuBiomes;
import net.regions_unexplored.data.worldgen.biome.builder.AquaticBiomes;
import net.regions_unexplored.data.worldgen.biome.builder.AridBiomes;
import net.regions_unexplored.data.worldgen.biome.builder.CaveBiomes;
import net.regions_unexplored.data.worldgen.biome.builder.CoastalBiomes;
import net.regions_unexplored.data.worldgen.biome.builder.ForestBiomes;
import net.regions_unexplored.data.worldgen.biome.builder.FrozenBiomes;
import net.regions_unexplored.data.worldgen.biome.builder.MountainBiomes;
import net.regions_unexplored.data.worldgen.biome.builder.NetherBiomes;
import net.regions_unexplored.data.worldgen.biome.builder.PlainsBiomes;
import net.regions_unexplored.data.worldgen.biome.builder.TaigaBiomes;
import net.regions_unexplored.data.worldgen.biome.builder.WetBiomes;
import net.regions_unexplored.data.worldgen.biome.surface.RuSurfaceRuleData;
import net.regions_unexplored.world.level.region.RuRegionNether;
import net.regions_unexplored.world.level.region.RuRegionPrimary;
import net.regions_unexplored.world.level.region.RuRegionSecondary;
import terrablender.api.Region;
import terrablender.api.Regions;
import terrablender.api.SurfaceRuleManager;

public class BiomeRegistry {
    public static void addBiomes() {
        BiomeRegistry.registerVillagerTypes();
    }

    public static void setupTerrablender() {
        Regions.register((Region)new RuRegionPrimary((Integer)RuCommonConfig.REGION_PRIMARY_WEIGHT.get()));
        Regions.register((Region)new RuRegionSecondary((Integer)RuCommonConfig.REGION_SECONDARY_WEIGHT.get()));
        Regions.register((Region)new RuRegionNether((Integer)RuCommonConfig.REGION_NETHER_WEIGHT.get()));
        SurfaceRuleManager.addSurfaceRules((SurfaceRuleManager.RuleCategory)SurfaceRuleManager.RuleCategory.NETHER, (String)"regions_unexplored", (SurfaceRules.RuleSource)RuSurfaceRuleData.nether());
        SurfaceRuleManager.addSurfaceRules((SurfaceRuleManager.RuleCategory)SurfaceRuleManager.RuleCategory.OVERWORLD, (String)"regions_unexplored", (SurfaceRules.RuleSource)RuSurfaceRuleData.overworld());
    }

    public static void bootstrap(BootstrapContext<Biome> context) {
        HolderGetter carversGetter = context.lookup(Registries.CONFIGURED_CARVER);
        HolderGetter featuresGetter = context.lookup(Registries.PLACED_FEATURE);
        BiomeRegistry.register(context, RuBiomes.AUTUMNAL_MAPLE_FOREST, ForestBiomes.autumnalMapleForest((HolderGetter<PlacedFeature>)featuresGetter, carversGetter));
        BiomeRegistry.register(context, RuBiomes.BAMBOO_FOREST, ForestBiomes.bambooForest((HolderGetter<PlacedFeature>)featuresGetter, carversGetter));
        BiomeRegistry.register(context, RuBiomes.MAGNOLIA_WOODLAND, ForestBiomes.magnoliaHighlands((HolderGetter<PlacedFeature>)featuresGetter, carversGetter));
        BiomeRegistry.register(context, RuBiomes.DECIDUOUS_FOREST, ForestBiomes.deciduousForest((HolderGetter<PlacedFeature>)featuresGetter, carversGetter));
        BiomeRegistry.register(context, RuBiomes.MAPLE_FOREST, ForestBiomes.mapleForest((HolderGetter<PlacedFeature>)featuresGetter, carversGetter));
        BiomeRegistry.register(context, RuBiomes.MAUVE_HILLS, ForestBiomes.mauveHills((HolderGetter<PlacedFeature>)featuresGetter, carversGetter));
        BiomeRegistry.register(context, RuBiomes.ORCHARD, ForestBiomes.orchard((HolderGetter<PlacedFeature>)featuresGetter, carversGetter));
        BiomeRegistry.register(context, RuBiomes.SILVER_BIRCH_FOREST, ForestBiomes.silverBirchForest((HolderGetter<PlacedFeature>)featuresGetter, carversGetter));
        BiomeRegistry.register(context, RuBiomes.TEMPERATE_GROVE, ForestBiomes.temperateGrove((HolderGetter<PlacedFeature>)featuresGetter, carversGetter));
        BiomeRegistry.register(context, RuBiomes.WILLOW_FOREST, ForestBiomes.willowForest((HolderGetter<PlacedFeature>)featuresGetter, carversGetter));
        BiomeRegistry.register(context, RuBiomes.BLACKWOOD_TAIGA, TaigaBiomes.blackwoodTaiga((HolderGetter<PlacedFeature>)featuresGetter, carversGetter));
        BiomeRegistry.register(context, RuBiomes.BOREAL_TAIGA, TaigaBiomes.borealTaiga((HolderGetter<PlacedFeature>)featuresGetter, carversGetter));
        BiomeRegistry.register(context, RuBiomes.GOLDEN_BOREAL_TAIGA, TaigaBiomes.goldenBorealTaiga((HolderGetter<PlacedFeature>)featuresGetter, carversGetter));
        BiomeRegistry.register(context, RuBiomes.PINE_TAIGA, TaigaBiomes.pineTaiga((HolderGetter<PlacedFeature>)featuresGetter, carversGetter));
        BiomeRegistry.register(context, RuBiomes.REDWOODS, TaigaBiomes.redwoods((HolderGetter<PlacedFeature>)featuresGetter, carversGetter));
        BiomeRegistry.register(context, RuBiomes.SPARSE_REDWOODS, TaigaBiomes.sparseRedwoods((HolderGetter<PlacedFeature>)featuresGetter, carversGetter));
        BiomeRegistry.register(context, RuBiomes.BARLEY_FIELDS, PlainsBiomes.barleyFields((HolderGetter<PlacedFeature>)featuresGetter, carversGetter));
        BiomeRegistry.register(context, RuBiomes.FLOWER_FIELDS, PlainsBiomes.flowerFields((HolderGetter<PlacedFeature>)featuresGetter, carversGetter));
        BiomeRegistry.register(context, RuBiomes.GRASSLAND, PlainsBiomes.grassland((HolderGetter<PlacedFeature>)featuresGetter, carversGetter));
        BiomeRegistry.register(context, RuBiomes.CLOVER_PLAINS, PlainsBiomes.cloverPlains((HolderGetter<PlacedFeature>)featuresGetter, carversGetter));
        BiomeRegistry.register(context, RuBiomes.ROCKY_MEADOW, PlainsBiomes.rockyMeadow((HolderGetter<PlacedFeature>)featuresGetter, carversGetter));
        BiomeRegistry.register(context, RuBiomes.POPPY_FIELDS, PlainsBiomes.poppyFields((HolderGetter<PlacedFeature>)featuresGetter, carversGetter));
        BiomeRegistry.register(context, RuBiomes.PRAIRIE, PlainsBiomes.prairie((HolderGetter<PlacedFeature>)featuresGetter, carversGetter));
        BiomeRegistry.register(context, RuBiomes.PUMPKIN_FIELDS, PlainsBiomes.pumpkinFields((HolderGetter<PlacedFeature>)featuresGetter, carversGetter));
        BiomeRegistry.register(context, RuBiomes.SHRUBLAND, PlainsBiomes.shrubland((HolderGetter<PlacedFeature>)featuresGetter, carversGetter));
        BiomeRegistry.register(context, RuBiomes.BAYOU, WetBiomes.bayou((HolderGetter<PlacedFeature>)featuresGetter, carversGetter));
        BiomeRegistry.register(context, RuBiomes.EUCALYPTUS_FOREST, WetBiomes.eucalyptusForest((HolderGetter<PlacedFeature>)featuresGetter, carversGetter));
        BiomeRegistry.register(context, RuBiomes.FEN, WetBiomes.fen((HolderGetter<PlacedFeature>)featuresGetter, carversGetter));
        BiomeRegistry.register(context, RuBiomes.MARSH, WetBiomes.marsh((HolderGetter<PlacedFeature>)featuresGetter, carversGetter));
        BiomeRegistry.register(context, RuBiomes.FUNGAL_FEN, WetBiomes.fungalFen((HolderGetter<PlacedFeature>)featuresGetter, carversGetter));
        BiomeRegistry.register(context, RuBiomes.OLD_GROWTH_BAYOU, WetBiomes.oldGrowthBayou((HolderGetter<PlacedFeature>)featuresGetter, carversGetter));
        BiomeRegistry.register(context, RuBiomes.SPARSE_RAINFOREST, WetBiomes.rainforest((HolderGetter<PlacedFeature>)featuresGetter, carversGetter, false));
        BiomeRegistry.register(context, RuBiomes.RAINFOREST, WetBiomes.rainforest((HolderGetter<PlacedFeature>)featuresGetter, carversGetter, true));
        BiomeRegistry.register(context, RuBiomes.BAOBAB_SAVANNA, AridBiomes.baobabSavanna((HolderGetter<PlacedFeature>)featuresGetter, carversGetter));
        BiomeRegistry.register(context, RuBiomes.DRY_BUSHLAND, AridBiomes.dryBushland((HolderGetter<PlacedFeature>)featuresGetter, carversGetter));
        BiomeRegistry.register(context, RuBiomes.JOSHUA_DESERT, AridBiomes.joshuaDesert((HolderGetter<PlacedFeature>)featuresGetter, carversGetter));
        BiomeRegistry.register(context, RuBiomes.OUTBACK, AridBiomes.outback((HolderGetter<PlacedFeature>)featuresGetter, carversGetter));
        BiomeRegistry.register(context, RuBiomes.SAGUARO_DESERT, AridBiomes.saguaroDesert((HolderGetter<PlacedFeature>)featuresGetter, carversGetter));
        BiomeRegistry.register(context, RuBiomes.STEPPE, AridBiomes.steppe((HolderGetter<PlacedFeature>)featuresGetter, carversGetter));
        BiomeRegistry.register(context, RuBiomes.ARID_MOUNTAINS, MountainBiomes.aridMountains((HolderGetter<PlacedFeature>)featuresGetter, carversGetter));
        BiomeRegistry.register(context, RuBiomes.HIGHLAND_FIELDS, MountainBiomes.highlandFields((HolderGetter<PlacedFeature>)featuresGetter, carversGetter));
        BiomeRegistry.register(context, RuBiomes.MOUNTAINS, MountainBiomes.mountainsAndSlopes((HolderGetter<PlacedFeature>)featuresGetter, carversGetter, false));
        BiomeRegistry.register(context, RuBiomes.PINE_SLOPES, MountainBiomes.mountainsAndSlopes((HolderGetter<PlacedFeature>)featuresGetter, carversGetter, true));
        BiomeRegistry.register(context, RuBiomes.TOWERING_CLIFFS, MountainBiomes.toweringCliffs((HolderGetter<PlacedFeature>)featuresGetter, carversGetter));
        BiomeRegistry.register(context, RuBiomes.CHALK_CLIFFS, CoastalBiomes.chalkCliffs((HolderGetter<PlacedFeature>)featuresGetter, carversGetter));
        BiomeRegistry.register(context, RuBiomes.GRASSY_BEACH, CoastalBiomes.grassyBeach((HolderGetter<PlacedFeature>)featuresGetter, carversGetter));
        BiomeRegistry.register(context, RuBiomes.GRAVEL_BEACH, CoastalBiomes.gravelBeach((HolderGetter<PlacedFeature>)featuresGetter, carversGetter));
        BiomeRegistry.register(context, RuBiomes.ALPHA_GROVE, AquaticBiomes.alphaGrove((HolderGetter<PlacedFeature>)featuresGetter, carversGetter));
        BiomeRegistry.register(context, RuBiomes.COLD_RIVER, AquaticBiomes.coldRiver((HolderGetter<PlacedFeature>)featuresGetter, carversGetter));
        BiomeRegistry.register(context, RuBiomes.HYACINTH_DEEPS, AquaticBiomes.hyacinthDeeps((HolderGetter<PlacedFeature>)featuresGetter, carversGetter));
        BiomeRegistry.register(context, RuBiomes.MUDDY_RIVER, AquaticBiomes.muddyRiver((HolderGetter<PlacedFeature>)featuresGetter, carversGetter));
        BiomeRegistry.register(context, RuBiomes.ROCKY_REEF, AquaticBiomes.rockyReef((HolderGetter<PlacedFeature>)featuresGetter, carversGetter));
        BiomeRegistry.register(context, RuBiomes.ASHEN_WOODLAND, AquaticBiomes.ashenWoodland((HolderGetter<PlacedFeature>)featuresGetter, carversGetter));
        BiomeRegistry.register(context, RuBiomes.TROPICAL_RIVER, AquaticBiomes.tropicalRiver((HolderGetter<PlacedFeature>)featuresGetter, carversGetter));
        BiomeRegistry.register(context, RuBiomes.TROPICS, AquaticBiomes.tropics((HolderGetter<PlacedFeature>)featuresGetter, carversGetter));
        BiomeRegistry.register(context, RuBiomes.COLD_BOREAL_TAIGA, FrozenBiomes.coldBorealTaiga((HolderGetter<PlacedFeature>)featuresGetter, carversGetter));
        BiomeRegistry.register(context, RuBiomes.COLD_DECIDUOUS_FOREST, FrozenBiomes.coldDeciduousForest((HolderGetter<PlacedFeature>)featuresGetter, carversGetter));
        BiomeRegistry.register(context, RuBiomes.FROZEN_PINE_TAIGA, FrozenBiomes.frozenPineTaiga((HolderGetter<PlacedFeature>)featuresGetter, carversGetter));
        BiomeRegistry.register(context, RuBiomes.FROZEN_TUNDRA, FrozenBiomes.frozenTundra((HolderGetter<PlacedFeature>)featuresGetter, carversGetter));
        BiomeRegistry.register(context, RuBiomes.ICY_HEIGHTS, FrozenBiomes.icyHeights((HolderGetter<PlacedFeature>)featuresGetter, carversGetter));
        BiomeRegistry.register(context, RuBiomes.SPIRES, FrozenBiomes.spires((HolderGetter<PlacedFeature>)featuresGetter, carversGetter));
        BiomeRegistry.register(context, RuBiomes.ANCIENT_DELTA, CaveBiomes.ancientDelta((HolderGetter<PlacedFeature>)featuresGetter, carversGetter));
        BiomeRegistry.register(context, RuBiomes.BIOSHROOM_CAVES, CaveBiomes.bioshroomCaves((HolderGetter<PlacedFeature>)featuresGetter, carversGetter));
        BiomeRegistry.register(context, RuBiomes.PRISMACHASM, CaveBiomes.prismachasm((HolderGetter<PlacedFeature>)featuresGetter, carversGetter));
        BiomeRegistry.register(context, RuBiomes.REDSTONE_CAVES, CaveBiomes.redstoneCaves((HolderGetter<PlacedFeature>)featuresGetter, carversGetter));
        BiomeRegistry.register(context, RuBiomes.SCORCHING_CAVES, CaveBiomes.scorchingCaves((HolderGetter<PlacedFeature>)featuresGetter, carversGetter));
        BiomeRegistry.register(context, RuBiomes.BLACKSTONE_BASIN, NetherBiomes.blackstoneBasin((HolderGetter<PlacedFeature>)featuresGetter, carversGetter));
        BiomeRegistry.register(context, RuBiomes.INFERNAL_HOLT, NetherBiomes.infernalHolt((HolderGetter<PlacedFeature>)featuresGetter, carversGetter));
        BiomeRegistry.register(context, RuBiomes.GLISTERING_MEADOW, NetherBiomes.glisteringMeadow((HolderGetter<PlacedFeature>)featuresGetter, carversGetter));
        BiomeRegistry.register(context, RuBiomes.MYCOTOXIC_UNDERGROWTH, NetherBiomes.mycotoxicUndergrowth((HolderGetter<PlacedFeature>)featuresGetter, carversGetter));
        BiomeRegistry.register(context, RuBiomes.REDSTONE_ABYSS, NetherBiomes.redstoneAbyss((HolderGetter<PlacedFeature>)featuresGetter, carversGetter));
    }

    private static void registerVillagerTypes() {
        BiomeRegistry.registerVillagers(RuBiomes.AUTUMNAL_MAPLE_FOREST, VillagerType.PLAINS);
        BiomeRegistry.registerVillagers(RuBiomes.BAMBOO_FOREST, VillagerType.JUNGLE);
        BiomeRegistry.registerVillagers(RuBiomes.MAGNOLIA_WOODLAND, VillagerType.PLAINS);
        BiomeRegistry.registerVillagers(RuBiomes.DECIDUOUS_FOREST, VillagerType.PLAINS);
        BiomeRegistry.registerVillagers(RuBiomes.MAPLE_FOREST, VillagerType.TAIGA);
        BiomeRegistry.registerVillagers(RuBiomes.MAUVE_HILLS, VillagerType.PLAINS);
        BiomeRegistry.registerVillagers(RuBiomes.ORCHARD, VillagerType.PLAINS);
        BiomeRegistry.registerVillagers(RuBiomes.SILVER_BIRCH_FOREST, VillagerType.PLAINS);
        BiomeRegistry.registerVillagers(RuBiomes.TEMPERATE_GROVE, VillagerType.PLAINS);
        BiomeRegistry.registerVillagers(RuBiomes.WILLOW_FOREST, VillagerType.PLAINS);
        BiomeRegistry.registerVillagers(RuBiomes.BLACKWOOD_TAIGA, VillagerType.TAIGA);
        BiomeRegistry.registerVillagers(RuBiomes.BOREAL_TAIGA, VillagerType.TAIGA);
        BiomeRegistry.registerVillagers(RuBiomes.GOLDEN_BOREAL_TAIGA, VillagerType.TAIGA);
        BiomeRegistry.registerVillagers(RuBiomes.PINE_TAIGA, VillagerType.TAIGA);
        BiomeRegistry.registerVillagers(RuBiomes.REDWOODS, VillagerType.PLAINS);
        BiomeRegistry.registerVillagers(RuBiomes.SPARSE_REDWOODS, VillagerType.PLAINS);
        BiomeRegistry.registerVillagers(RuBiomes.BARLEY_FIELDS, VillagerType.PLAINS);
        BiomeRegistry.registerVillagers(RuBiomes.FLOWER_FIELDS, VillagerType.PLAINS);
        BiomeRegistry.registerVillagers(RuBiomes.GRASSLAND, VillagerType.PLAINS);
        BiomeRegistry.registerVillagers(RuBiomes.CLOVER_PLAINS, VillagerType.PLAINS);
        BiomeRegistry.registerVillagers(RuBiomes.ROCKY_MEADOW, VillagerType.PLAINS);
        BiomeRegistry.registerVillagers(RuBiomes.POPPY_FIELDS, VillagerType.PLAINS);
        BiomeRegistry.registerVillagers(RuBiomes.PRAIRIE, VillagerType.PLAINS);
        BiomeRegistry.registerVillagers(RuBiomes.PUMPKIN_FIELDS, VillagerType.PLAINS);
        BiomeRegistry.registerVillagers(RuBiomes.SHRUBLAND, VillagerType.TAIGA);
        BiomeRegistry.registerVillagers(RuBiomes.BAYOU, VillagerType.SWAMP);
        BiomeRegistry.registerVillagers(RuBiomes.EUCALYPTUS_FOREST, VillagerType.JUNGLE);
        BiomeRegistry.registerVillagers(RuBiomes.FEN, VillagerType.SWAMP);
        BiomeRegistry.registerVillagers(RuBiomes.MARSH, VillagerType.SWAMP);
        BiomeRegistry.registerVillagers(RuBiomes.FUNGAL_FEN, VillagerType.SWAMP);
        BiomeRegistry.registerVillagers(RuBiomes.OLD_GROWTH_BAYOU, VillagerType.SWAMP);
        BiomeRegistry.registerVillagers(RuBiomes.SPARSE_RAINFOREST, VillagerType.JUNGLE);
        BiomeRegistry.registerVillagers(RuBiomes.RAINFOREST, VillagerType.JUNGLE);
        BiomeRegistry.registerVillagers(RuBiomes.BAOBAB_SAVANNA, VillagerType.SAVANNA);
        BiomeRegistry.registerVillagers(RuBiomes.DRY_BUSHLAND, VillagerType.SAVANNA);
        BiomeRegistry.registerVillagers(RuBiomes.JOSHUA_DESERT, VillagerType.DESERT);
        BiomeRegistry.registerVillagers(RuBiomes.OUTBACK, VillagerType.SAVANNA);
        BiomeRegistry.registerVillagers(RuBiomes.SAGUARO_DESERT, VillagerType.DESERT);
        BiomeRegistry.registerVillagers(RuBiomes.STEPPE, VillagerType.PLAINS);
        BiomeRegistry.registerVillagers(RuBiomes.ARID_MOUNTAINS, VillagerType.SAVANNA);
        BiomeRegistry.registerVillagers(RuBiomes.HIGHLAND_FIELDS, VillagerType.PLAINS);
        BiomeRegistry.registerVillagers(RuBiomes.MOUNTAINS, VillagerType.TAIGA);
        BiomeRegistry.registerVillagers(RuBiomes.PINE_SLOPES, VillagerType.TAIGA);
        BiomeRegistry.registerVillagers(RuBiomes.TOWERING_CLIFFS, VillagerType.TAIGA);
        BiomeRegistry.registerVillagers(RuBiomes.CHALK_CLIFFS, VillagerType.PLAINS);
        BiomeRegistry.registerVillagers(RuBiomes.GRASSY_BEACH, VillagerType.PLAINS);
        BiomeRegistry.registerVillagers(RuBiomes.GRAVEL_BEACH, VillagerType.TAIGA);
        BiomeRegistry.registerVillagers(RuBiomes.ALPHA_GROVE, VillagerType.PLAINS);
        BiomeRegistry.registerVillagers(RuBiomes.COLD_RIVER, VillagerType.PLAINS);
        BiomeRegistry.registerVillagers(RuBiomes.HYACINTH_DEEPS, VillagerType.PLAINS);
        BiomeRegistry.registerVillagers(RuBiomes.MUDDY_RIVER, VillagerType.PLAINS);
        BiomeRegistry.registerVillagers(RuBiomes.ROCKY_REEF, VillagerType.JUNGLE);
        BiomeRegistry.registerVillagers(RuBiomes.ASHEN_WOODLAND, VillagerType.TAIGA);
        BiomeRegistry.registerVillagers(RuBiomes.TROPICAL_RIVER, VillagerType.JUNGLE);
        BiomeRegistry.registerVillagers(RuBiomes.TROPICS, VillagerType.JUNGLE);
        BiomeRegistry.registerVillagers(RuBiomes.COLD_BOREAL_TAIGA, VillagerType.SNOW);
        BiomeRegistry.registerVillagers(RuBiomes.COLD_DECIDUOUS_FOREST, VillagerType.SNOW);
        BiomeRegistry.registerVillagers(RuBiomes.FROZEN_PINE_TAIGA, VillagerType.SNOW);
        BiomeRegistry.registerVillagers(RuBiomes.FROZEN_TUNDRA, VillagerType.SNOW);
        BiomeRegistry.registerVillagers(RuBiomes.ICY_HEIGHTS, VillagerType.SNOW);
        BiomeRegistry.registerVillagers(RuBiomes.SPIRES, VillagerType.SNOW);
        BiomeRegistry.registerVillagers(RuBiomes.BIOSHROOM_CAVES, VillagerType.PLAINS);
        BiomeRegistry.registerVillagers(RuBiomes.ANCIENT_DELTA, VillagerType.PLAINS);
        BiomeRegistry.registerVillagers(RuBiomes.PRISMACHASM, VillagerType.PLAINS);
        BiomeRegistry.registerVillagers(RuBiomes.REDSTONE_CAVES, VillagerType.PLAINS);
        BiomeRegistry.registerVillagers(RuBiomes.SCORCHING_CAVES, VillagerType.PLAINS);
        BiomeRegistry.registerVillagers(RuBiomes.BLACKSTONE_BASIN, VillagerType.PLAINS);
        BiomeRegistry.registerVillagers(RuBiomes.INFERNAL_HOLT, VillagerType.PLAINS);
        BiomeRegistry.registerVillagers(RuBiomes.GLISTERING_MEADOW, VillagerType.PLAINS);
        BiomeRegistry.registerVillagers(RuBiomes.MYCOTOXIC_UNDERGROWTH, VillagerType.PLAINS);
        BiomeRegistry.registerVillagers(RuBiomes.REDSTONE_ABYSS, VillagerType.PLAINS);
    }

    private static void register(BootstrapContext<Biome> context, ResourceKey<Biome> key, Biome biome) {
        context.register(key, (Object)biome);
    }

    private static void registerVillagers(ResourceKey<Biome> key, VillagerType type) {
        VillagerType.BY_BIOME.put(key, type);
    }
}

