/*
 * Decompiled with CFR 0.152.
 */
package net.regions_unexplored.entity.custom;

import java.util.Arrays;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.Vec3;
import net.regions_unexplored.block.RuBlocks;
import net.regions_unexplored.entity.RuEntities;
import net.regions_unexplored.item.RuItems;
import org.jetbrains.annotations.NotNull;

public class RuBoat
extends Boat {
    public RuBoat(EntityType<? extends RuBoat> type, Level level) {
        super(type, level);
        this.blocksBuilding = true;
    }

    public RuBoat(Level level, double x, double y, double z) {
        this(RuEntities.BOAT.get(), level);
        this.setPos(x, y, z);
        this.xo = x;
        this.yo = y;
        this.zo = z;
    }

    public Item getDropItem() {
        return switch (this.getModel().ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> RuItems.BAOBAB_BOAT.get();
            case 1 -> RuItems.BLACKWOOD_BOAT.get();
            case 2 -> RuItems.CYPRESS_BOAT.get();
            case 3 -> RuItems.DEAD_BOAT.get();
            case 4 -> RuItems.EUCALYPTUS_BOAT.get();
            case 5 -> RuItems.JOSHUA_BOAT.get();
            case 6 -> RuItems.KAPOK_BOAT.get();
            case 7 -> RuItems.LARCH_BOAT.get();
            case 8 -> RuItems.MAGNOLIA_BOAT.get();
            case 9 -> RuItems.MAPLE_BOAT.get();
            case 10 -> RuItems.MAUVE_BOAT.get();
            case 11 -> RuItems.PALM_BOAT.get();
            case 12 -> RuItems.PINE_BOAT.get();
            case 13 -> RuItems.REDWOOD_BOAT.get();
            case 14 -> RuItems.SOCOTRA_BOAT.get();
            case 15 -> RuItems.WILLOW_BOAT.get();
        };
    }

    protected void addAdditionalSaveData(CompoundTag tag) {
        tag.putString("model", this.getModel().getName());
    }

    protected void readAdditionalSaveData(CompoundTag tag) {
        if (tag.contains("model", 8)) {
            this.entityData.set(DATA_ID_TYPE, (Object)ModelType.byName(tag.getString("model")).ordinal());
        }
    }

    @NotNull
    protected Vec3 getPassengerAttachmentPoint(@NotNull Entity entity, @NotNull EntityDimensions entityDimensions, float isBamboo) {
        float f = this.getSinglePassengerXOffset();
        if (this.getPassengers().size() > 1) {
            int i = this.getPassengers().indexOf(entity);
            f = i == 0 ? 0.2f : -0.6f;
            if (entity instanceof Animal) {
                f += 0.2f;
            }
        }
        return new Vec3(0.0, (double)(entityDimensions.height() / 3.0f), (double)f);
    }

    public void setModel(ModelType model) {
        this.entityData.set(DATA_ID_TYPE, (Object)model.ordinal());
    }

    public ModelType getModel() {
        return ModelType.byId((Integer)this.entityData.get(DATA_ID_TYPE));
    }

    public static enum ModelType {
        BAOBAB("baobab", RuBlocks.BAOBAB_PLANKS.get()),
        BLACKWOOD("blackwood", RuBlocks.BLACKWOOD_PLANKS.get()),
        CYPRESS("cypress", RuBlocks.CYPRESS_PLANKS.get()),
        DEAD("dead", RuBlocks.DEAD_PLANKS.get()),
        EUCALYPTUS("eucalyptus", RuBlocks.EUCALYPTUS_PLANKS.get()),
        JOSHUA("joshua", RuBlocks.JOSHUA_PLANKS.get()),
        KAPOK("kapok", RuBlocks.KAPOK_PLANKS.get()),
        LARCH("larch", RuBlocks.LARCH_PLANKS.get()),
        MAGNOLIA("magnolia", RuBlocks.MAGNOLIA_PLANKS.get()),
        MAPLE("maple", RuBlocks.MAPLE_PLANKS.get()),
        MAUVE("mauve", RuBlocks.MAUVE_PLANKS.get()),
        PALM("palm", RuBlocks.PALM_PLANKS.get()),
        PINE("pine", RuBlocks.PINE_PLANKS.get()),
        REDWOOD("redwood", RuBlocks.REDWOOD_PLANKS.get()),
        SOCOTRA("socotra", RuBlocks.SOCOTRA_PLANKS.get()),
        WILLOW("willow", RuBlocks.WILLOW_PLANKS.get());

        private final String name;
        private final Block planks;

        private ModelType(String name, Block planks) {
            this.name = name;
            this.planks = planks;
        }

        public String getName() {
            return this.name;
        }

        public Block getPlanks() {
            return this.planks;
        }

        public String toString() {
            return this.name;
        }

        public static ModelType byId(int id) {
            ModelType[] model = ModelType.values();
            return model[id < 0 || id >= model.length ? 0 : id];
        }

        public static ModelType byName(String name) {
            ModelType[] model = ModelType.values();
            return Arrays.stream(model).filter(t -> t.getName().equals(name)).findFirst().orElse(model[0]);
        }
    }
}

