/*
 * Decompiled with CFR 0.152.
 */
package net.regions_unexplored.datagen;

import java.util.Map;
import java.util.Set;
import net.minecraft.advancements.critereon.BlockPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.SweetBerryBushBlock;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.IntRange;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.AlternativesEntry;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.FunctionUserBuilder;
import net.minecraft.world.level.storage.loot.functions.LimitCount;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.predicates.BonusLevelTableCondition;
import net.minecraft.world.level.storage.loot.predicates.ConditionUserBuilder;
import net.minecraft.world.level.storage.loot.predicates.LocationCheck;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraft.world.level.storage.loot.predicates.MatchTool;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.neoforged.neoforge.common.Tags;
import net.regions_unexplored.block.RuBlocks;
import net.regions_unexplored.item.RuItems;
import net.regions_unexplored.world.level.block.plant.food.SalmonBerryBushBlock;

public class RuBlockLootTables
extends BlockLootSubProvider {
    protected static final LootItemCondition.Builder HAS_SHEARS = MatchTool.toolMatches((ItemPredicate.Builder)ItemPredicate.Builder.item().of(Tags.Items.TOOLS_SHEAR));
    private final LootItemCondition.Builder HAS_SHEARS_OR_SILK_TOUCH = HAS_SHEARS.or(this.hasSilkTouch());
    private final LootItemCondition.Builder HAS_NO_SHEARS_OR_SILK_TOUCH = this.HAS_SHEARS_OR_SILK_TOUCH.invert();
    protected static final float[] ASPEN_LEAVES_SAPLING_CHANCES = new float[]{0.0725f, 0.0785f, 0.0875f, 0.125f};
    protected static final float[] COBALT_LEAVES_SAPLING_CHANCES = new float[]{0.083f, 0.095f, 0.105f, 0.13f};
    protected static final float[] FLOWERING_OAK_LEAVES_SAPLING_CHANCES = new float[]{0.08f, 0.091f, 0.1f, 0.12f};
    protected static final float[] JOSHUA_LEAVES_SAPLING_CHANCES = new float[]{0.13f, 0.15f, 0.17f, 0.185f};
    protected static final float[] PALM_LEAVES_SAPLING_CHANCES = new float[]{0.1f, 0.125f, 0.14f, 0.155f};
    protected static final float[] SMALL_OAK_LEAVES_SAPLING_CHANCES = new float[]{0.075f, 0.08f, 0.089f, 0.1275f};
    private static final float[] NORMAL_LEAVES_STICK_CHANCES = new float[]{0.02f, 0.022222223f, 0.025f, 0.033333335f, 0.1f};

    public RuBlockLootTables(HolderLookup.Provider holder) {
        super(Set.of(), FeatureFlags.REGISTRY.allFlags(), holder);
    }

    protected void generate() {
        this.add(RuBlocks.PRISMOSS.get(), block -> this.createSingleItemTableWithSilkTouch((Block)block, (ItemLike)Blocks.COBBLESTONE));
        this.add(RuBlocks.DEEPSLATE_PRISMOSS.get(), block -> this.createSingleItemTableWithSilkTouch((Block)block, (ItemLike)Blocks.COBBLED_DEEPSLATE));
        this.dropSelf(RuBlocks.HANGING_PRISMARITE.get());
        this.add(RuBlocks.LARGE_PRISMARITE_CLUSTER.get(), block -> this.createSinglePropConditionTable((Block)block, (Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.LOWER));
        this.add(RuBlocks.PRISMAGLASS.get(), block -> this.createSilkTouchOnlyTable((ItemLike)block));
        this.dropSelf(RuBlocks.PRISMARITE_CLUSTER.get());
        this.add(RuBlocks.PRISMOSS_SPROUT.get(), block -> RuBlockLootTables.createShearsOnlyDrop((ItemLike)block));
        this.dropSelf(RuBlocks.POINTED_REDSTONE.get());
        this.dropSelf(RuBlocks.RAW_REDSTONE_BLOCK.get());
        this.add(RuBlocks.REDSTONE_BUD.get(), block -> this.createSilkTouchDispatchTable((Block)block, (LootPoolEntryContainer.Builder)this.applyExplosionDecay((ItemLike)block, (FunctionUserBuilder)LootItem.lootTableItem((ItemLike)Items.REDSTONE).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)2.0f))))));
        this.dropSelf(RuBlocks.REDSTONE_BULB.get());
        this.add(RuBlocks.ARGILLITE_GRASS_BLOCK.get(), block -> this.createSingleItemTableWithSilkTouch((Block)block, (ItemLike)RuBlocks.ARGILLITE.get()));
        this.add(RuBlocks.STONE_GRASS_BLOCK.get(), block -> this.createSingleItemTableWithSilkTouch((Block)block, (ItemLike)Blocks.COBBLESTONE));
        this.add(RuBlocks.DEEPSLATE_GRASS_BLOCK.get(), block -> this.createSingleItemTableWithSilkTouch((Block)block, (ItemLike)Blocks.COBBLED_DEEPSLATE));
        this.add(RuBlocks.VIRIDESCENT_NYLIUM.get(), block -> this.createSingleItemTableWithSilkTouch((Block)block, (ItemLike)Blocks.COBBLESTONE));
        this.add(RuBlocks.DEEPSLATE_VIRIDESCENT_NYLIUM.get(), block -> this.createSingleItemTableWithSilkTouch((Block)block, (ItemLike)Blocks.COBBLED_DEEPSLATE));
        this.add(RuBlocks.CORPSE_FLOWER.get(), block -> this.createSinglePropConditionTable((Block)block, (Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.LOWER));
        this.add(RuBlocks.BLADED_GRASS.get(), block -> this.createGrassDrops((Block)block));
        this.add(RuBlocks.BLADED_TALL_GRASS.get(), block -> this.createDoublePlantWithSeedDrops((Block)block, RuBlocks.BLADED_GRASS.get()));
        this.add(RuBlocks.DROPLEAF.get(), block -> this.createSilkTouchOrShearsDispatchTable((Block)block, (LootPoolEntryContainer.Builder<?>)LootItem.lootTableItem((ItemLike)block).when(BonusLevelTableCondition.bonusLevelFlatChance((Holder)this.registries.holderOrThrow(Enchantments.FORTUNE), (float[])new float[]{0.33f, 0.55f, 0.77f, 1.0f}))));
        this.add(RuBlocks.DROPLEAF_PLANT.get(), block -> this.createSilkTouchOrShearsDispatchTable((Block)block, (LootPoolEntryContainer.Builder<?>)LootItem.lootTableItem((ItemLike)block).when(BonusLevelTableCondition.bonusLevelFlatChance((Holder)this.registries.holderOrThrow(Enchantments.FORTUNE), (float[])new float[]{0.33f, 0.55f, 0.77f, 1.0f}))));
        this.add(RuBlocks.DUSKMELON.get(), block -> (LootTable.Builder)this.applyExplosionDecay((ItemLike)block, (FunctionUserBuilder)LootTable.lootTable().withPool(LootPool.lootPool().when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)RuBlocks.DUSKMELON.get()).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)SalmonBerryBushBlock.AGE, 3))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)RuItems.DUSKMELON_SLICE.get()))).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)2.0f, (float)3.0f))).apply((LootItemFunction.Builder)ApplyBonusCount.addUniformBonusCount((Holder)this.registries.holderOrThrow(Enchantments.FORTUNE)))).withPool(LootPool.lootPool().when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)RuBlocks.DUSKMELON.get()).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)SweetBerryBushBlock.AGE, 2))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)RuItems.DUSKMELON_SLICE.get()))).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)2.0f))).apply((LootItemFunction.Builder)ApplyBonusCount.addUniformBonusCount((Holder)this.registries.holderOrThrow(Enchantments.FORTUNE))))));
        this.add(RuBlocks.DUSKTRAP.get(), block -> this.createSinglePropConditionTable((Block)block, (Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.LOWER));
        this.dropSelf(RuBlocks.DEAD_STEPPE_SHRUB.get());
        this.add(RuBlocks.ASHEN_GRASS.get(), block -> this.createGrassDrops((Block)block));
        this.add(RuBlocks.FROZEN_GRASS.get(), block -> this.createGrassDrops((Block)block));
        this.add(RuBlocks.MEDIUM_GRASS.get(), block -> this.createGrassDrops((Block)block));
        this.add(RuBlocks.SANDY_GRASS.get(), block -> this.createGrassDrops((Block)block));
        this.add(RuBlocks.SMALL_DESERT_SHRUB.get(), block -> RuBlockLootTables.createShearsOnlyDrop((ItemLike)block));
        this.add(RuBlocks.STEPPE_GRASS.get(), block -> this.createGrassDrops((Block)block));
        this.add(RuBlocks.STEPPE_SHRUB.get(), block -> this.createGrassDrops((Block)block));
        this.add(RuBlocks.STONE_BUD.get(), block -> this.createGrassDrops((Block)block));
        this.add(RuBlocks.ELEPHANT_EAR.get(), block -> this.createSinglePropConditionTable((Block)block, (Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.LOWER));
        this.add(RuBlocks.SANDY_TALL_GRASS.get(), block -> this.createDoublePlantWithSeedDrops((Block)block, RuBlocks.SANDY_GRASS.get()));
        this.add(RuBlocks.STEPPE_TALL_GRASS.get(), block -> this.createDoublePlantWithSeedDrops((Block)block, RuBlocks.STEPPE_GRASS.get()));
        this.add(RuBlocks.WINDSWEPT_GRASS.get(), block -> this.createDoublePlantWithSeedDropsNoGrass((Block)block));
        this.dropSelf(RuBlocks.ALPHA_DANDELION.get());
        this.dropSelf(RuBlocks.ALPHA_ROSE.get());
        this.dropSelf(RuBlocks.ASTER.get());
        this.dropSelf(RuBlocks.BLEEDING_HEART.get());
        this.dropSelf(RuBlocks.BLUE_LUPINE.get());
        this.dropSelf(RuBlocks.DAISY.get());
        this.dropSelf(RuBlocks.DORCEL.get());
        this.dropSelf(RuBlocks.FELICIA_DAISY.get());
        this.dropSelf(RuBlocks.FIREWEED.get());
        this.dropSelf(RuBlocks.HIBISCUS.get());
        this.dropSelf(RuBlocks.HYSSOP.get());
        this.dropSelf(RuBlocks.MALLOW.get());
        this.dropSelf(RuBlocks.PINK_LUPINE.get());
        this.dropSelf(RuBlocks.POPPY_BUSH.get());
        this.dropSelf(RuBlocks.SALMON_POPPY_BUSH.get());
        this.dropSelf(RuBlocks.PURPLE_LUPINE.get());
        this.dropSelf(RuBlocks.RED_LUPINE.get());
        this.dropSelf(RuBlocks.TSUBAKI.get());
        this.dropSelf(RuBlocks.WARATAH.get());
        this.dropSelf(RuBlocks.WHITE_TRILLIUM.get());
        this.dropSelf(RuBlocks.WILTING_TRILLIUM.get());
        this.dropSelf(RuBlocks.YELLOW_LUPINE.get());
        this.add(RuBlocks.ORANGE_CONEFLOWER.get(), block -> this.createPetalsDrops((Block)block));
        this.add(RuBlocks.PURPLE_CONEFLOWER.get(), block -> this.createPetalsDrops((Block)block));
        this.add(RuBlocks.CLOVER.get(), block -> this.createPetalsDrops((Block)block));
        this.add(RuBlocks.BLUE_MAGNOLIA_FLOWERS.get(), block -> this.createMultifaceBlockDrops((Block)block, HAS_SHEARS));
        this.add(RuBlocks.PINK_MAGNOLIA_FLOWERS.get(), block -> this.createMultifaceBlockDrops((Block)block, HAS_SHEARS));
        this.add(RuBlocks.WHITE_MAGNOLIA_FLOWERS.get(), block -> this.createMultifaceBlockDrops((Block)block, HAS_SHEARS));
        this.dropSelf(RuBlocks.RED_SNOWBELLE.get());
        this.dropSelf(RuBlocks.ORANGE_SNOWBELLE.get());
        this.dropSelf(RuBlocks.YELLOW_SNOWBELLE.get());
        this.dropSelf(RuBlocks.LIME_SNOWBELLE.get());
        this.dropSelf(RuBlocks.GREEN_SNOWBELLE.get());
        this.dropSelf(RuBlocks.CYAN_SNOWBELLE.get());
        this.dropSelf(RuBlocks.LIGHT_BLUE_SNOWBELLE.get());
        this.dropSelf(RuBlocks.BLUE_SNOWBELLE.get());
        this.dropSelf(RuBlocks.PURPLE_SNOWBELLE.get());
        this.dropSelf(RuBlocks.MAGENTA_SNOWBELLE.get());
        this.dropSelf(RuBlocks.PINK_SNOWBELLE.get());
        this.dropSelf(RuBlocks.BROWN_SNOWBELLE.get());
        this.dropSelf(RuBlocks.WHITE_SNOWBELLE.get());
        this.dropSelf(RuBlocks.LIGHT_GRAY_SNOWBELLE.get());
        this.dropSelf(RuBlocks.GRAY_SNOWBELLE.get());
        this.dropSelf(RuBlocks.BLACK_SNOWBELLE.get());
        this.add(RuBlocks.MAPLE_LEAF_PILE.get(), block -> this.createPetalsDrops((Block)block));
        this.add(RuBlocks.RED_MAPLE_LEAF_PILE.get(), block -> this.createPetalsDrops((Block)block));
        this.add(RuBlocks.ORANGE_MAPLE_LEAF_PILE.get(), block -> this.createPetalsDrops((Block)block));
        this.add(RuBlocks.SILVER_BIRCH_LEAF_PILE.get(), block -> this.createPetalsDrops((Block)block));
        this.add(RuBlocks.ENCHANTED_BIRCH_LEAF_PILE.get(), block -> this.createPetalsDrops((Block)block));
        this.add(RuBlocks.MEADOW_SAGE.get(), block -> this.createSinglePropConditionTable((Block)block, (Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.LOWER));
        this.add(RuBlocks.BARLEY.get(), block -> this.createSinglePropConditionTable((Block)block, (Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.LOWER));
        this.add(RuBlocks.CATTAIL.get(), block -> this.createSinglePropConditionTable((Block)block, (Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.LOWER));
        this.add(RuBlocks.TASSEL.get(), block -> this.createSinglePropConditionTable((Block)block, (Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.LOWER));
        this.add(RuBlocks.DAY_LILY.get(), block -> this.createSinglePropConditionTable((Block)block, (Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.LOWER));
        this.dropSelf(RuBlocks.ASHEN_SAPLING.get());
        this.dropSelf(RuBlocks.ALPHA_SAPLING.get());
        this.dropSelf(RuBlocks.APPLE_OAK_SAPLING.get());
        this.dropSelf(RuBlocks.BAMBOO_SAPLING.get());
        this.dropSelf(RuBlocks.BAOBAB_SAPLING.get());
        this.dropSelf(RuBlocks.BLACKWOOD_SAPLING.get());
        this.dropSelf(RuBlocks.CACTUS_FLOWER.get());
        this.dropSelf(RuBlocks.COBALT_SAPLING.get());
        this.dropSelf(RuBlocks.MAGNOLIA_SAPLING.get());
        this.dropSelf(RuBlocks.CYPRESS_SAPLING.get());
        this.dropSelf(RuBlocks.DEAD_PINE_SAPLING.get());
        this.dropSelf(RuBlocks.DEAD_SAPLING.get());
        this.dropSelf(RuBlocks.EUCALYPTUS_SAPLING.get());
        this.dropSelf(RuBlocks.FLOWERING_SAPLING.get());
        this.dropSelf(RuBlocks.GOLDEN_LARCH_SAPLING.get());
        this.dropSelf(RuBlocks.JOSHUA_SAPLING.get());
        this.dropSelf(RuBlocks.KAPOK_SAPLING.get());
        this.dropSelf(RuBlocks.LARCH_SAPLING.get());
        this.dropSelf(RuBlocks.MAPLE_SAPLING.get());
        this.dropSelf(RuBlocks.MAUVE_SAPLING.get());
        this.dropSelf(RuBlocks.ORANGE_MAPLE_SAPLING.get());
        this.dropSelf(RuBlocks.PALM_SAPLING.get());
        this.dropSelf(RuBlocks.PINE_SAPLING.get());
        this.dropSelf(RuBlocks.BLUE_MAGNOLIA_SAPLING.get());
        this.dropSelf(RuBlocks.PINK_MAGNOLIA_SAPLING.get());
        this.dropSelf(RuBlocks.REDWOOD_SAPLING.get());
        this.dropSelf(RuBlocks.RED_MAPLE_SAPLING.get());
        this.dropSelf(RuBlocks.BRIMWOOD_SAPLING.get());
        this.dropSelf(RuBlocks.ENCHANTED_BIRCH_SAPLING.get());
        this.dropSelf(RuBlocks.SILVER_BIRCH_SAPLING.get());
        this.dropSelf(RuBlocks.SMALL_OAK_SAPLING.get());
        this.dropSelf(RuBlocks.SOCOTRA_SAPLING.get());
        this.dropSelf(RuBlocks.WHITE_MAGNOLIA_SAPLING.get());
        this.dropSelf(RuBlocks.WILLOW_SAPLING.get());
        this.add(RuBlocks.ASHEN_SHRUB.get(), block -> this.createSinglePropConditionTable((Block)block, (Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.LOWER));
        this.add(RuBlocks.ACACIA_SHRUB.get(), block -> this.createSinglePropConditionTable((Block)block, (Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.LOWER));
        this.add(RuBlocks.BAOBAB_SHRUB.get(), block -> this.createSinglePropConditionTable((Block)block, (Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.LOWER));
        this.add(RuBlocks.BIRCH_SHRUB.get(), block -> this.createSinglePropConditionTable((Block)block, (Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.LOWER));
        this.add(RuBlocks.BLACKWOOD_SHRUB.get(), block -> this.createSinglePropConditionTable((Block)block, (Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.LOWER));
        this.add(RuBlocks.BRIMWOOD_SHRUB.get(), block -> this.createSinglePropConditionTable((Block)block, (Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.LOWER));
        this.add(RuBlocks.MAGNOLIA_SHRUB.get(), block -> this.createSinglePropConditionTable((Block)block, (Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.LOWER));
        this.add(RuBlocks.CHERRY_SHRUB.get(), block -> this.createSinglePropConditionTable((Block)block, (Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.LOWER));
        this.add(RuBlocks.CYPRESS_SHRUB.get(), block -> this.createSinglePropConditionTable((Block)block, (Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.LOWER));
        this.add(RuBlocks.DARK_OAK_SHRUB.get(), block -> this.createSinglePropConditionTable((Block)block, (Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.LOWER));
        this.add(RuBlocks.DEAD_PINE_SHRUB.get(), block -> this.createSinglePropConditionTable((Block)block, (Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.LOWER));
        this.add(RuBlocks.DEAD_SHRUB.get(), block -> this.createSinglePropConditionTable((Block)block, (Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.LOWER));
        this.add(RuBlocks.EUCALYPTUS_SHRUB.get(), block -> this.createSinglePropConditionTable((Block)block, (Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.LOWER));
        this.add(RuBlocks.FLOWERING_SHRUB.get(), block -> this.createSinglePropConditionTable((Block)block, (Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.LOWER));
        this.add(RuBlocks.GOLDEN_LARCH_SHRUB.get(), block -> this.createSinglePropConditionTable((Block)block, (Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.LOWER));
        this.add(RuBlocks.JOSHUA_SHRUB.get(), block -> this.createSinglePropConditionTable((Block)block, (Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.LOWER));
        this.add(RuBlocks.JUNGLE_SHRUB.get(), block -> this.createSinglePropConditionTable((Block)block, (Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.LOWER));
        this.add(RuBlocks.KAPOK_SHRUB.get(), block -> this.createSinglePropConditionTable((Block)block, (Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.LOWER));
        this.add(RuBlocks.LARCH_SHRUB.get(), block -> this.createSinglePropConditionTable((Block)block, (Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.LOWER));
        this.add(RuBlocks.MANGROVE_SHRUB.get(), block -> this.createSinglePropConditionTable((Block)block, (Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.LOWER));
        this.add(RuBlocks.MAPLE_SHRUB.get(), block -> this.createSinglePropConditionTable((Block)block, (Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.LOWER));
        this.add(RuBlocks.MAUVE_SHRUB.get(), block -> this.createSinglePropConditionTable((Block)block, (Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.LOWER));
        this.add(RuBlocks.OAK_SHRUB.get(), block -> this.createSinglePropConditionTable((Block)block, (Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.LOWER));
        this.add(RuBlocks.ORANGE_MAPLE_SHRUB.get(), block -> this.createSinglePropConditionTable((Block)block, (Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.LOWER));
        this.add(RuBlocks.PALM_SHRUB.get(), block -> this.createSinglePropConditionTable((Block)block, (Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.LOWER));
        this.add(RuBlocks.PINE_SHRUB.get(), block -> this.createSinglePropConditionTable((Block)block, (Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.LOWER));
        this.add(RuBlocks.BLUE_MAGNOLIA_SHRUB.get(), block -> this.createSinglePropConditionTable((Block)block, (Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.LOWER));
        this.add(RuBlocks.PINK_MAGNOLIA_SHRUB.get(), block -> this.createSinglePropConditionTable((Block)block, (Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.LOWER));
        this.add(RuBlocks.REDWOOD_SHRUB.get(), block -> this.createSinglePropConditionTable((Block)block, (Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.LOWER));
        this.add(RuBlocks.RED_MAPLE_SHRUB.get(), block -> this.createSinglePropConditionTable((Block)block, (Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.LOWER));
        this.add(RuBlocks.ENCHANTED_BIRCH_SHRUB.get(), block -> this.createSinglePropConditionTable((Block)block, (Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.LOWER));
        this.add(RuBlocks.SILVER_BIRCH_SHRUB.get(), block -> this.createSinglePropConditionTable((Block)block, (Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.LOWER));
        this.add(RuBlocks.SOCOTRA_SHRUB.get(), block -> this.createSinglePropConditionTable((Block)block, (Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.LOWER));
        this.add(RuBlocks.SPRUCE_SHRUB.get(), block -> this.createSinglePropConditionTable((Block)block, (Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.LOWER));
        this.add(RuBlocks.WHITE_MAGNOLIA_SHRUB.get(), block -> this.createSinglePropConditionTable((Block)block, (Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.LOWER));
        this.add(RuBlocks.WILLOW_SHRUB.get(), block -> this.createSinglePropConditionTable((Block)block, (Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.LOWER));
        this.dropSelf(RuBlocks.BLUE_BIOSHROOM.get());
        this.dropSelf(RuBlocks.GREEN_BIOSHROOM.get());
        this.dropSelf(RuBlocks.PINK_BIOSHROOM.get());
        this.dropSelf(RuBlocks.YELLOW_BIOSHROOM.get());
        this.add(RuBlocks.TALL_BLUE_BIOSHROOM.get(), block -> this.createSinglePropConditionTable((Block)block, (Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.LOWER));
        this.add(RuBlocks.TALL_GREEN_BIOSHROOM.get(), block -> this.createSinglePropConditionTable((Block)block, (Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.LOWER));
        this.add(RuBlocks.TALL_PINK_BIOSHROOM.get(), block -> this.createSinglePropConditionTable((Block)block, (Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.LOWER));
        this.add(RuBlocks.TALL_YELLOW_BIOSHROOM.get(), block -> this.createSinglePropConditionTable((Block)block, (Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.LOWER));
        this.add(RuBlocks.ICICLE.get(), block -> this.createSilkTouchOnlyTable((ItemLike)block));
        this.dropSelf(RuBlocks.BARREL_CACTUS.get());
        this.dropSelf(RuBlocks.CAVE_HYSSOP.get());
        this.dropSelf(RuBlocks.DUCKWEED.get());
        this.add(RuBlocks.SPANISH_MOSS.get(), block -> RuBlockLootTables.createShearsOnlyDrop((ItemLike)block));
        this.add(RuBlocks.SPANISH_MOSS_PLANT.get(), block -> RuBlockLootTables.createShearsOnlyDrop((ItemLike)block));
        this.add(RuBlocks.KAPOK_VINES.get(), block -> RuBlockLootTables.createShearsOnlyDrop((ItemLike)block));
        this.add(RuBlocks.KAPOK_VINES_PLANT.get(), block -> RuBlockLootTables.createShearsOnlyDrop((ItemLike)block));
        this.dropSelf(RuBlocks.FLOWERING_LILY_PAD.get());
        this.add(RuBlocks.GIANT_LILY_PAD.get(), block -> this.createSingleItemTable((ItemLike)RuBlocks.FLOWERING_LILY_PAD.get()));
        this.add(RuBlocks.SALMONBERRY_BUSH.get(), block -> (LootTable.Builder)this.applyExplosionDecay((ItemLike)block, (FunctionUserBuilder)LootTable.lootTable().withPool(LootPool.lootPool().when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)RuBlocks.SALMONBERRY_BUSH.get()).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)SalmonBerryBushBlock.AGE, 3))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)RuItems.SALMONBERRY.get()))).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)2.0f, (float)3.0f))).apply((LootItemFunction.Builder)ApplyBonusCount.addUniformBonusCount((Holder)this.registries.holderOrThrow(Enchantments.FORTUNE)))).withPool(LootPool.lootPool().when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)RuBlocks.SALMONBERRY_BUSH.get()).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)SweetBerryBushBlock.AGE, 2))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)RuItems.SALMONBERRY.get()))).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)2.0f))).apply((LootItemFunction.Builder)ApplyBonusCount.addUniformBonusCount((Holder)this.registries.holderOrThrow(Enchantments.FORTUNE))))));
        this.add(RuBlocks.POTTED_ALPHA_DANDELION.get(), this.createPotFlowerItemTable((ItemLike)RuBlocks.ALPHA_DANDELION.get()));
        this.add(RuBlocks.POTTED_ALPHA_ROSE.get(), this.createPotFlowerItemTable((ItemLike)RuBlocks.ALPHA_ROSE.get()));
        this.add(RuBlocks.POTTED_ASTER.get(), this.createPotFlowerItemTable((ItemLike)RuBlocks.ASTER.get()));
        this.add(RuBlocks.POTTED_BLEEDING_HEART.get(), this.createPotFlowerItemTable((ItemLike)RuBlocks.BLEEDING_HEART.get()));
        this.add(RuBlocks.POTTED_DAISY.get(), this.createPotFlowerItemTable((ItemLike)RuBlocks.DAISY.get()));
        this.add(RuBlocks.POTTED_FELICIA_DAISY.get(), this.createPotFlowerItemTable((ItemLike)RuBlocks.FELICIA_DAISY.get()));
        this.add(RuBlocks.POTTED_DORCEL.get(), this.createPotFlowerItemTable((ItemLike)RuBlocks.DORCEL.get()));
        this.add(RuBlocks.POTTED_FIREWEED.get(), this.createPotFlowerItemTable((ItemLike)RuBlocks.FIREWEED.get()));
        this.add(RuBlocks.POTTED_GLISTERING_BLOOM.get(), this.createPotFlowerItemTable((ItemLike)RuBlocks.GLISTERING_BLOOM.get()));
        this.add(RuBlocks.POTTED_HIBISCUS.get(), this.createPotFlowerItemTable((ItemLike)RuBlocks.HIBISCUS.get()));
        this.add(RuBlocks.POTTED_HYSSOP.get(), this.createPotFlowerItemTable((ItemLike)RuBlocks.HYSSOP.get()));
        this.add(RuBlocks.POTTED_MALLOW.get(), this.createPotFlowerItemTable((ItemLike)RuBlocks.MALLOW.get()));
        this.add(RuBlocks.POTTED_POPPY_BUSH.get(), this.createPotFlowerItemTable((ItemLike)RuBlocks.POPPY_BUSH.get()));
        this.add(RuBlocks.POTTED_SALMON_POPPY_BUSH.get(), this.createPotFlowerItemTable((ItemLike)RuBlocks.SALMON_POPPY_BUSH.get()));
        this.add(RuBlocks.POTTED_TSUBAKI.get(), this.createPotFlowerItemTable((ItemLike)RuBlocks.TSUBAKI.get()));
        this.add(RuBlocks.POTTED_WARATAH.get(), this.createPotFlowerItemTable((ItemLike)RuBlocks.WARATAH.get()));
        this.add(RuBlocks.POTTED_WHITE_TRILLIUM.get(), this.createPotFlowerItemTable((ItemLike)RuBlocks.WHITE_TRILLIUM.get()));
        this.add(RuBlocks.POTTED_WILTING_TRILLIUM.get(), this.createPotFlowerItemTable((ItemLike)RuBlocks.WILTING_TRILLIUM.get()));
        this.add(RuBlocks.POTTED_BLUE_LUPINE.get(), this.createPotFlowerItemTable((ItemLike)RuBlocks.BLUE_LUPINE.get()));
        this.add(RuBlocks.POTTED_PINK_LUPINE.get(), this.createPotFlowerItemTable((ItemLike)RuBlocks.PINK_LUPINE.get()));
        this.add(RuBlocks.POTTED_PURPLE_LUPINE.get(), this.createPotFlowerItemTable((ItemLike)RuBlocks.PURPLE_LUPINE.get()));
        this.add(RuBlocks.POTTED_RED_LUPINE.get(), this.createPotFlowerItemTable((ItemLike)RuBlocks.RED_LUPINE.get()));
        this.add(RuBlocks.POTTED_YELLOW_LUPINE.get(), this.createPotFlowerItemTable((ItemLike)RuBlocks.YELLOW_LUPINE.get()));
        this.add(RuBlocks.POTTED_ORANGE_CONEFLOWER.get(), this.createPotFlowerItemTable((ItemLike)RuBlocks.ORANGE_CONEFLOWER.get()));
        this.add(RuBlocks.POTTED_PURPLE_CONEFLOWER.get(), this.createPotFlowerItemTable((ItemLike)RuBlocks.PURPLE_CONEFLOWER.get()));
        this.add(RuBlocks.POTTED_WHITE_SNOWBELLE.get(), this.createPotFlowerItemTable((ItemLike)RuBlocks.WHITE_SNOWBELLE.get()));
        this.add(RuBlocks.POTTED_LIGHT_GRAY_SNOWBELLE.get(), this.createPotFlowerItemTable((ItemLike)RuBlocks.LIGHT_GRAY_SNOWBELLE.get()));
        this.add(RuBlocks.POTTED_GRAY_SNOWBELLE.get(), this.createPotFlowerItemTable((ItemLike)RuBlocks.GRAY_SNOWBELLE.get()));
        this.add(RuBlocks.POTTED_RED_SNOWBELLE.get(), this.createPotFlowerItemTable((ItemLike)RuBlocks.RED_SNOWBELLE.get()));
        this.add(RuBlocks.POTTED_ORANGE_SNOWBELLE.get(), this.createPotFlowerItemTable((ItemLike)RuBlocks.ORANGE_SNOWBELLE.get()));
        this.add(RuBlocks.POTTED_YELLOW_SNOWBELLE.get(), this.createPotFlowerItemTable((ItemLike)RuBlocks.YELLOW_SNOWBELLE.get()));
        this.add(RuBlocks.POTTED_LIME_SNOWBELLE.get(), this.createPotFlowerItemTable((ItemLike)RuBlocks.LIME_SNOWBELLE.get()));
        this.add(RuBlocks.POTTED_GREEN_SNOWBELLE.get(), this.createPotFlowerItemTable((ItemLike)RuBlocks.GREEN_SNOWBELLE.get()));
        this.add(RuBlocks.POTTED_CYAN_SNOWBELLE.get(), this.createPotFlowerItemTable((ItemLike)RuBlocks.CYAN_SNOWBELLE.get()));
        this.add(RuBlocks.POTTED_LIGHT_BLUE_SNOWBELLE.get(), this.createPotFlowerItemTable((ItemLike)RuBlocks.LIGHT_BLUE_SNOWBELLE.get()));
        this.add(RuBlocks.POTTED_BLUE_SNOWBELLE.get(), this.createPotFlowerItemTable((ItemLike)RuBlocks.BLUE_SNOWBELLE.get()));
        this.add(RuBlocks.POTTED_PURPLE_SNOWBELLE.get(), this.createPotFlowerItemTable((ItemLike)RuBlocks.PURPLE_SNOWBELLE.get()));
        this.add(RuBlocks.POTTED_MAGENTA_SNOWBELLE.get(), this.createPotFlowerItemTable((ItemLike)RuBlocks.MAGENTA_SNOWBELLE.get()));
        this.add(RuBlocks.POTTED_PINK_SNOWBELLE.get(), this.createPotFlowerItemTable((ItemLike)RuBlocks.PINK_SNOWBELLE.get()));
        this.add(RuBlocks.POTTED_BROWN_SNOWBELLE.get(), this.createPotFlowerItemTable((ItemLike)RuBlocks.BROWN_SNOWBELLE.get()));
        this.add(RuBlocks.POTTED_BLACK_SNOWBELLE.get(), this.createPotFlowerItemTable((ItemLike)RuBlocks.BLACK_SNOWBELLE.get()));
        this.add(RuBlocks.POTTED_DAY_LILY.get(), this.createPotFlowerItemTable((ItemLike)RuBlocks.DAY_LILY.get()));
        this.add(RuBlocks.POTTED_MEADOW_SAGE.get(), this.createPotFlowerItemTable((ItemLike)RuBlocks.MEADOW_SAGE.get()));
        this.add(RuBlocks.POTTED_CAVE_HYSSOP.get(), this.createPotFlowerItemTable((ItemLike)RuBlocks.CAVE_HYSSOP.get()));
        this.add(RuBlocks.POTTED_BARREL_CACTUS.get(), this.createPotFlowerItemTable((ItemLike)RuBlocks.BARREL_CACTUS.get()));
        this.add(RuBlocks.POTTED_DUSKTRAP.get(), this.createPotFlowerItemTable((ItemLike)RuBlocks.DUSKTRAP.get()));
        this.add(RuBlocks.POTTED_CORPSE_FLOWER.get(), this.createPotFlowerItemTable((ItemLike)RuBlocks.CORPSE_FLOWER.get()));
        this.add(RuBlocks.POTTED_COBALT_EARLIGHT.get(), this.createPotFlowerItemTable((ItemLike)RuBlocks.COBALT_EARLIGHT.get()));
        this.add(RuBlocks.POTTED_TALL_COBALT_EARLIGHT.get(), this.createPotFlowerItemTable((ItemLike)RuBlocks.TALL_COBALT_EARLIGHT.get()));
        this.add(RuBlocks.POTTED_MYCOTOXIC_DAISY.get(), this.createPotFlowerItemTable((ItemLike)RuBlocks.MYCOTOXIC_DAISY.get()));
        this.add(RuBlocks.POTTED_GLISTER_SPIRE.get(), this.createPotFlowerItemTable((ItemLike)RuBlocks.GLISTER_SPIRE.get()));
        this.add(RuBlocks.POTTED_BLUE_BIOSHROOM.get(), this.createPotFlowerItemTable((ItemLike)RuBlocks.BLUE_BIOSHROOM.get()));
        this.add(RuBlocks.POTTED_GREEN_BIOSHROOM.get(), this.createPotFlowerItemTable((ItemLike)RuBlocks.GREEN_BIOSHROOM.get()));
        this.add(RuBlocks.POTTED_PINK_BIOSHROOM.get(), this.createPotFlowerItemTable((ItemLike)RuBlocks.PINK_BIOSHROOM.get()));
        this.add(RuBlocks.POTTED_YELLOW_BIOSHROOM.get(), this.createPotFlowerItemTable((ItemLike)RuBlocks.YELLOW_BIOSHROOM.get()));
        this.add(RuBlocks.POTTED_TALL_BLUE_BIOSHROOM.get(), this.createPotFlowerItemTable((ItemLike)RuBlocks.TALL_BLUE_BIOSHROOM.get()));
        this.add(RuBlocks.POTTED_TALL_GREEN_BIOSHROOM.get(), this.createPotFlowerItemTable((ItemLike)RuBlocks.TALL_GREEN_BIOSHROOM.get()));
        this.add(RuBlocks.POTTED_TALL_PINK_BIOSHROOM.get(), this.createPotFlowerItemTable((ItemLike)RuBlocks.TALL_PINK_BIOSHROOM.get()));
        this.add(RuBlocks.POTTED_TALL_YELLOW_BIOSHROOM.get(), this.createPotFlowerItemTable((ItemLike)RuBlocks.TALL_YELLOW_BIOSHROOM.get()));
        this.add(RuBlocks.POTTED_ASHEN_SAPLING.get(), this.createPotFlowerItemTable((ItemLike)RuBlocks.ASHEN_SAPLING.get()));
        this.add(RuBlocks.POTTED_ALPHA_SAPLING.get(), this.createPotFlowerItemTable((ItemLike)RuBlocks.ALPHA_SAPLING.get()));
        this.add(RuBlocks.POTTED_APPLE_OAK_SAPLING.get(), this.createPotFlowerItemTable((ItemLike)RuBlocks.APPLE_OAK_SAPLING.get()));
        this.add(RuBlocks.POTTED_BAMBOO_SAPLING.get(), this.createPotFlowerItemTable((ItemLike)RuBlocks.BAMBOO_SAPLING.get()));
        this.add(RuBlocks.POTTED_BAOBAB_SAPLING.get(), this.createPotFlowerItemTable((ItemLike)RuBlocks.BAOBAB_SAPLING.get()));
        this.add(RuBlocks.POTTED_BLACKWOOD_SAPLING.get(), this.createPotFlowerItemTable((ItemLike)RuBlocks.BLACKWOOD_SAPLING.get()));
        this.add(RuBlocks.POTTED_BRIMWOOD_SAPLING.get(), this.createPotFlowerItemTable((ItemLike)RuBlocks.BRIMWOOD_SAPLING.get()));
        this.add(RuBlocks.POTTED_COBALT_SAPLING.get(), this.createPotFlowerItemTable((ItemLike)RuBlocks.COBALT_SAPLING.get()));
        this.add(RuBlocks.POTTED_CACTUS_FLOWER.get(), this.createPotFlowerItemTable((ItemLike)RuBlocks.CACTUS_FLOWER.get()));
        this.add(RuBlocks.POTTED_MAGNOLIA_SAPLING.get(), this.createPotFlowerItemTable((ItemLike)RuBlocks.MAGNOLIA_SAPLING.get()));
        this.add(RuBlocks.POTTED_CYPRESS_SAPLING.get(), this.createPotFlowerItemTable((ItemLike)RuBlocks.CYPRESS_SAPLING.get()));
        this.add(RuBlocks.POTTED_DEAD_PINE_SAPLING.get(), this.createPotFlowerItemTable((ItemLike)RuBlocks.DEAD_PINE_SAPLING.get()));
        this.add(RuBlocks.POTTED_DEAD_SAPLING.get(), this.createPotFlowerItemTable((ItemLike)RuBlocks.DEAD_SAPLING.get()));
        this.add(RuBlocks.POTTED_EUCALYPTUS_SAPLING.get(), this.createPotFlowerItemTable((ItemLike)RuBlocks.EUCALYPTUS_SAPLING.get()));
        this.add(RuBlocks.POTTED_FLOWERING_SAPLING.get(), this.createPotFlowerItemTable((ItemLike)RuBlocks.FLOWERING_SAPLING.get()));
        this.add(RuBlocks.POTTED_GOLDEN_LARCH_SAPLING.get(), this.createPotFlowerItemTable((ItemLike)RuBlocks.GOLDEN_LARCH_SAPLING.get()));
        this.add(RuBlocks.POTTED_JOSHUA_SAPLING.get(), this.createPotFlowerItemTable((ItemLike)RuBlocks.JOSHUA_SAPLING.get()));
        this.add(RuBlocks.POTTED_KAPOK_SAPLING.get(), this.createPotFlowerItemTable((ItemLike)RuBlocks.KAPOK_SAPLING.get()));
        this.add(RuBlocks.POTTED_LARCH_SAPLING.get(), this.createPotFlowerItemTable((ItemLike)RuBlocks.LARCH_SAPLING.get()));
        this.add(RuBlocks.POTTED_MAPLE_SAPLING.get(), this.createPotFlowerItemTable((ItemLike)RuBlocks.MAPLE_SAPLING.get()));
        this.add(RuBlocks.POTTED_MAUVE_SAPLING.get(), this.createPotFlowerItemTable((ItemLike)RuBlocks.MAUVE_SAPLING.get()));
        this.add(RuBlocks.POTTED_ORANGE_MAPLE_SAPLING.get(), this.createPotFlowerItemTable((ItemLike)RuBlocks.ORANGE_MAPLE_SAPLING.get()));
        this.add(RuBlocks.POTTED_PALM_SAPLING.get(), this.createPotFlowerItemTable((ItemLike)RuBlocks.PALM_SAPLING.get()));
        this.add(RuBlocks.POTTED_PINE_SAPLING.get(), this.createPotFlowerItemTable((ItemLike)RuBlocks.PINE_SAPLING.get()));
        this.add(RuBlocks.POTTED_BLUE_MAGNOLIA_SAPLING.get(), this.createPotFlowerItemTable((ItemLike)RuBlocks.BLUE_MAGNOLIA_SAPLING.get()));
        this.add(RuBlocks.POTTED_PINK_MAGNOLIA_SAPLING.get(), this.createPotFlowerItemTable((ItemLike)RuBlocks.PINK_MAGNOLIA_SAPLING.get()));
        this.add(RuBlocks.POTTED_REDWOOD_SAPLING.get(), this.createPotFlowerItemTable((ItemLike)RuBlocks.REDWOOD_SAPLING.get()));
        this.add(RuBlocks.POTTED_RED_MAPLE_SAPLING.get(), this.createPotFlowerItemTable((ItemLike)RuBlocks.RED_MAPLE_SAPLING.get()));
        this.add(RuBlocks.POTTED_ENCHANTED_BIRCH_SAPLING.get(), this.createPotFlowerItemTable((ItemLike)RuBlocks.ENCHANTED_BIRCH_SAPLING.get()));
        this.add(RuBlocks.POTTED_SILVER_BIRCH_SAPLING.get(), this.createPotFlowerItemTable((ItemLike)RuBlocks.SILVER_BIRCH_SAPLING.get()));
        this.add(RuBlocks.POTTED_SMALL_OAK_SAPLING.get(), this.createPotFlowerItemTable((ItemLike)RuBlocks.SMALL_OAK_SAPLING.get()));
        this.add(RuBlocks.POTTED_SOCOTRA_SAPLING.get(), this.createPotFlowerItemTable((ItemLike)RuBlocks.SOCOTRA_SAPLING.get()));
        this.add(RuBlocks.POTTED_WHITE_MAGNOLIA_SAPLING.get(), this.createPotFlowerItemTable((ItemLike)RuBlocks.WHITE_MAGNOLIA_SAPLING.get()));
        this.add(RuBlocks.POTTED_WILLOW_SAPLING.get(), this.createPotFlowerItemTable((ItemLike)RuBlocks.WILLOW_SAPLING.get()));
        this.add(RuBlocks.BLUE_BIOSHROOM_BLOCK.get(), block -> this.createMushroomBlockDrop((Block)block, (ItemLike)RuBlocks.BLUE_BIOSHROOM.get()));
        this.add(RuBlocks.GLOWING_BLUE_BIOSHROOM_BLOCK.get(), block -> this.createMushroomBlockDrop((Block)block, (ItemLike)RuBlocks.BLUE_BIOSHROOM.get()));
        this.add(RuBlocks.GREEN_BIOSHROOM_BLOCK.get(), block -> this.createMushroomBlockDrop((Block)block, (ItemLike)RuBlocks.GREEN_BIOSHROOM.get()));
        this.add(RuBlocks.GLOWING_GREEN_BIOSHROOM_BLOCK.get(), block -> this.createMushroomBlockDrop((Block)block, (ItemLike)RuBlocks.GREEN_BIOSHROOM.get()));
        this.add(RuBlocks.PINK_BIOSHROOM_BLOCK.get(), block -> this.createMushroomBlockDrop((Block)block, (ItemLike)RuBlocks.PINK_BIOSHROOM.get()));
        this.add(RuBlocks.GLOWING_PINK_BIOSHROOM_BLOCK.get(), block -> this.createMushroomBlockDrop((Block)block, (ItemLike)RuBlocks.PINK_BIOSHROOM.get()));
        this.add(RuBlocks.YELLOW_BIOSHROOM_BLOCK.get(), block -> this.createMushroomBlockDrop((Block)block, (ItemLike)RuBlocks.YELLOW_BIOSHROOM.get()));
        this.add(RuBlocks.GLOWING_YELLOW_BIOSHROOM_BLOCK.get(), block -> this.createMushroomBlockDrop((Block)block, (ItemLike)RuBlocks.YELLOW_BIOSHROOM.get()));
        this.dropSelf(RuBlocks.BAMBOO_LOG.get());
        this.dropSelf(RuBlocks.STRIPPED_BAMBOO_LOG.get());
        this.dropSelf(RuBlocks.SMALL_OAK_LOG.get());
        this.dropSelf(RuBlocks.STRIPPED_SMALL_OAK_LOG.get());
        this.dropSelf(RuBlocks.SAGUARO_CACTUS.get());
        this.add(RuBlocks.ALPHA_LEAVES.get(), block -> this.createLeavesDrops((Block)block, RuBlocks.ALPHA_SAPLING.get(), NORMAL_LEAVES_SAPLING_CHANCES));
        this.add(RuBlocks.APPLE_OAK_LEAVES.get(), block -> this.createOakLeavesDrops((Block)block, RuBlocks.APPLE_OAK_SAPLING.get(), NORMAL_LEAVES_SAPLING_CHANCES));
        this.add(RuBlocks.ASHEN_LEAVES.get(), block -> this.createOakLeavesDrops((Block)block, RuBlocks.ASHEN_SAPLING.get(), NORMAL_LEAVES_SAPLING_CHANCES));
        this.add(RuBlocks.BAMBOO_LEAVES.get(), block -> this.createLeavesDrops((Block)block, RuBlocks.BAMBOO_SAPLING.get(), NORMAL_LEAVES_SAPLING_CHANCES));
        this.add(RuBlocks.BAOBAB_LEAVES.get(), block -> this.createLeavesDrops((Block)block, RuBlocks.BAOBAB_SAPLING.get(), NORMAL_LEAVES_SAPLING_CHANCES));
        this.add(RuBlocks.BLACKWOOD_LEAVES.get(), block -> this.createLeavesDrops((Block)block, RuBlocks.BLACKWOOD_SAPLING.get(), NORMAL_LEAVES_SAPLING_CHANCES));
        this.add(RuBlocks.COBALT_WEBBING.get(), block -> this.createLeavesDrops((Block)block, RuBlocks.COBALT_SAPLING.get(), COBALT_LEAVES_SAPLING_CHANCES));
        this.add(RuBlocks.MAGNOLIA_LEAVES.get(), block -> this.createLeavesDrops((Block)block, RuBlocks.MAGNOLIA_SAPLING.get(), NORMAL_LEAVES_SAPLING_CHANCES));
        this.add(RuBlocks.CYPRESS_LEAVES.get(), block -> this.createLeavesDrops((Block)block, RuBlocks.CYPRESS_SAPLING.get(), NORMAL_LEAVES_SAPLING_CHANCES));
        this.add(RuBlocks.DEAD_LEAVES.get(), block -> this.createLeavesDrops((Block)block, RuBlocks.DEAD_SAPLING.get(), NORMAL_LEAVES_SAPLING_CHANCES));
        this.add(RuBlocks.DEAD_PINE_LEAVES.get(), block -> this.createLeavesDrops((Block)block, RuBlocks.DEAD_PINE_SAPLING.get(), NORMAL_LEAVES_SAPLING_CHANCES));
        this.add(RuBlocks.EUCALYPTUS_LEAVES.get(), block -> this.createLeavesDrops((Block)block, RuBlocks.EUCALYPTUS_SAPLING.get(), NORMAL_LEAVES_SAPLING_CHANCES));
        this.add(RuBlocks.FLOWERING_LEAVES.get(), block -> this.createOakLeavesDrops((Block)block, RuBlocks.FLOWERING_SAPLING.get(), FLOWERING_OAK_LEAVES_SAPLING_CHANCES));
        this.add(RuBlocks.GOLDEN_LARCH_LEAVES.get(), block -> this.createLeavesDrops((Block)block, RuBlocks.GOLDEN_LARCH_SAPLING.get(), NORMAL_LEAVES_SAPLING_CHANCES));
        this.add(RuBlocks.JOSHUA_LEAVES.get(), block -> this.createDoublePlantWithSeedDropsNoGrass((Block)block, RuBlocks.JOSHUA_LEAVES.get(), (ItemLike)RuBlocks.JOSHUA_SAPLING.get(), JOSHUA_LEAVES_SAPLING_CHANCES));
        this.add(RuBlocks.KAPOK_LEAVES.get(), block -> this.createLeavesDrops((Block)block, RuBlocks.KAPOK_SAPLING.get(), NORMAL_LEAVES_SAPLING_CHANCES));
        this.add(RuBlocks.LARCH_LEAVES.get(), block -> this.createLeavesDrops((Block)block, RuBlocks.LARCH_SAPLING.get(), NORMAL_LEAVES_SAPLING_CHANCES));
        this.add(RuBlocks.MAPLE_LEAVES.get(), block -> this.createOakLeavesDrops((Block)block, RuBlocks.MAPLE_SAPLING.get(), NORMAL_LEAVES_SAPLING_CHANCES));
        this.add(RuBlocks.MAUVE_LEAVES.get(), block -> this.createOakLeavesDrops((Block)block, RuBlocks.MAUVE_SAPLING.get(), NORMAL_LEAVES_SAPLING_CHANCES));
        this.add(RuBlocks.ORANGE_MAPLE_LEAVES.get(), block -> this.createOakLeavesDrops((Block)block, RuBlocks.ORANGE_MAPLE_SAPLING.get(), NORMAL_LEAVES_SAPLING_CHANCES));
        this.add(RuBlocks.PALM_LEAVES.get(), block -> this.createLeavesDrops((Block)block, RuBlocks.PALM_SAPLING.get(), PALM_LEAVES_SAPLING_CHANCES));
        this.add(RuBlocks.PINE_LEAVES.get(), block -> this.createLeavesDrops((Block)block, RuBlocks.PINE_SAPLING.get(), NORMAL_LEAVES_SAPLING_CHANCES));
        this.add(RuBlocks.BLUE_MAGNOLIA_LEAVES.get(), block -> this.createLeavesDrops((Block)block, RuBlocks.BLUE_MAGNOLIA_SAPLING.get(), NORMAL_LEAVES_SAPLING_CHANCES));
        this.add(RuBlocks.PINK_MAGNOLIA_LEAVES.get(), block -> this.createLeavesDrops((Block)block, RuBlocks.PINK_MAGNOLIA_SAPLING.get(), NORMAL_LEAVES_SAPLING_CHANCES));
        this.add(RuBlocks.REDWOOD_LEAVES.get(), block -> this.createLeavesDrops((Block)block, RuBlocks.REDWOOD_SAPLING.get(), NORMAL_LEAVES_SAPLING_CHANCES));
        this.add(RuBlocks.RED_MAPLE_LEAVES.get(), block -> this.createOakLeavesDrops((Block)block, RuBlocks.RED_MAPLE_SAPLING.get(), NORMAL_LEAVES_SAPLING_CHANCES));
        this.add(RuBlocks.BRIMWOOD_LEAVES.get(), block -> this.createSilkTouchOrShearsDispatchTable((Block)block, (LootPoolEntryContainer.Builder<?>)((LootPoolSingletonContainer.Builder)this.applyExplosionCondition((ItemLike)block, (ConditionUserBuilder)LootItem.lootTableItem((ItemLike)((ItemLike)RuBlocks.BRIMWOOD_SAPLING.get())))).when(BonusLevelTableCondition.bonusLevelFlatChance((Holder)this.registries.holderOrThrow(Enchantments.FORTUNE), (float[])NORMAL_LEAVES_SAPLING_CHANCES))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).when(this.HAS_NO_SHEARS_OR_SILK_TOUCH)));
        this.add(RuBlocks.SILVER_BIRCH_LEAVES.get(), block -> this.createLeavesDrops((Block)block, RuBlocks.SILVER_BIRCH_SAPLING.get(), ASPEN_LEAVES_SAPLING_CHANCES));
        this.add(RuBlocks.SMALL_OAK_LEAVES.get(), block -> this.createOakLeavesDrops((Block)block, RuBlocks.SMALL_OAK_SAPLING.get(), SMALL_OAK_LEAVES_SAPLING_CHANCES));
        this.add(RuBlocks.SOCOTRA_LEAVES.get(), block -> this.createLeavesDrops((Block)block, RuBlocks.SOCOTRA_SAPLING.get(), NORMAL_LEAVES_SAPLING_CHANCES));
        this.add(RuBlocks.ENCHANTED_BIRCH_LEAVES.get(), block -> this.createLeavesDrops((Block)block, RuBlocks.ENCHANTED_BIRCH_SAPLING.get(), ASPEN_LEAVES_SAPLING_CHANCES));
        this.add(RuBlocks.WHITE_MAGNOLIA_LEAVES.get(), block -> this.createLeavesDrops((Block)block, RuBlocks.WHITE_MAGNOLIA_SAPLING.get(), NORMAL_LEAVES_SAPLING_CHANCES));
        this.add(RuBlocks.WILLOW_LEAVES.get(), block -> this.createLeavesDrops((Block)block, RuBlocks.WILLOW_SAPLING.get(), NORMAL_LEAVES_SAPLING_CHANCES));
        this.add(RuBlocks.ACACIA_BRANCH.get(), block -> this.createShearsDispatchTable((Block)block, (LootPoolEntryContainer.Builder<?>)((LootPoolEntryContainer.Builder)this.applyExplosionCondition((ItemLike)block, (ConditionUserBuilder)LootItem.lootTableItem((ItemLike)Items.STICK)))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)4.0f)).when(HAS_SHEARS.invert())));
        this.add(RuBlocks.BAOBAB_BRANCH.get(), block -> this.createShearsDispatchTable((Block)block, (LootPoolEntryContainer.Builder<?>)((LootPoolEntryContainer.Builder)this.applyExplosionCondition((ItemLike)block, (ConditionUserBuilder)LootItem.lootTableItem((ItemLike)Items.STICK)))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)4.0f)).when(HAS_SHEARS.invert())));
        this.add(RuBlocks.BIRCH_BRANCH.get(), block -> this.createShearsDispatchTable((Block)block, (LootPoolEntryContainer.Builder<?>)((LootPoolEntryContainer.Builder)this.applyExplosionCondition((ItemLike)block, (ConditionUserBuilder)LootItem.lootTableItem((ItemLike)Items.STICK)))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)4.0f)).when(HAS_SHEARS.invert())));
        this.add(RuBlocks.BLACKWOOD_BRANCH.get(), block -> this.createShearsDispatchTable((Block)block, (LootPoolEntryContainer.Builder<?>)((LootPoolEntryContainer.Builder)this.applyExplosionCondition((ItemLike)block, (ConditionUserBuilder)LootItem.lootTableItem((ItemLike)Items.STICK)))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)4.0f)).when(HAS_SHEARS.invert())));
        this.add(RuBlocks.MAGNOLIA_BRANCH.get(), block -> this.createShearsDispatchTable((Block)block, (LootPoolEntryContainer.Builder<?>)((LootPoolEntryContainer.Builder)this.applyExplosionCondition((ItemLike)block, (ConditionUserBuilder)LootItem.lootTableItem((ItemLike)Items.STICK)))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)4.0f)).when(HAS_SHEARS.invert())));
        this.add(RuBlocks.CYPRESS_BRANCH.get(), block -> this.createShearsDispatchTable((Block)block, (LootPoolEntryContainer.Builder<?>)((LootPoolEntryContainer.Builder)this.applyExplosionCondition((ItemLike)block, (ConditionUserBuilder)LootItem.lootTableItem((ItemLike)Items.STICK)))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)4.0f)).when(HAS_SHEARS.invert())));
        this.add(RuBlocks.CHERRY_BRANCH.get(), block -> this.createShearsDispatchTable((Block)block, (LootPoolEntryContainer.Builder<?>)((LootPoolEntryContainer.Builder)this.applyExplosionCondition((ItemLike)block, (ConditionUserBuilder)LootItem.lootTableItem((ItemLike)Items.STICK)))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)4.0f)).when(HAS_SHEARS.invert())));
        this.add(RuBlocks.DARK_OAK_BRANCH.get(), block -> this.createShearsDispatchTable((Block)block, (LootPoolEntryContainer.Builder<?>)((LootPoolEntryContainer.Builder)this.applyExplosionCondition((ItemLike)block, (ConditionUserBuilder)LootItem.lootTableItem((ItemLike)Items.STICK)))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)4.0f)).when(HAS_SHEARS.invert())));
        this.add(RuBlocks.DEAD_BRANCH.get(), block -> this.createShearsDispatchTable((Block)block, (LootPoolEntryContainer.Builder<?>)((LootPoolEntryContainer.Builder)this.applyExplosionCondition((ItemLike)block, (ConditionUserBuilder)LootItem.lootTableItem((ItemLike)Items.STICK)))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)4.0f)).when(HAS_SHEARS.invert())));
        this.add(RuBlocks.EUCALYPTUS_BRANCH.get(), block -> this.createShearsDispatchTable((Block)block, (LootPoolEntryContainer.Builder<?>)((LootPoolEntryContainer.Builder)this.applyExplosionCondition((ItemLike)block, (ConditionUserBuilder)LootItem.lootTableItem((ItemLike)Items.STICK)))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)4.0f)).when(HAS_SHEARS.invert())));
        this.add(RuBlocks.JOSHUA_BEARD.get(), block -> this.createShearsDispatchTable((Block)block, (LootPoolEntryContainer.Builder<?>)((LootPoolEntryContainer.Builder)this.applyExplosionCondition((ItemLike)block, (ConditionUserBuilder)LootItem.lootTableItem((ItemLike)Items.STICK)))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)4.0f)).when(HAS_SHEARS.invert())));
        this.add(RuBlocks.JUNGLE_BRANCH.get(), block -> this.createShearsDispatchTable((Block)block, (LootPoolEntryContainer.Builder<?>)((LootPoolEntryContainer.Builder)this.applyExplosionCondition((ItemLike)block, (ConditionUserBuilder)LootItem.lootTableItem((ItemLike)Items.STICK)))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)4.0f)).when(HAS_SHEARS.invert())));
        this.add(RuBlocks.KAPOK_BRANCH.get(), block -> this.createShearsDispatchTable((Block)block, (LootPoolEntryContainer.Builder<?>)((LootPoolEntryContainer.Builder)this.applyExplosionCondition((ItemLike)block, (ConditionUserBuilder)LootItem.lootTableItem((ItemLike)Items.STICK)))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)4.0f)).when(HAS_SHEARS.invert())));
        this.add(RuBlocks.LARCH_BRANCH.get(), block -> this.createShearsDispatchTable((Block)block, (LootPoolEntryContainer.Builder<?>)((LootPoolEntryContainer.Builder)this.applyExplosionCondition((ItemLike)block, (ConditionUserBuilder)LootItem.lootTableItem((ItemLike)Items.STICK)))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)4.0f)).when(HAS_SHEARS.invert())));
        this.add(RuBlocks.MANGROVE_BRANCH.get(), block -> this.createShearsDispatchTable((Block)block, (LootPoolEntryContainer.Builder<?>)((LootPoolEntryContainer.Builder)this.applyExplosionCondition((ItemLike)block, (ConditionUserBuilder)LootItem.lootTableItem((ItemLike)Items.STICK)))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)4.0f)).when(HAS_SHEARS.invert())));
        this.add(RuBlocks.MAPLE_BRANCH.get(), block -> this.createShearsDispatchTable((Block)block, (LootPoolEntryContainer.Builder<?>)((LootPoolEntryContainer.Builder)this.applyExplosionCondition((ItemLike)block, (ConditionUserBuilder)LootItem.lootTableItem((ItemLike)Items.STICK)))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)4.0f)).when(HAS_SHEARS.invert())));
        this.add(RuBlocks.MAUVE_BRANCH.get(), block -> this.createShearsDispatchTable((Block)block, (LootPoolEntryContainer.Builder<?>)((LootPoolEntryContainer.Builder)this.applyExplosionCondition((ItemLike)block, (ConditionUserBuilder)LootItem.lootTableItem((ItemLike)Items.STICK)))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)4.0f)).when(HAS_SHEARS.invert())));
        this.add(RuBlocks.OAK_BRANCH.get(), block -> this.createShearsDispatchTable((Block)block, (LootPoolEntryContainer.Builder<?>)((LootPoolEntryContainer.Builder)this.applyExplosionCondition((ItemLike)block, (ConditionUserBuilder)LootItem.lootTableItem((ItemLike)Items.STICK)))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)4.0f)).when(HAS_SHEARS.invert())));
        this.add(RuBlocks.PALM_BEARD.get(), block -> this.createShearsDispatchTable((Block)block, (LootPoolEntryContainer.Builder<?>)((LootPoolEntryContainer.Builder)this.applyExplosionCondition((ItemLike)block, (ConditionUserBuilder)LootItem.lootTableItem((ItemLike)Items.STICK)))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)4.0f)).when(HAS_SHEARS.invert())));
        this.add(RuBlocks.PINE_BRANCH.get(), block -> this.createShearsDispatchTable((Block)block, (LootPoolEntryContainer.Builder<?>)((LootPoolEntryContainer.Builder)this.applyExplosionCondition((ItemLike)block, (ConditionUserBuilder)LootItem.lootTableItem((ItemLike)Items.STICK)))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)4.0f)).when(HAS_SHEARS.invert())));
        this.add(RuBlocks.REDWOOD_BRANCH.get(), block -> this.createShearsDispatchTable((Block)block, (LootPoolEntryContainer.Builder<?>)((LootPoolEntryContainer.Builder)this.applyExplosionCondition((ItemLike)block, (ConditionUserBuilder)LootItem.lootTableItem((ItemLike)Items.STICK)))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)4.0f)).when(HAS_SHEARS.invert())));
        this.add(RuBlocks.SILVER_BIRCH_BRANCH.get(), block -> this.createShearsDispatchTable((Block)block, (LootPoolEntryContainer.Builder<?>)((LootPoolEntryContainer.Builder)this.applyExplosionCondition((ItemLike)block, (ConditionUserBuilder)LootItem.lootTableItem((ItemLike)Items.STICK)))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)4.0f)).when(HAS_SHEARS.invert())));
        this.add(RuBlocks.SOCOTRA_BRANCH.get(), block -> this.createShearsDispatchTable((Block)block, (LootPoolEntryContainer.Builder<?>)((LootPoolEntryContainer.Builder)this.applyExplosionCondition((ItemLike)block, (ConditionUserBuilder)LootItem.lootTableItem((ItemLike)Items.STICK)))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)4.0f)).when(HAS_SHEARS.invert())));
        this.add(RuBlocks.SPRUCE_BRANCH.get(), block -> this.createShearsDispatchTable((Block)block, (LootPoolEntryContainer.Builder<?>)((LootPoolEntryContainer.Builder)this.applyExplosionCondition((ItemLike)block, (ConditionUserBuilder)LootItem.lootTableItem((ItemLike)Items.STICK)))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)4.0f)).when(HAS_SHEARS.invert())));
        this.add(RuBlocks.WILLOW_BRANCH.get(), block -> this.createShearsDispatchTable((Block)block, (LootPoolEntryContainer.Builder<?>)((LootPoolEntryContainer.Builder)this.applyExplosionCondition((ItemLike)block, (ConditionUserBuilder)LootItem.lootTableItem((ItemLike)Items.STICK)))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)4.0f)).when(HAS_SHEARS.invert())));
        this.add(RuBlocks.PEAT_GRASS_BLOCK.get(), block -> this.createSingleItemTableWithSilkTouch((Block)block, (ItemLike)RuBlocks.PEAT_DIRT.get()));
        this.dropSelf(RuBlocks.PEAT_DIRT.get());
        this.add(RuBlocks.PEAT_DIRT_PATH.get(), block -> this.createSingleItemTableWithSilkTouch((Block)block, (ItemLike)RuBlocks.PEAT_DIRT.get()));
        this.dropSelf(RuBlocks.PEAT_COARSE_DIRT.get());
        this.dropSelf(RuBlocks.PEAT_PODZOL.get());
        this.dropSelf(RuBlocks.PEAT_MUD.get());
        this.add(RuBlocks.PEAT_FARMLAND.get(), block -> this.createSingleItemTableWithSilkTouch((Block)block, (ItemLike)RuBlocks.PEAT_DIRT.get()));
        this.add(RuBlocks.SILT_GRASS_BLOCK.get(), block -> this.createSingleItemTableWithSilkTouch((Block)block, (ItemLike)RuBlocks.SILT_DIRT.get()));
        this.dropSelf(RuBlocks.SILT_DIRT.get());
        this.add(RuBlocks.SILT_DIRT_PATH.get(), block -> this.createSingleItemTableWithSilkTouch((Block)block, (ItemLike)RuBlocks.SILT_DIRT.get()));
        this.dropSelf(RuBlocks.SILT_COARSE_DIRT.get());
        this.dropSelf(RuBlocks.SILT_PODZOL.get());
        this.dropSelf(RuBlocks.SILT_MUD.get());
        this.add(RuBlocks.SILT_FARMLAND.get(), block -> this.createSingleItemTableWithSilkTouch((Block)block, (ItemLike)RuBlocks.SILT_DIRT.get()));
        this.add(RuBlocks.ALPHA_GRASS_BLOCK.get(), block -> this.createSingleItemTableWithSilkTouch((Block)block, (ItemLike)Blocks.DIRT));
        this.dropSelf(RuBlocks.ASHEN_DIRT.get());
        this.dropSelf(RuBlocks.CHALK.get());
        this.add(RuBlocks.CHALK_GRASS_BLOCK.get(), block -> this.createSingleItemTableWithSilkTouch((Block)block, (ItemLike)RuBlocks.CHALK.get()));
        this.dropSelf(RuBlocks.CHALK_BRICKS.get());
        this.add(RuBlocks.CHALK_BRICK_SLAB.get(), block -> this.createSlabItemTable((Block)block));
        this.dropSelf(RuBlocks.CHALK_BRICK_STAIRS.get());
        this.dropSelf(RuBlocks.CHALK_PILLAR.get());
        this.add(RuBlocks.CHALK_SLAB.get(), block -> this.createSlabItemTable((Block)block));
        this.dropSelf(RuBlocks.CHALK_STAIRS.get());
        this.dropSelf(RuBlocks.POLISHED_CHALK.get());
        this.add(RuBlocks.POLISHED_CHALK_SLAB.get(), block -> this.createSlabItemTable((Block)block));
        this.dropSelf(RuBlocks.POLISHED_CHALK_STAIRS.get());
        this.dropSelf(RuBlocks.ARGILLITE.get());
        this.add(RuBlocks.MOSSY_STONE.get(), block -> this.createSingleItemTableWithSilkTouch((Block)block, (ItemLike)Blocks.MOSSY_COBBLESTONE));
        this.dropSelf(RuBlocks.HYACINTH_LAMP.get());
        this.dropSelf(RuBlocks.HYACINTH_BLOOM.get());
        this.add(RuBlocks.HYACINTH_FLOWERS.get(), block -> this.createMultifaceBlockDrops((Block)block, HAS_SHEARS));
        this.dropSelf(RuBlocks.TALL_HYACINTH_STOCK.get());
        this.add(RuBlocks.ASH.get(), block -> this.createSilkTouchDispatchTable((Block)block, (LootPoolEntryContainer.Builder)this.applyExplosionCondition((ItemLike)Items.FLINT, (ConditionUserBuilder)((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)block).when(BonusLevelTableCondition.bonusLevelFlatChance((Holder)this.registries.holderOrThrow(Enchantments.SILK_TOUCH), (float[])new float[]{1.0f}))).otherwise((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.FLINT)))));
        this.add(RuBlocks.VOLCANIC_ASH.get(), block -> this.createSilkTouchDispatchTable((Block)block, (LootPoolEntryContainer.Builder)this.applyExplosionCondition((ItemLike)Items.FLINT, (ConditionUserBuilder)((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)block).when(BonusLevelTableCondition.bonusLevelFlatChance((Holder)this.registries.holderOrThrow(Enchantments.SILK_TOUCH), (float[])new float[]{1.0f}))).otherwise((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.FLINT)))));
        this.dropSelf(RuBlocks.ASH_VENT.get());
        this.dropSelf(RuBlocks.ASHEN_LOG.get());
        this.dropSelf(RuBlocks.ASHEN_WOOD.get());
        this.dropSelf(RuBlocks.SILVER_BIRCH_LOG.get());
        this.dropSelf(RuBlocks.SILVER_BIRCH_WOOD.get());
        this.dropSelf(RuBlocks.ALPHA_LOG.get());
        this.dropSelf(RuBlocks.ALPHA_PLANKS.get());
        this.dropSelf(RuBlocks.ALPHA_STAIRS.get());
        this.add(RuBlocks.ALPHA_SLAB.get(), block -> this.createSlabItemTable((Block)block));
        this.dropSelf(RuBlocks.BAOBAB_LOG.get());
        this.dropSelf(RuBlocks.STRIPPED_BAOBAB_LOG.get());
        this.dropSelf(RuBlocks.BAOBAB_WOOD.get());
        this.dropSelf(RuBlocks.STRIPPED_BAOBAB_WOOD.get());
        this.dropSelf(RuBlocks.BAOBAB_PLANKS.get());
        this.dropSelf(RuBlocks.BAOBAB_STAIRS.get());
        this.add(RuBlocks.BAOBAB_SLAB.get(), block -> this.createSlabItemTable((Block)block));
        this.dropSelf(RuBlocks.BAOBAB_FENCE.get());
        this.add(RuBlocks.BAOBAB_DOOR.get(), block -> this.createDoorTable((Block)block));
        this.dropSelf(RuBlocks.BAOBAB_FENCE_GATE.get());
        this.dropSelf(RuBlocks.BAOBAB_TRAPDOOR.get());
        this.dropSelf(RuBlocks.BAOBAB_PRESSURE_PLATE.get());
        this.dropSelf(RuBlocks.BAOBAB_BUTTON.get());
        this.dropSelf(RuBlocks.BAOBAB_SIGN.get());
        this.add(RuBlocks.BAOBAB_WALL_SIGN.get(), block -> this.createSingleItemTable((ItemLike)RuBlocks.BAOBAB_SIGN.get()));
        this.dropSelf(RuBlocks.BAOBAB_HANGING_SIGN.get());
        this.add(RuBlocks.BAOBAB_WALL_HANGING_SIGN.get(), block -> this.createSingleItemTable((ItemLike)RuBlocks.BAOBAB_HANGING_SIGN.get()));
        this.dropSelf(RuBlocks.BLACKWOOD_LOG.get());
        this.dropSelf(RuBlocks.STRIPPED_BLACKWOOD_LOG.get());
        this.dropSelf(RuBlocks.BLACKWOOD_WOOD.get());
        this.dropSelf(RuBlocks.STRIPPED_BLACKWOOD_WOOD.get());
        this.dropSelf(RuBlocks.BLACKWOOD_PLANKS.get());
        this.dropSelf(RuBlocks.BLACKWOOD_STAIRS.get());
        this.add(RuBlocks.BLACKWOOD_SLAB.get(), block -> this.createSlabItemTable((Block)block));
        this.dropSelf(RuBlocks.BLACKWOOD_FENCE.get());
        this.add(RuBlocks.BLACKWOOD_DOOR.get(), block -> this.createDoorTable((Block)block));
        this.dropSelf(RuBlocks.BLACKWOOD_FENCE_GATE.get());
        this.dropSelf(RuBlocks.BLACKWOOD_TRAPDOOR.get());
        this.dropSelf(RuBlocks.BLACKWOOD_PRESSURE_PLATE.get());
        this.dropSelf(RuBlocks.BLACKWOOD_BUTTON.get());
        this.dropSelf(RuBlocks.BLACKWOOD_SIGN.get());
        this.add(RuBlocks.BLACKWOOD_WALL_SIGN.get(), block -> this.createSingleItemTable((ItemLike)RuBlocks.BLACKWOOD_SIGN.get()));
        this.dropSelf(RuBlocks.BLACKWOOD_HANGING_SIGN.get());
        this.add(RuBlocks.BLACKWOOD_WALL_HANGING_SIGN.get(), block -> this.createSingleItemTable((ItemLike)RuBlocks.BLACKWOOD_HANGING_SIGN.get()));
        this.dropSelf(RuBlocks.BLUE_BIOSHROOM_STEM.get());
        this.dropSelf(RuBlocks.STRIPPED_BLUE_BIOSHROOM_STEM.get());
        this.dropSelf(RuBlocks.BLUE_BIOSHROOM_HYPHAE.get());
        this.dropSelf(RuBlocks.STRIPPED_BLUE_BIOSHROOM_HYPHAE.get());
        this.dropSelf(RuBlocks.BLUE_BIOSHROOM_PLANKS.get());
        this.dropSelf(RuBlocks.BLUE_BIOSHROOM_STAIRS.get());
        this.add(RuBlocks.BLUE_BIOSHROOM_SLAB.get(), block -> this.createSlabItemTable((Block)block));
        this.dropSelf(RuBlocks.BLUE_BIOSHROOM_FENCE.get());
        this.add(RuBlocks.BLUE_BIOSHROOM_DOOR.get(), block -> this.createDoorTable((Block)block));
        this.dropSelf(RuBlocks.BLUE_BIOSHROOM_FENCE_GATE.get());
        this.dropSelf(RuBlocks.BLUE_BIOSHROOM_TRAPDOOR.get());
        this.dropSelf(RuBlocks.BLUE_BIOSHROOM_PRESSURE_PLATE.get());
        this.dropSelf(RuBlocks.BLUE_BIOSHROOM_BUTTON.get());
        this.dropSelf(RuBlocks.BLUE_BIOSHROOM_SIGN.get());
        this.add(RuBlocks.BLUE_BIOSHROOM_WALL_SIGN.get(), block -> this.createSingleItemTable((ItemLike)RuBlocks.BLUE_BIOSHROOM_SIGN.get()));
        this.dropSelf(RuBlocks.BLUE_BIOSHROOM_HANGING_SIGN.get());
        this.add(RuBlocks.BLUE_BIOSHROOM_WALL_HANGING_SIGN.get(), block -> this.createSingleItemTable((ItemLike)RuBlocks.BLUE_BIOSHROOM_HANGING_SIGN.get()));
        this.dropSelf(RuBlocks.BRIMWOOD_LOG.get());
        this.add(RuBlocks.BRIMWOOD_LOG_MAGMA.get(), block -> this.createSingleItemTableWithSilkTouch((Block)block, (ItemLike)RuBlocks.BRIMWOOD_LOG.get()));
        this.dropSelf(RuBlocks.STRIPPED_BRIMWOOD_LOG.get());
        this.dropSelf(RuBlocks.BRIMWOOD_WOOD.get());
        this.dropSelf(RuBlocks.STRIPPED_BRIMWOOD_WOOD.get());
        this.dropSelf(RuBlocks.BRIMWOOD_PLANKS.get());
        this.dropSelf(RuBlocks.BRIMWOOD_STAIRS.get());
        this.add(RuBlocks.BRIMWOOD_SLAB.get(), block -> this.createSlabItemTable((Block)block));
        this.dropSelf(RuBlocks.BRIMWOOD_FENCE.get());
        this.add(RuBlocks.BRIMWOOD_DOOR.get(), block -> this.createDoorTable((Block)block));
        this.dropSelf(RuBlocks.BRIMWOOD_FENCE_GATE.get());
        this.dropSelf(RuBlocks.BRIMWOOD_TRAPDOOR.get());
        this.dropSelf(RuBlocks.BRIMWOOD_PRESSURE_PLATE.get());
        this.dropSelf(RuBlocks.BRIMWOOD_BUTTON.get());
        this.dropSelf(RuBlocks.BRIMWOOD_SIGN.get());
        this.add(RuBlocks.BRIMWOOD_WALL_SIGN.get(), block -> this.createSingleItemTable((ItemLike)RuBlocks.BRIMWOOD_SIGN.get()));
        this.dropSelf(RuBlocks.BRIMWOOD_HANGING_SIGN.get());
        this.add(RuBlocks.BRIMWOOD_WALL_HANGING_SIGN.get(), block -> this.createSingleItemTable((ItemLike)RuBlocks.BRIMWOOD_HANGING_SIGN.get()));
        this.dropSelf(RuBlocks.COBALT_LOG.get());
        this.dropSelf(RuBlocks.STRIPPED_COBALT_LOG.get());
        this.dropSelf(RuBlocks.COBALT_WOOD.get());
        this.dropSelf(RuBlocks.STRIPPED_COBALT_WOOD.get());
        this.dropSelf(RuBlocks.COBALT_PLANKS.get());
        this.dropSelf(RuBlocks.COBALT_STAIRS.get());
        this.add(RuBlocks.COBALT_SLAB.get(), block -> this.createSlabItemTable((Block)block));
        this.dropSelf(RuBlocks.COBALT_FENCE.get());
        this.add(RuBlocks.COBALT_DOOR.get(), block -> this.createDoorTable((Block)block));
        this.dropSelf(RuBlocks.COBALT_FENCE_GATE.get());
        this.dropSelf(RuBlocks.COBALT_TRAPDOOR.get());
        this.dropSelf(RuBlocks.COBALT_PRESSURE_PLATE.get());
        this.dropSelf(RuBlocks.COBALT_BUTTON.get());
        this.dropSelf(RuBlocks.COBALT_SIGN.get());
        this.add(RuBlocks.COBALT_WALL_SIGN.get(), block -> this.createSingleItemTable((ItemLike)RuBlocks.COBALT_SIGN.get()));
        this.dropSelf(RuBlocks.COBALT_HANGING_SIGN.get());
        this.add(RuBlocks.COBALT_WALL_HANGING_SIGN.get(), block -> this.createSingleItemTable((ItemLike)RuBlocks.COBALT_HANGING_SIGN.get()));
        this.dropSelf(RuBlocks.CYPRESS_LOG.get());
        this.dropSelf(RuBlocks.STRIPPED_CYPRESS_LOG.get());
        this.dropSelf(RuBlocks.CYPRESS_WOOD.get());
        this.dropSelf(RuBlocks.STRIPPED_CYPRESS_WOOD.get());
        this.dropSelf(RuBlocks.CYPRESS_PLANKS.get());
        this.dropSelf(RuBlocks.CYPRESS_STAIRS.get());
        this.add(RuBlocks.CYPRESS_SLAB.get(), block -> this.createSlabItemTable((Block)block));
        this.dropSelf(RuBlocks.CYPRESS_FENCE.get());
        this.add(RuBlocks.CYPRESS_DOOR.get(), block -> this.createDoorTable((Block)block));
        this.dropSelf(RuBlocks.CYPRESS_FENCE_GATE.get());
        this.dropSelf(RuBlocks.CYPRESS_TRAPDOOR.get());
        this.dropSelf(RuBlocks.CYPRESS_PRESSURE_PLATE.get());
        this.dropSelf(RuBlocks.CYPRESS_BUTTON.get());
        this.dropSelf(RuBlocks.CYPRESS_SIGN.get());
        this.add(RuBlocks.CYPRESS_WALL_SIGN.get(), block -> this.createSingleItemTable((ItemLike)RuBlocks.CYPRESS_SIGN.get()));
        this.dropSelf(RuBlocks.CYPRESS_HANGING_SIGN.get());
        this.add(RuBlocks.CYPRESS_WALL_HANGING_SIGN.get(), block -> this.createSingleItemTable((ItemLike)RuBlocks.CYPRESS_HANGING_SIGN.get()));
        this.dropSelf(RuBlocks.DEAD_LOG.get());
        this.dropSelf(RuBlocks.STRIPPED_DEAD_LOG.get());
        this.dropSelf(RuBlocks.DEAD_WOOD.get());
        this.dropSelf(RuBlocks.STRIPPED_DEAD_WOOD.get());
        this.dropSelf(RuBlocks.DEAD_PLANKS.get());
        this.dropSelf(RuBlocks.DEAD_STAIRS.get());
        this.add(RuBlocks.DEAD_SLAB.get(), block -> this.createSlabItemTable((Block)block));
        this.dropSelf(RuBlocks.DEAD_FENCE.get());
        this.add(RuBlocks.DEAD_DOOR.get(), block -> this.createDoorTable((Block)block));
        this.dropSelf(RuBlocks.DEAD_FENCE_GATE.get());
        this.dropSelf(RuBlocks.DEAD_TRAPDOOR.get());
        this.dropSelf(RuBlocks.DEAD_PRESSURE_PLATE.get());
        this.dropSelf(RuBlocks.DEAD_BUTTON.get());
        this.dropSelf(RuBlocks.DEAD_SIGN.get());
        this.add(RuBlocks.DEAD_WALL_SIGN.get(), block -> this.createSingleItemTable((ItemLike)RuBlocks.DEAD_SIGN.get()));
        this.dropSelf(RuBlocks.DEAD_HANGING_SIGN.get());
        this.add(RuBlocks.DEAD_WALL_HANGING_SIGN.get(), block -> this.createSingleItemTable((ItemLike)RuBlocks.DEAD_HANGING_SIGN.get()));
        this.dropSelf(RuBlocks.EUCALYPTUS_LOG.get());
        this.dropSelf(RuBlocks.STRIPPED_EUCALYPTUS_LOG.get());
        this.dropSelf(RuBlocks.EUCALYPTUS_WOOD.get());
        this.dropSelf(RuBlocks.STRIPPED_EUCALYPTUS_WOOD.get());
        this.dropSelf(RuBlocks.EUCALYPTUS_PLANKS.get());
        this.dropSelf(RuBlocks.EUCALYPTUS_STAIRS.get());
        this.add(RuBlocks.EUCALYPTUS_SLAB.get(), block -> this.createSlabItemTable((Block)block));
        this.dropSelf(RuBlocks.EUCALYPTUS_FENCE.get());
        this.add(RuBlocks.EUCALYPTUS_DOOR.get(), block -> this.createDoorTable((Block)block));
        this.dropSelf(RuBlocks.EUCALYPTUS_FENCE_GATE.get());
        this.dropSelf(RuBlocks.EUCALYPTUS_TRAPDOOR.get());
        this.dropSelf(RuBlocks.EUCALYPTUS_PRESSURE_PLATE.get());
        this.dropSelf(RuBlocks.EUCALYPTUS_BUTTON.get());
        this.dropSelf(RuBlocks.EUCALYPTUS_SIGN.get());
        this.add(RuBlocks.EUCALYPTUS_WALL_SIGN.get(), block -> this.createSingleItemTable((ItemLike)RuBlocks.EUCALYPTUS_SIGN.get()));
        this.dropSelf(RuBlocks.EUCALYPTUS_HANGING_SIGN.get());
        this.add(RuBlocks.EUCALYPTUS_WALL_HANGING_SIGN.get(), block -> this.createSingleItemTable((ItemLike)RuBlocks.EUCALYPTUS_HANGING_SIGN.get()));
        this.dropSelf(RuBlocks.GREEN_BIOSHROOM_STEM.get());
        this.dropSelf(RuBlocks.STRIPPED_GREEN_BIOSHROOM_STEM.get());
        this.dropSelf(RuBlocks.GREEN_BIOSHROOM_HYPHAE.get());
        this.dropSelf(RuBlocks.STRIPPED_GREEN_BIOSHROOM_HYPHAE.get());
        this.dropSelf(RuBlocks.GREEN_BIOSHROOM_PLANKS.get());
        this.dropSelf(RuBlocks.GREEN_BIOSHROOM_STAIRS.get());
        this.add(RuBlocks.GREEN_BIOSHROOM_SLAB.get(), block -> this.createSlabItemTable((Block)block));
        this.dropSelf(RuBlocks.GREEN_BIOSHROOM_FENCE.get());
        this.add(RuBlocks.GREEN_BIOSHROOM_DOOR.get(), block -> this.createDoorTable((Block)block));
        this.dropSelf(RuBlocks.GREEN_BIOSHROOM_FENCE_GATE.get());
        this.dropSelf(RuBlocks.GREEN_BIOSHROOM_TRAPDOOR.get());
        this.dropSelf(RuBlocks.GREEN_BIOSHROOM_PRESSURE_PLATE.get());
        this.dropSelf(RuBlocks.GREEN_BIOSHROOM_BUTTON.get());
        this.dropSelf(RuBlocks.GREEN_BIOSHROOM_SIGN.get());
        this.add(RuBlocks.GREEN_BIOSHROOM_WALL_SIGN.get(), block -> this.createSingleItemTable((ItemLike)RuBlocks.GREEN_BIOSHROOM_SIGN.get()));
        this.dropSelf(RuBlocks.GREEN_BIOSHROOM_HANGING_SIGN.get());
        this.add(RuBlocks.GREEN_BIOSHROOM_WALL_HANGING_SIGN.get(), block -> this.createSingleItemTable((ItemLike)RuBlocks.GREEN_BIOSHROOM_HANGING_SIGN.get()));
        this.dropSelf(RuBlocks.JOSHUA_LOG.get());
        this.dropSelf(RuBlocks.STRIPPED_JOSHUA_LOG.get());
        this.dropSelf(RuBlocks.JOSHUA_WOOD.get());
        this.dropSelf(RuBlocks.STRIPPED_JOSHUA_WOOD.get());
        this.dropSelf(RuBlocks.JOSHUA_PLANKS.get());
        this.dropSelf(RuBlocks.JOSHUA_STAIRS.get());
        this.add(RuBlocks.JOSHUA_SLAB.get(), block -> this.createSlabItemTable((Block)block));
        this.dropSelf(RuBlocks.JOSHUA_FENCE.get());
        this.add(RuBlocks.JOSHUA_DOOR.get(), block -> this.createDoorTable((Block)block));
        this.dropSelf(RuBlocks.JOSHUA_FENCE_GATE.get());
        this.dropSelf(RuBlocks.JOSHUA_TRAPDOOR.get());
        this.dropSelf(RuBlocks.JOSHUA_PRESSURE_PLATE.get());
        this.dropSelf(RuBlocks.JOSHUA_BUTTON.get());
        this.dropSelf(RuBlocks.JOSHUA_SIGN.get());
        this.add(RuBlocks.JOSHUA_WALL_SIGN.get(), block -> this.createSingleItemTable((ItemLike)RuBlocks.JOSHUA_SIGN.get()));
        this.dropSelf(RuBlocks.JOSHUA_HANGING_SIGN.get());
        this.add(RuBlocks.JOSHUA_WALL_HANGING_SIGN.get(), block -> this.createSingleItemTable((ItemLike)RuBlocks.JOSHUA_HANGING_SIGN.get()));
        this.dropSelf(RuBlocks.KAPOK_LOG.get());
        this.dropSelf(RuBlocks.STRIPPED_KAPOK_LOG.get());
        this.dropSelf(RuBlocks.KAPOK_WOOD.get());
        this.dropSelf(RuBlocks.STRIPPED_KAPOK_WOOD.get());
        this.dropSelf(RuBlocks.KAPOK_PLANKS.get());
        this.dropSelf(RuBlocks.KAPOK_STAIRS.get());
        this.add(RuBlocks.KAPOK_SLAB.get(), block -> this.createSlabItemTable((Block)block));
        this.dropSelf(RuBlocks.KAPOK_FENCE.get());
        this.add(RuBlocks.KAPOK_DOOR.get(), block -> this.createDoorTable((Block)block));
        this.dropSelf(RuBlocks.KAPOK_FENCE_GATE.get());
        this.dropSelf(RuBlocks.KAPOK_TRAPDOOR.get());
        this.dropSelf(RuBlocks.KAPOK_PRESSURE_PLATE.get());
        this.dropSelf(RuBlocks.KAPOK_BUTTON.get());
        this.dropSelf(RuBlocks.KAPOK_SIGN.get());
        this.add(RuBlocks.KAPOK_WALL_SIGN.get(), block -> this.createSingleItemTable((ItemLike)RuBlocks.KAPOK_SIGN.get()));
        this.dropSelf(RuBlocks.KAPOK_HANGING_SIGN.get());
        this.add(RuBlocks.KAPOK_WALL_HANGING_SIGN.get(), block -> this.createSingleItemTable((ItemLike)RuBlocks.KAPOK_HANGING_SIGN.get()));
        this.dropSelf(RuBlocks.LARCH_LOG.get());
        this.dropSelf(RuBlocks.STRIPPED_LARCH_LOG.get());
        this.dropSelf(RuBlocks.LARCH_WOOD.get());
        this.dropSelf(RuBlocks.STRIPPED_LARCH_WOOD.get());
        this.dropSelf(RuBlocks.LARCH_PLANKS.get());
        this.dropSelf(RuBlocks.LARCH_STAIRS.get());
        this.add(RuBlocks.LARCH_SLAB.get(), block -> this.createSlabItemTable((Block)block));
        this.dropSelf(RuBlocks.LARCH_FENCE.get());
        this.add(RuBlocks.LARCH_DOOR.get(), block -> this.createDoorTable((Block)block));
        this.dropSelf(RuBlocks.LARCH_FENCE_GATE.get());
        this.dropSelf(RuBlocks.LARCH_TRAPDOOR.get());
        this.dropSelf(RuBlocks.LARCH_PRESSURE_PLATE.get());
        this.dropSelf(RuBlocks.LARCH_BUTTON.get());
        this.dropSelf(RuBlocks.LARCH_SIGN.get());
        this.add(RuBlocks.LARCH_WALL_SIGN.get(), block -> this.createSingleItemTable((ItemLike)RuBlocks.LARCH_SIGN.get()));
        this.dropSelf(RuBlocks.LARCH_HANGING_SIGN.get());
        this.add(RuBlocks.LARCH_WALL_HANGING_SIGN.get(), block -> this.createSingleItemTable((ItemLike)RuBlocks.LARCH_HANGING_SIGN.get()));
        this.dropSelf(RuBlocks.MAGNOLIA_LOG.get());
        this.dropSelf(RuBlocks.STRIPPED_MAGNOLIA_LOG.get());
        this.dropSelf(RuBlocks.MAGNOLIA_WOOD.get());
        this.dropSelf(RuBlocks.STRIPPED_MAGNOLIA_WOOD.get());
        this.dropSelf(RuBlocks.MAGNOLIA_PLANKS.get());
        this.dropSelf(RuBlocks.MAGNOLIA_STAIRS.get());
        this.add(RuBlocks.MAGNOLIA_SLAB.get(), block -> this.createSlabItemTable((Block)block));
        this.dropSelf(RuBlocks.MAGNOLIA_FENCE.get());
        this.add(RuBlocks.MAGNOLIA_DOOR.get(), block -> this.createDoorTable((Block)block));
        this.dropSelf(RuBlocks.MAGNOLIA_FENCE_GATE.get());
        this.dropSelf(RuBlocks.MAGNOLIA_TRAPDOOR.get());
        this.dropSelf(RuBlocks.MAGNOLIA_PRESSURE_PLATE.get());
        this.dropSelf(RuBlocks.MAGNOLIA_BUTTON.get());
        this.dropSelf(RuBlocks.MAGNOLIA_SIGN.get());
        this.add(RuBlocks.MAGNOLIA_WALL_SIGN.get(), block -> this.createSingleItemTable((ItemLike)RuBlocks.MAGNOLIA_SIGN.get()));
        this.dropSelf(RuBlocks.MAGNOLIA_HANGING_SIGN.get());
        this.add(RuBlocks.MAGNOLIA_WALL_HANGING_SIGN.get(), block -> this.createSingleItemTable((ItemLike)RuBlocks.MAGNOLIA_HANGING_SIGN.get()));
        this.dropSelf(RuBlocks.MAPLE_LOG.get());
        this.dropSelf(RuBlocks.STRIPPED_MAPLE_LOG.get());
        this.dropSelf(RuBlocks.MAPLE_WOOD.get());
        this.dropSelf(RuBlocks.STRIPPED_MAPLE_WOOD.get());
        this.dropSelf(RuBlocks.MAPLE_PLANKS.get());
        this.dropSelf(RuBlocks.MAPLE_STAIRS.get());
        this.add(RuBlocks.MAPLE_SLAB.get(), block -> this.createSlabItemTable((Block)block));
        this.dropSelf(RuBlocks.MAPLE_FENCE.get());
        this.add(RuBlocks.MAPLE_DOOR.get(), block -> this.createDoorTable((Block)block));
        this.dropSelf(RuBlocks.MAPLE_FENCE_GATE.get());
        this.dropSelf(RuBlocks.MAPLE_TRAPDOOR.get());
        this.dropSelf(RuBlocks.MAPLE_PRESSURE_PLATE.get());
        this.dropSelf(RuBlocks.MAPLE_BUTTON.get());
        this.dropSelf(RuBlocks.MAPLE_SIGN.get());
        this.add(RuBlocks.MAPLE_WALL_SIGN.get(), block -> this.createSingleItemTable((ItemLike)RuBlocks.MAPLE_SIGN.get()));
        this.dropSelf(RuBlocks.MAPLE_HANGING_SIGN.get());
        this.add(RuBlocks.MAPLE_WALL_HANGING_SIGN.get(), block -> this.createSingleItemTable((ItemLike)RuBlocks.MAPLE_HANGING_SIGN.get()));
        this.dropSelf(RuBlocks.MAUVE_LOG.get());
        this.dropSelf(RuBlocks.STRIPPED_MAUVE_LOG.get());
        this.dropSelf(RuBlocks.MAUVE_WOOD.get());
        this.dropSelf(RuBlocks.STRIPPED_MAUVE_WOOD.get());
        this.dropSelf(RuBlocks.MAUVE_PLANKS.get());
        this.dropSelf(RuBlocks.MAUVE_STAIRS.get());
        this.add(RuBlocks.MAUVE_SLAB.get(), block -> this.createSlabItemTable((Block)block));
        this.dropSelf(RuBlocks.MAUVE_FENCE.get());
        this.add(RuBlocks.MAUVE_DOOR.get(), block -> this.createDoorTable((Block)block));
        this.dropSelf(RuBlocks.MAUVE_FENCE_GATE.get());
        this.dropSelf(RuBlocks.MAUVE_TRAPDOOR.get());
        this.dropSelf(RuBlocks.MAUVE_PRESSURE_PLATE.get());
        this.dropSelf(RuBlocks.MAUVE_BUTTON.get());
        this.dropSelf(RuBlocks.MAUVE_SIGN.get());
        this.add(RuBlocks.MAUVE_WALL_SIGN.get(), block -> this.createSingleItemTable((ItemLike)RuBlocks.MAUVE_SIGN.get()));
        this.dropSelf(RuBlocks.MAUVE_HANGING_SIGN.get());
        this.add(RuBlocks.MAUVE_WALL_HANGING_SIGN.get(), block -> this.createSingleItemTable((ItemLike)RuBlocks.MAUVE_HANGING_SIGN.get()));
        this.dropSelf(RuBlocks.PALM_LOG.get());
        this.dropSelf(RuBlocks.STRIPPED_PALM_LOG.get());
        this.dropSelf(RuBlocks.PALM_WOOD.get());
        this.dropSelf(RuBlocks.STRIPPED_PALM_WOOD.get());
        this.dropSelf(RuBlocks.PALM_PLANKS.get());
        this.dropSelf(RuBlocks.PALM_STAIRS.get());
        this.add(RuBlocks.PALM_SLAB.get(), block -> this.createSlabItemTable((Block)block));
        this.dropSelf(RuBlocks.PALM_FENCE.get());
        this.add(RuBlocks.PALM_DOOR.get(), block -> this.createDoorTable((Block)block));
        this.dropSelf(RuBlocks.PALM_FENCE_GATE.get());
        this.dropSelf(RuBlocks.PALM_TRAPDOOR.get());
        this.dropSelf(RuBlocks.PALM_PRESSURE_PLATE.get());
        this.dropSelf(RuBlocks.PALM_BUTTON.get());
        this.dropSelf(RuBlocks.PALM_SIGN.get());
        this.add(RuBlocks.PALM_WALL_SIGN.get(), block -> this.createSingleItemTable((ItemLike)RuBlocks.PALM_SIGN.get()));
        this.dropSelf(RuBlocks.PALM_HANGING_SIGN.get());
        this.add(RuBlocks.PALM_WALL_HANGING_SIGN.get(), block -> this.createSingleItemTable((ItemLike)RuBlocks.PALM_HANGING_SIGN.get()));
        this.dropSelf(RuBlocks.PINE_LOG.get());
        this.dropSelf(RuBlocks.STRIPPED_PINE_LOG.get());
        this.dropSelf(RuBlocks.PINE_WOOD.get());
        this.dropSelf(RuBlocks.STRIPPED_PINE_WOOD.get());
        this.dropSelf(RuBlocks.PINE_PLANKS.get());
        this.dropSelf(RuBlocks.PINE_STAIRS.get());
        this.add(RuBlocks.PINE_SLAB.get(), block -> this.createSlabItemTable((Block)block));
        this.dropSelf(RuBlocks.PINE_FENCE.get());
        this.add(RuBlocks.PINE_DOOR.get(), block -> this.createDoorTable((Block)block));
        this.dropSelf(RuBlocks.PINE_FENCE_GATE.get());
        this.dropSelf(RuBlocks.PINE_TRAPDOOR.get());
        this.dropSelf(RuBlocks.PINE_PRESSURE_PLATE.get());
        this.dropSelf(RuBlocks.PINE_BUTTON.get());
        this.dropSelf(RuBlocks.PINE_SIGN.get());
        this.add(RuBlocks.PINE_WALL_SIGN.get(), block -> this.createSingleItemTable((ItemLike)RuBlocks.PINE_SIGN.get()));
        this.dropSelf(RuBlocks.PINE_HANGING_SIGN.get());
        this.add(RuBlocks.PINE_WALL_HANGING_SIGN.get(), block -> this.createSingleItemTable((ItemLike)RuBlocks.PINE_HANGING_SIGN.get()));
        this.dropSelf(RuBlocks.PINK_BIOSHROOM_STEM.get());
        this.dropSelf(RuBlocks.STRIPPED_PINK_BIOSHROOM_STEM.get());
        this.dropSelf(RuBlocks.PINK_BIOSHROOM_HYPHAE.get());
        this.dropSelf(RuBlocks.STRIPPED_PINK_BIOSHROOM_HYPHAE.get());
        this.dropSelf(RuBlocks.PINK_BIOSHROOM_PLANKS.get());
        this.dropSelf(RuBlocks.PINK_BIOSHROOM_STAIRS.get());
        this.add(RuBlocks.PINK_BIOSHROOM_SLAB.get(), block -> this.createSlabItemTable((Block)block));
        this.dropSelf(RuBlocks.PINK_BIOSHROOM_FENCE.get());
        this.add(RuBlocks.PINK_BIOSHROOM_DOOR.get(), block -> this.createDoorTable((Block)block));
        this.dropSelf(RuBlocks.PINK_BIOSHROOM_FENCE_GATE.get());
        this.dropSelf(RuBlocks.PINK_BIOSHROOM_TRAPDOOR.get());
        this.dropSelf(RuBlocks.PINK_BIOSHROOM_PRESSURE_PLATE.get());
        this.dropSelf(RuBlocks.PINK_BIOSHROOM_BUTTON.get());
        this.dropSelf(RuBlocks.PINK_BIOSHROOM_SIGN.get());
        this.add(RuBlocks.PINK_BIOSHROOM_WALL_SIGN.get(), block -> this.createSingleItemTable((ItemLike)RuBlocks.PINK_BIOSHROOM_SIGN.get()));
        this.dropSelf(RuBlocks.PINK_BIOSHROOM_HANGING_SIGN.get());
        this.add(RuBlocks.PINK_BIOSHROOM_WALL_HANGING_SIGN.get(), block -> this.createSingleItemTable((ItemLike)RuBlocks.PINK_BIOSHROOM_HANGING_SIGN.get()));
        this.dropSelf(RuBlocks.REDWOOD_LOG.get());
        this.dropSelf(RuBlocks.STRIPPED_REDWOOD_LOG.get());
        this.dropSelf(RuBlocks.REDWOOD_WOOD.get());
        this.dropSelf(RuBlocks.STRIPPED_REDWOOD_WOOD.get());
        this.dropSelf(RuBlocks.REDWOOD_PLANKS.get());
        this.dropSelf(RuBlocks.REDWOOD_STAIRS.get());
        this.add(RuBlocks.REDWOOD_SLAB.get(), block -> this.createSlabItemTable((Block)block));
        this.dropSelf(RuBlocks.REDWOOD_FENCE.get());
        this.add(RuBlocks.REDWOOD_DOOR.get(), block -> this.createDoorTable((Block)block));
        this.dropSelf(RuBlocks.REDWOOD_FENCE_GATE.get());
        this.dropSelf(RuBlocks.REDWOOD_TRAPDOOR.get());
        this.dropSelf(RuBlocks.REDWOOD_PRESSURE_PLATE.get());
        this.dropSelf(RuBlocks.REDWOOD_BUTTON.get());
        this.dropSelf(RuBlocks.REDWOOD_SIGN.get());
        this.add(RuBlocks.REDWOOD_WALL_SIGN.get(), block -> this.createSingleItemTable((ItemLike)RuBlocks.REDWOOD_SIGN.get()));
        this.dropSelf(RuBlocks.REDWOOD_HANGING_SIGN.get());
        this.add(RuBlocks.REDWOOD_WALL_HANGING_SIGN.get(), block -> this.createSingleItemTable((ItemLike)RuBlocks.REDWOOD_HANGING_SIGN.get()));
        this.dropSelf(RuBlocks.SOCOTRA_LOG.get());
        this.dropSelf(RuBlocks.STRIPPED_SOCOTRA_LOG.get());
        this.dropSelf(RuBlocks.SOCOTRA_WOOD.get());
        this.dropSelf(RuBlocks.STRIPPED_SOCOTRA_WOOD.get());
        this.dropSelf(RuBlocks.SOCOTRA_PLANKS.get());
        this.dropSelf(RuBlocks.SOCOTRA_STAIRS.get());
        this.add(RuBlocks.SOCOTRA_SLAB.get(), block -> this.createSlabItemTable((Block)block));
        this.dropSelf(RuBlocks.SOCOTRA_FENCE.get());
        this.add(RuBlocks.SOCOTRA_DOOR.get(), block -> this.createDoorTable((Block)block));
        this.dropSelf(RuBlocks.SOCOTRA_FENCE_GATE.get());
        this.dropSelf(RuBlocks.SOCOTRA_TRAPDOOR.get());
        this.dropSelf(RuBlocks.SOCOTRA_PRESSURE_PLATE.get());
        this.dropSelf(RuBlocks.SOCOTRA_BUTTON.get());
        this.dropSelf(RuBlocks.SOCOTRA_SIGN.get());
        this.add(RuBlocks.SOCOTRA_WALL_SIGN.get(), block -> this.createSingleItemTable((ItemLike)RuBlocks.SOCOTRA_SIGN.get()));
        this.dropSelf(RuBlocks.SOCOTRA_HANGING_SIGN.get());
        this.add(RuBlocks.SOCOTRA_WALL_HANGING_SIGN.get(), block -> this.createSingleItemTable((ItemLike)RuBlocks.SOCOTRA_HANGING_SIGN.get()));
        this.dropSelf(RuBlocks.WILLOW_LOG.get());
        this.dropSelf(RuBlocks.STRIPPED_WILLOW_LOG.get());
        this.dropSelf(RuBlocks.WILLOW_WOOD.get());
        this.dropSelf(RuBlocks.STRIPPED_WILLOW_WOOD.get());
        this.dropSelf(RuBlocks.WILLOW_PLANKS.get());
        this.dropSelf(RuBlocks.WILLOW_STAIRS.get());
        this.add(RuBlocks.WILLOW_SLAB.get(), block -> this.createSlabItemTable((Block)block));
        this.dropSelf(RuBlocks.WILLOW_FENCE.get());
        this.add(RuBlocks.WILLOW_DOOR.get(), block -> this.createDoorTable((Block)block));
        this.dropSelf(RuBlocks.WILLOW_FENCE_GATE.get());
        this.dropSelf(RuBlocks.WILLOW_TRAPDOOR.get());
        this.dropSelf(RuBlocks.WILLOW_PRESSURE_PLATE.get());
        this.dropSelf(RuBlocks.WILLOW_BUTTON.get());
        this.dropSelf(RuBlocks.WILLOW_SIGN.get());
        this.add(RuBlocks.WILLOW_WALL_SIGN.get(), block -> this.createSingleItemTable((ItemLike)RuBlocks.WILLOW_SIGN.get()));
        this.dropSelf(RuBlocks.WILLOW_HANGING_SIGN.get());
        this.add(RuBlocks.WILLOW_WALL_HANGING_SIGN.get(), block -> this.createSingleItemTable((ItemLike)RuBlocks.WILLOW_HANGING_SIGN.get()));
        this.dropSelf(RuBlocks.YELLOW_BIOSHROOM_STEM.get());
        this.dropSelf(RuBlocks.STRIPPED_YELLOW_BIOSHROOM_STEM.get());
        this.dropSelf(RuBlocks.YELLOW_BIOSHROOM_HYPHAE.get());
        this.dropSelf(RuBlocks.STRIPPED_YELLOW_BIOSHROOM_HYPHAE.get());
        this.dropSelf(RuBlocks.YELLOW_BIOSHROOM_PLANKS.get());
        this.dropSelf(RuBlocks.YELLOW_BIOSHROOM_STAIRS.get());
        this.add(RuBlocks.YELLOW_BIOSHROOM_SLAB.get(), block -> this.createSlabItemTable((Block)block));
        this.dropSelf(RuBlocks.YELLOW_BIOSHROOM_FENCE.get());
        this.add(RuBlocks.YELLOW_BIOSHROOM_DOOR.get(), block -> this.createDoorTable((Block)block));
        this.dropSelf(RuBlocks.YELLOW_BIOSHROOM_FENCE_GATE.get());
        this.dropSelf(RuBlocks.YELLOW_BIOSHROOM_TRAPDOOR.get());
        this.dropSelf(RuBlocks.YELLOW_BIOSHROOM_PRESSURE_PLATE.get());
        this.dropSelf(RuBlocks.YELLOW_BIOSHROOM_BUTTON.get());
        this.dropSelf(RuBlocks.YELLOW_BIOSHROOM_SIGN.get());
        this.add(RuBlocks.YELLOW_BIOSHROOM_WALL_SIGN.get(), block -> this.createSingleItemTable((ItemLike)RuBlocks.YELLOW_BIOSHROOM_SIGN.get()));
        this.dropSelf(RuBlocks.YELLOW_BIOSHROOM_HANGING_SIGN.get());
        this.add(RuBlocks.YELLOW_BIOSHROOM_WALL_HANGING_SIGN.get(), block -> this.createSingleItemTable((ItemLike)RuBlocks.YELLOW_BIOSHROOM_HANGING_SIGN.get()));
        this.dropSelf(RuBlocks.RED_PAINTED_PLANKS.get());
        this.dropSelf(RuBlocks.ORANGE_PAINTED_PLANKS.get());
        this.dropSelf(RuBlocks.YELLOW_PAINTED_PLANKS.get());
        this.dropSelf(RuBlocks.LIME_PAINTED_PLANKS.get());
        this.dropSelf(RuBlocks.GREEN_PAINTED_PLANKS.get());
        this.dropSelf(RuBlocks.CYAN_PAINTED_PLANKS.get());
        this.dropSelf(RuBlocks.LIGHT_BLUE_PAINTED_PLANKS.get());
        this.dropSelf(RuBlocks.BLUE_PAINTED_PLANKS.get());
        this.dropSelf(RuBlocks.PURPLE_PAINTED_PLANKS.get());
        this.dropSelf(RuBlocks.MAGENTA_PAINTED_PLANKS.get());
        this.dropSelf(RuBlocks.PINK_PAINTED_PLANKS.get());
        this.dropSelf(RuBlocks.BROWN_PAINTED_PLANKS.get());
        this.dropSelf(RuBlocks.WHITE_PAINTED_PLANKS.get());
        this.dropSelf(RuBlocks.LIGHT_GRAY_PAINTED_PLANKS.get());
        this.dropSelf(RuBlocks.GRAY_PAINTED_PLANKS.get());
        this.dropSelf(RuBlocks.BLACK_PAINTED_PLANKS.get());
        this.dropSelf(RuBlocks.RED_PAINTED_STAIRS.get());
        this.dropSelf(RuBlocks.ORANGE_PAINTED_STAIRS.get());
        this.dropSelf(RuBlocks.YELLOW_PAINTED_STAIRS.get());
        this.dropSelf(RuBlocks.LIME_PAINTED_STAIRS.get());
        this.dropSelf(RuBlocks.GREEN_PAINTED_STAIRS.get());
        this.dropSelf(RuBlocks.CYAN_PAINTED_STAIRS.get());
        this.dropSelf(RuBlocks.LIGHT_BLUE_PAINTED_STAIRS.get());
        this.dropSelf(RuBlocks.BLUE_PAINTED_STAIRS.get());
        this.dropSelf(RuBlocks.PURPLE_PAINTED_STAIRS.get());
        this.dropSelf(RuBlocks.MAGENTA_PAINTED_STAIRS.get());
        this.dropSelf(RuBlocks.PINK_PAINTED_STAIRS.get());
        this.dropSelf(RuBlocks.BROWN_PAINTED_STAIRS.get());
        this.dropSelf(RuBlocks.WHITE_PAINTED_STAIRS.get());
        this.dropSelf(RuBlocks.LIGHT_GRAY_PAINTED_STAIRS.get());
        this.dropSelf(RuBlocks.GRAY_PAINTED_STAIRS.get());
        this.dropSelf(RuBlocks.BLACK_PAINTED_STAIRS.get());
        this.add(RuBlocks.RED_PAINTED_SLAB.get(), block -> this.createSlabItemTable((Block)block));
        this.add(RuBlocks.ORANGE_PAINTED_SLAB.get(), block -> this.createSlabItemTable((Block)block));
        this.add(RuBlocks.YELLOW_PAINTED_SLAB.get(), block -> this.createSlabItemTable((Block)block));
        this.add(RuBlocks.LIME_PAINTED_SLAB.get(), block -> this.createSlabItemTable((Block)block));
        this.add(RuBlocks.GREEN_PAINTED_SLAB.get(), block -> this.createSlabItemTable((Block)block));
        this.add(RuBlocks.CYAN_PAINTED_SLAB.get(), block -> this.createSlabItemTable((Block)block));
        this.add(RuBlocks.LIGHT_BLUE_PAINTED_SLAB.get(), block -> this.createSlabItemTable((Block)block));
        this.add(RuBlocks.BLUE_PAINTED_SLAB.get(), block -> this.createSlabItemTable((Block)block));
        this.add(RuBlocks.PURPLE_PAINTED_SLAB.get(), block -> this.createSlabItemTable((Block)block));
        this.add(RuBlocks.MAGENTA_PAINTED_SLAB.get(), block -> this.createSlabItemTable((Block)block));
        this.add(RuBlocks.PINK_PAINTED_SLAB.get(), block -> this.createSlabItemTable((Block)block));
        this.add(RuBlocks.BROWN_PAINTED_SLAB.get(), block -> this.createSlabItemTable((Block)block));
        this.add(RuBlocks.WHITE_PAINTED_SLAB.get(), block -> this.createSlabItemTable((Block)block));
        this.add(RuBlocks.LIGHT_GRAY_PAINTED_SLAB.get(), block -> this.createSlabItemTable((Block)block));
        this.add(RuBlocks.GRAY_PAINTED_SLAB.get(), block -> this.createSlabItemTable((Block)block));
        this.add(RuBlocks.BLACK_PAINTED_SLAB.get(), block -> this.createSlabItemTable((Block)block));
        this.dropSelf(RuBlocks.BLACKSTONE_CLUSTER.get());
        this.add(RuBlocks.OVERGROWN_BONE_BLOCK.get(), block -> this.createSingleItemTableWithSilkTouch((Block)block, (ItemLike)Items.BONE_BLOCK));
        this.add(RuBlocks.BRIMSPROUT_NYLIUM.get(), block -> this.createSingleItemTableWithSilkTouch((Block)block, (ItemLike)Blocks.NETHERRACK));
        this.dropSelf(RuBlocks.BRIMSPROUT.get());
        this.dropSelf(RuBlocks.COBALT_EARLIGHT.get());
        this.add(RuBlocks.TALL_COBALT_EARLIGHT.get(), block -> this.createSinglePropConditionTable((Block)block, (Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.LOWER));
        this.add(RuBlocks.COBALT_NYLIUM.get(), block -> this.createSingleItemTableWithSilkTouch((Block)block, (ItemLike)Blocks.BLACKSTONE));
        this.dropSelf(RuBlocks.COBALT_OBSIDIAN.get());
        this.dropSelf(RuBlocks.COBALT_ROOTS.get());
        this.add(RuBlocks.HANGING_EARLIGHT.get(), block -> this.createSilkTouchOrShearsDispatchTable((Block)block, (LootPoolEntryContainer.Builder<?>)LootItem.lootTableItem((ItemLike)block).when(BonusLevelTableCondition.bonusLevelFlatChance((Holder)this.registries.holderOrThrow(Enchantments.FORTUNE), (float[])new float[]{0.66f, 0.78f, 0.9f, 1.0f}))));
        this.add(RuBlocks.HANGING_EARLIGHT_PLANT.get(), block -> this.createSilkTouchOrShearsDispatchTable((Block)block, (LootPoolEntryContainer.Builder<?>)LootItem.lootTableItem((ItemLike)block).when(BonusLevelTableCondition.bonusLevelFlatChance((Holder)this.registries.holderOrThrow(Enchantments.FORTUNE), (float[])new float[]{0.66f, 0.78f, 0.9f, 1.0f}))));
        this.add(RuBlocks.GLISTERING_IVY.get(), block -> this.createSilkTouchOrShearsDispatchTable((Block)block, (LootPoolEntryContainer.Builder<?>)LootItem.lootTableItem((ItemLike)block).when(BonusLevelTableCondition.bonusLevelFlatChance((Holder)this.registries.holderOrThrow(Enchantments.FORTUNE), (float[])new float[]{0.33f, 0.55f, 0.77f, 1.0f}))));
        this.add(RuBlocks.GLISTERING_IVY_PLANT.get(), block -> this.createSilkTouchOrShearsDispatchTable((Block)block, (LootPoolEntryContainer.Builder<?>)LootItem.lootTableItem((ItemLike)block).when(BonusLevelTableCondition.bonusLevelFlatChance((Holder)this.registries.holderOrThrow(Enchantments.FORTUNE), (float[])new float[]{0.33f, 0.55f, 0.77f, 1.0f}))));
        this.add(RuBlocks.GLISTERING_NYLIUM.get(), block -> this.createSingleItemTableWithSilkTouch((Block)block, (ItemLike)Blocks.NETHERRACK));
        this.dropSelf(RuBlocks.GLISTERING_SPROUT.get());
        this.dropSelf(RuBlocks.GLISTERING_BLOOM.get());
        this.dropSelf(RuBlocks.GLISTERING_FERN.get());
        this.dropSelf(RuBlocks.GLISTERING_WART.get());
        this.add(RuBlocks.GLISTER_BULB.get(), block -> this.createSinglePropConditionTable((Block)block, (Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.LOWER));
        this.add(RuBlocks.GLISTER_SPIRE.get(), block -> this.createSinglePropConditionTable((Block)block, (Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.LOWER));
        this.add(RuBlocks.MYCOTOXIC_MUSHROOMS.get(), block -> this.createPetalsDrops((Block)block));
        this.add(RuBlocks.MYCOTOXIC_DAISY.get(), block -> this.createSinglePropConditionTable((Block)block, (Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.LOWER));
        this.dropSelf(RuBlocks.MYCOTOXIC_GRASS.get());
        this.add(RuBlocks.MYCOTOXIC_NYLIUM.get(), block -> this.createSingleItemTableWithSilkTouch((Block)block, (ItemLike)Blocks.NETHERRACK));
    }

    protected Iterable<Block> getKnownBlocks() {
        return BuiltInRegistries.BLOCK.entrySet().stream().filter(entry -> ((ResourceKey)entry.getKey()).location().getNamespace().contains("regions_unexplored")).map(Map.Entry::getValue).toList();
    }

    protected LootTable.Builder createMushroomBlockDrop(Block block, ItemLike item) {
        return this.createSilkTouchDispatchTable(block, (LootPoolEntryContainer.Builder)this.applyExplosionDecay((ItemLike)block, (FunctionUserBuilder)LootItem.lootTableItem((ItemLike)item).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)0.0f, (float)2.0f))).apply((LootItemFunction.Builder)LimitCount.limitCount((IntRange)IntRange.lowerBound((int)0)))));
    }

    protected LootTable.Builder createDoublePlantWithSeedDropsNoGrass(Block block, Block block1, ItemLike item, float ... chances) {
        AlternativesEntry.Builder builder = ((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)block1).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)1.0f))).when(HAS_SHEARS)).otherwise(((LootPoolSingletonContainer.Builder)this.applyExplosionCondition((ItemLike)block, (ConditionUserBuilder)LootItem.lootTableItem((ItemLike)item))).when(BonusLevelTableCondition.bonusLevelFlatChance((Holder)this.registries.holderOrThrow(Enchantments.FORTUNE), (float[])chances)));
        return LootTable.lootTable().withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)builder).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)block).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.LOWER))).when(LocationCheck.checkLocation((LocationPredicate.Builder)LocationPredicate.Builder.location().setBlock(BlockPredicate.Builder.block().of(new Block[]{block}).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.UPPER))), (BlockPos)new BlockPos(0, 1, 0)))).withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)builder).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)block).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.UPPER))).when(LocationCheck.checkLocation((LocationPredicate.Builder)LocationPredicate.Builder.location().setBlock(BlockPredicate.Builder.block().of(new Block[]{block}).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.LOWER))), (BlockPos)new BlockPos(0, -1, 0))));
    }

    protected LootTable.Builder createDoublePlantWithSeedDropsNoGrass(Block block) {
        AlternativesEntry.Builder builder = ((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)block).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)2.0f))).when(HAS_SHEARS)).otherwise(((LootPoolSingletonContainer.Builder)this.applyExplosionCondition((ItemLike)block, (ConditionUserBuilder)LootItem.lootTableItem((ItemLike)Items.WHEAT_SEEDS))).when(LootItemRandomChanceCondition.randomChance((float)0.125f)));
        return LootTable.lootTable().withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)builder).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)block).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.LOWER))).when(LocationCheck.checkLocation((LocationPredicate.Builder)LocationPredicate.Builder.location().setBlock(BlockPredicate.Builder.block().of(new Block[]{block}).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.UPPER))), (BlockPos)new BlockPos(0, 1, 0)))).withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)builder).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)block).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.UPPER))).when(LocationCheck.checkLocation((LocationPredicate.Builder)LocationPredicate.Builder.location().setBlock(BlockPredicate.Builder.block().of(new Block[]{block}).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.LOWER))), (BlockPos)new BlockPos(0, -1, 0))));
    }

    protected LootTable.Builder createShearsDispatchTable(Block block, LootPoolEntryContainer.Builder<?> builder) {
        return RuBlockLootTables.createSelfDropDispatchTable((Block)block, (LootItemCondition.Builder)HAS_SHEARS, builder);
    }

    protected static LootTable.Builder createShearsOnlyDrop(ItemLike item) {
        return LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).when(HAS_SHEARS).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)item)));
    }

    protected LootTable.Builder createSilkTouchOrShearsDispatchTable(Block block, LootPoolEntryContainer.Builder<?> builder) {
        return RuBlockLootTables.createSelfDropDispatchTable((Block)block, (LootItemCondition.Builder)this.HAS_SHEARS_OR_SILK_TOUCH, builder);
    }

    protected LootTable.Builder createLeavesDrops(Block block, Block block1, float ... chances) {
        HolderLookup.RegistryLookup registrylookup = this.registries.lookupOrThrow(Registries.ENCHANTMENT);
        return this.createSilkTouchOrShearsDispatchTable(block, ((LootPoolSingletonContainer.Builder)this.applyExplosionCondition((ItemLike)block, (ConditionUserBuilder)LootItem.lootTableItem((ItemLike)block1))).when(BonusLevelTableCondition.bonusLevelFlatChance((Holder)registrylookup.getOrThrow(Enchantments.FORTUNE), (float[])chances))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).when(this.HAS_NO_SHEARS_OR_SILK_TOUCH).add(((LootPoolSingletonContainer.Builder)this.applyExplosionDecay((ItemLike)block, (FunctionUserBuilder)LootItem.lootTableItem((ItemLike)Items.STICK).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)2.0f))))).when(BonusLevelTableCondition.bonusLevelFlatChance((Holder)registrylookup.getOrThrow(Enchantments.FORTUNE), (float[])NORMAL_LEAVES_STICK_CHANCES))));
    }

    protected LootTable.Builder createOakLeavesDrops(Block block, Block block1, float ... chances) {
        HolderLookup.RegistryLookup registrylookup = this.registries.lookupOrThrow(Registries.ENCHANTMENT);
        return this.createLeavesDrops(block, block1, chances).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).when(this.HAS_NO_SHEARS_OR_SILK_TOUCH).add(((LootPoolSingletonContainer.Builder)this.applyExplosionCondition((ItemLike)block, (ConditionUserBuilder)LootItem.lootTableItem((ItemLike)Items.APPLE))).when(BonusLevelTableCondition.bonusLevelFlatChance((Holder)registrylookup.getOrThrow(Enchantments.FORTUNE), (float[])new float[]{0.005f, 0.0055555557f, 0.00625f, 0.008333334f, 0.025f}))));
    }

    protected LootTable.Builder createDoublePlantWithSeedDrops(Block block, Block block1) {
        AlternativesEntry.Builder builder = ((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)block1).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)2.0f))).when(HAS_SHEARS)).otherwise(((LootPoolSingletonContainer.Builder)this.applyExplosionCondition((ItemLike)block, (ConditionUserBuilder)LootItem.lootTableItem((ItemLike)Items.WHEAT_SEEDS))).when(LootItemRandomChanceCondition.randomChance((float)0.125f)));
        return LootTable.lootTable().withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)builder).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)block).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.LOWER))).when(LocationCheck.checkLocation((LocationPredicate.Builder)LocationPredicate.Builder.location().setBlock(BlockPredicate.Builder.block().of(new Block[]{block}).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.UPPER))), (BlockPos)new BlockPos(0, 1, 0)))).withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)builder).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)block).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.UPPER))).when(LocationCheck.checkLocation((LocationPredicate.Builder)LocationPredicate.Builder.location().setBlock(BlockPredicate.Builder.block().of(new Block[]{block}).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.LOWER))), (BlockPos)new BlockPos(0, -1, 0))));
    }
}

