/*
 * Decompiled with CFR 0.152.
 */
package net.regions_unexplored.data.worldgen.placement;

import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.valueproviders.ClampedNormalInt;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.BlockPredicateFilter;
import net.minecraft.world.level.levelgen.placement.CountOnEveryLayerPlacement;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.EnvironmentScanPlacement;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RandomOffsetPlacement;
import net.minecraft.world.level.levelgen.placement.RarityFilter;
import net.minecraft.world.level.levelgen.placement.SurfaceWaterDepthFilter;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.regions_unexplored.block.RuBlocks;
import net.regions_unexplored.data.worldgen.features.RuMiscOverworldFeatures;
import net.regions_unexplored.registry.PlacedFeatureRegistry;

public class RuMiscOverworldPlacements {
    public static final ResourceKey<PlacedFeature> DISK_CLAY = PlacedFeatureRegistry.createKey("disk_clay");
    public static final ResourceKey<PlacedFeature> DISK_GRAVEL = PlacedFeatureRegistry.createKey("disk_gravel");
    public static final ResourceKey<PlacedFeature> DISK_SAND = PlacedFeatureRegistry.createKey("disk_sand");
    public static final ResourceKey<PlacedFeature> REDWOODS_ROCK = PlacedFeatureRegistry.createKey("redwoods_rock");
    public static final ResourceKey<PlacedFeature> FALLEN_LARCH_TREE = PlacedFeatureRegistry.createKey("fallen_larch_tree");
    public static final ResourceKey<PlacedFeature> FALLEN_MAPLE_TREE = PlacedFeatureRegistry.createKey("fallen_maple_tree");
    public static final ResourceKey<PlacedFeature> FALLEN_OAK_TREE_SPARSE = PlacedFeatureRegistry.createKey("fallen_oak_tree_sparse");
    public static final ResourceKey<PlacedFeature> FALLEN_OAK_TREE_DENSE = PlacedFeatureRegistry.createKey("fallen_oak_tree_dense");
    public static final ResourceKey<PlacedFeature> FALLEN_PINE_TREE = PlacedFeatureRegistry.createKey("fallen_pine_tree");
    public static final ResourceKey<PlacedFeature> FALLEN_PINE_TREE_ON_DIRT = PlacedFeatureRegistry.createKey("fallen_pine_tree_on_dirt");
    public static final ResourceKey<PlacedFeature> FALLEN_PINE_TREE_ON_SNOW = PlacedFeatureRegistry.createKey("fallen_pine_tree_on_snow");
    public static final ResourceKey<PlacedFeature> FALLEN_SILVER_BIRCH_TREE = PlacedFeatureRegistry.createKey("fallen_silver_birch_tree");
    public static final ResourceKey<PlacedFeature> POINTED_REDSTONE = PlacedFeatureRegistry.createKey("pointed_redstone");
    public static final ResourceKey<PlacedFeature> LARGE_POINTED_REDSTONE = PlacedFeatureRegistry.createKey("large_pointed_redstone");
    public static final ResourceKey<PlacedFeature> POINTED_REDSTONE_CLUSTER = PlacedFeatureRegistry.createKey("pointed_redstone_cluster");
    public static final ResourceKey<PlacedFeature> ORE_REDSTONE_LARGE = PlacedFeatureRegistry.createKey("ore_redstone_large");
    public static final ResourceKey<PlacedFeature> PRISMARITE_CLUSTERS = PlacedFeatureRegistry.createKey("prismarite_clusters");
    public static final ResourceKey<PlacedFeature> HANGING_PRISMARITE_CLUSTER = PlacedFeatureRegistry.createKey("hanging_prismarite_cluster");
    public static final ResourceKey<PlacedFeature> LAVA_FALL = PlacedFeatureRegistry.createKey("lava_fall");
    public static final ResourceKey<PlacedFeature> OVERWORLD_LAVA_DELTA = PlacedFeatureRegistry.createKey("overworld_lava_delta");
    public static final ResourceKey<PlacedFeature> ASH_VENT = PlacedFeatureRegistry.createKey("ash_vent");
    public static final ResourceKey<PlacedFeature> BASALT_BLOB = PlacedFeatureRegistry.createKey("basalt_blob");
    public static final ResourceKey<PlacedFeature> MINERAL_POOL = PlacedFeatureRegistry.createKey("mineral_pool");
    public static final ResourceKey<PlacedFeature> MOSS_PATCH_WITH_WATER = PlacedFeatureRegistry.createKey("moss_patch_with_water");
    public static final ResourceKey<PlacedFeature> MOSS_PATCH_WITH_WATER_UNCOMMON = PlacedFeatureRegistry.createKey("moss_patch_with_water_uncommon");
    public static final ResourceKey<PlacedFeature> MOSS_PATCH_WITH_WATER_RARE = PlacedFeatureRegistry.createKey("moss_patch_with_water_rare");
    public static final ResourceKey<PlacedFeature> MARSH = PlacedFeatureRegistry.createKey("marsh");
    public static final ResourceKey<PlacedFeature> WATER_EDGE = PlacedFeatureRegistry.createKey("water_edge");
    public static final ResourceKey<PlacedFeature> ICICLE_UP = PlacedFeatureRegistry.createKey("icicle_up");
    public static final ResourceKey<PlacedFeature> SMOULDERING_DIRT = PlacedFeatureRegistry.createKey("smouldering_dirt");
    public static final ResourceKey<PlacedFeature> MEADOW_ROCK = PlacedFeatureRegistry.createKey("meadow_rock");
    public static final ResourceKey<PlacedFeature> ROCK = PlacedFeatureRegistry.createKey("rock");
    public static final ResourceKey<PlacedFeature> ROCK_ON_GRAVEL = PlacedFeatureRegistry.createKey("rock_on_gravel");
    public static final ResourceKey<PlacedFeature> ROCK_ON_SNOW = PlacedFeatureRegistry.createKey("rock_on_snow");
    public static final ResourceKey<PlacedFeature> NOISE_PUMPKINS = PlacedFeatureRegistry.createKey("noise_pumpkins");
    public static final ResourceKey<PlacedFeature> NOISE_ROCKS = PlacedFeatureRegistry.createKey("noise_rocks");
    public static final ResourceKey<PlacedFeature> NOISE_BUSH = PlacedFeatureRegistry.createKey("noise_bush");

    public static void bootstrap(BootstrapContext<PlacedFeature> context) {
        HolderGetter featureGetter = context.lookup(Registries.CONFIGURED_FEATURE);
        Holder.Reference DISK_CLAY = featureGetter.getOrThrow(RuMiscOverworldFeatures.DISK_CLAY);
        Holder.Reference DISK_GRAVEL = featureGetter.getOrThrow(RuMiscOverworldFeatures.DISK_GRAVEL);
        Holder.Reference DISK_SAND = featureGetter.getOrThrow(RuMiscOverworldFeatures.DISK_SAND);
        Holder.Reference REDWOODS_ROCK = featureGetter.getOrThrow(RuMiscOverworldFeatures.REDWOODS_ROCK);
        Holder.Reference FALLEN_LARCH_TREE = featureGetter.getOrThrow(RuMiscOverworldFeatures.FALLEN_LARCH_TREE);
        Holder.Reference FALLEN_MAPLE_TREE = featureGetter.getOrThrow(RuMiscOverworldFeatures.FALLEN_MAPLE_TREE);
        Holder.Reference FALLEN_OAK_TREE = featureGetter.getOrThrow(RuMiscOverworldFeatures.FALLEN_OAK_TREE);
        Holder.Reference FALLEN_OAK_TREE_WITH_BLOB = featureGetter.getOrThrow(RuMiscOverworldFeatures.FALLEN_OAK_TREE_WITH_BLOB);
        Holder.Reference FALLEN_PINE_TREE = featureGetter.getOrThrow(RuMiscOverworldFeatures.FALLEN_PINE_TREE);
        Holder.Reference FALLEN_SNOW_PINE_TREE = featureGetter.getOrThrow(RuMiscOverworldFeatures.FALLEN_SNOW_PINE_TREE);
        Holder.Reference FALLEN_SILVER_BIRCH_TREE = featureGetter.getOrThrow(RuMiscOverworldFeatures.FALLEN_SILVER_BIRCH_TREE);
        Holder.Reference POINTED_REDSTONE = featureGetter.getOrThrow(RuMiscOverworldFeatures.POINTED_REDSTONE);
        Holder.Reference LARGE_POINTED_REDSTONE = featureGetter.getOrThrow(RuMiscOverworldFeatures.LARGE_POINTED_REDSTONE);
        Holder.Reference POINTED_REDSTONE_CLUSTER = featureGetter.getOrThrow(RuMiscOverworldFeatures.POINTED_REDSTONE_CLUSTER);
        Holder.Reference ORE_REDSTONE_LARGE = featureGetter.getOrThrow(RuMiscOverworldFeatures.ORE_REDSTONE_LARGE);
        Holder.Reference PRISMARITE_CLUSTERS = featureGetter.getOrThrow(RuMiscOverworldFeatures.PRISMARITE_CLUSTERS);
        Holder.Reference HANGING_PRISMARITE_CLUSTER = featureGetter.getOrThrow(RuMiscOverworldFeatures.HANGING_PRISMARITE_CLUSTER);
        Holder.Reference MINERAL_POOL = featureGetter.getOrThrow(RuMiscOverworldFeatures.MINERAL_POOL);
        Holder.Reference LAVA_FALL = featureGetter.getOrThrow(RuMiscOverworldFeatures.LAVA_FALL);
        Holder.Reference OVERWORLD_LAVA_DELTA = featureGetter.getOrThrow(RuMiscOverworldFeatures.OVERWORLD_LAVA_DELTA);
        Holder.Reference ASH_VENT = featureGetter.getOrThrow(RuMiscOverworldFeatures.ASH_VENT);
        Holder.Reference BASALT_BLOB = featureGetter.getOrThrow(RuMiscOverworldFeatures.BASALT_BLOB);
        Holder.Reference MOSS_PATCH_WITH_WATER = featureGetter.getOrThrow(RuMiscOverworldFeatures.MOSS_PATCH_WITH_WATER);
        Holder.Reference MARSH = featureGetter.getOrThrow(RuMiscOverworldFeatures.MARSH);
        Holder.Reference WATER_EDGE = featureGetter.getOrThrow(RuMiscOverworldFeatures.WATER_EDGE);
        Holder.Reference ICICLE_UP = featureGetter.getOrThrow(RuMiscOverworldFeatures.ICICLE_UP);
        Holder.Reference SMOULDERING_DIRT = featureGetter.getOrThrow(RuMiscOverworldFeatures.SMOULDERING_DIRT);
        Holder.Reference MEADOW_ROCK = featureGetter.getOrThrow(RuMiscOverworldFeatures.MEADOW_ROCK);
        Holder.Reference ROCK = featureGetter.getOrThrow(RuMiscOverworldFeatures.ROCK);
        Holder.Reference NOISE_PUMPKINS = featureGetter.getOrThrow(RuMiscOverworldFeatures.PATCH_NOISE_PUMPKINS);
        Holder.Reference NOISE_ROCKS = featureGetter.getOrThrow(RuMiscOverworldFeatures.PATCH_NOISE_ROCKS);
        Holder.Reference NOISE_BUSH = featureGetter.getOrThrow(RuMiscOverworldFeatures.PATCH_NOISE_BUSH);
        RuMiscOverworldPlacements.register(context, RuMiscOverworldPlacements.DISK_CLAY, DISK_CLAY, new PlacementModifier[]{InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP_TOP_SOLID, BlockPredicateFilter.forPredicate((BlockPredicate)BlockPredicate.matchesFluids((Fluid[])new Fluid[]{Fluids.WATER})), BiomeFilter.biome()});
        RuMiscOverworldPlacements.register(context, RuMiscOverworldPlacements.DISK_GRAVEL, DISK_GRAVEL, new PlacementModifier[]{InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP_TOP_SOLID, BlockPredicateFilter.forPredicate((BlockPredicate)BlockPredicate.matchesFluids((Fluid[])new Fluid[]{Fluids.WATER})), BiomeFilter.biome()});
        RuMiscOverworldPlacements.register(context, RuMiscOverworldPlacements.DISK_SAND, DISK_SAND, new PlacementModifier[]{CountPlacement.of((int)3), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP_TOP_SOLID, BlockPredicateFilter.forPredicate((BlockPredicate)BlockPredicate.matchesFluids((Fluid[])new Fluid[]{Fluids.WATER})), BiomeFilter.biome()});
        RuMiscOverworldPlacements.register(context, RuMiscOverworldPlacements.REDWOODS_ROCK, REDWOODS_ROCK, new PlacementModifier[]{CountPlacement.of((int)2), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, BiomeFilter.biome()});
        RuMiscOverworldPlacements.register(context, RuMiscOverworldPlacements.FALLEN_LARCH_TREE, FALLEN_LARCH_TREE, List.of(RarityFilter.onAverageOnceEvery((int)3), InSquarePlacement.spread(), SurfaceWaterDepthFilter.forMaxDepth((int)0), PlacementUtils.HEIGHTMAP_OCEAN_FLOOR, PlacementUtils.filteredByBlockSurvival((Block)Blocks.OAK_SAPLING), BiomeFilter.biome()));
        RuMiscOverworldPlacements.register(context, RuMiscOverworldPlacements.FALLEN_SILVER_BIRCH_TREE, FALLEN_SILVER_BIRCH_TREE, List.of(RarityFilter.onAverageOnceEvery((int)2), InSquarePlacement.spread(), SurfaceWaterDepthFilter.forMaxDepth((int)0), PlacementUtils.HEIGHTMAP_OCEAN_FLOOR, PlacementUtils.filteredByBlockSurvival((Block)Blocks.OAK_SAPLING), BiomeFilter.biome()));
        RuMiscOverworldPlacements.register(context, RuMiscOverworldPlacements.FALLEN_MAPLE_TREE, FALLEN_MAPLE_TREE, List.of(RarityFilter.onAverageOnceEvery((int)2), InSquarePlacement.spread(), SurfaceWaterDepthFilter.forMaxDepth((int)0), PlacementUtils.HEIGHTMAP_OCEAN_FLOOR, PlacementUtils.filteredByBlockSurvival((Block)Blocks.OAK_SAPLING), BiomeFilter.biome()));
        RuMiscOverworldPlacements.register(context, FALLEN_OAK_TREE_SPARSE, FALLEN_OAK_TREE, List.of(RarityFilter.onAverageOnceEvery((int)6), InSquarePlacement.spread(), SurfaceWaterDepthFilter.forMaxDepth((int)0), PlacementUtils.HEIGHTMAP_OCEAN_FLOOR, PlacementUtils.filteredByBlockSurvival((Block)Blocks.OAK_SAPLING), BiomeFilter.biome()));
        RuMiscOverworldPlacements.register(context, FALLEN_OAK_TREE_DENSE, FALLEN_OAK_TREE_WITH_BLOB, List.of(RarityFilter.onAverageOnceEvery((int)2), InSquarePlacement.spread(), SurfaceWaterDepthFilter.forMaxDepth((int)0), PlacementUtils.HEIGHTMAP_OCEAN_FLOOR, PlacementUtils.filteredByBlockSurvival((Block)Blocks.OAK_SAPLING), BiomeFilter.biome()));
        RuMiscOverworldPlacements.register(context, RuMiscOverworldPlacements.FALLEN_PINE_TREE, FALLEN_PINE_TREE, List.of(RarityFilter.onAverageOnceEvery((int)2), InSquarePlacement.spread(), SurfaceWaterDepthFilter.forMaxDepth((int)0), PlacementUtils.HEIGHTMAP_OCEAN_FLOOR, PlacementUtils.filteredByBlockSurvival((Block)Blocks.OAK_SAPLING), BiomeFilter.biome()));
        RuMiscOverworldPlacements.register(context, FALLEN_PINE_TREE_ON_DIRT, FALLEN_PINE_TREE, List.of(RarityFilter.onAverageOnceEvery((int)2), InSquarePlacement.spread(), SurfaceWaterDepthFilter.forMaxDepth((int)0), PlacementUtils.HEIGHTMAP_OCEAN_FLOOR, BlockPredicateFilter.forPredicate((BlockPredicate)PlacedFeatureRegistry.onDirtPredicate), BiomeFilter.biome()));
        RuMiscOverworldPlacements.register(context, FALLEN_PINE_TREE_ON_SNOW, FALLEN_SNOW_PINE_TREE, List.of(RarityFilter.onAverageOnceEvery((int)2), InSquarePlacement.spread(), SurfaceWaterDepthFilter.forMaxDepth((int)0), PlacementUtils.HEIGHTMAP_OCEAN_FLOOR, BlockPredicateFilter.forPredicate((BlockPredicate)PlacedFeatureRegistry.onSnowPredicate), BiomeFilter.biome()));
        RuMiscOverworldPlacements.register(context, RuMiscOverworldPlacements.POINTED_REDSTONE, POINTED_REDSTONE, new PlacementModifier[]{CountPlacement.of((IntProvider)UniformInt.of((int)192, (int)256)), InSquarePlacement.spread(), PlacementUtils.RANGE_BOTTOM_TO_MAX_TERRAIN_HEIGHT, CountPlacement.of((IntProvider)UniformInt.of((int)1, (int)5)), RandomOffsetPlacement.of((IntProvider)ClampedNormalInt.of((float)0.0f, (float)3.0f, (int)-10, (int)10), (IntProvider)ClampedNormalInt.of((float)0.0f, (float)0.6f, (int)-2, (int)2)), BiomeFilter.biome()});
        RuMiscOverworldPlacements.register(context, RuMiscOverworldPlacements.LARGE_POINTED_REDSTONE, LARGE_POINTED_REDSTONE, new PlacementModifier[]{CountPlacement.of((IntProvider)UniformInt.of((int)10, (int)48)), InSquarePlacement.spread(), PlacementUtils.RANGE_BOTTOM_TO_MAX_TERRAIN_HEIGHT, BiomeFilter.biome()});
        RuMiscOverworldPlacements.register(context, RuMiscOverworldPlacements.POINTED_REDSTONE_CLUSTER, POINTED_REDSTONE_CLUSTER, new PlacementModifier[]{CountPlacement.of((IntProvider)UniformInt.of((int)78, (int)126)), InSquarePlacement.spread(), PlacementUtils.RANGE_BOTTOM_TO_MAX_TERRAIN_HEIGHT, BiomeFilter.biome()});
        RuMiscOverworldPlacements.register(context, RuMiscOverworldPlacements.ORE_REDSTONE_LARGE, ORE_REDSTONE_LARGE, RuMiscOverworldPlacements.commonOrePlacement(16, (PlacementModifier)HeightRangePlacement.triangle((VerticalAnchor)VerticalAnchor.bottom(), (VerticalAnchor)VerticalAnchor.absolute((int)112))));
        RuMiscOverworldPlacements.register(context, RuMiscOverworldPlacements.PRISMARITE_CLUSTERS, PRISMARITE_CLUSTERS, List.of(CountOnEveryLayerPlacement.of((int)8), BiomeFilter.biome()));
        RuMiscOverworldPlacements.register(context, RuMiscOverworldPlacements.HANGING_PRISMARITE_CLUSTER, HANGING_PRISMARITE_CLUSTER, new PlacementModifier[]{CountPlacement.of((IntProvider)UniformInt.of((int)78, (int)126)), InSquarePlacement.spread(), PlacementUtils.RANGE_BOTTOM_TO_MAX_TERRAIN_HEIGHT, BiomeFilter.biome()});
        RuMiscOverworldPlacements.register(context, RuMiscOverworldPlacements.MINERAL_POOL, MINERAL_POOL, new PlacementModifier[]{CountPlacement.of((int)70), InSquarePlacement.spread(), PlacementUtils.RANGE_BOTTOM_TO_MAX_TERRAIN_HEIGHT, EnvironmentScanPlacement.scanningFor((Direction)Direction.DOWN, (BlockPredicate)BlockPredicate.solid(), (BlockPredicate)BlockPredicate.ONLY_IN_AIR_PREDICATE, (int)12), RandomOffsetPlacement.vertical((IntProvider)ConstantInt.of((int)1)), BiomeFilter.biome()});
        RuMiscOverworldPlacements.register(context, RuMiscOverworldPlacements.LAVA_FALL, LAVA_FALL, List.of(CountOnEveryLayerPlacement.of((int)1), BiomeFilter.biome()));
        RuMiscOverworldPlacements.register(context, RuMiscOverworldPlacements.OVERWORLD_LAVA_DELTA, OVERWORLD_LAVA_DELTA, new PlacementModifier[]{CountPlacement.of((int)115), InSquarePlacement.spread(), PlacementUtils.RANGE_BOTTOM_TO_MAX_TERRAIN_HEIGHT, EnvironmentScanPlacement.scanningFor((Direction)Direction.DOWN, (BlockPredicate)BlockPredicate.solid(), (BlockPredicate)BlockPredicate.ONLY_IN_AIR_PREDICATE, (int)12), RandomOffsetPlacement.vertical((IntProvider)ConstantInt.of((int)1)), BiomeFilter.biome()});
        RuMiscOverworldPlacements.register(context, RuMiscOverworldPlacements.ASH_VENT, ASH_VENT, List.of(CountOnEveryLayerPlacement.of((int)7), BiomeFilter.biome()));
        RuMiscOverworldPlacements.register(context, RuMiscOverworldPlacements.BASALT_BLOB, BASALT_BLOB, new PlacementModifier[]{CountOnEveryLayerPlacement.of((int)4), BiomeFilter.biome()});
        RuMiscOverworldPlacements.register(context, RuMiscOverworldPlacements.MOSS_PATCH_WITH_WATER, MOSS_PATCH_WITH_WATER, new PlacementModifier[]{CountPlacement.of((int)1), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP_TOP_SOLID, EnvironmentScanPlacement.scanningFor((Direction)Direction.DOWN, (BlockPredicate)BlockPredicate.solid(), (BlockPredicate)BlockPredicate.ONLY_IN_AIR_PREDICATE, (int)12), RandomOffsetPlacement.vertical((IntProvider)ConstantInt.of((int)1)), BiomeFilter.biome()});
        RuMiscOverworldPlacements.register(context, MOSS_PATCH_WITH_WATER_UNCOMMON, MOSS_PATCH_WITH_WATER, new PlacementModifier[]{RarityFilter.onAverageOnceEvery((int)2), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP_TOP_SOLID, EnvironmentScanPlacement.scanningFor((Direction)Direction.DOWN, (BlockPredicate)BlockPredicate.solid(), (BlockPredicate)BlockPredicate.ONLY_IN_AIR_PREDICATE, (int)12), RandomOffsetPlacement.vertical((IntProvider)ConstantInt.of((int)1)), BiomeFilter.biome()});
        RuMiscOverworldPlacements.register(context, MOSS_PATCH_WITH_WATER_RARE, MOSS_PATCH_WITH_WATER, new PlacementModifier[]{RarityFilter.onAverageOnceEvery((int)4), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP_TOP_SOLID, EnvironmentScanPlacement.scanningFor((Direction)Direction.DOWN, (BlockPredicate)BlockPredicate.solid(), (BlockPredicate)BlockPredicate.ONLY_IN_AIR_PREDICATE, (int)12), RandomOffsetPlacement.vertical((IntProvider)ConstantInt.of((int)1)), BiomeFilter.biome()});
        RuMiscOverworldPlacements.register(context, RuMiscOverworldPlacements.MARSH, MARSH, new PlacementModifier[]{CountPlacement.of((int)10), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP_WORLD_SURFACE, BiomeFilter.biome()});
        RuMiscOverworldPlacements.register(context, RuMiscOverworldPlacements.WATER_EDGE, WATER_EDGE, new PlacementModifier[]{CountPlacement.of((int)10), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP_OCEAN_FLOOR, BiomeFilter.biome()});
        RuMiscOverworldPlacements.register(context, RuMiscOverworldPlacements.ICICLE_UP, ICICLE_UP, List.of(CountPlacement.of((int)4), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP_WORLD_SURFACE, BlockPredicateFilter.forPredicate((BlockPredicate)PlacedFeatureRegistry.onSnowPredicate), BiomeFilter.biome()));
        RuMiscOverworldPlacements.register(context, RuMiscOverworldPlacements.SMOULDERING_DIRT, SMOULDERING_DIRT, new PlacementModifier[]{CountPlacement.of((int)25), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP_WORLD_SURFACE, BiomeFilter.biome()});
        RuMiscOverworldPlacements.register(context, RuMiscOverworldPlacements.MEADOW_ROCK, MEADOW_ROCK, List.of(CountPlacement.of((int)1), InSquarePlacement.spread(), SurfaceWaterDepthFilter.forMaxDepth((int)0), PlacementUtils.HEIGHTMAP_OCEAN_FLOOR, PlacementUtils.filteredByBlockSurvival((Block)Blocks.OAK_SAPLING), BiomeFilter.biome()));
        RuMiscOverworldPlacements.register(context, RuMiscOverworldPlacements.ROCK, ROCK, List.of(CountPlacement.of((int)3), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP_OCEAN_FLOOR, PlacementUtils.filteredByBlockSurvival((Block)Blocks.OAK_SAPLING), BiomeFilter.biome()));
        RuMiscOverworldPlacements.register(context, ROCK_ON_GRAVEL, ROCK, List.of(CountPlacement.of((int)3), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP_OCEAN_FLOOR, PlacementUtils.filteredByBlockSurvival((Block)RuBlocks.STONE_BUD.get()), BiomeFilter.biome()));
        RuMiscOverworldPlacements.register(context, ROCK_ON_SNOW, ROCK, List.of(CountPlacement.of((int)1), InSquarePlacement.spread(), SurfaceWaterDepthFilter.forMaxDepth((int)0), PlacementUtils.HEIGHTMAP_OCEAN_FLOOR, BlockPredicateFilter.forPredicate((BlockPredicate)PlacedFeatureRegistry.onSnowPredicate), BiomeFilter.biome()));
        RuMiscOverworldPlacements.register(context, RuMiscOverworldPlacements.NOISE_PUMPKINS, NOISE_PUMPKINS, List.of(CountPlacement.of((int)18), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, BiomeFilter.biome()));
        RuMiscOverworldPlacements.register(context, RuMiscOverworldPlacements.NOISE_ROCKS, NOISE_ROCKS, List.of(CountPlacement.of((int)15), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, BiomeFilter.biome()));
        RuMiscOverworldPlacements.register(context, RuMiscOverworldPlacements.NOISE_BUSH, NOISE_BUSH, List.of(CountPlacement.of((int)15), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, BiomeFilter.biome()));
    }

    private static List<PlacementModifier> orePlacement(PlacementModifier placementModifier, PlacementModifier placementModifier1) {
        return List.of(placementModifier, InSquarePlacement.spread(), placementModifier1, BiomeFilter.biome());
    }

    private static List<PlacementModifier> commonOrePlacement(int i, PlacementModifier placementModifier) {
        return RuMiscOverworldPlacements.orePlacement((PlacementModifier)CountPlacement.of((int)i), placementModifier);
    }

    protected static void register(BootstrapContext<PlacedFeature> context, ResourceKey<PlacedFeature> key, Holder<ConfiguredFeature<?, ?>> feature, PlacementModifier ... placement) {
        RuMiscOverworldPlacements.register(context, key, feature, List.of(placement));
    }

    protected static void register(BootstrapContext<PlacedFeature> context, ResourceKey<PlacedFeature> key, Holder<ConfiguredFeature<?, ?>> feature, List<PlacementModifier> placement) {
        context.register(key, (Object)new PlacedFeature(feature, placement));
    }
}

