/*
 * Decompiled with CFR 0.152.
 */
package net.regions_unexplored.data.worldgen.biome.builder;

import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.data.worldgen.BiomeDefaultFeatures;
import net.minecraft.sounds.Musics;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.AmbientMoodSettings;
import net.minecraft.world.level.biome.AmbientParticleSettings;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.carver.ConfiguredWorldCarver;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.regions_unexplored.data.worldgen.RuBiomeDefaultFeatures;
import net.regions_unexplored.data.worldgen.placement.RuMiscOverworldPlacements;
import net.regions_unexplored.data.worldgen.placement.RuTreePlacements;
import net.regions_unexplored.data.worldgen.placement.RuVegetationPlacements;

public class TaigaBiomes {
    protected static final int NORMAL_WATER_COLOR = 4159204;
    protected static final int NORMAL_WATER_FOG_COLOR = 329011;
    private static final int OVERWORLD_FOG_COLOR = 12638463;

    protected static int calculateSkyColor(float color) {
        float $$1 = color / 3.0f;
        $$1 = Mth.clamp((float)$$1, (float)-1.0f, (float)1.0f);
        return Mth.hsvToRgb((float)(0.62222224f - $$1 * 0.05f), (float)(0.5f + $$1 * 0.1f), (float)1.0f);
    }

    private static MobSpawnSettings.Builder baseTaigaSpawning() {
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.farmAnimals((MobSpawnSettings.Builder)spawnBuilder);
        spawnBuilder.addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.WOLF, 8, 4, 4)).addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.RABBIT, 4, 2, 3)).addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.FOX, 8, 2, 4));
        BiomeDefaultFeatures.commonSpawns((MobSpawnSettings.Builder)spawnBuilder);
        return spawnBuilder;
    }

    private static BiomeGenerationSettings.Builder baseTaigaGeneration(HolderGetter<PlacedFeature> featureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter, boolean hasSweetBerries) {
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder(featureGetter, carverGetter);
        RuBiomeDefaultFeatures.globalOverworldGeneration(biomeBuilder);
        RuBiomeDefaultFeatures.mediumGrass(biomeBuilder);
        BiomeDefaultFeatures.addFerns((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.addDefaultOres((BiomeGenerationSettings.Builder)biomeBuilder);
        RuBiomeDefaultFeatures.addDefaultSoftDisks(biomeBuilder);
        BiomeDefaultFeatures.addDefaultExtraVegetation((BiomeGenerationSettings.Builder)biomeBuilder);
        if (hasSweetBerries) {
            BiomeDefaultFeatures.addCommonBerryBushes((BiomeGenerationSettings.Builder)biomeBuilder);
        }
        return biomeBuilder;
    }

    public static Biome blackwoodTaiga(HolderGetter<PlacedFeature> featureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeSpecialEffects.Builder effectBuilder = new BiomeSpecialEffects.Builder().skyColor(11454879).fogColor(11454879).waterColor(3108258).waterFogColor(4220035).foliageColorOverride(4347179).grassColorOverride(4089639).ambientParticle(new AmbientParticleSettings((ParticleOptions)ParticleTypes.WHITE_ASH, 0.005f)).ambientMoodSound(AmbientMoodSettings.LEGACY_CAVE_SETTINGS).backgroundMusic(Musics.createGameMusic((Holder)SoundEvents.MUSIC_BIOME_OLD_GROWTH_TAIGA));
        BiomeGenerationSettings.Builder biomeBuilder = TaigaBiomes.baseTaigaGeneration(featureGetter, carverGetter, true);
        RuBiomeDefaultFeatures.blackwoodTrees(biomeBuilder);
        RuBiomeDefaultFeatures.addBlackwoodBioshrooms(biomeBuilder);
        biomeBuilder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, RuVegetationPlacements.BLACKWOOD_VEGETATION);
        biomeBuilder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, RuVegetationPlacements.BLACKWOOD_DARK_OAK_SHRUB_MIX);
        MobSpawnSettings.Builder spawnBuilder = TaigaBiomes.baseTaigaSpawning();
        return new Biome.BiomeBuilder().hasPrecipitation(true).temperature(0.825f).downfall(0.765f).specialEffects(effectBuilder.build()).mobSpawnSettings(spawnBuilder.build()).generationSettings(biomeBuilder.build()).build();
    }

    public static Biome borealTaiga(HolderGetter<PlacedFeature> featureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeSpecialEffects.Builder effectBuilder = new BiomeSpecialEffects.Builder().skyColor(TaigaBiomes.calculateSkyColor(0.55f)).fogColor(12638463).waterColor(-12619852).waterFogColor(7436392).foliageColorOverride(8103502).grassColorOverride(8957796).ambientMoodSound(AmbientMoodSettings.LEGACY_CAVE_SETTINGS).backgroundMusic(Musics.createGameMusic((Holder)SoundEvents.MUSIC_BIOME_OLD_GROWTH_TAIGA));
        BiomeGenerationSettings.Builder biomeBuilder = TaigaBiomes.baseTaigaGeneration(featureGetter, carverGetter, true);
        biomeBuilder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, RuTreePlacements.LARCH_TREE_DENSE);
        biomeBuilder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, RuTreePlacements.GOLDEN_LARCH_TREE_SPARSE);
        biomeBuilder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, RuTreePlacements.BIRCH_TREE_ASPEN);
        biomeBuilder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, RuTreePlacements.OAK_BUSH_SPARSE);
        biomeBuilder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, RuMiscOverworldPlacements.FALLEN_LARCH_TREE);
        RuBiomeDefaultFeatures.addTaigaFlowerPatch(biomeBuilder);
        biomeBuilder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, RuVegetationPlacements.GRASS);
        biomeBuilder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, RuVegetationPlacements.LARCH_SHRUB);
        MobSpawnSettings.Builder spawnBuilder = TaigaBiomes.baseTaigaSpawning();
        return new Biome.BiomeBuilder().hasPrecipitation(true).temperature(0.5f).downfall(0.4f).specialEffects(effectBuilder.build()).mobSpawnSettings(spawnBuilder.build()).generationSettings(biomeBuilder.build()).build();
    }

    public static Biome goldenBorealTaiga(HolderGetter<PlacedFeature> featureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeSpecialEffects.Builder effectBuilder = new BiomeSpecialEffects.Builder().skyColor(TaigaBiomes.calculateSkyColor(0.65f)).fogColor(12638463).waterColor(-12619852).waterFogColor(7436392).foliageColorOverride(12562512).grassColorOverride(10400607).ambientMoodSound(AmbientMoodSettings.LEGACY_CAVE_SETTINGS).backgroundMusic(Musics.createGameMusic((Holder)SoundEvents.MUSIC_BIOME_OLD_GROWTH_TAIGA));
        BiomeGenerationSettings.Builder biomeBuilder = TaigaBiomes.baseTaigaGeneration(featureGetter, carverGetter, true);
        biomeBuilder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, RuTreePlacements.GOLDEN_LARCH_TREE_DENSE);
        biomeBuilder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, RuTreePlacements.LARCH_TREE_SPARSE);
        biomeBuilder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, RuTreePlacements.BIRCH_TREE_ASPEN);
        biomeBuilder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, RuTreePlacements.OAK_BUSH_SPARSE);
        biomeBuilder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, RuMiscOverworldPlacements.FALLEN_LARCH_TREE);
        RuBiomeDefaultFeatures.addTaigaFlowerPatch(biomeBuilder);
        biomeBuilder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, RuVegetationPlacements.GRASS);
        biomeBuilder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, RuVegetationPlacements.GOLDEN_LARCH_SHRUB_MIX);
        MobSpawnSettings.Builder spawnBuilder = TaigaBiomes.baseTaigaSpawning();
        return new Biome.BiomeBuilder().hasPrecipitation(true).temperature(0.45f).downfall(0.3f).specialEffects(effectBuilder.build()).mobSpawnSettings(spawnBuilder.build()).generationSettings(biomeBuilder.build()).build();
    }

    public static Biome pineTaiga(HolderGetter<PlacedFeature> featureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeSpecialEffects.Builder effectBuilder = new BiomeSpecialEffects.Builder().skyColor(TaigaBiomes.calculateSkyColor(0.7f)).fogColor(12638463).waterColor(4159204).waterFogColor(329011).foliageColorOverride(7702086).grassColorOverride(8693594).ambientMoodSound(AmbientMoodSettings.LEGACY_CAVE_SETTINGS).backgroundMusic(Musics.createGameMusic((Holder)SoundEvents.MUSIC_BIOME_OLD_GROWTH_TAIGA));
        BiomeGenerationSettings.Builder biomeBuilder = TaigaBiomes.baseTaigaGeneration(featureGetter, carverGetter, true);
        biomeBuilder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, RuTreePlacements.PINE_TREE_ON_DIRT);
        biomeBuilder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, RuTreePlacements.PINE_TREE_TALL_ON_DIRT);
        biomeBuilder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, RuTreePlacements.PINE_TREE_SHRUB_ON_GRASS);
        biomeBuilder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, RuMiscOverworldPlacements.FALLEN_PINE_TREE_ON_DIRT);
        RuBiomeDefaultFeatures.addTaigaFlowerPatch(biomeBuilder);
        RuBiomeDefaultFeatures.addDirtSurfaceVegetation(biomeBuilder);
        biomeBuilder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, RuVegetationPlacements.PINE_SHRUB);
        MobSpawnSettings.Builder spawnBuilder = TaigaBiomes.baseTaigaSpawning();
        return new Biome.BiomeBuilder().hasPrecipitation(true).temperature(0.6f).downfall(0.4f).specialEffects(effectBuilder.build()).mobSpawnSettings(spawnBuilder.build()).generationSettings(biomeBuilder.build()).build();
    }

    public static Biome redwoods(HolderGetter<PlacedFeature> featureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeSpecialEffects.Builder effectBuilder = new BiomeSpecialEffects.Builder().skyColor(TaigaBiomes.calculateSkyColor(0.8f)).fogColor(12638463).waterColor(4159204).waterFogColor(329011).foliageColorOverride(7512632).grassColorOverride(8240185).ambientMoodSound(AmbientMoodSettings.LEGACY_CAVE_SETTINGS).backgroundMusic(Musics.createGameMusic((Holder)SoundEvents.MUSIC_BIOME_OLD_GROWTH_TAIGA));
        BiomeGenerationSettings.Builder biomeBuilder = TaigaBiomes.baseTaigaGeneration(featureGetter, carverGetter, false);
        biomeBuilder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, RuTreePlacements.ULTRA_REDWOOD_TREE);
        biomeBuilder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, RuTreePlacements.GIANT_REDWOOD_TREE_DENSE);
        biomeBuilder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, RuTreePlacements.REDWOOD_TREE);
        biomeBuilder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, RuTreePlacements.OAK_BUSH_DENSE);
        RuBiomeDefaultFeatures.redwoodDecoration(biomeBuilder);
        biomeBuilder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, RuVegetationPlacements.REDWOOD_SHRUB);
        MobSpawnSettings.Builder spawnBuilder = TaigaBiomes.baseTaigaSpawning();
        return new Biome.BiomeBuilder().hasPrecipitation(true).temperature(1.0f).downfall(0.8f).specialEffects(effectBuilder.build()).mobSpawnSettings(spawnBuilder.build()).generationSettings(biomeBuilder.build()).build();
    }

    public static Biome sparseRedwoods(HolderGetter<PlacedFeature> featureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeSpecialEffects.Builder effectBuilder = new BiomeSpecialEffects.Builder().skyColor(TaigaBiomes.calculateSkyColor(0.8f)).fogColor(12638463).waterColor(4159204).waterFogColor(329011).foliageColorOverride(7512632).grassColorOverride(8240185).ambientMoodSound(AmbientMoodSettings.LEGACY_CAVE_SETTINGS).backgroundMusic(Musics.createGameMusic((Holder)SoundEvents.MUSIC_BIOME_OLD_GROWTH_TAIGA));
        BiomeGenerationSettings.Builder biomeBuilder = TaigaBiomes.baseTaigaGeneration(featureGetter, carverGetter, false);
        biomeBuilder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, RuTreePlacements.GIANT_REDWOOD_TREE_SPARSE);
        biomeBuilder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, RuTreePlacements.REDWOOD_TREE);
        biomeBuilder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, RuTreePlacements.OAK_BUSH_SPARSE);
        RuBiomeDefaultFeatures.redwoodDecoration(biomeBuilder);
        biomeBuilder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, RuVegetationPlacements.REDWOOD_SHRUB);
        MobSpawnSettings.Builder spawnBuilder = TaigaBiomes.baseTaigaSpawning();
        return new Biome.BiomeBuilder().hasPrecipitation(true).temperature(0.95f).downfall(0.8f).specialEffects(effectBuilder.build()).mobSpawnSettings(spawnBuilder.build()).generationSettings(biomeBuilder.build()).build();
    }
}

