/*
 * Decompiled with CFR 0.152.
 */
package com.finndog.mns.events.base;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

public class CancellableEventHandler<T> {
    private final List<CancellableFunction<T>> listeners = new ArrayList<CancellableFunction<T>>();

    public void addListener(CancellableFunction<T> listener) {
        this.listeners.add(listener);
    }

    public void addListener(CancellableFunctionNoReturn<T> listener) {
        this.addListener((boolean b, T t) -> {
            listener.apply(b, t);
            return false;
        });
    }

    public void addListener(CancellableFunctionOnlyReturn<T> listener) {
        this.addListener((boolean b, T t) -> listener.apply(t));
    }

    public void addListener(Consumer<T> listener) {
        this.addListener((T t) -> {
            listener.accept(t);
            return false;
        });
    }

    public void removeListener(CancellableFunction<T> listener) {
        this.listeners.remove(listener);
    }

    public boolean invoke(T event, boolean isCancelled) {
        for (CancellableFunction<T> listener : this.listeners) {
            if (!listener.apply(isCancelled, event)) continue;
            isCancelled = true;
        }
        return isCancelled;
    }

    public boolean invoke(T event) {
        return this.invoke(event, false);
    }

    @FunctionalInterface
    public static interface CancellableFunctionNoReturn<T> {
        public void apply(boolean var1, T var2);
    }

    @FunctionalInterface
    public static interface CancellableFunction<T> {
        public boolean apply(boolean var1, T var2);
    }

    @FunctionalInterface
    public static interface CancellableFunctionOnlyReturn<T> {
        public boolean apply(T var1);
    }
}

