/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.ui.misc;

import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.Icons;
import dev.ftb.mods.ftblibrary.ui.GuiHelper;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.components.toasts.ToastComponent;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;

public class SimpleToast
implements Toast {
    private static final ResourceLocation BACKGROUND_SPRITE = ResourceLocation.parse((String)"toast/advancement");
    private boolean hasPlayedSound = false;

    public static void info(final Component title, final Component subtitle) {
        Minecraft.getInstance().getToasts().addToast((Toast)new SimpleToast(){

            @Override
            public Component getTitle() {
                return title;
            }

            @Override
            public Component getSubtitle() {
                return subtitle;
            }
        });
    }

    public static void error(final Component title, final Component subtitle) {
        Minecraft.getInstance().getToasts().addToast((Toast)new SimpleToast(){

            @Override
            public Component getTitle() {
                return title;
            }

            @Override
            public Component getSubtitle() {
                return subtitle;
            }

            @Override
            public Icon getIcon() {
                return Icons.BARRIER;
            }
        });
    }

    public Toast.Visibility render(GuiGraphics graphics, ToastComponent gui, long delta) {
        int i;
        GuiHelper.setupDrawing();
        Minecraft mc = gui.getMinecraft();
        graphics.blitSprite(BACKGROUND_SPRITE, 0, 0, 160, 32);
        List list = mc.font.split((FormattedText)this.getSubtitle(), 125);
        int n = i = this.isImportant() ? 0xFF88FF : 0xFFFF00;
        if (list.size() == 1) {
            graphics.drawString(mc.font, this.getTitle(), 30, 7, i | 0xFF000000, true);
            graphics.drawString(mc.font, (FormattedCharSequence)list.get(0), 30, 18, -1);
        } else if (delta < 1500L) {
            int k = Mth.floor((float)(Mth.clamp((float)((float)(1500L - delta) / 300.0f), (float)0.0f, (float)1.0f) * 255.0f)) << 24 | 0x4000000;
            graphics.drawString(mc.font, this.getTitle(), 30, 11, i | k, true);
        } else {
            int i1 = Mth.floor((float)(Mth.clamp((float)((float)(delta - 1500L) / 300.0f), (float)0.0f, (float)1.0f) * 252.0f)) << 24 | 0x4000000;
            int n2 = list.size();
            Objects.requireNonNull(mc.font);
            int l = 16 - n2 * 9 / 2;
            for (FormattedCharSequence s : list) {
                graphics.drawString(mc.font, s, 30, l, 0xFFFFFF | i1, true);
                Objects.requireNonNull(mc.font);
                l += 9;
            }
        }
        if (!this.hasPlayedSound && delta > 0L) {
            this.hasPlayedSound = true;
            this.playSound(mc.getSoundManager());
        }
        this.getIcon().draw(graphics, 8, 8, 16, 16);
        return (double)delta >= 5000.0 * gui.getNotificationDisplayTimeMultiplier() ? Toast.Visibility.HIDE : Toast.Visibility.SHOW;
    }

    public Component getTitle() {
        return Component.literal((String)"<error>");
    }

    public Component getSubtitle() {
        return Component.empty();
    }

    public boolean isImportant() {
        return false;
    }

    public Icon getIcon() {
        return Icons.INFO;
    }

    public void playSound(SoundManager handler) {
    }
}

