/*
 * Decompiled with CFR 0.152.
 */
package forge.com.cursee.disenchanting_table.client.gui.screens;

import forge.com.cursee.disenchanting_table.DisEnchantingTable;
import forge.com.cursee.disenchanting_table.client.ClientConfigValues;
import forge.com.cursee.disenchanting_table.core.CommonConfigValues;
import forge.com.cursee.disenchanting_table.core.util.ExperienceHelper;
import forge.com.cursee.disenchanting_table.core.world.inventory.ManualDisenchantingMenu;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.ItemCombinerScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ItemCombinerMenu;

public class ManualDisEnchantingScreen
extends ItemCombinerScreen<ManualDisenchantingMenu> {
    public static final ResourceLocation BACKGROUND = DisEnchantingTable.identifier("textures/gui/container/disenchanting_table.png");

    public ManualDisEnchantingScreen(ManualDisenchantingMenu $$0, Inventory $$1, Component $$2) {
        super((ItemCombinerMenu)$$0, $$1, $$2, BACKGROUND);
    }

    protected void renderErrorIcon(GuiGraphics guiGraphics, int i, int i1) {
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        super.renderBg(guiGraphics, partialTick, mouseX, mouseY);
        if (!((ManualDisenchantingMenu)this.menu).hasResult()) {
            return;
        }
        Minecraft instance = Minecraft.getInstance();
        if (instance.player == null) {
            return;
        }
        LocalPlayer player = instance.player;
        boolean mayPickupResult = false;
        if (CommonConfigValues.uses_points && ExperienceHelper.totalPointsFromLevelAndProgress(player.experienceLevel, player.experienceProgress) >= CommonConfigValues.experience_cost) {
            mayPickupResult = true;
        } else if (!CommonConfigValues.uses_points && player.experienceLevel >= CommonConfigValues.experience_cost) {
            mayPickupResult = true;
        }
        if (!ClientConfigValues.experience_indicator || mayPickupResult || player.getAbilities().instabuild) {
            return;
        }
        guiGraphics.blit(BACKGROUND, this.leftPos + 99 + 3, this.topPos + 45, this.imageWidth, 0, 28, 21);
        int textPadding = 4;
        int xStart = this.leftPos + 45;
        int yStart = this.topPos + 72;
        MutableComponent text = Component.literal((String)"Insufficient Experience!");
        guiGraphics.fill(xStart, yStart, xStart + this.font.width((FormattedText)text) + 4, yStart + 11, -12242305);
        guiGraphics.drawString(this.font, (Component)text, xStart + 2, yStart + 2, -40864);
    }

    protected void init() {
        super.init();
        this.titleLabelY += 9999;
        this.inventoryLabelY += 9999;
    }

    public void resize(Minecraft minecraft, int width, int height) {
        this.init(minecraft, width, height);
    }
}

