/*
 * Decompiled with CFR 0.152.
 */
package fuzs.portablehole.world.level.block.entity;

import fuzs.portablehole.PortableHole;
import fuzs.portablehole.config.ServerConfig;
import fuzs.portablehole.init.ModRegistry;
import fuzs.puzzleslib.api.block.v1.entity.TickingBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Clearable;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class TemporaryHoleBlockEntity
extends BlockEntity
implements TickingBlockEntity {
    public static final String TAG_BLOCK_STATE_SOURCE = PortableHole.id("source_state").toString();
    public static final String TAG_BLOCK_ENTITY_SOURCE_TAG = PortableHole.id("source_block_entity_tag").toString();
    public static final String TAG_LIFETIME_TICKS = PortableHole.id("lifetime_ticks").toString();
    public static final String TAG_GROWTH_DIRECTION = PortableHole.id("growth_direction").toString();
    public static final String TAG_GROWTH_DISTANCE = PortableHole.id("growth_distance").toString();
    private BlockState sourceState;
    @Nullable
    private CompoundTag blockEntityTag;
    private int lifetimeTicks;
    private Direction growthDirection;
    private int growthDistance;

    public TemporaryHoleBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModRegistry.TEMPORARY_HOLE_BLOCK_ENTITY_TYPE.value(), pos, state);
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        if (tag.contains(TAG_BLOCK_STATE_SOURCE, 10)) {
            HolderLookup.RegistryLookup holdergetter = this.level != null ? this.level.holderLookup(Registries.BLOCK) : BuiltInRegistries.BLOCK.asLookup();
            this.sourceState = NbtUtils.readBlockState((HolderGetter)holdergetter, (CompoundTag)tag.getCompound(TAG_BLOCK_STATE_SOURCE));
            if (this.sourceState.isAir()) {
                this.sourceState = null;
            }
        }
        if (tag.contains(TAG_BLOCK_ENTITY_SOURCE_TAG, 10)) {
            this.blockEntityTag = tag.getCompound(TAG_BLOCK_ENTITY_SOURCE_TAG);
        }
        this.lifetimeTicks = tag.getInt(TAG_LIFETIME_TICKS);
        if (tag.contains(TAG_GROWTH_DIRECTION, 1)) {
            this.growthDirection = Direction.values()[tag.getByte(TAG_GROWTH_DIRECTION)];
        }
        this.growthDistance = tag.getInt(TAG_GROWTH_DISTANCE);
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        if (this.sourceState != null) {
            tag.put(TAG_BLOCK_STATE_SOURCE, (Tag)NbtUtils.writeBlockState((BlockState)this.sourceState));
        }
        if (this.blockEntityTag != null) {
            tag.put(TAG_BLOCK_ENTITY_SOURCE_TAG, (Tag)this.blockEntityTag);
        }
        tag.putInt(TAG_LIFETIME_TICKS, this.lifetimeTicks);
        if (this.growthDirection != null) {
            tag.putByte(TAG_GROWTH_DIRECTION, (byte)this.growthDirection.ordinal());
        }
        if (this.growthDistance > 0) {
            tag.putInt(TAG_GROWTH_DISTANCE, this.growthDistance);
        }
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag tag = super.getUpdateTag(registries);
        if (this.sourceState != null) {
            tag.put(TAG_BLOCK_STATE_SOURCE, (Tag)NbtUtils.writeBlockState((BlockState)this.sourceState));
        }
        return tag;
    }

    public BlockState getSourceBlockState() {
        return this.sourceState;
    }

    public void serverTick() {
        if (this.sourceState == null) {
            this.getLevel().removeBlock(this.getBlockPos(), false);
        } else if (this.lifetimeTicks <= 0) {
            this.getLevel().setBlock(this.getBlockPos(), this.sourceState, 3);
            if (this.blockEntityTag != null && this.getLevel().getBlockEntity(this.getBlockPos()) != null) {
                this.getLevel().getBlockEntity(this.getBlockPos()).loadWithComponents(this.blockEntityTag, (HolderLookup.Provider)this.getLevel().registryAccess());
            }
            if (((ServerConfig)PortableHole.CONFIG.get(ServerConfig.class)).particlesForReappearingBlocks) {
                this.getLevel().levelEvent(2001, this.getBlockPos(), Block.getId((BlockState)this.sourceState));
            }
        } else {
            --this.lifetimeTicks;
            TemporaryHoleBlockEntity.tryGrowInDirection(this.getLevel(), this.getBlockPos(), this);
        }
    }

    private static void tryGrowInDirection(Level level, BlockPos pos, TemporaryHoleBlockEntity blockEntity) {
        if (blockEntity.growthDistance > 0 && blockEntity.growthDirection != null) {
            TemporaryHoleBlockEntity.setTemporaryHoleBlock(level, pos.relative(blockEntity.growthDirection), blockEntity.growthDirection, blockEntity.growthDistance - 1);
            blockEntity.growthDistance = 0;
            blockEntity.growthDirection = null;
        }
    }

    public static boolean setTemporaryHoleBlock(Level level, BlockPos blockPos, Direction growthDirection, int growthDistance) {
        if (TemporaryHoleBlockEntity.isValidHolePosition(level, blockPos)) {
            BlockEntity blockEntity;
            boolean replaceBlock;
            BlockEntity blockentity;
            BlockState state = level.getBlockState(blockPos);
            CompoundTag blockEntityTag = null;
            if (((ServerConfig)PortableHole.CONFIG.get(ServerConfig.class)).replaceBlockEntities && (blockentity = level.getBlockEntity(blockPos)) != null) {
                blockEntityTag = blockentity.saveWithoutMetadata((HolderLookup.Provider)level.registryAccess());
                Clearable.tryClear((Object)blockentity);
            }
            boolean bl = replaceBlock = !state.is((Block)ModRegistry.TEMPORARY_HOLE_BLOCK.value());
            if (replaceBlock) {
                level.setBlock(blockPos, ((Block)ModRegistry.TEMPORARY_HOLE_BLOCK.value()).defaultBlockState(), 3);
            }
            if ((blockEntity = level.getBlockEntity(blockPos)) instanceof TemporaryHoleBlockEntity) {
                TemporaryHoleBlockEntity blockEntity2 = (TemporaryHoleBlockEntity)blockEntity;
                if (replaceBlock) {
                    blockEntity2.sourceState = state;
                    blockEntity2.blockEntityTag = blockEntityTag;
                }
                blockEntity2.growthDirection = growthDirection;
                blockEntity2.growthDistance = growthDistance;
                blockEntity2.lifetimeTicks = ((ServerConfig)PortableHole.CONFIG.get(ServerConfig.class)).temporaryHoleDuration;
            }
            return true;
        }
        return false;
    }

    public static boolean isValidHolePosition(Level level, BlockPos blockPos) {
        BlockState blockState = level.getBlockState(blockPos);
        if (level.hasChunkAt(blockPos) && level.isInWorldBounds(blockPos)) {
            if (blockState.is((Block)ModRegistry.TEMPORARY_HOLE_BLOCK.value())) {
                return true;
            }
            if (!(blockState.isAir() || blockState.hasBlockEntity() && !((ServerConfig)PortableHole.CONFIG.get(ServerConfig.class)).replaceBlockEntities || blockState.is(ModRegistry.PORTABLE_HOLE_IMMUNE_TAG))) {
                Block block = blockState.getBlock();
                if (block instanceof DoublePlantBlock || block instanceof DoorBlock || block instanceof BedBlock) {
                    return false;
                }
                float destroySpeed = blockState.getDestroySpeed((BlockGetter)level, blockPos);
                return destroySpeed != -1.0f && (double)destroySpeed <= ((ServerConfig)PortableHole.CONFIG.get(ServerConfig.class)).maxBlockHardness;
            }
        }
        return false;
    }
}

