/*
 * Decompiled with CFR 0.152.
 */
package fuzs.portablehole.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import fuzs.portablehole.PortableHole;
import fuzs.portablehole.config.ServerConfig;
import fuzs.portablehole.world.level.block.entity.TemporaryHoleBlockEntity;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.joml.Matrix4f;

public class TemporaryHoleRenderer
implements BlockEntityRenderer<TemporaryHoleBlockEntity> {
    public TemporaryHoleRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(TemporaryHoleBlockEntity blockEntity, float p_112651_, PoseStack poseStack, MultiBufferSource multiBufferSource, int p_112654_, int p_112655_) {
        if (!((ServerConfig)PortableHole.CONFIG.get(ServerConfig.class)).portalOverlay) {
            return;
        }
        Matrix4f matrix4f = poseStack.last().pose();
        this.renderCube(blockEntity, matrix4f, multiBufferSource.getBuffer(RenderType.endGateway()));
    }

    private void renderCube(TemporaryHoleBlockEntity blockEntity, Matrix4f matrix4f, VertexConsumer vertexConsumer) {
        this.renderFace(blockEntity, matrix4f, vertexConsumer, 0.0f, 1.0f, 0.0f, 1.0f, 0.9995f, 0.9995f, 0.9995f, 0.9995f, Direction.SOUTH);
        this.renderFace(blockEntity, matrix4f, vertexConsumer, 0.0f, 1.0f, 1.0f, 0.0f, 5.0E-4f, 5.0E-4f, 5.0E-4f, 5.0E-4f, Direction.NORTH);
        this.renderFace(blockEntity, matrix4f, vertexConsumer, 0.9995f, 0.9995f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, Direction.EAST);
        this.renderFace(blockEntity, matrix4f, vertexConsumer, 5.0E-4f, 5.0E-4f, 0.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f, Direction.WEST);
        this.renderFace(blockEntity, matrix4f, vertexConsumer, 0.0f, 1.0f, 5.0E-4f, 5.0E-4f, 0.0f, 0.0f, 1.0f, 1.0f, Direction.DOWN);
        this.renderFace(blockEntity, matrix4f, vertexConsumer, 0.0f, 1.0f, 0.9995f, 0.9995f, 1.0f, 1.0f, 0.0f, 0.0f, Direction.UP);
    }

    private void renderFace(TemporaryHoleBlockEntity blockEntity, Matrix4f matrix4f, VertexConsumer vertexConsumer, float x0, float x1, float y0, float y1, float z0, float z1, float z2, float z3, Direction direction) {
        if (!TemporaryHoleRenderer.shouldRenderFace(blockEntity, direction)) {
            vertexConsumer.addVertex(matrix4f, x0, y1, z3);
            vertexConsumer.addVertex(matrix4f, x1, y1, z2);
            vertexConsumer.addVertex(matrix4f, x1, y0, z1);
            vertexConsumer.addVertex(matrix4f, x0, y0, z0);
        }
    }

    private static boolean shouldRenderFace(TemporaryHoleBlockEntity blockEntity, Direction direction) {
        BlockPos blockPos = blockEntity.getBlockPos();
        return Block.shouldRenderFace((BlockState)blockEntity.getBlockState(), (BlockGetter)blockEntity.getLevel(), (BlockPos)blockPos, (Direction)direction, (BlockPos)blockPos.relative(direction));
    }
}

