/*
 * Decompiled with CFR 0.152.
 */
package fuzs.portablehole.client.particle;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import fuzs.portablehole.PortableHole;
import fuzs.portablehole.client.core.ClientAbstractions;
import fuzs.portablehole.config.ClientConfig;
import fuzs.portablehole.core.particles.SparkleParticleData;
import java.util.Objects;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.phys.Vec3;

public class FXSparkle
extends TextureSheetParticle {
    public static final ParticleRenderType NORMAL_RENDER = new ParticleRenderType(){

        public BufferBuilder begin(Tesselator tesselator, TextureManager textureManager) {
            RenderSystem.enableDepthTest();
            if (((ClientConfig)PortableHole.CONFIG.get(ClientConfig.class)).opaqueSparkleParticles) {
                RenderSystem.disableBlend();
                RenderSystem.depthMask((boolean)true);
                RenderSystem.setShader(GameRenderer::getParticleShader);
            } else {
                RenderSystem.depthMask((boolean)false);
                RenderSystem.enableBlend();
                RenderSystem.blendFunc((int)770, (int)1);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.7f);
            }
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)TextureAtlas.LOCATION_PARTICLES);
            return tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.PARTICLE);
        }

        public String toString() {
            return "botania:sparkle";
        }
    };
    private final boolean corrupt;
    private final boolean fake;
    private final boolean slowdown = true;
    private final SpriteSet sprite;

    public FXSparkle(ClientLevel world, double x, double y, double z, float size, float red, float green, float blue, int m, boolean fake, boolean noClip, boolean corrupt, SpriteSet sprite) {
        super(world, x, y, z, 0.0, 0.0, 0.0);
        this.rCol = red;
        this.gCol = green;
        this.bCol = blue;
        this.alpha = 0.75f;
        this.gravity = 0.0f;
        this.zd = 0.0;
        this.yd = 0.0;
        this.xd = 0.0;
        this.quadSize = (this.random.nextFloat() * 0.5f + 0.5f) * 0.2f * size;
        this.lifetime = 3 * m;
        this.setSize(0.01f, 0.01f);
        this.xo = x;
        this.yo = y;
        this.zo = z;
        this.fake = fake;
        this.corrupt = corrupt;
        this.hasPhysics = !fake && !noClip;
        this.sprite = sprite;
        this.setSpriteFromAge(sprite);
    }

    public float getQuadSize(float partialTicks) {
        return this.quadSize * (float)(this.lifetime - this.age + 1) / (float)this.lifetime;
    }

    public void tick() {
        this.setSpriteFromAge(this.sprite);
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.age++ >= this.lifetime) {
            this.remove();
        }
        this.yd -= 0.04 * (double)this.gravity;
        if (this.hasPhysics && !this.fake) {
            this.wiggleAround(this.x, (this.getBoundingBox().minY + this.getBoundingBox().maxY) / 2.0, this.z);
        }
        this.move(this.xd, this.yd, this.zd);
        Objects.requireNonNull(this);
        this.xd *= 0.908;
        this.yd *= 0.908;
        this.zd *= 0.908;
        if (this.onGround) {
            this.xd *= 0.7;
            this.zd *= 0.7;
        }
        if (this.fake && this.age > 1) {
            this.remove();
        }
    }

    public void render(VertexConsumer buffer, Camera camera, float partialTicks) {
        Minecraft minecraft = Minecraft.getInstance();
        AbstractTexture abstractTexture = minecraft.getTextureManager().getTexture(TextureAtlas.LOCATION_PARTICLES);
        ClientAbstractions.INSTANCE.setFilterSave(abstractTexture, true, false);
        super.render(buffer, camera, partialTicks);
        ClientAbstractions.INSTANCE.restoreLastFilter(abstractTexture);
    }

    public ParticleRenderType getRenderType() {
        return NORMAL_RENDER;
    }

    public void setGravity(float value) {
        this.gravity = value;
    }

    private void wiggleAround(double x, double y, double z) {
        BlockPos blockpos = BlockPos.containing((double)x, (double)y, (double)z);
        Vec3 Vector3d = new Vec3(x - (double)blockpos.getX(), y - (double)blockpos.getY(), z - (double)blockpos.getZ());
        BlockPos.MutableBlockPos blockpos$mutable = new BlockPos.MutableBlockPos();
        Direction direction = Direction.UP;
        double d0 = Double.MAX_VALUE;
        for (Direction direction1 : new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST, Direction.UP}) {
            double d2;
            blockpos$mutable.set((Vec3i)blockpos).move(direction1);
            if (this.level.getBlockState((BlockPos)blockpos$mutable).isCollisionShapeFullBlock((BlockGetter)this.level, (BlockPos)blockpos$mutable)) continue;
            double d1 = Vector3d.get(direction1.getAxis());
            double d = d2 = direction1.getAxisDirection() == Direction.AxisDirection.POSITIVE ? 1.0 - d1 : d1;
            if (!(d2 < d0)) continue;
            d0 = d2;
            direction = direction1;
        }
        float f = this.random.nextFloat() * 0.05f + 0.025f;
        float f1 = direction.getAxisDirection().getStep();
        float secondary = (this.random.nextFloat() - this.random.nextFloat()) * 0.1f;
        float secondary2 = (this.random.nextFloat() - this.random.nextFloat()) * 0.1f;
        if (direction.getAxis() == Direction.Axis.X) {
            this.xd = f1 * f;
            this.yd = secondary;
            this.zd = secondary2;
        } else if (direction.getAxis() == Direction.Axis.Y) {
            this.xd = secondary;
            this.yd = f1 * f;
            this.zd = secondary2;
        } else if (direction.getAxis() == Direction.Axis.Z) {
            this.xd = secondary;
            this.yd = secondary2;
            this.zd = f1 * f;
        }
    }

    public static class Factory
    implements ParticleProvider<SparkleParticleData> {
        private final SpriteSet sprite;

        public Factory(SpriteSet sprite) {
            this.sprite = sprite;
        }

        public Particle createParticle(SparkleParticleData data, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new FXSparkle(level, x, y, z, data.size, data.r, data.g, data.b, data.m, data.fake, data.noClip, data.corrupt, this.sprite);
        }
    }
}

