/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.impl.common;

import info.u_team.u_team_core.api.registry.GameRuleRegister;
import info.u_team.u_team_core.api.registry.LazyEntry;
import info.u_team.u_team_core.util.CastUtil;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.world.level.GameRules;

public abstract class CommonGameRuleRegister
implements GameRuleRegister {
    protected final Map<GameRuleLazyEntry<?>, GameRuleData<?>> entries = new LinkedHashMap();

    protected CommonGameRuleRegister() {
    }

    @Override
    public <T extends GameRules.Value<T>> LazyEntry<GameRules.Key<T>> register(String name, GameRules.Category category, Supplier<? extends GameRules.Type<T>> type) {
        GameRuleLazyEntry entry = new GameRuleLazyEntry();
        this.entries.put(entry, new GameRuleData(name, category, type));
        return entry;
    }

    @Override
    public Collection<LazyEntry<GameRules.Key<?>>> getEntries() {
        return (Collection)CastUtil.uncheckedCast(this.entries.keySet());
    }

    protected void registerEntries() {
        for (Map.Entry<GameRuleLazyEntry<?>, GameRuleData<?>> entry : this.entries.entrySet()) {
            GameRuleLazyEntry<?> registryEntry = entry.getKey();
            GameRuleData<?> data = entry.getValue();
            GameRules.Key key = GameRules.register((String)data.name, (GameRules.Category)data.category, data.type.get());
            registryEntry.updateReference(key);
        }
    }

    public static class GameRuleLazyEntry<T extends GameRules.Value<T>>
    implements LazyEntry<GameRules.Key<T>> {
        private GameRules.Key<T> value;

        GameRuleLazyEntry() {
        }

        void updateReference(GameRules.Key<?> ruleKey) {
            this.value = (GameRules.Key)CastUtil.uncheckedCast(ruleKey);
        }

        @Override
        public GameRules.Key<T> get() {
            Objects.requireNonNull(this.value, () -> "Gamerule not present");
            return this.value;
        }

        @Override
        public boolean isPresent() {
            return this.value != null;
        }
    }

    protected record GameRuleData<T extends GameRules.Value<T>>(String name, GameRules.Category category, Supplier<? extends GameRules.Type<T>> type) {
    }
}

