/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.impl;

import info.u_team.u_team_core.api.event.ClientEvents;
import info.u_team.u_team_core.util.registry.BusRegister;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.RenderHighlightEvent;
import net.neoforged.neoforge.client.event.ScreenEvent;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;
import net.neoforged.neoforge.event.tick.LevelTickEvent;

public class NeoForgeClientEventsHandler
implements ClientEvents.Handler {
    @Override
    public void registerStartClientTick(ClientEvents.StartClientTick event) {
        this.registerNeoForgeEvent(ClientTickEvent.Pre.class, neoForgeEvent -> event.onStartTick(Minecraft.getInstance()));
    }

    @Override
    public void registerEndClientTick(ClientEvents.EndClientTick event) {
        this.registerNeoForgeEvent(ClientTickEvent.Post.class, neoForgeEvent -> event.onEndTick(Minecraft.getInstance()));
    }

    @Override
    public void registerStartClientLevelTick(ClientEvents.StartClientLevelTick event) {
        this.registerNeoForgeEvent(LevelTickEvent.Pre.class, neoForgeEvent -> {
            Level patt0$temp = neoForgeEvent.getLevel();
            if (patt0$temp instanceof ClientLevel) {
                ClientLevel clientLevel = (ClientLevel)patt0$temp;
                event.onStartTick(clientLevel);
            }
        });
    }

    @Override
    public void registerEndClientLevelTick(ClientEvents.EndClientLevelTick event) {
        this.registerNeoForgeEvent(LevelTickEvent.Post.class, neoForgeEvent -> {
            Level patt0$temp = neoForgeEvent.getLevel();
            if (patt0$temp instanceof ClientLevel) {
                ClientLevel clientLevel = (ClientLevel)patt0$temp;
                event.onEndTick(clientLevel);
            }
        });
    }

    @Override
    public void registerScreenAfterKeyPressed(ClientEvents.ScreenAfterKeyPressed event) {
        this.registerNeoForgeEvent(ScreenEvent.KeyPressed.Post.class, neoForgeEvent -> {
            if (event.onKeyPressed(neoForgeEvent.getScreen(), neoForgeEvent.getKeyCode(), neoForgeEvent.getScanCode(), neoForgeEvent.getModifiers())) {
                neoForgeEvent.setCanceled(true);
            }
        });
    }

    @Override
    public void registerItemTooltip(ClientEvents.ItemTooltip event) {
        this.registerNeoForgeEvent(ItemTooltipEvent.class, neoForgeEvent -> event.onTooltip(neoForgeEvent.getItemStack(), neoForgeEvent.getFlags(), neoForgeEvent.getToolTip()));
    }

    @Override
    public void registerRenderBlockOutline(ClientEvents.RenderBlockOutline event) {
        this.registerNeoForgeEvent(RenderHighlightEvent.Block.class, neoForgeEvent -> {
            if (!event.onRenderBlockOutline(neoForgeEvent.getLevelRenderer(), neoForgeEvent.getCamera(), neoForgeEvent.getTarget(), neoForgeEvent.getDeltaTracker(), neoForgeEvent.getPoseStack(), neoForgeEvent.getMultiBufferSource())) {
                neoForgeEvent.setCanceled(true);
            }
        });
    }

    private <T extends Event> void registerNeoForgeEvent(Class<T> eventClass, Consumer<T> event) {
        BusRegister.registerNeoForge(bus -> bus.addListener(EventPriority.NORMAL, false, eventClass, event));
    }
}

