/*
 * Decompiled with CFR 0.152.
 */
package pers.solid.brrp.v1.tag;

import java.util.Arrays;
import java.util.function.Function;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagBuilder;
import net.minecraft.tags.TagEntry;
import net.minecraft.tags.TagKey;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import pers.solid.brrp.v1.mixin.TagBuilderAccessor;
import pers.solid.brrp.v1.tag.IdentifiedTagBuilder;

public class ObjectTagBuilder<T, Self extends ObjectTagBuilder<T, Self>>
extends TagBuilder {
    public final Function<T, ResourceLocation> valueToId;

    protected ObjectTagBuilder(Function<T, ResourceLocation> valueToId) {
        this.valueToId = valueToId;
    }

    @Contract(value="_ -> new")
    public static <T> Impl<T> create(@NotNull Function<T, ResourceLocation> valueToId) {
        return new Impl<T>(valueToId);
    }

    @Contract(value="_ -> new")
    public static <T> Impl<T> create(@NotNull Registry<T> registry) {
        return ObjectTagBuilder.create(arg_0 -> registry.getKey(arg_0));
    }

    @Contract(value="-> this")
    protected Self self() {
        return (Self)((Object)this);
    }

    @Contract(mutates="this")
    public Self add(@NotNull TagEntry entry) {
        super.add(entry);
        return this.self();
    }

    @Contract(mutates="this")
    public Self add(@NotNull ResourceLocation id) {
        super.addElement(id);
        return this.self();
    }

    @Contract(mutates="this")
    public Self addOptional(@NotNull ResourceLocation id) {
        super.addOptionalElement(id);
        return this.self();
    }

    @Contract(mutates="this")
    public Self addTag(@NotNull ResourceLocation id) {
        super.addTag(id);
        return this.self();
    }

    @Contract(mutates="this")
    public Self addTag(@NotNull TagKey<T> tagKey) {
        return (Self)this.addTag(tagKey.location());
    }

    @SafeVarargs
    @Contract(mutates="this")
    public final Self addTag(TagKey<T> ... tagKeys) {
        for (TagKey<T> tagKey : tagKeys) {
            this.addTag(tagKey);
        }
        return this.self();
    }

    @Contract(mutates="this")
    public Self addTag(@NotNull IdentifiedTagBuilder<T> tagBuilder) {
        return (Self)this.addTag(tagBuilder.identifier);
    }

    @SafeVarargs
    @Contract(mutates="this")
    public final Self addTag(IdentifiedTagBuilder<T> ... tagBuilders) {
        for (IdentifiedTagBuilder<T> tagBuilder : tagBuilders) {
            this.addTag(tagBuilder);
        }
        return this.self();
    }

    @Contract(mutates="this")
    public Self addOptionalTag(@NotNull ResourceLocation id) {
        super.addOptionalTag(id);
        return this.self();
    }

    @Contract(mutates="this")
    public Self add(T value) {
        return this.add((T)this.valueToId.apply(value));
    }

    @SafeVarargs
    @Contract(mutates="this")
    public final Self add(T ... value) {
        Arrays.stream(value).map(this.valueToId).forEach(this::add);
        return this.self();
    }

    @Contract(mutates="this")
    public Self copy(TagBuilder copyFrom) {
        ((TagBuilderAccessor)copyFrom).getEntries().forEach(tagEntry -> this.add((TagEntry)tagEntry));
        return this.self();
    }

    public static final class Impl<T>
    extends ObjectTagBuilder<T, Impl<T>> {
        public Impl(Function<T, ResourceLocation> valueToId) {
            super(valueToId);
        }
    }
}

