/*
 * Decompiled with CFR 0.152.
 */
package pers.solid.brrp.v1.tag;

import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagBuilder;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import pers.solid.brrp.v1.mixin.TagBuilderAccessor;
import pers.solid.brrp.v1.tag.ObjectTagBuilder;

public class IdentifiedTagBuilder<T>
extends ObjectTagBuilder<T, IdentifiedTagBuilder<T>> {
    public final Registry<T> registry;
    public final ResourceLocation identifier;

    public IdentifiedTagBuilder(Registry<T> registry, ResourceLocation identifier) {
        super(arg_0 -> registry.getKey(arg_0));
        this.registry = registry;
        this.identifier = identifier;
    }

    public static IdentifiedTagBuilder<Block> createBlock(ResourceLocation identifier) {
        return new IdentifiedTagBuilder<Block>((Registry<Block>)BuiltInRegistries.BLOCK, identifier);
    }

    public static IdentifiedTagBuilder<Block> createBlock(TagKey<Block> blockTagKey) {
        return IdentifiedTagBuilder.createBlock(blockTagKey.location());
    }

    public static IdentifiedTagBuilder<Item> createItem(ResourceLocation identifier) {
        return new IdentifiedTagBuilder<Item>((Registry<Item>)BuiltInRegistries.ITEM, identifier);
    }

    public static IdentifiedTagBuilder<Item> createItem(TagKey<Item> itemTagKey) {
        return IdentifiedTagBuilder.createItem(itemTagKey.location());
    }

    public static IdentifiedTagBuilder<EntityType<?>> createEntityType(ResourceLocation identifier) {
        return new IdentifiedTagBuilder((Registry<EntityType<?>>)BuiltInRegistries.ENTITY_TYPE, identifier);
    }

    public static IdentifiedTagBuilder<EntityType<?>> createEntityType(TagKey<EntityType<?>> entityTypeTagKey) {
        return IdentifiedTagBuilder.createEntityType(entityTypeTagKey.location());
    }

    public static IdentifiedTagBuilder<Fluid> createFluid(ResourceLocation identifier) {
        return new IdentifiedTagBuilder<Fluid>((Registry<Fluid>)BuiltInRegistries.FLUID, identifier);
    }

    public static IdentifiedTagBuilder<Fluid> createFluid(TagKey<Fluid> fluidTagKey) {
        return IdentifiedTagBuilder.createFluid(fluidTagKey.location());
    }

    public static IdentifiedTagBuilder<Item> createItemCopy(TagKey<Item> itemTagKey, TagBuilder copyFrom) {
        IdentifiedTagBuilder<Item> identifiedTagBuilder = IdentifiedTagBuilder.createItem(itemTagKey);
        ((TagBuilderAccessor)copyFrom).getEntries().forEach(identifiedTagBuilder::add);
        return identifiedTagBuilder;
    }

    public static IdentifiedTagBuilder<Item> createItemCopy(IdentifiedTagBuilder<?> copyFrom) {
        IdentifiedTagBuilder<Item> identifiedTagBuilder = IdentifiedTagBuilder.createItem(copyFrom.identifier);
        ((TagBuilderAccessor)((Object)identifiedTagBuilder)).getEntries().addAll(((TagBuilderAccessor)((Object)copyFrom)).getEntries());
        return identifiedTagBuilder;
    }
}

