/*
 * Decompiled with CFR 0.152.
 */
package pers.solid.brrp.v1.recipe.mixin;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.Slice;
import pers.solid.brrp.v1.recipe.RecipeJsonBuilderExtension;
import pers.solid.brrp.v1.recipe.ShapedRecipeJsonBuilderExtension;

@Mixin(value={ShapedRecipeBuilder.class})
public abstract class ShapedRecipeJsonBuilderMixin
implements ShapedRecipeJsonBuilderExtension {
    @Unique
    private boolean bypassesValidation;
    @Unique
    @Nullable
    private String customRecipeCategory;
    @Unique
    @Nullable
    private DataComponentPatch componentChanges;
    @Unique
    private CraftingBookCategory customCraftingCategory;

    @Shadow
    public abstract ShapedRecipeBuilder pattern(String var1);

    @Unique
    private ShapedRecipeBuilder self() {
        return (ShapedRecipeBuilder)this;
    }

    @Override
    public ShapedRecipeBuilder patterns(String ... patterns) {
        for (String pattern : patterns) {
            this.pattern(pattern);
        }
        return this.self();
    }

    @Override
    public ShapedRecipeBuilder setBypassesValidation(boolean bypassesValidation) {
        this.bypassesValidation = bypassesValidation;
        return this.self();
    }

    @ModifyExpressionValue(method={"validate"}, at={@At(value="INVOKE", target="Ljava/util/Map;isEmpty()Z")})
    private boolean bypassValidation(boolean original) {
        return !this.bypassesValidation && original;
    }

    @Override
    public ShapedRecipeBuilder setCustomRecipeCategory(@Nullable String recipeCategory) {
        this.customRecipeCategory = recipeCategory;
        return this.self();
    }

    @WrapOperation(method={"offerTo"}, at={@At(value="INVOKE", target="Lnet/minecraft/recipe/book/RecipeCategory;getName()Ljava/lang/String;")})
    public String redirectGetName(RecipeCategory instance, Operation<String> original) {
        if (this.customRecipeCategory != null) {
            return this.customRecipeCategory;
        }
        return (String)original.call(new Object[]{instance});
    }

    @ModifyArg(method={"offerTo"}, at=@At(value="INVOKE", target="Lnet/minecraft/util/Identifier;withPrefixedPath(Ljava/lang/String;)Lnet/minecraft/util/Identifier;"), slice=@Slice(from=@At(value="INVOKE", target="Lnet/minecraft/recipe/book/RecipeCategory;getName()Ljava/lang/String;")))
    public String redundantSlash(String path) {
        if (this.customRecipeCategory != null && this.customRecipeCategory.isEmpty()) {
            return StringUtils.replaceOnce((String)path, (String)"recipes//", (String)"recipes/");
        }
        return path;
    }

    @Override
    public ShapedRecipeBuilder setCustomCraftingCategory(CraftingBookCategory customCraftingCategory) {
        this.customCraftingCategory = customCraftingCategory;
        return this.self();
    }

    @ModifyArg(method={"offerTo"}, at=@At(value="INVOKE", target="Lnet/minecraft/data/server/recipe/CraftingRecipeJsonBuilder;toCraftingCategory(Lnet/minecraft/recipe/book/RecipeCategory;)Lnet/minecraft/recipe/book/CraftingRecipeCategory;"))
    public RecipeCategory applyCustomCraftingCategory(RecipeCategory par1) {
        if (par1 == null && this.customCraftingCategory != null) {
            return RecipeJsonBuilderExtension.invertGetCraftingCategory(this.customCraftingCategory);
        }
        return par1;
    }

    @Override
    public ShapedRecipeBuilder setComponentChanges(DataComponentPatch componentChanges) {
        this.componentChanges = componentChanges;
        return this.self();
    }

    @ModifyExpressionValue(method={"offerTo"}, at={@At(value="NEW", target="(Lnet/minecraft/item/ItemConvertible;I)Lnet/minecraft/item/ItemStack;")})
    public ItemStack applyComponents(ItemStack itemStack) {
        if (this.componentChanges != null) {
            itemStack.applyComponentsAndValidate(this.componentChanges);
        }
        return itemStack;
    }
}

