/*
 * Decompiled with CFR 0.152.
 */
package pers.solid.brrp.v1.recipe;

import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pers.solid.brrp.v1.api.RuntimeResourcePack;

public interface RecipeJsonBuilderExtension<Self> {
    @Contract(value="_, _ -> this")
    @ApiStatus.Internal
    default public Self criterionMethodBridge(String criterionName, Criterion<?> criterion) {
        RuntimeResourcePack.LOGGER.warn("Calling unimplemented 'criterionMethodBridge' for {}. Silently ignored.", (Object)this);
        return (Self)this;
    }

    default public Self criterionFromItem(ItemLike item) {
        return this.criterionMethodBridge(RecipeProvider.getHasName((ItemLike)item), RecipeProvider.has((ItemLike)item));
    }

    default public Self criterionFromItem(String criterionName, ItemLike item) {
        return this.criterionMethodBridge(criterionName, RecipeProvider.has((ItemLike)item));
    }

    default public Self criterionFromItem(String criterionName, MinMaxBounds.Ints count, ItemLike item) {
        return this.criterionMethodBridge(criterionName, RecipeProvider.has((MinMaxBounds.Ints)count, (ItemLike)item));
    }

    default public Self criterionFromItemPredicates(String criterionName, ItemPredicate ... predicates) {
        return this.criterionMethodBridge(criterionName, RecipeProvider.inventoryTrigger((ItemPredicate[])predicates));
    }

    default public Self criterionFromItemTag(String criterionName, TagKey<Item> itemTag) {
        return this.criterionMethodBridge(criterionName, RecipeProvider.has(itemTag));
    }

    default public Self setCustomRecipeCategory(@Nullable String recipeCategory) {
        return (Self)this;
    }

    default public Self setCustomCraftingCategory(@Nullable CraftingBookCategory customCraftingCategory) {
        return (Self)this;
    }

    default public Self setBypassesValidation(boolean bypassesValidation) {
        return (Self)this;
    }

    default public Self setComponentChanges(DataComponentPatch componentChanges) {
        return (Self)this;
    }

    @NotNull
    public static RecipeCategory invertGetCraftingCategory(@NotNull CraftingBookCategory craftingRecipeCategory) {
        return switch (craftingRecipeCategory) {
            case CraftingBookCategory.BUILDING -> RecipeCategory.BUILDING_BLOCKS;
            case CraftingBookCategory.EQUIPMENT -> RecipeCategory.TOOLS;
            case CraftingBookCategory.REDSTONE -> RecipeCategory.REDSTONE;
            default -> RecipeCategory.MISC;
        };
    }
}

