/*
 * Decompiled with CFR 0.152.
 */
package pers.solid.brrp.v1.model;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.renderer.block.model.ItemTransform;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;
import pers.solid.brrp.v1.annotations.PreferredEnvironment;

@PreferredEnvironment(value=EnvType.CLIENT)
public class TransformationBuilder {
    public static final Vector3f EMPTY_VECTOR = new Vector3f(0.0f, 0.0f, 0.0f);
    public static final Vector3f UNIT_VECTOR = new Vector3f(1.0f, 1.0f, 1.0f);
    @NotNull
    public Vector3f rotation;
    @NotNull
    public Vector3f translation;
    @NotNull
    public Vector3f scale;

    public TransformationBuilder(@NotNull Vector3f rotation, @NotNull Vector3f translation, @NotNull Vector3f scale) {
        this.rotation = rotation;
        this.translation = translation;
        this.scale = scale;
    }

    public TransformationBuilder() {
        this(EMPTY_VECTOR, EMPTY_VECTOR, UNIT_VECTOR);
    }

    @Contract(value="_, _, _ -> this", mutates="this")
    public TransformationBuilder rotation(float x, float y, float z) {
        return this.rotation(new Vector3f(x, y, z));
    }

    @Contract(value="_ -> this", mutates="this")
    public TransformationBuilder rotation(Vector3f rotation) {
        this.rotation = rotation;
        return this;
    }

    @Contract(value="_, _, _ -> this", mutates="this")
    public TransformationBuilder translation(float x, float y, float z) {
        return this.translation(new Vector3f(x, y, z));
    }

    @Contract(value="_ -> this", mutates="this")
    public TransformationBuilder translation(Vector3f translation) {
        this.translation = translation;
        return this;
    }

    @Contract(value="_, _, _ -> this", mutates="this")
    public TransformationBuilder scale(float x, float y, float z) {
        return this.scale(new Vector3f(x, y, z));
    }

    @Contract(value="_ -> this", mutates="this")
    public TransformationBuilder scale(Vector3f scale) {
        this.scale = scale;
        return this;
    }

    @Environment(value=EnvType.CLIENT)
    public ItemTransform asVanillaTransformation() {
        return new ItemTransform(this.rotation, this.translation, this.scale);
    }
}

