/*
 * Decompiled with CFR 0.152.
 */
package pers.solid.brrp.v1.model;

import java.util.HashMap;
import net.fabricmc.api.EnvType;
import net.minecraft.data.models.model.ModelTemplate;
import net.minecraft.data.models.model.TextureSlot;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import pers.solid.brrp.v1.annotations.PreferredEnvironment;
import pers.solid.brrp.v1.api.RuntimeResourcePack;
import pers.solid.brrp.v1.generator.BlockResourceGenerator;
import pers.solid.brrp.v1.mixin.ModelAccessor;
import pers.solid.brrp.v1.model.ModelJsonBuilder;

@PreferredEnvironment(value=EnvType.CLIENT)
public final class ModelUtils {
    private ModelUtils() {
    }

    @Contract(pure=true)
    public static ResourceLocation getId(@NotNull ModelTemplate model) {
        return ((ModelAccessor)model).getParent().orElse(null);
    }

    @Contract(pure=true)
    @NotNull
    public static ResourceLocation appendVariant(@NotNull ResourceLocation modelId, @NotNull ModelTemplate model) {
        return ((ModelAccessor)model).getVariant().map(arg_0 -> modelId.brrp_suffixed(arg_0)).orElse(modelId);
    }

    @Contract(pure=true, value="_, _ -> new")
    public static HashMap<String, String> getTextureMap(BlockResourceGenerator blockResourceGenerator, TextureSlot ... textureKeys) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (TextureSlot textureKey : textureKeys) {
            map.put(textureKey.getId(), blockResourceGenerator.getTextureId(textureKey).toString());
        }
        return map;
    }

    @Contract(mutates="param1")
    public static void writeModelsWithVariants(@NotNull RuntimeResourcePack pack, @NotNull ResourceLocation modelId, @NotNull ModelJsonBuilder model, ModelTemplate parent) {
        pack.addModel(ModelUtils.appendVariant(modelId, parent), model.withParent(parent));
    }

    @Contract(mutates="param1")
    public static void writeModelsWithVariants(@NotNull RuntimeResourcePack pack, @NotNull ResourceLocation modelId, @NotNull ModelJsonBuilder model, ModelTemplate ... parents) {
        for (ModelTemplate parent : parents) {
            ModelUtils.writeModelsWithVariants(pack, modelId, model, parent);
        }
    }

    @NotNull
    @Contract(value="_, _ -> new", pure=true)
    public static ModelJsonBuilder createModelWithVariants(BlockResourceGenerator blockResourceGenerator, ModelTemplate parent) {
        ModelJsonBuilder model = ModelJsonBuilder.create(parent);
        for (TextureSlot textureKey : ((ModelAccessor)parent).getRequiredTextures()) {
            model.addTexture(textureKey, blockResourceGenerator.getTextureId(textureKey));
        }
        return model;
    }
}

