/*
 * Decompiled with CFR 0.152.
 */
package pers.solid.brrp.v1.model;

import com.google.gson.annotations.SerializedName;
import it.unimi.dsi.fastutil.objects.Object2FloatLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2FloatMap;
import it.unimi.dsi.fastutil.objects.Object2FloatOpenHashMap;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.renderer.block.model.ItemOverride;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import pers.solid.brrp.v1.annotations.PreferredEnvironment;

@PreferredEnvironment(value=EnvType.CLIENT)
public class ModelOverrideBuilder
implements Cloneable {
    @SerializedName(value="model")
    public final ResourceLocation modelId;
    @SerializedName(value="predicate")
    public Object2FloatMap<ResourceLocation> conditions;

    public ModelOverrideBuilder(ResourceLocation modelId) {
        this.modelId = modelId;
    }

    public ModelOverrideBuilder(String namespace, String value) {
        this(ResourceLocation.fromNamespaceAndPath((String)namespace, (String)value));
    }

    public ModelOverrideBuilder(String modelId) {
        this(ResourceLocation.parse((String)modelId));
    }

    @Contract(pure=true)
    public static ModelOverrideBuilder of(ResourceLocation modelId, Object2FloatMap<ResourceLocation> conditions) {
        ModelOverrideBuilder builder = new ModelOverrideBuilder(modelId);
        builder.conditions = conditions;
        return builder;
    }

    @Contract(pure=true)
    public static ModelOverrideBuilder of(ResourceLocation modelId, ResourceLocation type, float threshold) {
        return new ModelOverrideBuilder(modelId).addCondition(type, threshold);
    }

    @Contract(value="_ -> this", mutates="this")
    public ModelOverrideBuilder setConditions(Object2FloatMap<ResourceLocation> conditions) {
        this.conditions = conditions;
        return this;
    }

    @Contract(value="_, _ -> this", mutates="this")
    public ModelOverrideBuilder addCondition(@NotNull ResourceLocation type, float threshold) {
        if (this.conditions == null) {
            this.conditions = new Object2FloatLinkedOpenHashMap();
        }
        this.conditions.put((Object)type, threshold);
        return this;
    }

    @Contract(value="_, _, _ -> this", mutates="this")
    public ModelOverrideBuilder addCondition(String namespace, String value, float threshold) {
        return this.addCondition(ResourceLocation.fromNamespaceAndPath((String)namespace, (String)value), threshold);
    }

    @Contract(value="_, _ -> this", mutates="this")
    public ModelOverrideBuilder addCondition(String identifier, float threshold) {
        return this.addCondition(ResourceLocation.parse((String)identifier), threshold);
    }

    @Environment(value=EnvType.CLIENT)
    @Contract(pure=true)
    public ItemOverride asModelOverride() {
        return new ItemOverride(this.modelId, this.conditions.object2FloatEntrySet().stream().map(entry -> new ItemOverride.Predicate((ResourceLocation)entry.getKey(), entry.getFloatValue())).toList());
    }

    public ModelOverrideBuilder clone() {
        try {
            ModelOverrideBuilder clone = (ModelOverrideBuilder)super.clone();
            clone.conditions = new Object2FloatOpenHashMap(this.conditions);
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError();
        }
    }
}

