/*
 * Decompiled with CFR 0.152.
 */
package pers.solid.brrp.v1.model;

import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.data.models.model.ModelTemplate;
import net.minecraft.data.models.model.TextureMapping;
import net.minecraft.data.models.model.TextureSlot;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.ItemDisplayContext;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pers.solid.brrp.v1.mixin.TextureMapAccessor;
import pers.solid.brrp.v1.model.ModelElementBuilder;
import pers.solid.brrp.v1.model.ModelOverrideBuilder;
import pers.solid.brrp.v1.model.ModelUtils;
import pers.solid.brrp.v1.model.TransformationBuilder;

public class ModelJsonBuilder
implements Cloneable {
    public List<ModelElementBuilder> elements;
    @SerializedName(value="gui_light")
    public GuiLight guiLight;
    @SerializedName(value="ambientocclusion")
    public Boolean ambientOcclusion;
    @SerializedName(value="display")
    public Map<ItemDisplayContext, TransformationBuilder> transformations;
    public List<ModelOverrideBuilder> overrides;
    public Map<String, String> textures;
    @SerializedName(value="parent")
    public ResourceLocation parentId;

    @NotNull
    @Contract(pure=true, value="_ -> new")
    public static ModelJsonBuilder create(ResourceLocation parentId) {
        ModelJsonBuilder modelJsonBuilder = new ModelJsonBuilder();
        modelJsonBuilder.parentId = parentId;
        return modelJsonBuilder;
    }

    @NotNull
    @Contract(pure=true, value="_ -> new")
    public static ModelJsonBuilder create(String parentId) {
        return ModelJsonBuilder.create(ResourceLocation.parse((String)parentId));
    }

    @NotNull
    @Contract(pure=true, value="_ -> new")
    public static ModelJsonBuilder create(ModelTemplate parentModel) {
        return ModelJsonBuilder.create(ModelUtils.getId(parentModel));
    }

    @NotNull
    @Contract(pure=true, value="_, _ -> new")
    public static ModelJsonBuilder create(String namespace, String path) {
        return ModelJsonBuilder.create(ResourceLocation.fromNamespaceAndPath((String)namespace, (String)path));
    }

    @Contract(mutates="this", value="_ -> this")
    public ModelJsonBuilder setOverrides(List<ModelOverrideBuilder> overrides) {
        this.overrides = overrides;
        return this;
    }

    @Contract(mutates="this", value="_ -> this")
    public ModelJsonBuilder addOverride(ModelOverrideBuilder override) {
        if (this.overrides == null) {
            this.overrides = new ArrayList<ModelOverrideBuilder>();
        }
        this.overrides.add(override);
        return this;
    }

    @Contract(mutates="this", value="_ -> this")
    public ModelJsonBuilder setElements(List<ModelElementBuilder> elements) {
        this.elements = elements;
        return this;
    }

    @Contract(mutates="this", value="_ -> this")
    public ModelJsonBuilder addElement(ModelElementBuilder element) {
        if (this.elements == null) {
            this.elements = new ArrayList<ModelElementBuilder>();
        }
        this.elements.add(element);
        return this;
    }

    @Contract(mutates="this", value="_ -> this")
    public ModelJsonBuilder guiLight(GuiLight guiLight) {
        this.guiLight = guiLight;
        return this;
    }

    @Contract(mutates="this", value="_ -> this")
    public ModelJsonBuilder ambientOcclusion(Boolean ambientOcclusion) {
        this.ambientOcclusion = ambientOcclusion;
        return this;
    }

    @Contract(mutates="this", value="_, _ -> this")
    public ModelJsonBuilder transformation(ItemDisplayContext modelTransformationMode, TransformationBuilder transformation) {
        if (this.transformations == null) {
            this.transformations = new LinkedHashMap<ItemDisplayContext, TransformationBuilder>();
        }
        this.transformations.put(modelTransformationMode, transformation);
        return this;
    }

    @Contract(mutates="this", value="_-> this")
    public ModelJsonBuilder transformations(Map<ItemDisplayContext, TransformationBuilder> transformations) {
        this.transformations = transformations;
        return this;
    }

    @Contract(mutates="this", value="_, _ -> this")
    public ModelJsonBuilder addTexture(@NotNull TextureSlot textureKey, @Nullable ResourceLocation textureLocation) {
        return this.addTexture(textureKey.getId(), textureLocation);
    }

    @Contract(mutates="this", value="_, _ -> this")
    public ModelJsonBuilder addTexture(@NotNull TextureSlot textureKey, @Nullable String textureReference) {
        return this.addTexture(textureKey.getId(), textureReference);
    }

    @Contract(mutates="this", value="_, _ -> this")
    public ModelJsonBuilder addTexture(@NotNull String key, @Nullable ResourceLocation textureLocation) {
        return this.addTexture(key, textureLocation == null ? null : textureLocation.toString());
    }

    @Contract(mutates="this", value="_, _ -> this")
    public ModelJsonBuilder addTexture(@NotNull String key, @Nullable String textureReference) {
        if (this.textures == null) {
            this.textures = new LinkedHashMap<String, String>();
        }
        this.textures.put(key, textureReference);
        return this;
    }

    @Contract(mutates="this", value="_ -> this")
    public ModelJsonBuilder setTextures(TextureMapping textures) {
        ((TextureMapAccessor)textures).getEntries().forEach(this::addTexture);
        return this;
    }

    @Contract(mutates="this", value="_ -> this")
    public ModelJsonBuilder setTextures(Map<String, String> textures) {
        this.textures = textures;
        return this;
    }

    @Contract(mutates="this", value="_ -> this")
    public ModelJsonBuilder parent(ModelTemplate model) {
        return this.parent(ModelUtils.getId(model));
    }

    @Contract(mutates="this", value="_ -> this")
    public ModelJsonBuilder parent(ResourceLocation parentId) {
        this.parentId = parentId;
        return this;
    }

    @Contract(mutates="this", value="_ -> this")
    public ModelJsonBuilder parent(String parentId) {
        return this.parent(ResourceLocation.parse((String)parentId));
    }

    @Contract(mutates="this", value="_, _ -> this")
    public ModelJsonBuilder parent(String namespace, String path) {
        return this.parent(ResourceLocation.fromNamespaceAndPath((String)namespace, (String)path));
    }

    @Contract(pure=true)
    public ModelJsonBuilder withParent(ModelTemplate model) {
        return this.withParent(ModelUtils.getId(model));
    }

    @Contract(pure=true)
    public ModelJsonBuilder withParent(String namespace, String path) {
        return this.withParent(ResourceLocation.fromNamespaceAndPath((String)namespace, (String)path));
    }

    @Contract(pure=true)
    public ModelJsonBuilder withParent(ResourceLocation parentId) {
        if (Objects.equals(this.parentId, parentId)) {
            return this;
        }
        return this.clone().parent(parentId);
    }

    @Contract(pure=true)
    public ModelJsonBuilder withParent(String parentId) {
        return this.withParent(ResourceLocation.parse((String)parentId));
    }

    public ModelJsonBuilder clone() {
        try {
            ModelJsonBuilder clone = (ModelJsonBuilder)super.clone();
            if (clone.elements != null) {
                clone.elements = new ArrayList<ModelElementBuilder>(this.elements);
            }
            if (clone.overrides != null) {
                clone.overrides = new ArrayList<ModelOverrideBuilder>(this.overrides);
            }
            if (clone.transformations != null) {
                clone.transformations = new HashMap<ItemDisplayContext, TransformationBuilder>(this.transformations);
            }
            if (clone.textures != null) {
                clone.textures = new HashMap<String, String>(this.textures);
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError();
        }
    }

    public static enum GuiLight implements StringRepresentable
    {
        FRONT("front"),
        SIDE("side");

        private final String name;

        private GuiLight(String name) {
            this.name = name;
        }

        @Environment(value=EnvType.CLIENT)
        public BlockModel.GuiLight asVanillaGuiLight() {
            return this == FRONT ? BlockModel.GuiLight.FRONT : BlockModel.GuiLight.SIDE;
        }

        public String getSerializedName() {
            return this.name;
        }
    }
}

