/*
 * Decompiled with CFR 0.152.
 */
package pers.solid.brrp.v1.model;

import com.google.common.base.Preconditions;
import com.google.gson.annotations.SerializedName;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.renderer.block.model.BlockElementFace;
import net.minecraft.client.renderer.block.model.BlockFaceUV;
import net.minecraft.core.Direction;
import org.jetbrains.annotations.Nullable;

public class ModelElementFaceBuilder
implements Cloneable {
    @SerializedName(value="uv")
    public float @Nullable [] uvs;
    public int rotation;
    @SerializedName(value="cullface")
    public Direction cullFace;
    public int tintIndex;
    @SerializedName(value="texture")
    public String textureId;

    public ModelElementFaceBuilder uv(float x1, float y1, float x2, float y2) {
        this.uvs = new float[]{x1, y1, x2, y1};
        return this;
    }

    public ModelElementFaceBuilder uv(float[] uvs) {
        if (uvs != null) {
            Preconditions.checkArgument((uvs.length == 4 ? 1 : 0) != 0, (String)"Parameter uv must be an 4-element array, instead of %s!", (int)uvs.length);
        }
        this.uvs = uvs;
        return this;
    }

    public ModelElementFaceBuilder rotation(int rotation) {
        this.rotation = rotation;
        return this;
    }

    public ModelElementFaceBuilder cullFace(Direction cullFace) {
        this.cullFace = cullFace;
        return this;
    }

    public ModelElementFaceBuilder tintIndex(int tintIndex) {
        this.tintIndex = tintIndex;
        return this;
    }

    public ModelElementFaceBuilder texture(String textureId) {
        this.textureId = textureId;
        return this;
    }

    @Environment(value=EnvType.CLIENT)
    public BlockElementFace toModelElementFace() {
        return new BlockElementFace(this.cullFace, this.tintIndex, this.textureId, new BlockFaceUV(this.uvs, this.rotation));
    }

    public ModelElementFaceBuilder clone() {
        try {
            return (ModelElementFaceBuilder)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError();
        }
    }
}

