/*
 * Decompiled with CFR 0.152.
 */
package pers.solid.brrp.v1.mixin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.function.Consumer;
import net.minecraft.SharedConstants;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackSelectionConfig;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.FolderRepositorySource;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackCompatibility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import pers.solid.brrp.v1.PlatformBridge;
import pers.solid.brrp.v1.api.RuntimeResourcePack;

@Mixin(value={FolderRepositorySource.class})
public class FileResourcePackProviderMixin {
    @Unique
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"FileResourcePackProviderMixin");
    @Shadow
    @Final
    private PackType packType;

    @Inject(method={"register"}, at={@At(value="HEAD")})
    public void register(Consumer<Pack> adder, CallbackInfo ci) {
        ArrayList<PackResources> list = new ArrayList<PackResources>();
        LOGGER.info("BRRP register - before user");
        PlatformBridge.getInstance().postBeforeUser(this.packType, list);
        for (final PackResources pack : list) {
            RuntimeResourcePack runtimeResourcePack;
            Pack.Metadata metadata = Pack.readPackMetadata((PackLocationInfo)pack.location(), (Pack.ResourcesSupplier)new Pack.ResourcesSupplier(){

                public PackResources openPrimary(PackLocationInfo info) {
                    return pack;
                }

                public PackResources openFull(PackLocationInfo info, Pack.Metadata metadata) {
                    return pack;
                }
            }, (int)SharedConstants.getCurrentVersion().getPackVersion(PackType.CLIENT_RESOURCES));
            if (metadata == null) continue;
            adder.accept(new Pack(pack.location(), new Pack.ResourcesSupplier(){

                public PackResources openPrimary(PackLocationInfo info) {
                    return pack;
                }

                public PackResources openFull(PackLocationInfo info, Pack.Metadata metadata) {
                    return pack;
                }
            }, new Pack.Metadata(pack instanceof RuntimeResourcePack && (runtimeResourcePack = (RuntimeResourcePack)pack).getDescription() != null ? runtimeResourcePack.getDescription() : metadata.description(), PackCompatibility.COMPATIBLE, metadata.requestedFeatures(), Collections.emptyList()), new PackSelectionConfig(false, Pack.Position.TOP, false)));
        }
    }
}

