/*
 * Decompiled with CFR 0.152.
 */
package pers.solid.brrp.v1.impl;

import com.google.common.base.Suppliers;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.IntUnaryOperator;
import java.util.function.Supplier;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.imageio.ImageIO;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.advancements.Advancement;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.AbstractPackResources;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.resources.IoSupplier;
import net.minecraft.tags.TagBuilder;
import net.minecraft.tags.TagFile;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.storage.loot.LootTable;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.input.CountingInputStream;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.lang3.function.FailableFunction;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pers.solid.brrp.v1.JsonSerializers;
import pers.solid.brrp.v1.api.RuntimeResourcePack;
import pers.solid.brrp.v1.impl.AbstractRuntimeResourcePack;
import pers.solid.brrp.v1.impl.BRRPBlockLootTableGenerator;
import pers.solid.brrp.v1.mixin.BuiltinRegistriesAccessor;
import pers.solid.brrp.v1.mixin.RegistryBuilderAccessor;

@ApiStatus.Internal
public class RuntimeResourcePackImpl
extends AbstractRuntimeResourcePack
implements PackResources {
    public static final ExecutorService EXECUTOR_SERVICE = Executors.newFixedThreadPool(10, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("BRRP-Workers-%s").build());
    private final Map<ResourceLocation, Supplier<byte[]>> data = new ConcurrentHashMap<ResourceLocation, Supplier<byte[]>>();
    private final Map<ResourceLocation, Supplier<byte[]>> assets = new ConcurrentHashMap<ResourceLocation, Supplier<byte[]>>();
    private final Map<List<String>, Supplier<byte[]>> root = new ConcurrentHashMap<List<String>, Supplier<byte[]>>();
    private final HolderLookup.Provider registryLookup;
    private final Gson gson;
    public final BlockLootSubProvider blockLootTableGenerator;
    private static final PackSource RUNTIME = PackSource.create(name -> Component.translatable((String)"pack.nameAndSource", (Object[])new Object[]{name, Component.translatable((String)"pack.source.runtime")}).withStyle(ChatFormatting.GRAY), (boolean)true);

    private static Gson createGson(HolderLookup.Provider registryLookup) {
        return GSON.newBuilder().registerTypeHierarchyAdapter(LootTable.class, JsonSerializers.forCodec(LootTable.DIRECT_CODEC, registryLookup)).registerTypeHierarchyAdapter(Advancement.class, JsonSerializers.forCodec(Advancement.CODEC, registryLookup)).registerTypeHierarchyAdapter(TagFile.class, JsonSerializers.forCodec(TagFile.CODEC, registryLookup)).registerTypeHierarchyAdapter(Recipe.class, JsonSerializers.forCodec(Recipe.CODEC, registryLookup)).create();
    }

    public RuntimeResourcePackImpl(ResourceLocation id, @NotNull HolderLookup.Provider registryLookup) {
        super(id);
        this.registryLookup = registryLookup;
        this.gson = RuntimeResourcePackImpl.createGson(registryLookup);
        this.blockLootTableGenerator = new BRRPBlockLootTableGenerator(registryLookup);
    }

    public RuntimeResourcePackImpl(ResourceLocation id) {
        super(id);
        this.registryLookup = Holder.registryLookup;
        this.gson = Holder.gson;
        this.blockLootTableGenerator = Holder.blockLootTableGenerator;
    }

    @Override
    public byte[] serialize(Object object) {
        return RuntimeResourcePack.serialize(object, this.gson);
    }

    private static ResourceLocation fix(ResourceLocation identifier, String prefix, String append) {
        return ResourceLocation.fromNamespaceAndPath((String)identifier.getNamespace(), (String)(prefix + "/" + identifier.getPath() + "." + append));
    }

    @Override
    public void addRecoloredImage(ResourceLocation identifier, InputStream target, IntUnaryOperator operator) {
        this.addLazyResource(PackType.CLIENT_RESOURCES, RuntimeResourcePackImpl.fix(identifier, "textures", "png"), (i, r) -> {
            try {
                CountingInputStream is = new CountingInputStream(target);
                BufferedImage base = ImageIO.read((InputStream)is);
                BufferedImage recolored = new BufferedImage(base.getWidth(), base.getHeight(), 2);
                for (int y = 0; y < base.getHeight(); ++y) {
                    for (int x = 0; x < base.getWidth(); ++x) {
                        recolored.setRGB(x, y, operator.applyAsInt(base.getRGB(x, y)));
                    }
                }
                ByteArrayOutputStream stream = new ByteArrayOutputStream(is.getCount());
                ImageIO.write((RenderedImage)recolored, "png", (OutputStream)stream);
                return stream.toByteArray();
            }
            catch (Throwable e) {
                LOGGER.error("Failed to add resources:", e);
                throw new RuntimeException(e);
            }
        });
    }

    @Override
    public byte[] addLang(ResourceLocation identifier, byte[] serializedData) {
        return this.addAsset(RuntimeResourcePackImpl.fix(identifier, "lang", "json"), serializedData);
    }

    @Override
    public byte[] addLootTable(ResourceLocation identifier, byte[] serializedData) {
        return this.addData(RuntimeResourcePackImpl.fix(identifier, "loot_table", "json"), serializedData);
    }

    @Override
    public Future<byte[]> addAsyncResource(PackType type, ResourceLocation path, FailableFunction<ResourceLocation, byte[], Exception> data) {
        Future<byte[]> future = EXECUTOR_SERVICE.submit(() -> (byte[])data.apply((Object)path));
        Map<ResourceLocation, Supplier<byte[]>> sys = this.getSys(type);
        if (!this.allowsDuplicateResource && sys.containsKey(path)) {
            throw new IllegalArgumentException(String.format("Duplicate resource id %s in runtime resource pack %s.", path, this.getDisplayName().getString()));
        }
        sys.put(path, () -> {
            try {
                return (byte[])future.get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
        });
        return future;
    }

    @Override
    public void addLazyResource(PackType type, ResourceLocation path, BiFunction<RuntimeResourcePack, ResourceLocation, byte[]> func) {
        Map<ResourceLocation, Supplier<byte[]>> sys = this.getSys(type);
        if (!this.allowsDuplicateResource && sys.containsKey(path)) {
            throw new IllegalArgumentException(String.format("Duplicate resource id %s in runtime resource pack %s.", path, this.getDisplayName().getString()));
        }
        sys.put(path, (Supplier<byte[]>)Suppliers.memoize(() -> (byte[])func.apply(this, path)));
    }

    @Override
    public byte[] addResource(PackType type, ResourceLocation path, byte[] data) {
        Map<ResourceLocation, Supplier<byte[]>> sys = this.getSys(type);
        if (!this.allowsDuplicateResource && sys.containsKey(path)) {
            throw new IllegalArgumentException(String.format("Duplicate resource id %s in runtime resource pack %s.", path, this.getDisplayName().getString()));
        }
        sys.put(path, (Supplier<byte[]>)Suppliers.ofInstance((Object)data));
        return data;
    }

    @Override
    public Future<byte[]> addAsyncRootResource(String path, FailableFunction<String, byte[], Exception> data) {
        if (!this.allowsDuplicateResource && this.root.containsKey(Arrays.asList(path.split("/")))) {
            throw new IllegalArgumentException(String.format("Duplicate root resource id %s in runtime resource pack %s!", path, this.getDisplayName().getString()));
        }
        Future<byte[]> future = EXECUTOR_SERVICE.submit(() -> (byte[])data.apply((Object)path));
        this.root.put(Arrays.asList(path.split("/")), () -> {
            try {
                return (byte[])future.get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
        });
        return future;
    }

    @Override
    public void addLazyRootResource(String path, BiFunction<RuntimeResourcePack, String, byte[]> data) {
        if (!this.allowsDuplicateResource && this.root.containsKey(Arrays.asList(path.split("/")))) {
            throw new IllegalArgumentException(String.format("Duplicate root resource id %s in runtime resource pack %s!", path, this.getDisplayName().getString()));
        }
        this.root.put(Arrays.asList(path.split("/")), (Supplier<byte[]>)Suppliers.memoize(() -> (byte[])data.apply(this, path)));
    }

    @Override
    public byte[] addRootResource(String path, byte[] data) {
        if (!this.allowsDuplicateResource && this.root.containsKey(Arrays.asList(path.split("/")))) {
            throw new IllegalArgumentException(String.format("Duplicate root resource id %s in runtime resource pack %s!", path, this.getDisplayName().getString()));
        }
        this.root.put(Arrays.asList(path.split("/")), () -> data);
        return data;
    }

    @Override
    public byte[] addAsset(ResourceLocation id, byte[] data) {
        if (!this.allowsDuplicateResource && this.assets.containsKey(id)) {
            throw new IllegalArgumentException(String.format("Duplicate asset id %s in runtime resource pack %s!", id, this.getDisplayName().getString()));
        }
        this.assets.put(id, (Supplier<byte[]>)Suppliers.ofInstance((Object)data));
        return data;
    }

    @Override
    public byte[] addData(ResourceLocation id, byte[] data) {
        if (!this.allowsDuplicateResource && this.data.containsKey(id)) {
            throw new IllegalArgumentException(String.format("Duplicate data id %s in runtime resource pack %s!", id, this.getDisplayName().getString()));
        }
        this.data.put(id, (Supplier<byte[]>)Suppliers.ofInstance((Object)data));
        return data;
    }

    @Override
    public byte[] addBlockState(ResourceLocation id, byte[] serializedData) {
        return this.addAsset(RuntimeResourcePackImpl.fix(id, "blockstates", "json"), serializedData);
    }

    @Override
    public byte[] addModel(ResourceLocation id, byte[] serializedData) {
        return this.addAsset(RuntimeResourcePackImpl.fix(id, "models", "json"), serializedData);
    }

    @Override
    public byte[] addTexture(ResourceLocation id, BufferedImage image) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)image, "png", (OutputStream)stream);
        }
        catch (IOException e) {
            throw new RuntimeException("impossible.", e);
        }
        return this.addAsset(RuntimeResourcePackImpl.fix(id, "textures", "png"), stream.toByteArray());
    }

    @Override
    public byte[] addTag(ResourceLocation fullId, byte[] serializedData) {
        return this.addData(RuntimeResourcePackImpl.fix(fullId, "tags", "json"), serializedData);
    }

    @Override
    public <T> byte[] addTag(TagKey<T> tagKey, TagBuilder tagBuilder) {
        return this.addData(ResourceLocation.fromNamespaceAndPath((String)tagKey.location().getNamespace(), (String)(Registries.tagsDirPath((ResourceKey)tagKey.registry()) + "/" + tagKey.location().getPath() + ".json")), this.serialize(new TagFile(tagBuilder.build(), false)));
    }

    @Override
    public byte[] addAnimation(ResourceLocation id, byte[] serializedData) {
        return this.addAsset(RuntimeResourcePackImpl.fix(id, "textures", "png.mcmeta"), serializedData);
    }

    @Override
    public byte[] addRecipe(ResourceLocation id, byte[] serializedData) {
        return this.addData(RuntimeResourcePackImpl.fix(id, "recipe", "json"), serializedData);
    }

    @Override
    public byte[] addAdvancement(ResourceLocation id, byte[] serializedData) {
        return this.addData(RuntimeResourcePackImpl.fix(id, "advancement", "json"), serializedData);
    }

    @Override
    public Future<?> async(Consumer<RuntimeResourcePack> action) {
        return EXECUTOR_SERVICE.submit(() -> action.accept(this));
    }

    @Override
    public void dumpInPath(Path output, @Nullable PackType dumpResourceType, int @Nullable [] stat) {
        LOGGER.info("Dumping {} in the path {}. The path will be cleared.", (Object)this.getDisplayName().getString(), (Object)output);
        try {
            if (stat != null) {
                stat[0] = -1;
            }
            if (output.toFile().exists()) {
                FileUtils.cleanDirectory((File)output.toFile());
            } else {
                Files.createDirectories(output, new FileAttribute[0]);
            }
            if (stat != null) {
                stat[2] = 0;
                stat[1] = 0;
                stat[0] = 0;
            }
            if (!this.root.isEmpty()) {
                for (Map.Entry<List<String>, Supplier<byte[]>> e : this.root.entrySet()) {
                    Path root = output.resolve(String.join((CharSequence)"/", (Iterable<? extends CharSequence>)e.getKey()));
                    Files.createDirectories(root.getParent(), new FileAttribute[0]);
                    Files.write(root, e.getValue().get(), new OpenOption[0]);
                    if (stat != null) {
                        stat[0] = stat[0] + 1;
                    }
                    if (!Thread.interrupted()) continue;
                    throw new InterruptedException("Dumping root resources");
                }
            }
            if (dumpResourceType != PackType.SERVER_DATA && !this.assets.isEmpty()) {
                Path assets = output.resolve("assets");
                Files.createDirectories(assets, new FileAttribute[0]);
                for (Map.Entry<ResourceLocation, Supplier<byte[]>> entry : this.assets.entrySet()) {
                    this.write(assets, entry.getKey(), entry.getValue().get());
                    if (stat != null) {
                        stat[1] = stat[1] + 1;
                    }
                    if (!Thread.interrupted()) continue;
                    throw new InterruptedException("Dumping server data");
                }
            }
            if (dumpResourceType != PackType.CLIENT_RESOURCES && !this.data.isEmpty()) {
                Path data = output.resolve("data");
                Files.createDirectories(data, new FileAttribute[0]);
                for (Map.Entry<ResourceLocation, Supplier<byte[]>> entry : this.data.entrySet()) {
                    this.write(data, entry.getKey(), entry.getValue().get());
                    if (stat != null) {
                        stat[2] = stat[2] + 1;
                    }
                    if (!Thread.interrupted()) continue;
                    throw new InterruptedException("Dumping client resources");
                }
            }
            LOGGER.info("Dumping {} finished.", (Object)this.getDisplayName().getString());
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
        catch (InterruptedException e) {
            LOGGER.warn("Interrupted when dumping:", (Throwable)e);
        }
    }

    @Override
    public void load(Path dir) throws IOException {
        try (Stream<Path> stream = Files.walk(dir, new FileVisitOption[0]);){
            for (Path file : () -> stream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(dir::relativize).iterator()) {
                String path;
                String s = file.toString();
                if (s.startsWith("assets")) {
                    path = s.substring("assets".length() + 1);
                    this.load(path, this.assets, Files.readAllBytes(file));
                    continue;
                }
                if (s.startsWith("data")) {
                    path = s.substring("data".length() + 1);
                    this.load(path, this.data, Files.readAllBytes(file));
                    continue;
                }
                byte[] data = Files.readAllBytes(file);
                this.root.put(Arrays.asList(s.split("/")), () -> data);
            }
        }
    }

    @Override
    public void dump(ZipOutputStream zos) throws IOException {
        ResourceLocation id;
        for (Map.Entry<List<String>, Supplier<byte[]>> entry : this.root.entrySet()) {
            zos.putNextEntry(new ZipEntry(String.join((CharSequence)"/", (Iterable<? extends CharSequence>)entry.getKey())));
            zos.write(entry.getValue().get());
            zos.closeEntry();
        }
        for (Map.Entry<List<String>, Supplier<byte[]>> entry : this.assets.entrySet()) {
            id = (ResourceLocation)entry.getKey();
            zos.putNextEntry(new ZipEntry("assets/" + id.getNamespace() + "/" + id.getPath()));
            zos.write(entry.getValue().get());
            zos.closeEntry();
        }
        for (Map.Entry<List<String>, Supplier<byte[]>> entry : this.data.entrySet()) {
            id = (ResourceLocation)entry.getKey();
            zos.putNextEntry(new ZipEntry("data/" + id.getNamespace() + "/" + id.getPath()));
            zos.write(entry.getValue().get());
            zos.closeEntry();
        }
    }

    @Override
    public void load(ZipInputStream stream) throws IOException {
        ZipEntry entry;
        while ((entry = stream.getNextEntry()) != null) {
            String path;
            String s = entry.toString();
            if (s.startsWith("assets")) {
                path = s.substring("assets".length() + 1);
                this.load(path, this.assets, this.read(entry, stream));
                continue;
            }
            if (s.startsWith("data")) {
                path = s.substring("data".length() + 1);
                this.load(path, this.data, this.read(entry, stream));
                continue;
            }
            byte[] data = this.read(entry, stream);
            this.root.put(Arrays.asList(s.split("/")), () -> data);
        }
    }

    public IoSupplier<InputStream> getRootResource(String ... segments) {
        Supplier<byte[]> supplier = this.root.get(Arrays.asList(segments));
        if (supplier == null) {
            return null;
        }
        return () -> new ByteArrayInputStream((byte[])supplier.get());
    }

    @Nullable
    public IoSupplier<InputStream> getResource(PackType type, ResourceLocation id) {
        Supplier<byte[]> supplier = this.getSys(type).get(id);
        return supplier == null ? null : () -> new ByteArrayInputStream((byte[])supplier.get());
    }

    public void listResources(PackType type, String namespace, String prefix, PackResources.ResourceOutput consumer) {
        for (ResourceLocation identifier : this.getSys(type).keySet()) {
            if (!identifier.getNamespace().equals(namespace) || !identifier.getPath().startsWith(prefix)) continue;
            consumer.accept((Object)identifier, this.getResource(type, identifier));
        }
    }

    public Set<String> getNamespaces(PackType type) {
        HashSet<String> namespaces = new HashSet<String>();
        for (ResourceLocation identifier : this.getSys(type).keySet()) {
            namespaces.add(identifier.getNamespace());
        }
        return namespaces;
    }

    public <T> T getMetadataSection(MetadataSectionSerializer<T> metaReader) {
        InputStream stream = null;
        try {
            IoSupplier<InputStream> supplier = this.getRootResource("pack.mcmeta");
            if (supplier != null) {
                stream = (InputStream)supplier.get();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (stream != null) {
            return (T)AbstractPackResources.getMetadataFromStream(metaReader, (InputStream)stream);
        }
        if (metaReader.getMetadataSectionName().equals("pack")) {
            JsonObject object = new JsonObject();
            object.addProperty("pack_format", (Number)this.packVersion);
            Component description = this.getDescription();
            object.add("description", (JsonElement)ComponentSerialization.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, description == null ? Component.translatable((String)"brrp.pack.defaultDescription", (Object[])new Object[]{this.packId()}) : description).getOrThrow(JsonParseException::new));
            return (T)metaReader.fromJson(object);
        }
        return null;
    }

    public PackLocationInfo location() {
        return new PackLocationInfo(this.packId(), this.getDisplayName(), RUNTIME, Optional.empty());
    }

    public void close() {
        LOGGER.debug("Closing Runtime Resource Pack {}.", (Object)this.getDisplayName().getString());
    }

    protected byte[] read(ZipEntry entry, InputStream stream) throws IOException {
        byte[] data = new byte[Math.toIntExact(entry.getSize())];
        if (stream.read(data) != data.length) {
            throw new IOException("Zip stream was cut off! (maybe incorrect zip entry length? maybe u didn't flush your stream?)");
        }
        return data;
    }

    protected void load(String fullPath, Map<ResourceLocation, Supplier<byte[]>> map, byte[] data) {
        int sep = fullPath.indexOf(47);
        String namespace = fullPath.substring(0, sep);
        String path = fullPath.substring(sep + 1);
        map.put(ResourceLocation.fromNamespaceAndPath((String)namespace, (String)path), () -> data);
    }

    private void write(Path dir, ResourceLocation identifier, byte[] data) {
        try {
            Path file = dir.resolve(identifier.getNamespace()).resolve(identifier.getPath());
            Files.createDirectories(file.getParent(), new FileAttribute[0]);
            try (OutputStream output = Files.newOutputStream(file, new OpenOption[0]);){
                output.write(data);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void clearResources(PackType side) {
        this.getSys(side).clear();
    }

    @Override
    public void clearResources() {
        this.assets.clear();
        this.data.clear();
        this.root.clear();
    }

    @Override
    public void clearRootResources() {
        this.root.clear();
    }

    @Override
    public int numberOfClientResources() {
        return this.assets.size();
    }

    @Override
    public int numberOfServerData() {
        return this.data.size();
    }

    @Override
    public int numberOfRootResources() {
        return this.root.size();
    }

    @Override
    public HolderLookup.Provider getRegistryLookup() {
        return this.registryLookup;
    }

    @Override
    public BlockLootSubProvider getBlockLootTableGenerator() {
        return this.blockLootTableGenerator;
    }

    protected Map<ResourceLocation, Supplier<byte[]>> getSys(PackType side) {
        return side == PackType.CLIENT_RESOURCES ? this.assets : this.data;
    }

    private static final class Holder {
        private static final HolderLookup.Provider registryLookup = (HolderLookup.Provider)Util.make(() -> {
            Workaround rb = Workaround.copy(BuiltinRegistriesAccessor.getRegistryBuilder());
            return rb.build((RegistryAccess)RegistryAccess.fromRegistryOfRegistries((Registry)BuiltInRegistries.REGISTRY));
        });
        private static final Gson gson = RuntimeResourcePackImpl.createGson(registryLookup);
        private static final BlockLootSubProvider blockLootTableGenerator = new BRRPBlockLootTableGenerator(registryLookup);

        private Holder() {
        }
    }

    public static class Workaround
    extends RegistrySetBuilder {
        @Contract(pure=true)
        public static Workaround copy(RegistrySetBuilder from) {
            Workaround rb = new Workaround();
            List<?> vanilla = ((RegistryBuilderAccessor)from).getRegistries();
            ((RegistryBuilderAccessor)((Object)rb)).getRegistries().addAll(vanilla);
            return rb;
        }
    }
}

