/*
 * Decompiled with CFR 0.152.
 */
package pers.solid.brrp.v1.impl;

import net.minecraft.SharedConstants;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.function.FailableRunnable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pers.solid.brrp.v1.api.RuntimeResourcePack;

public abstract class AbstractRuntimeResourcePack
implements RuntimeResourcePack {
    private final ResourceLocation id;
    public int packVersion = SharedConstants.getCurrentVersion().getPackVersion(PackType.CLIENT_RESOURCES);
    protected boolean allowsDuplicateResource = false;
    protected FailableRunnable<InterruptedException> regenerationCallback;
    protected FailableRunnable<InterruptedException> clientResourceRegenerationCallback;
    protected FailableRunnable<InterruptedException> serverDataRegenerationCallback;
    private Component displayName;
    private Component description;

    protected AbstractRuntimeResourcePack(ResourceLocation id) {
        this.id = id;
    }

    @Override
    public boolean hasRegenerationCallback() {
        return ObjectUtils.anyNotNull((Object[])new Object[]{this.regenerationCallback, this.clientResourceRegenerationCallback, this.serverDataRegenerationCallback});
    }

    @Override
    public boolean hasSidedRegenerationCallback(@Nullable PackType resourceType) {
        if (resourceType == null) {
            return this.regenerationCallback != null;
        }
        return switch (resourceType) {
            default -> throw new MatchException(null, null);
            case PackType.CLIENT_RESOURCES -> {
                if (this.clientResourceRegenerationCallback != null) {
                    yield true;
                }
                yield false;
            }
            case PackType.SERVER_DATA -> this.serverDataRegenerationCallback != null;
        };
    }

    @Override
    public void setRegenerationCallback(FailableRunnable<InterruptedException> regenerationCallback) {
        this.regenerationCallback = regenerationCallback;
    }

    @Override
    public void setSidedRegenerationCallback(@NotNull PackType resourceType, FailableRunnable<InterruptedException> regenerationCallback) {
        switch (resourceType) {
            case SERVER_DATA: {
                this.serverDataRegenerationCallback = regenerationCallback;
                break;
            }
            case CLIENT_RESOURCES: {
                this.clientResourceRegenerationCallback = regenerationCallback;
            }
        }
    }

    @Override
    public void regenerate() throws InterruptedException {
        if (this.regenerationCallback != null) {
            this.regenerationCallback.run();
        } else {
            if (this.clientResourceRegenerationCallback != null) {
                this.clientResourceRegenerationCallback.run();
            }
            if (this.serverDataRegenerationCallback != null) {
                this.serverDataRegenerationCallback.run();
            }
        }
    }

    @Override
    public void regenerateSided(@NotNull PackType resourceType) throws InterruptedException {
        switch (resourceType) {
            case CLIENT_RESOURCES: {
                this.clientResourceRegenerationCallback.run();
                break;
            }
            case SERVER_DATA: {
                this.serverDataRegenerationCallback.run();
            }
        }
    }

    @Override
    public String packId() {
        return this.id.toString();
    }

    @Override
    public int getPackVersion() {
        return this.packVersion;
    }

    @Override
    public void setPackVersion(int packVersion) {
        this.packVersion = packVersion;
    }

    @Override
    public void setAllowsDuplicateResource(boolean b) {
        this.allowsDuplicateResource = b;
    }

    @Override
    public Component getDisplayName() {
        if (this.displayName != null) {
            return this.displayName;
        }
        return RuntimeResourcePack.super.getDisplayName();
    }

    @Override
    public void setDisplayName(Component name) {
        this.displayName = name;
    }

    @Override
    @Nullable
    public Component getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(Component description) {
        this.description = description;
    }
}

