/*
 * Decompiled with CFR 0.152.
 */
package pers.solid.brrp.v1.gui;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.MultiLineTextWidget;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.PackType;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pers.solid.brrp.v1.api.RuntimeResourcePack;
import pers.solid.brrp.v1.gui.RRPConfigScreen;

@Environment(value=EnvType.CLIENT)
public class RegenerateScreen
extends Screen {
    protected static final Component STATE_REGEN_CLIENT = Component.translatable((String)"brrp.regenerateScreen.state.client");
    protected static final Component STATE_REGEN_SERVER = Component.translatable((String)"brrp.regenerateScreen.state.server");
    protected static final Component STATE_REGEN_ALL = Component.translatable((String)"brrp.regenerateScreen.state.all");
    protected static final Component STATE_IDLE = Component.translatable((String)"brrp.regenerateScreen.state.idle");
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"BRRP/RegenerateScreen");
    private final Screen parent;
    private final RuntimeResourcePack pack;
    protected Thread currentThread;
    private StringWidget stateText;
    private MultiLineTextWidget summaryText;
    private Button onlyRegenClientButton;
    private Button onlyRegenServerButton;
    private Button regenButton;
    private Button interruptButton;
    private Button backButton;

    protected RegenerateScreen(Screen parent, @NotNull RuntimeResourcePack pack) {
        super((Component)Component.translatable((String)"brrp.regenerateScreen.title", (Object[])new Object[]{pack.getDisplayName()}));
        this.parent = parent;
        this.pack = pack;
    }

    public Component getNarrationMessage() {
        return super.getNarrationMessage().copy().append(CommonComponents.NEW_LINE).append(STATE_IDLE);
    }

    protected void init() {
        super.init();
        this.stateText = new StringWidget(10, 25, this.width - 20, 20, STATE_IDLE, this.font).alignCenter().setColor(0xEEEE66);
        this.summaryText = new MultiLineTextWidget(10, 45, CommonComponents.EMPTY, this.font).setCentered(true).setMaxWidth(this.width - 20).setColor(-3355444);
        this.onlyRegenClientButton = Button.builder((Component)Component.translatable((String)"brrp.regenerateScreen.onlyRegenClient"), button -> this.regenClientOnly()).bounds(this.width / 2 - 100, 90, 200, 20).build();
        this.onlyRegenServerButton = Button.builder((Component)Component.translatable((String)"brrp.regenerateScreen.onlyRegenServer"), button -> this.regenServerOnly()).bounds(this.width / 2 - 100, 110, 200, 20).build();
        this.regenButton = Button.builder((Component)Component.translatable((String)"brrp.regenerateScreen.regenAll"), button -> this.regenAll()).bounds(this.width / 2 - 100, 130, 200, 20).build();
        this.addRenderableWidget((GuiEventListener)this.stateText);
        this.addRenderableWidget((GuiEventListener)this.summaryText);
        this.addRenderableWidget((GuiEventListener)this.onlyRegenClientButton);
        this.addRenderableWidget((GuiEventListener)this.onlyRegenServerButton);
        this.addRenderableWidget((GuiEventListener)this.regenButton);
        this.interruptButton = Button.builder((Component)Component.translatable((String)"brrp.regenerateScreen.interrupt"), button -> {
            if (this.currentThread != null) {
                if (this.currentThread.isAlive()) {
                    LOGGER.warn("Interrupting thread {}!", (Object)this.currentThread);
                }
                this.currentThread.interrupt();
                try {
                    this.currentThread.join();
                }
                catch (InterruptedException e) {
                    LOGGER.warn("Waiting the thread to finish:", (Throwable)e);
                }
            }
        }).bounds(this.width / 2 - 100, this.height - 48, 200, 20).tooltip(Tooltip.create((Component)Component.translatable((String)"brrp.regenerateScreen.interrupt.tooltip"))).build();
        this.addRenderableWidget((GuiEventListener)this.interruptButton);
        this.interruptButton.active = false;
        this.backButton = Button.builder((Component)CommonComponents.GUI_BACK, button -> this.onClose()).bounds(this.width / 2 - 100, this.height - 28, 200, 20).build();
        this.addRenderableWidget((GuiEventListener)this.backButton);
    }

    public void render(GuiGraphics context, int mouseX, int mouseY, float delta) {
        super.render(context, mouseX, mouseY, delta);
        context.drawCenteredString(this.font, this.title, this.width / 2, 8, 0xFFFFFF);
        this.summaryText.setX(this.width / 2 - this.summaryText.getWidth() / 2);
        boolean isIdle = this.currentThread == null || !this.currentThread.isAlive();
        this.onlyRegenClientButton.active = isIdle && this.pack.hasSidedRegenerationCallback(PackType.CLIENT_RESOURCES);
        this.onlyRegenServerButton.active = isIdle && this.pack.hasSidedRegenerationCallback(PackType.SERVER_DATA);
        this.regenButton.active = isIdle && this.pack.hasRegenerationCallback();
        this.backButton.active = isIdle;
        boolean bl = this.interruptButton.active = !isIdle;
        if (isIdle) {
            this.stateText.setMessage(STATE_IDLE);
        }
    }

    private void regenClientOnly() {
        this.currentThread = new Thread(() -> {
            try {
                this.pack.regenerateSided(PackType.CLIENT_RESOURCES);
            }
            catch (InterruptedException e) {
                LOGGER.warn("Interrupted:", (Throwable)e);
            }
        }, "Regenerate client resources");
        this.stateText.setMessage(STATE_REGEN_CLIENT);
        this.currentThread.start();
    }

    private void regenServerOnly() {
        this.currentThread = new Thread(() -> {
            try {
                this.pack.regenerateSided(PackType.SERVER_DATA);
            }
            catch (InterruptedException e) {
                LOGGER.warn("Interrupted:", (Throwable)e);
            }
        }, "Regenerate server data");
        this.stateText.setMessage(STATE_REGEN_SERVER);
        this.currentThread.start();
    }

    private void regenAll() {
        this.currentThread = new Thread(() -> {
            try {
                this.pack.regenerate();
            }
            catch (InterruptedException e) {
                LOGGER.warn("Interrupted:", (Throwable)e);
            }
        }, "Regenerate all resources");
        this.stateText.setMessage(STATE_REGEN_ALL);
        this.currentThread.start();
    }

    public void tick() {
        super.tick();
        this.summaryText.setMessage((Component)Component.translatable((String)"brrp.configScreen.summary", (Object[])new Object[]{RRPConfigScreen.PackListWidget.Entry.singleOrPlural("brrp.configScreen.summary.rootResources.", this.pack.numberOfRootResources()), RRPConfigScreen.PackListWidget.Entry.singleOrPlural("brrp.configScreen.summary.clientResources.", this.pack.numberOfClientResources()), RRPConfigScreen.PackListWidget.Entry.singleOrPlural("brrp.configScreen.summary.serverData.", this.pack.numberOfServerData())}));
    }

    public void onClose() {
        if (this.currentThread != null && this.currentThread.isAlive()) {
            return;
        }
        if (this.minecraft != null) {
            this.minecraft.setScreen(this.parent);
        }
    }
}

