/*
 * Decompiled with CFR 0.152.
 */
package pers.solid.brrp.v1.gui;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.MultiLineLabel;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.tooltip.BelowOrAboveWidgetTooltipPositioner;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipPositioner;
import net.minecraft.client.gui.screens.inventory.tooltip.DefaultTooltipPositioner;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pers.solid.brrp.v1.PlatformBridge;
import pers.solid.brrp.v1.api.RuntimeResourcePack;
import pers.solid.brrp.v1.gui.DumpScreen;
import pers.solid.brrp.v1.gui.RegenerateScreen;

@Environment(value=EnvType.CLIENT)
public class RRPConfigScreen
extends Screen {
    protected final List<PackResources> beforeVanillaPacks;
    protected final List<PackResources> beforeUserPacks;
    protected final List<PackResources> afterVanillaPacks;
    private final Screen parent;
    protected PackListWidget beforeVanillaListWidget;
    protected PackListWidget beforeUserListWidget;
    protected PackListWidget afterVanillaListWidget;
    protected Button beforeVanillaTabButton;
    protected Button beforeUserTabButton;
    protected Button afterVanillaTabButton;
    protected int currentTab = 0;
    protected Button backButton;

    public RRPConfigScreen(Screen parent) {
        super((Component)Component.translatable((String)"brrp.configScreen.title"));
        this.parent = parent;
        this.beforeVanillaPacks = new ArrayList<PackResources>();
        this.beforeUserPacks = new ArrayList<PackResources>();
        this.afterVanillaPacks = new ArrayList<PackResources>();
        PlatformBridge.getInstance().postBefore(null, this.beforeVanillaPacks);
        PlatformBridge.getInstance().postBeforeUser(null, this.beforeUserPacks);
        PlatformBridge.getInstance().postAfter(null, this.afterVanillaPacks);
    }

    public void onClose() {
        if (this.minecraft != null) {
            this.minecraft.setScreen(this.parent);
        }
    }

    protected void setTab(int tab) {
        this.beforeVanillaTabButton.active = tab != 0;
        this.beforeUserTabButton.active = tab != 1;
        this.afterVanillaTabButton.active = tab != 2;
        GuiEventListener guiEventListener = this.getFocused();
        if (guiEventListener instanceof PackListWidget) {
            PackListWidget packListWidget = (PackListWidget)guiEventListener;
            this.setFocused(null);
            packListWidget.setFocused(null);
        }
        this.removeWidget((GuiEventListener)this.beforeVanillaListWidget);
        this.removeWidget((GuiEventListener)this.beforeUserListWidget);
        this.removeWidget((GuiEventListener)this.afterVanillaListWidget);
        this.removeWidget((GuiEventListener)this.backButton);
        switch (tab) {
            case 0: {
                this.addWidget((GuiEventListener)this.beforeVanillaListWidget);
                break;
            }
            case 1: {
                this.addWidget((GuiEventListener)this.beforeUserListWidget);
                break;
            }
            case 2: {
                this.addWidget((GuiEventListener)this.afterVanillaListWidget);
            }
        }
        this.addRenderableWidget((GuiEventListener)this.backButton);
        this.currentTab = tab;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 258 && RRPConfigScreen.hasControlDown()) {
            this.setTab((this.currentTab + 3 + (RRPConfigScreen.hasShiftDown() ? -1 : 1)) % 3);
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    protected void init() {
        this.beforeVanillaTabButton = Button.builder((Component)Component.translatable((String)"brrp.configScreen.tab.beforeVanilla", (Object[])new Object[]{this.beforeVanillaPacks.size()}), button -> this.setTab(0)).createNarration(textSupplier -> Component.translatable((String)"brrp.configScreen.tab.description", (Object[])new Object[]{textSupplier.get(), 1, 3})).bounds(this.width / 2 - 120, 20, 80, 20).build();
        this.addRenderableWidget((GuiEventListener)this.beforeVanillaTabButton);
        this.beforeUserTabButton = Button.builder((Component)Component.translatable((String)"brrp.configScreen.tab.beforeUser", (Object[])new Object[]{this.beforeUserPacks.size()}), button -> this.setTab(1)).createNarration(textSupplier -> Component.translatable((String)"brrp.configScreen.tab.description", (Object[])new Object[]{textSupplier.get(), 2, 3})).bounds(this.width / 2 - 40, 20, 80, 20).build();
        this.addRenderableWidget((GuiEventListener)this.beforeUserTabButton);
        this.afterVanillaTabButton = Button.builder((Component)Component.translatable((String)"brrp.configScreen.tab.afterVanilla", (Object[])new Object[]{this.afterVanillaPacks.size()}), button -> this.setTab(2)).createNarration(textSupplier -> Component.translatable((String)"brrp.configScreen.tab.description", (Object[])new Object[]{textSupplier.get(), 3, 3})).bounds(this.width / 2 + 40, 20, 80, 20).build();
        this.addRenderableWidget((GuiEventListener)this.afterVanillaTabButton);
        this.beforeVanillaListWidget = new PackListWidget(this.beforeVanillaPacks);
        this.beforeUserListWidget = new PackListWidget(this.beforeUserPacks);
        this.afterVanillaListWidget = new PackListWidget(this.afterVanillaPacks);
        this.backButton = Button.builder((Component)CommonComponents.GUI_BACK, button -> this.onClose()).bounds(this.width / 2 - 100, this.height - 28, 200, 20).build();
        this.addRenderableWidget((GuiEventListener)this.backButton);
        this.setTab(this.currentTab);
    }

    protected void updateNarratedWidget(NarrationElementOutput builder) {
        super.updateNarratedWidget(builder);
        switch (this.currentTab) {
            case 0: {
                if (this.beforeVanillaListWidget.nothingHereText == null) break;
                builder.nest().add(NarratedElementType.USAGE, PackListWidget.NOTHING_HERE);
                break;
            }
            case 1: {
                if (this.beforeUserListWidget.nothingHereText == null) break;
                builder.nest().add(NarratedElementType.USAGE, PackListWidget.NOTHING_HERE);
                break;
            }
            case 2: {
                if (this.afterVanillaListWidget.nothingHereText == null) break;
                builder.nest().add(NarratedElementType.USAGE, PackListWidget.NOTHING_HERE);
            }
        }
    }

    public Component getNarrationMessage() {
        return super.getNarrationMessage().copy().append(CommonComponents.NEW_LINE).append((Component)Component.translatable((String)"brrp.configScreen.tab.narration", (Object[])new Object[]{this.currentTab + 1, 3}));
    }

    public void render(GuiGraphics context, int mouseX, int mouseY, float delta) {
        super.render(context, mouseX, mouseY, delta);
        switch (this.currentTab) {
            case 0: {
                this.beforeVanillaListWidget.render(context, mouseX, mouseY, delta);
                break;
            }
            case 1: {
                this.beforeUserListWidget.render(context, mouseX, mouseY, delta);
                break;
            }
            case 2: {
                this.afterVanillaListWidget.render(context, mouseX, mouseY, delta);
            }
        }
        context.drawCenteredString(this.font, this.title, this.width / 2, 8, 0xFFFFFF);
    }

    @Environment(value=EnvType.CLIENT)
    public class PackListWidget
    extends ContainerObjectSelectionList<Entry> {
        private static final Component NOTHING_HERE = Component.translatable((String)"brrp.configScreen.nothing");
        private final List<PackResources> packList;
        @Nullable
        private final StringWidget nothingHereText;

        public PackListWidget(List<PackResources> packList) {
            super(RRPConfigScreen.this.minecraft, RRPConfigScreen.this.width, RRPConfigScreen.this.height - 77, 40, 36);
            this.packList = packList;
            for (PackResources resourcePack : packList) {
                this.addEntry((AbstractSelectionList.Entry)new Entry(resourcePack));
            }
            if (packList.isEmpty()) {
                this.nothingHereText = new StringWidget(NOTHING_HERE, RRPConfigScreen.this.font);
                this.nothingHereText.alignCenter();
                this.nothingHereText.setWidth(this.width);
            } else {
                this.nothingHereText = null;
            }
        }

        public int getRowWidth() {
            return this.width - 14;
        }

        protected int getScrollbarPosition() {
            return this.width - 6;
        }

        protected boolean isSelectedItem(int index) {
            return Objects.equals(this.getSelected(), this.children().get(index));
        }

        public void renderWidget(GuiGraphics context, int mouseX, int mouseY, float delta) {
            super.renderWidget(context, mouseX, mouseY, delta);
            if (this.nothingHereText != null) {
                this.nothingHereText.setPosition(0, this.height / 2 - 8);
                this.nothingHereText.render(context, mouseX, mouseY, delta);
            }
        }

        public void updateWidgetNarration(NarrationElementOutput builder) {
            super.updateWidgetNarration(builder);
            if (this.getFocused() != null && (((Entry)this.getFocused()).getFocused() == null || ((Entry)this.getFocused()).getFocused() == ((Entry)this.getFocused()).keyboardPlaceHolder)) {
                builder.add(NarratedElementType.TITLE, ((Entry)this.getFocused()).titleText);
                builder.add(NarratedElementType.USAGE, ((Entry)this.getFocused()).description);
            }
        }

        @Environment(value=EnvType.CLIENT)
        public class Entry
        extends ContainerObjectSelectionList.Entry<Entry> {
            private final StringWidget keyboardPlaceHolder;
            private final Button regenerateButton;
            private final Button dumpButton;
            private final PackResources resourcePack;
            private final Component titleText;
            private final Component description;
            private ScreenRectangle area;

            public Entry(PackResources resourcePack) {
                RuntimeResourcePack runtimeResourcePack;
                this.resourcePack = resourcePack;
                this.keyboardPlaceHolder = new StringWidget(0, 0, 60, 20, CommonComponents.EMPTY, RRPConfigScreen.this.font);
                this.keyboardPlaceHolder.active = true;
                this.regenerateButton = Button.builder((Component)Component.translatable((String)"brrp.configScreen.regenerate"), button -> {
                    if (resourcePack instanceof RuntimeResourcePack) {
                        RuntimeResourcePack runtimeResourcePack = (RuntimeResourcePack)resourcePack;
                        PackListWidget.this.minecraft.setScreen((Screen)new RegenerateScreen(RRPConfigScreen.this, runtimeResourcePack));
                    }
                }).bounds(0, 0, 60, 20).tooltip(Tooltip.create((Component)Component.translatable((String)"brrp.configScreen.regenerate.tooltip").append((Component)(resourcePack instanceof RuntimeResourcePack && (runtimeResourcePack = (RuntimeResourcePack)resourcePack).hasRegenerationCallback() ? Component.empty() : Component.literal((String)"\n").withStyle(ChatFormatting.RED).append((Component)Component.translatable((String)"brrp.configScreen.regenerate.notSupported")))))).build();
                this.dumpButton = Button.builder((Component)Component.translatable((String)"brrp.configScreen.dump"), button -> {
                    if (resourcePack instanceof RuntimeResourcePack) {
                        RuntimeResourcePack runtimeResourcePack = (RuntimeResourcePack)resourcePack;
                        PackListWidget.this.minecraft.setScreen((Screen)new DumpScreen(RRPConfigScreen.this, runtimeResourcePack));
                    }
                }).tooltip(Tooltip.create((Component)Component.translatable((String)"brrp.configScreen.dump.tooltip"))).bounds(0, 0, 60, 20).build();
                ArrayList<MutableComponent> descriptionList = new ArrayList<MutableComponent>();
                if (resourcePack instanceof RuntimeResourcePack) {
                    RuntimeResourcePack runtimeResourcePack2 = (RuntimeResourcePack)resourcePack;
                    this.titleText = runtimeResourcePack2.getDisplayName();
                    Component description = runtimeResourcePack2.getDescription();
                    if (description != null) {
                        descriptionList.add(Component.empty().append(description));
                    }
                    descriptionList.add(Component.translatable((String)"brrp.configScreen.summary", (Object[])new Object[]{Entry.singleOrPlural("brrp.configScreen.summary.rootResources.", runtimeResourcePack2.numberOfRootResources()), Entry.singleOrPlural("brrp.configScreen.summary.clientResources.", runtimeResourcePack2.numberOfClientResources()), Entry.singleOrPlural("brrp.configScreen.summary.serverData.", runtimeResourcePack2.numberOfServerData())}));
                } else {
                    this.titleText = resourcePack.location().title();
                }
                @NotNull LinkedHashSet namespaces = Sets.newLinkedHashSet((Iterable)Iterables.concat((Iterable)resourcePack.getNamespaces(PackType.CLIENT_RESOURCES), (Iterable)resourcePack.getNamespaces(PackType.SERVER_DATA)));
                descriptionList.add(Component.translatable((String)"brrp.configScreen.namespaces", (Object[])new Object[]{namespaces.isEmpty() ? Component.translatable((String)"gui.none") : ComponentUtils.formatList((Collection)namespaces, (Component)ComponentUtils.DEFAULT_SEPARATOR, Component::literal).withStyle(style -> style.withColor(14533802))}).withStyle(style -> style.withColor(0x909090)));
                this.description = ComponentUtils.formatList(descriptionList, (Component)CommonComponents.NEW_LINE);
                this.keyboardPlaceHolder.setTooltip(Tooltip.create((Component)this.description));
                this.area = new ScreenRectangle(PackListWidget.this.width / 2 - PackListWidget.this.getRowWidth() / 2, 0, PackListWidget.this.getRowWidth(), PackListWidget.this.itemHeight);
            }

            static MutableComponent singleOrPlural(String prefix, int number) {
                return Component.translatable((String)(prefix + (number == 1 ? "single" : "plural")), (Object[])new Object[]{number});
            }

            public void render(GuiGraphics context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
                RuntimeResourcePack runtimeResourcePack;
                context.enableScissor(5, y, PackListWidget.this.width - 141, y + entryHeight);
                context.drawString(RRPConfigScreen.this.font, this.titleText, x + 5, y + 2, 0xFFFFFF);
                MultiLineLabel.create((Font)RRPConfigScreen.this.font, (Component)this.description, (int)(PackListWidget.this.width - 151)).renderLeftAlignedNoShadow(context, x + 5, y + 12, 10, 0xAAAAAA);
                context.disableScissor();
                this.area = new ScreenRectangle(PackListWidget.this.width / 2 - entryWidth / 2, y, entryWidth, PackListWidget.this.itemHeight);
                MutableComponent tooltipContent = Component.empty().append(this.titleText).append(CommonComponents.NEW_LINE);
                PackResources packResources = this.resourcePack;
                if (packResources instanceof RuntimeResourcePack) {
                    runtimeResourcePack = (RuntimeResourcePack)packResources;
                    tooltipContent.append((Component)Component.literal((String)runtimeResourcePack.packId()).withStyle(ChatFormatting.GRAY)).append(CommonComponents.NEW_LINE);
                }
                tooltipContent.append((Component)this.description.copy().withStyle(ChatFormatting.GRAY));
                if (this.isMouseOver(mouseX, mouseY) && !this.regenerateButton.isMouseOver((double)mouseX, (double)mouseY) && !this.dumpButton.isMouseOver((double)mouseX, (double)mouseY)) {
                    RRPConfigScreen.this.setTooltipForNextRenderPass(Tooltip.create((Component)tooltipContent), DefaultTooltipPositioner.INSTANCE, false);
                } else if (this.isFocused() && Minecraft.getInstance().getLastInputType().isKeyboard() && (this.getFocused() == null || this.keyboardPlaceHolder.isFocused())) {
                    RRPConfigScreen.this.setTooltipForNextRenderPass(Tooltip.create((Component)tooltipContent), (ClientTooltipPositioner)new BelowOrAboveWidgetTooltipPositioner(this.area), true);
                }
                this.keyboardPlaceHolder.setPosition(PackListWidget.this.width - 196, y + entryHeight / 2 - this.keyboardPlaceHolder.getHeight() / 2);
                this.regenerateButton.setPosition(PackListWidget.this.width - 136, y + entryHeight / 2 - this.regenerateButton.getHeight() / 2);
                packResources = this.resourcePack;
                this.regenerateButton.active = packResources instanceof RuntimeResourcePack && (runtimeResourcePack = (RuntimeResourcePack)packResources).hasRegenerationCallback();
                this.regenerateButton.render(context, mouseX, mouseY, tickDelta);
                this.regenerateButton.active = true;
                this.dumpButton.setPosition(PackListWidget.this.width - 76, y + entryHeight / 2 - this.dumpButton.getHeight() / 2);
                this.dumpButton.render(context, mouseX, mouseY, tickDelta);
            }

            public boolean mouseClicked(double mouseX, double mouseY, int button) {
                if (this.keyboardPlaceHolder.isMouseOver(mouseX, mouseY) || !super.mouseClicked(mouseX, mouseY, button)) {
                    PackListWidget.this.setSelected((AbstractSelectionList.Entry)this);
                    this.setFocused(null);
                    PackListWidget.this.setFocused((GuiEventListener)this);
                    return false;
                }
                return true;
            }

            public void setFocused(boolean focused) {
                super.setFocused(focused);
                if (!focused) {
                    this.setFocused(null);
                }
            }

            public List<? extends NarratableEntry> narratables() {
                return ImmutableList.of((Object)this.regenerateButton, (Object)this.dumpButton);
            }

            public List<? extends GuiEventListener> children() {
                return ImmutableList.of((Object)this.keyboardPlaceHolder, (Object)this.regenerateButton, (Object)this.dumpButton);
            }
        }
    }
}

