/*
 * Decompiled with CFR 0.152.
 */
package pers.solid.brrp.v1.gui;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.MultiLineTextWidget;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.PackType;
import net.minecraft.util.StringRepresentable;
import org.apache.commons.io.file.PathUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pers.solid.brrp.v1.api.RuntimeResourcePack;
import pers.solid.brrp.v1.gui.RRPConfigScreen;

@Environment(value=EnvType.CLIENT)
public class DumpScreen
extends Screen {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"BRRP/DumpScreen");
    private final Screen parent;
    private final RuntimeResourcePack pack;
    private final int[] dumpStat = new int[3];
    private CycleButton<DumpType> dumpTypeButton;
    @NotNull
    private DumpType dumpType = DumpType.ALL;
    private StringWidget dumpPathText;
    private EditBox dumpPathTextField;
    private Path dumpPath;
    private String dumpPathString;
    private InvalidPathException invalidPathException;
    private MultiLineTextWidget dumpPathPreviewText;
    private StringWidget summaryText;
    private StringWidget dumpProgressText;
    private Button dumpButton;
    private Button interruptButton;
    private Button backButton;
    private Thread dumpThread;

    protected DumpScreen(Screen parent, @NotNull RuntimeResourcePack pack) {
        super((Component)Component.translatable((String)"brrp.dumpScreen.title", (Object[])new Object[]{pack.getDisplayName()}));
        this.parent = parent;
        this.pack = pack;
        this.dumpPath = RuntimeResourcePack.DEFAULT_OUTPUT.resolve(pack.packId().replace(':', '/'));
        this.dumpPathString = this.dumpPath.toString();
    }

    protected void init() {
        super.init();
        this.dumpTypeButton = new CycleButton.Builder(dumpType -> Component.translatable((String)("brrp.dumpScreen.dumpType." + dumpType.getSerializedName()))).withValues((Object[])DumpType.values()).withInitialValue((Object)this.dumpType).withTooltip(value -> Tooltip.create((Component)Component.translatable((String)("brrp.dumpScreen.dumpType.tooltip." + value.getSerializedName())))).create(this.width / 2 - 100, 30, 200, 20, (Component)Component.translatable((String)"brrp.dumpScreen.dumpType"), (button, value) -> {
            this.dumpType = value;
        });
        this.addRenderableWidget((GuiEventListener)this.dumpTypeButton);
        this.dumpPathText = new StringWidget(this.width / 2 - 100, 65, 200, 20, (Component)Component.translatable((String)"brrp.dumpScreen.dumpPath.title"), this.font).setColor(0xCCCCCC).alignCenter();
        this.addRenderableWidget((GuiEventListener)this.dumpPathText);
        this.dumpPathTextField = new EditBox(this.font, 20, 85, this.width - 40, 20, (Component)Component.translatable((String)"brrp.dumpScreen.dumpPath.message"));
        this.dumpPathTextField.setTooltip(Tooltip.create((Component)Component.translatable((String)"brrp.dumpScreen.dumpPath.tooltip")));
        this.dumpPathTextField.setMaxLength(64);
        this.dumpPathTextField.setResponder(s -> {
            this.dumpPathString = s;
            try {
                this.dumpPath = Path.of(s, new String[0]);
                this.invalidPathException = null;
                this.dumpPathPreviewText.setMessage((Component)Component.translatable((String)"brrp.dumpScreen.dumpToPath", (Object[])new Object[]{this.dumpPath.toAbsolutePath().toString()}).withStyle(ChatFormatting.GREEN));
            }
            catch (InvalidPathException exception) {
                this.invalidPathException = exception;
                this.dumpPathPreviewText.setMessage((Component)Component.translatable((String)"brrp.dumpScreen.dumpInvalidPath", (Object[])new Object[]{this.invalidPathException.getMessage()}).withStyle(ChatFormatting.RED));
                this.dumpButton.active = false;
            }
            this.dumpPathPreviewText.setX(this.width / 2 - this.dumpPathPreviewText.getWidth() / 2);
            this.dumpPathTextField.setTooltip(Tooltip.create((Component)Component.translatable((String)"brrp.dumpScreen.dumpPath.tooltip"), (Component)this.dumpPathPreviewText.getMessage().copy().append(CommonComponents.NEW_LINE).append((Component)Component.translatable((String)"brrp.dumpScreen.dumpPath.tooltip"))));
        });
        this.addRenderableWidget((GuiEventListener)this.dumpPathTextField);
        this.dumpPathPreviewText = new MultiLineTextWidget(20, 120, CommonComponents.EMPTY, this.font).setMaxWidth(this.width - 40).setCentered(true);
        this.dumpPathTextField.setValue(this.dumpPathString);
        this.addRenderableWidget((GuiEventListener)this.dumpPathPreviewText);
        this.summaryText = new StringWidget(20, this.height - 89, this.width - 40, 20, (Component)Component.translatable((String)"brrp.configScreen.summary", (Object[])new Object[]{RRPConfigScreen.PackListWidget.Entry.singleOrPlural("brrp.configScreen.summary.rootResources.", this.pack.numberOfRootResources()), RRPConfigScreen.PackListWidget.Entry.singleOrPlural("brrp.configScreen.summary.clientResources.", this.pack.numberOfClientResources()), RRPConfigScreen.PackListWidget.Entry.singleOrPlural("brrp.configScreen.summary.serverData.", this.pack.numberOfServerData())}), this.font).alignCenter().setColor(-3355444);
        this.addRenderableWidget((GuiEventListener)this.summaryText);
        this.dumpProgressText = new StringWidget(20, this.height - 73, this.width - 40, 20, CommonComponents.EMPTY, this.font).alignCenter();
        this.addRenderableWidget((GuiEventListener)this.dumpProgressText);
        this.dumpButton = Button.builder((Component)Component.translatable((String)"brrp.dumpScreen.dump"), button -> this.runDump()).bounds(this.width / 2 - 200, this.height - 53, 200, 20).build();
        this.addRenderableWidget((GuiEventListener)this.dumpButton);
        this.interruptButton = Button.builder((Component)Component.translatable((String)"brrp.dumpScreen.interrupt"), button -> {
            if (this.dumpThread != null) {
                this.dumpThread.interrupt();
                try {
                    this.dumpThread.join();
                }
                catch (InterruptedException e) {
                    LOGGER.error("Interrupted dump screen:", (Throwable)e);
                }
            }
        }).tooltip(Tooltip.create((Component)Component.translatable((String)"brrp.dumpScreen.interrupt.tooltip"))).bounds(this.width / 2, this.height - 53, 200, 20).build();
        this.interruptButton.active = false;
        this.addRenderableWidget((GuiEventListener)this.interruptButton);
        this.backButton = Button.builder((Component)CommonComponents.GUI_BACK, button -> this.onClose()).bounds(this.width / 2 - 100, this.height - 28, 200, 20).build();
        this.addRenderableWidget((GuiEventListener)this.backButton);
    }

    public void render(GuiGraphics context, int mouseX, int mouseY, float delta) {
        super.render(context, mouseX, mouseY, delta);
        context.drawCenteredString(this.font, this.title, this.width / 2, 8, 0xFFFFFF);
    }

    public void tick() {
        super.tick();
        boolean bl = this.dumpButton.active = this.invalidPathException == null && (this.dumpThread == null || !this.dumpThread.isAlive());
        if (this.dumpThread != null && this.dumpThread.isAlive()) {
            if (this.dumpStat[0] == -1) {
                this.dumpProgressText.setMessage((Component)Component.translatable((String)"brrp.dumpScreen.removeExisting"));
            } else {
                this.dumpProgressText.setMessage((Component)Component.translatable((String)"brrp.dumpScreen.dumpSummary", (Object[])new Object[]{RRPConfigScreen.PackListWidget.Entry.singleOrPlural("brrp.configScreen.summary.rootResources.", this.dumpStat[0]), RRPConfigScreen.PackListWidget.Entry.singleOrPlural("brrp.configScreen.summary.clientResources.", this.dumpStat[1]), RRPConfigScreen.PackListWidget.Entry.singleOrPlural("brrp.configScreen.summary.serverData.", this.dumpStat[2])}));
            }
        } else if (this.dumpThread != null) {
            this.dumpProgressText.setMessage(CommonComponents.GUI_DONE);
        }
    }

    private void runDump() {
        this.runDump(false);
    }

    private void runDump(boolean ignoreExistingWarning) {
        try {
            if (!ignoreExistingWarning && PathUtils.isDirectory((Path)this.dumpPath, (LinkOption[])new LinkOption[0]) && !PathUtils.isEmptyDirectory((Path)this.dumpPath)) {
                long size = Files.walk(this.dumpPath, new FileVisitOption[0]).limit(2001L).count();
                if (this.minecraft != null) {
                    this.dumpProgressText.setMessage(CommonComponents.EMPTY);
                    this.minecraft.setScreen((Screen)new ConfirmScreen(value -> {
                        if (this.minecraft != null) {
                            this.minecraft.setScreen((Screen)this);
                            if (value) {
                                this.runDump(true);
                            }
                        }
                    }, (Component)Component.translatable((String)"brrp.dumpScreen.existing.title"), (Component)Component.translatable((String)"brrp.dumpScreen.existing.message", (Object[])new Object[]{size > 2000L ? Component.translatable((String)"brrp.dumpScreen.existing.size", (Object[])new Object[]{2000}) : Long.valueOf(size), this.dumpPath.toAbsolutePath().toString()})));
                    return;
                }
            }
        }
        catch (IOException e) {
            LOGGER.error("Checking whether the dump file exists:", (Throwable)e);
        }
        this.dumpThread = new Thread(() -> {
            this.interruptButton.active = true;
            this.backButton.active = false;
            this.dumpButton.setMessage((Component)Component.translatable((String)"brrp.dumpScreen.dumping"));
            Arrays.fill(this.dumpStat, 0);
            this.pack.dumpInPath(this.dumpPath, this.dumpType.resourceType, this.dumpStat);
            this.dumpButton.setMessage((Component)Component.translatable((String)"brrp.dumpScreen.dump"));
            this.interruptButton.active = false;
            this.backButton.active = true;
        }, "Dump pack");
        this.dumpThread.start();
    }

    public void onClose() {
        if (this.dumpThread != null && this.dumpThread.isAlive()) {
            return;
        }
        if (this.minecraft != null) {
            this.minecraft.setScreen(this.parent);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static enum DumpType implements StringRepresentable
    {
        ALL("all", null),
        CLIENT_RESOURCES("client_resources", PackType.CLIENT_RESOURCES),
        SERVER_DATA("server_data", PackType.SERVER_DATA);

        public final PackType resourceType;
        private final String name;

        private DumpType(String name, PackType resourceType) {
            this.name = name;
            this.resourceType = resourceType;
        }

        public String getSerializedName() {
            return this.name;
        }
    }
}

