/*
 * Decompiled with CFR 0.152.
 */
package pers.solid.brrp.v1.generator;

import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Collections;
import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.models.model.TextureMapping;
import net.minecraft.data.models.model.TextureSlot;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnmodifiableView;

public final class TextureRegistry {
    private static final Object2ObjectMap<@NotNull Block, TextureMapping> TEXTURE_MAPS = new Object2ObjectOpenHashMap();

    private TextureRegistry() {
    }

    public static void register(Block block, ResourceLocation texture) {
        TextureRegistry.register(block, TextureSlot.ALL, texture);
    }

    public static void register(Block block, TextureSlot textureKey, ResourceLocation texture) {
        ((TextureMapping)TEXTURE_MAPS.computeIfAbsent((Object)block, b -> new TextureMapping())).put(textureKey, texture);
    }

    public static void registerSuffixed(Block block, TextureSlot textureKey, String suffix) {
        TextureRegistry.register(block, textureKey, BuiltInRegistries.BLOCK.getKey((Object)block).brrp_prefix_and_suffixed("block/", suffix));
    }

    public static void registerWithName(Block block, TextureSlot textureKey, String path) {
        ResourceLocation id = BuiltInRegistries.BLOCK.getKey((Object)block);
        TextureRegistry.register(block, textureKey, ResourceLocation.fromNamespaceAndPath((String)id.getNamespace(), (String)("block/" + path)));
    }

    @Nullable
    public static ResourceLocation getTexture(@NotNull Block block, @NotNull TextureSlot textureKey) {
        @Nullable TextureMapping textureMap = (TextureMapping)TEXTURE_MAPS.getOrDefault((Object)block, null);
        if (textureMap == null) {
            return null;
        }
        try {
            return textureMap.get(textureKey);
        }
        catch (IllegalStateException e) {
            return null;
        }
    }

    @Nullable
    public static ResourceLocation getTexture(@NotNull Block block) {
        return TextureRegistry.getTexture(block, TextureSlot.ALL);
    }

    public static @UnmodifiableView Map<Block, TextureMapping> getTextureMaps() {
        return Collections.unmodifiableMap(TEXTURE_MAPS);
    }
}

