/*
 * Decompiled with CFR 0.152.
 */
package pers.solid.brrp.v1.generator;

import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import net.fabricmc.api.EnvType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.models.model.ModelTemplates;
import net.minecraft.data.models.model.TextureSlot;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pers.solid.brrp.v1.PlatformBridge;
import pers.solid.brrp.v1.annotations.PreferredEnvironment;
import pers.solid.brrp.v1.api.RuntimeResourcePack;
import pers.solid.brrp.v1.model.ModelJsonBuilder;

public interface ItemResourceGenerator {
    public static final Object2ObjectMap<@NotNull Item, @Nullable RecipeCategory> ITEM_TO_RECIPE_CATEGORY = new Object2ObjectOpenHashMap();

    @Contract(pure=true)
    default public ResourceLocation getItemId() {
        return BuiltInRegistries.ITEM.getKey((Object)((Item)this));
    }

    @PreferredEnvironment(value=EnvType.CLIENT)
    @Contract(pure=true)
    default public ResourceLocation getItemModelId() {
        return this.getItemId().brrp_prefixed("item/");
    }

    @PreferredEnvironment(value=EnvType.CLIENT)
    @Contract(pure=true)
    default public ResourceLocation getTextureId() {
        return this.getItemId().brrp_prefixed("item/");
    }

    @PreferredEnvironment(value=EnvType.CLIENT)
    @Contract(pure=true)
    default public ModelJsonBuilder getItemModel() {
        return new ModelJsonBuilder().parent(ModelTemplates.FLAT_ITEM).addTexture(TextureSlot.LAYER0, this.getTextureId());
    }

    @PreferredEnvironment(value=EnvType.CLIENT)
    @Contract(mutates="param1")
    default public void writeItemModel(RuntimeResourcePack pack) {
        ModelJsonBuilder model = this.getItemModel();
        if (model != null) {
            pack.addModel(this.getItemModelId(), model);
        }
    }

    @PreferredEnvironment(value=EnvType.CLIENT)
    @Contract(mutates="param1")
    default public void writeAssets(RuntimeResourcePack pack) {
        this.writeItemModel(pack);
    }

    @Contract(pure=true)
    default public RecipeBuilder getCraftingRecipe() {
        return null;
    }

    @Contract(pure=true)
    default public RecipeCategory getRecipeCategory() {
        ItemResourceGenerator itemResourceGenerator = this;
        if (itemResourceGenerator instanceof ItemLike) {
            ItemLike itemConvertible = (ItemLike)itemResourceGenerator;
            return (RecipeCategory)ITEM_TO_RECIPE_CATEGORY.getOrDefault((Object)itemConvertible.asItem(), (Object)RecipeCategory.MISC);
        }
        return RecipeCategory.MISC;
    }

    default public void setRecipeCategory(@Nullable RecipeCategory recipeCategory) {
        ItemResourceGenerator itemResourceGenerator = this;
        if (!(itemResourceGenerator instanceof ItemLike)) {
            throw new UnsupportedOperationException("Cannot invoke setRecipeCategory for non-ItemConvertible objects. Maybe you have to override this method.");
        }
        ItemLike itemConvertible = (ItemLike)itemResourceGenerator;
        ITEM_TO_RECIPE_CATEGORY.put((Object)itemConvertible.asItem(), (Object)recipeCategory);
    }

    @Contract(pure=true)
    default public ResourceLocation getRecipeId() {
        return this.getItemId();
    }

    @Contract(mutates="param1")
    default public void writeRecipes(RuntimeResourcePack pack) {
        @Nullable RecipeBuilder recipe = this.getCraftingRecipe();
        if (recipe != null) {
            ResourceLocation recipeId = this.getRecipeId();
            pack.addRecipeAndAdvancement(recipeId, recipe);
        }
    }

    @Contract(mutates="param1")
    default public void writeData(RuntimeResourcePack pack) {
        this.writeRecipes(pack);
    }

    @Contract(mutates="param1")
    default public void writeAll(RuntimeResourcePack pack) {
        if (PlatformBridge.getInstance().isClientEnvironment()) {
            this.writeAssets(pack);
        }
        this.writeData(pack);
    }

    @Contract(mutates="param1")
    @ApiStatus.NonExtendable
    default public void writeResources(RuntimeResourcePack pack, @Nullable PackType resourceType) {
        if (resourceType == null) {
            this.writeAssets(pack);
            this.writeData(pack);
        } else if (resourceType == PackType.CLIENT_RESOURCES) {
            this.writeAssets(pack);
        } else {
            this.writeData(pack);
        }
    }

    @Contract(mutates="param1")
    @ApiStatus.NonExtendable
    default public void writeResources(RuntimeResourcePack pack, boolean clientIncluded, boolean serverIncluded) {
        if (clientIncluded) {
            this.writeAssets(pack);
        }
        if (serverIncluded) {
            this.writeData(pack);
        }
    }
}

