/*
 * Decompiled with CFR 0.152.
 */
package pers.solid.brrp.v1.generator;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.fabricmc.api.EnvType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.data.models.blockstates.BlockStateGenerator;
import net.minecraft.data.models.model.TextureSlot;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.SingleItemRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootTable;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pers.solid.brrp.v1.BRRPUtils;
import pers.solid.brrp.v1.annotations.PreferredEnvironment;
import pers.solid.brrp.v1.api.RuntimeResourcePack;
import pers.solid.brrp.v1.generator.ItemResourceGenerator;
import pers.solid.brrp.v1.generator.TextureRegistry;
import pers.solid.brrp.v1.impl.BRRPBlockLootTableGenerator;
import pers.solid.brrp.v1.model.ModelJsonBuilder;

public interface BlockResourceGenerator
extends ItemResourceGenerator {
    @Contract(pure=true)
    @Nullable
    default public Block getBaseBlock() {
        return null;
    }

    @Contract(pure=true)
    default public ResourceLocation getBlockId() {
        return BuiltInRegistries.BLOCK.getKey((Object)((Block)this));
    }

    @Override
    @Contract(pure=true)
    default public ResourceLocation getItemId() {
        BlockResourceGenerator blockResourceGenerator = this;
        if (blockResourceGenerator instanceof Block) {
            Block block = (Block)blockResourceGenerator;
            Item item = block.asItem();
            if (item == Items.AIR) {
                if (BlockItem.BY_BLOCK.containsKey(block)) {
                    return BuiltInRegistries.ITEM.getKey((Object)((Item)BlockItem.BY_BLOCK.get(block)));
                }
                return null;
            }
            return BuiltInRegistries.ITEM.getKey((Object)item);
        }
        return null;
    }

    @PreferredEnvironment(value=EnvType.CLIENT)
    default public ResourceLocation getBlockModelId() {
        return this.getBlockId().brrp_prefixed("block/");
    }

    @PreferredEnvironment(value=EnvType.CLIENT)
    @Contract(pure=true)
    @NotNull
    default public ResourceLocation getTextureId(@NotNull TextureSlot textureKey) {
        BlockResourceGenerator blockResourceGenerator = this;
        if (blockResourceGenerator instanceof Block) {
            Block thisBlock = (Block)blockResourceGenerator;
            ResourceLocation texture = TextureRegistry.getTexture(thisBlock, textureKey);
            if (texture != null) {
                return texture;
            }
            @Nullable Block baseBlock = this.getBaseBlock();
            if (baseBlock != null) {
                return BRRPUtils.getTextureId(baseBlock, textureKey);
            }
        }
        return this.getBlockId().brrp_prefixed("block/");
    }

    @PreferredEnvironment(value=EnvType.CLIENT)
    @Contract(pure=true)
    default public BlockStateGenerator getBlockStates() {
        return null;
    }

    @PreferredEnvironment(value=EnvType.CLIENT)
    @Contract(mutates="param1")
    default public void writeBlockStates(RuntimeResourcePack pack) {
        BlockStateGenerator blockStates = this.getBlockStates();
        if (blockStates != null) {
            pack.addBlockState(this.getBlockId(), blockStates);
        }
    }

    @PreferredEnvironment(value=EnvType.CLIENT)
    @Contract(pure=true)
    default public ModelJsonBuilder getBlockModel() {
        return null;
    }

    @PreferredEnvironment(value=EnvType.CLIENT)
    @Contract(mutates="param1")
    default public void writeBlockModel(RuntimeResourcePack pack) {
        @Nullable ModelJsonBuilder model = this.getBlockModel();
        if (model != null) {
            pack.addModel(this.getBlockModelId(), model);
        }
    }

    @Override
    @PreferredEnvironment(value=EnvType.CLIENT)
    @Contract(pure=true)
    default public ResourceLocation getItemModelId() {
        ResourceLocation itemId = this.getItemId();
        if (itemId == null) {
            return null;
        }
        return itemId.brrp_prefixed("item/");
    }

    @Override
    @PreferredEnvironment(value=EnvType.CLIENT)
    @Contract(pure=true)
    default public ModelJsonBuilder getItemModel() {
        return ModelJsonBuilder.create(this.getBlockModelId());
    }

    @Override
    @PreferredEnvironment(value=EnvType.CLIENT)
    @Contract(mutates="param1")
    default public void writeItemModel(RuntimeResourcePack pack) {
        ModelJsonBuilder model;
        ResourceLocation itemModelId = this.getItemModelId();
        if (itemModelId != null && (model = this.getItemModel()) != null) {
            pack.addModel(itemModelId, model);
        }
    }

    @Override
    @PreferredEnvironment(value=EnvType.CLIENT)
    @Contract(mutates="param1")
    default public void writeAssets(RuntimeResourcePack pack) {
        this.writeBlockStates(pack);
        this.writeBlockModel(pack);
        this.writeItemModel(pack);
    }

    @Contract(pure=true)
    @ApiStatus.NonExtendable
    default public ResourceLocation getLootTableId() {
        return this.getBlockId().brrp_prefixed("blocks/");
    }

    @Deprecated(forRemoval=true)
    @Contract(pure=true)
    default public LootTable.Builder getLootTable() {
        return new BRRPBlockLootTableGenerator(null).createSingleItemTable((ItemLike)this);
    }

    @ApiStatus.AvailableSince(value="1.0.4")
    @Contract(pure=true)
    default public LootTable.Builder getLootTable(BlockLootSubProvider blockLootTableGenerator) {
        try {
            Method method = this.getClass().getMethod("getLootTable", new Class[0]);
            if (method.getDeclaringClass() != BlockResourceGenerator.class) {
                method.setAccessible(true);
                RuntimeResourcePack.LOGGER.warn("Runtime Resource Pack: Using deprecated 'getLootTable()' method for object {}!", (Object)this);
                return (LootTable.Builder)method.invoke((Object)this, new Object[0]);
            }
        }
        catch (ClassCastException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            RuntimeResourcePack.LOGGER.warn("Runtime Resource Pack: Cannot find deprecated method 'getLootTable' for {}:", (Object)this, (Object)e);
        }
        return blockLootTableGenerator.createSingleItemTable((ItemLike)this);
    }

    @Contract(mutates="param1")
    default public void writeLootTable(RuntimeResourcePack pack) {
        ResourceLocation lootTableId = this.getLootTableId();
        if (lootTableId.equals((Object)BuiltInLootTables.EMPTY.location())) {
            return;
        }
        LootTable.Builder lootTable = this.getLootTable(pack.getBlockLootTableGenerator());
        if (lootTable != null) {
            pack.addLootTable(lootTableId, lootTable);
        }
    }

    @Contract(pure=true)
    default public SingleItemRecipeBuilder getStonecuttingRecipe() {
        return null;
    }

    @Contract(pure=true)
    default public boolean shouldWriteStonecuttingRecipe() {
        return false;
    }

    @Override
    default public void writeRecipes(RuntimeResourcePack pack) {
        SingleItemRecipeBuilder stonecuttingRecipe;
        ItemResourceGenerator.super.writeRecipes(pack);
        if (this.shouldWriteStonecuttingRecipe() && (stonecuttingRecipe = this.getStonecuttingRecipe()) != null) {
            pack.addRecipeAndAdvancement(this.getStonecuttingRecipeId(), (RecipeBuilder)stonecuttingRecipe);
        }
    }

    @NotNull
    @Contract(pure=true)
    default public ResourceLocation getStonecuttingRecipeId() {
        return this.getRecipeId().brrp_suffixed("_from_stonecutting");
    }

    @Override
    default public void writeData(RuntimeResourcePack pack) {
        this.writeLootTable(pack);
        this.writeRecipes(pack);
    }
}

