/*
 * Decompiled with CFR 0.152.
 */
package pers.solid.brrp.v1.generator;

import com.mojang.serialization.MapCodec;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.data.models.BlockModelGenerators;
import net.minecraft.data.models.blockstates.BlockStateGenerator;
import net.minecraft.data.models.model.ModelTemplates;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnknownNullability;
import pers.solid.brrp.v1.BRRPUtils;
import pers.solid.brrp.v1.api.RuntimeResourcePack;
import pers.solid.brrp.v1.generator.BlockResourceGenerator;
import pers.solid.brrp.v1.model.ModelJsonBuilder;
import pers.solid.brrp.v1.model.ModelUtils;

public class BRRPWallBlock
extends WallBlock
implements BlockResourceGenerator {
    public static final MapCodec<BRRPWallBlock> CODEC = BRRPUtils.createCodecWithBaseBlock(BRRPWallBlock.propertiesCodec(), BRRPWallBlock::new);
    @Nullable
    public final Block baseBlock;

    public BRRPWallBlock(@Nullable Block baseBlock, BlockBehaviour.Properties settings) {
        super(settings);
        this.baseBlock = baseBlock;
    }

    public BRRPWallBlock(@NotNull Block baseBlock) {
        this(baseBlock, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)baseBlock));
    }

    @Override
    @Nullable
    public Block getBaseBlock() {
        return this.baseBlock;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public BlockStateGenerator getBlockStates() {
        ResourceLocation blockModelId = this.getBlockModelId();
        return BlockModelGenerators.createWall((Block)this, (ResourceLocation)ModelUtils.appendVariant(blockModelId, ModelTemplates.WALL_POST), (ResourceLocation)ModelUtils.appendVariant(blockModelId, ModelTemplates.WALL_LOW_SIDE), (ResourceLocation)ModelUtils.appendVariant(blockModelId, ModelTemplates.WALL_TALL_SIDE));
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public ModelJsonBuilder getBlockModel() {
        return ModelUtils.createModelWithVariants(this, ModelTemplates.WALL_POST);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void writeBlockModel(RuntimeResourcePack pack) {
        ResourceLocation blockModelId = this.getBlockModelId();
        @UnknownNullability ModelJsonBuilder blockModel = this.getBlockModel();
        ModelUtils.writeModelsWithVariants(pack, blockModelId, blockModel, ModelTemplates.WALL_POST, ModelTemplates.WALL_LOW_SIDE, ModelTemplates.WALL_TALL_SIDE);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public ModelJsonBuilder getItemModel() {
        return ModelUtils.createModelWithVariants(this, ModelTemplates.WALL_INVENTORY);
    }

    @Override
    public RecipeBuilder getCraftingRecipe() {
        return this.baseBlock == null ? null : RecipeProvider.wallBuilder((RecipeCategory)this.getRecipeCategory(), (ItemLike)this, (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{this.baseBlock})).unlockedBy(RecipeProvider.getHasName((ItemLike)this.baseBlock), RecipeProvider.has((ItemLike)this.baseBlock));
    }

    @Override
    public RecipeCategory getRecipeCategory() {
        return (RecipeCategory)ITEM_TO_RECIPE_CATEGORY.getOrDefault((Object)this.asItem(), (Object)RecipeCategory.DECORATIONS);
    }

    public MapCodec<WallBlock> codec() {
        return CODEC;
    }
}

