/*
 * Decompiled with CFR 0.152.
 */
package pers.solid.brrp.v1.generator;

import com.mojang.serialization.MapCodec;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.data.models.BlockModelGenerators;
import net.minecraft.data.models.blockstates.BlockStateGenerator;
import net.minecraft.data.models.model.ModelTemplates;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import pers.solid.brrp.v1.BRRPUtils;
import pers.solid.brrp.v1.api.RuntimeResourcePack;
import pers.solid.brrp.v1.generator.BlockResourceGenerator;
import pers.solid.brrp.v1.model.ModelJsonBuilder;
import pers.solid.brrp.v1.model.ModelUtils;

public class BRRPStairsBlock
extends StairBlock
implements BlockResourceGenerator {
    public static final MapCodec<BRRPStairsBlock> CODEC = BRRPUtils.createCodecWithBaseBlock(BRRPStairsBlock.propertiesCodec(), BRRPStairsBlock::new);
    @NotNull
    public final Block baseBlock;

    public BRRPStairsBlock(@NotNull BlockState baseBlockState, BlockBehaviour.Properties settings) {
        super(baseBlockState, settings);
        this.baseBlock = baseBlockState.getBlock();
    }

    public BRRPStairsBlock(@NotNull Block baseBlock, BlockBehaviour.Properties settings) {
        super(baseBlock.defaultBlockState(), settings);
        this.baseBlock = baseBlock;
    }

    public BRRPStairsBlock(Block baseBlock) {
        this(baseBlock, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)baseBlock));
    }

    @Override
    @NotNull
    public Block getBaseBlock() {
        return this.baseBlock;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public BlockStateGenerator getBlockStates() {
        ResourceLocation blockModelId = this.getBlockModelId();
        return BlockModelGenerators.createStairs((Block)this, (ResourceLocation)ModelUtils.appendVariant(blockModelId, ModelTemplates.STAIRS_INNER), (ResourceLocation)blockModelId, (ResourceLocation)ModelUtils.appendVariant(blockModelId, ModelTemplates.STAIRS_OUTER));
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public ModelJsonBuilder getBlockModel() {
        return ModelUtils.createModelWithVariants(this, ModelTemplates.STAIRS_STRAIGHT);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void writeBlockModel(RuntimeResourcePack pack) {
        ModelJsonBuilder blockModel = this.getBlockModel();
        ResourceLocation id = this.getBlockModelId();
        ModelUtils.writeModelsWithVariants(pack, id, blockModel, ModelTemplates.STAIRS_STRAIGHT, ModelTemplates.STAIRS_INNER, ModelTemplates.STAIRS_OUTER);
    }

    @Override
    public RecipeBuilder getCraftingRecipe() {
        return (RecipeBuilder)ShapedRecipeBuilder.shaped((RecipeCategory)this.getRecipeCategory(), (ItemLike)this, (int)4).define(Character.valueOf('#'), (ItemLike)this.baseBlock).pattern("#  ").pattern("## ").pattern("###").criterionFromItem((ItemLike)this.baseBlock);
    }

    @Override
    public RecipeCategory getRecipeCategory() {
        return (RecipeCategory)ITEM_TO_RECIPE_CATEGORY.getOrDefault((Object)this.asItem(), (Object)RecipeCategory.BUILDING_BLOCKS);
    }

    public MapCodec<? extends BRRPStairsBlock> codec() {
        return CODEC;
    }
}

