/*
 * Decompiled with CFR 0.152.
 */
package pers.solid.brrp.v1.generator;

import com.mojang.serialization.MapCodec;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.data.models.BlockModelGenerators;
import net.minecraft.data.models.blockstates.BlockStateGenerator;
import net.minecraft.data.models.model.ModelTemplates;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.storage.loot.LootTable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pers.solid.brrp.v1.BRRPUtils;
import pers.solid.brrp.v1.api.RuntimeResourcePack;
import pers.solid.brrp.v1.generator.BlockResourceGenerator;
import pers.solid.brrp.v1.model.ModelJsonBuilder;
import pers.solid.brrp.v1.model.ModelUtils;

public class BRRPSlabBlock
extends SlabBlock
implements BlockResourceGenerator {
    public static final MapCodec<BRRPSlabBlock> CODEC = BRRPUtils.createCodecWithBaseBlock(BRRPSlabBlock.propertiesCodec(), BRRPSlabBlock::new);
    @Nullable
    public final Block baseBlock;

    public BRRPSlabBlock(@NotNull Block baseBlock) {
        this(baseBlock, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)baseBlock));
    }

    public BRRPSlabBlock(@Nullable Block baseBlock, BlockBehaviour.Properties settings) {
        super(settings);
        this.baseBlock = baseBlock;
    }

    public BRRPSlabBlock(BlockBehaviour.Properties settings) {
        this(null, settings);
    }

    @Override
    @Nullable
    public Block getBaseBlock() {
        return this.baseBlock;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public BlockStateGenerator getBlockStates() {
        ResourceLocation id = this.getBlockModelId();
        ResourceLocation baseBlockModelId = this.baseBlock != null ? BRRPUtils.getBlockModelId(this.baseBlock) : id.brrp_suffixed("_double");
        ResourceLocation topSlabModelId = id.brrp_suffixed("_top");
        return BlockModelGenerators.createSlab((Block)this, (ResourceLocation)id, (ResourceLocation)topSlabModelId, (ResourceLocation)baseBlockModelId);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public ModelJsonBuilder getBlockModel() {
        return ModelUtils.createModelWithVariants(this, ModelTemplates.SLAB_BOTTOM);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void writeBlockModel(RuntimeResourcePack pack) {
        ModelJsonBuilder model = this.getBlockModel();
        ResourceLocation id = this.getBlockModelId();
        ModelUtils.writeModelsWithVariants(pack, id, model, ModelTemplates.SLAB_BOTTOM, ModelTemplates.SLAB_TOP);
        if (this.baseBlock == null) {
            pack.addModel(id.brrp_suffixed("_double"), model.withParent(ModelTemplates.CUBE_BOTTOM_TOP));
        }
    }

    @Override
    public LootTable.Builder getLootTable(BlockLootSubProvider blockLootTableGenerator) {
        return blockLootTableGenerator.createSlabItemTable((Block)this);
    }

    @Override
    public RecipeBuilder getCraftingRecipe() {
        return this.baseBlock == null ? null : RecipeProvider.slabBuilder((RecipeCategory)this.getRecipeCategory(), (ItemLike)this, (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{this.baseBlock})).unlockedBy(RecipeProvider.getHasName((ItemLike)this.baseBlock), RecipeProvider.has((ItemLike)this.baseBlock));
    }

    @Override
    public RecipeCategory getRecipeCategory() {
        return (RecipeCategory)ITEM_TO_RECIPE_CATEGORY.getOrDefault((Object)this.asItem(), (Object)RecipeCategory.BUILDING_BLOCKS);
    }

    public MapCodec<? extends BRRPSlabBlock> codec() {
        return CODEC;
    }
}

