/*
 * Decompiled with CFR 0.152.
 */
package pers.solid.brrp.v1.generator;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.models.BlockModelGenerators;
import net.minecraft.data.models.blockstates.BlockStateGenerator;
import net.minecraft.data.models.model.ModelTemplates;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.WoodType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnknownNullability;
import pers.solid.brrp.v1.api.RuntimeResourcePack;
import pers.solid.brrp.v1.generator.BlockResourceGenerator;
import pers.solid.brrp.v1.model.ModelJsonBuilder;
import pers.solid.brrp.v1.model.ModelUtils;

public class BRRPFenceGateBlock
extends FenceGateBlock
implements BlockResourceGenerator {
    public static final MapCodec<BRRPFenceGateBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BuiltInRegistries.BLOCK.byNameCodec().fieldOf("base_block").forGetter(BRRPFenceGateBlock::getBaseBlock), (App)BRRPFenceGateBlock.propertiesCodec(), (App)WoodType.CODEC.fieldOf("wood_type").forGetter(o -> o.type)).apply((Applicative)instance, BRRPFenceGateBlock::new));
    @Nullable
    public final Block baseBlock;
    private final WoodType type;

    public BRRPFenceGateBlock(@Nullable Block baseBlock, BlockBehaviour.Properties settings, WoodType woodType) {
        super(woodType, settings);
        this.baseBlock = baseBlock;
        this.type = woodType;
    }

    public BRRPFenceGateBlock(@NotNull Block baseBlock, WoodType woodType) {
        this(baseBlock, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)baseBlock), woodType);
    }

    @Override
    @Nullable
    public Block getBaseBlock() {
        return this.baseBlock;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public BlockStateGenerator getBlockStates() {
        ResourceLocation blockModelId = this.getBlockModelId();
        return BlockModelGenerators.createFenceGate((Block)this, (ResourceLocation)ModelUtils.appendVariant(blockModelId, ModelTemplates.FENCE_GATE_OPEN), (ResourceLocation)ModelUtils.appendVariant(blockModelId, ModelTemplates.FENCE_GATE_CLOSED), (ResourceLocation)ModelUtils.appendVariant(blockModelId, ModelTemplates.FENCE_GATE_WALL_OPEN), (ResourceLocation)ModelUtils.appendVariant(blockModelId, ModelTemplates.FENCE_GATE_WALL_CLOSED), (boolean)true);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public ModelJsonBuilder getBlockModel() {
        return ModelUtils.createModelWithVariants(this, ModelTemplates.FENCE_GATE_CLOSED);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void writeBlockModel(RuntimeResourcePack pack) {
        @UnknownNullability ModelJsonBuilder blockModel = this.getBlockModel();
        ResourceLocation blockModelId = this.getBlockModelId();
        ModelUtils.writeModelsWithVariants(pack, blockModelId, blockModel, ModelTemplates.FENCE_GATE_CLOSED, ModelTemplates.FENCE_GATE_OPEN, ModelTemplates.FENCE_GATE_WALL_CLOSED, ModelTemplates.FENCE_GATE_WALL_OPEN);
    }

    @Override
    public RecipeBuilder getCraftingRecipe() {
        Item secondIngredient = this.getSecondIngredient();
        return this.baseBlock == null || secondIngredient == null ? null : (RecipeBuilder)ShapedRecipeBuilder.shaped((RecipeCategory)this.getRecipeCategory(), (ItemLike)this).define(Character.valueOf('#'), (ItemLike)secondIngredient).define(Character.valueOf('W'), (ItemLike)this.baseBlock).pattern("#W#").pattern("#W#").criterionFromItem((ItemLike)this.baseBlock);
    }

    @Override
    public RecipeCategory getRecipeCategory() {
        return (RecipeCategory)ITEM_TO_RECIPE_CATEGORY.getOrDefault((Object)this.asItem(), (Object)RecipeCategory.REDSTONE);
    }

    @Nullable
    public Item getSecondIngredient() {
        return Items.STICK;
    }

    public MapCodec<FenceGateBlock> codec() {
        return CODEC;
    }
}

