/*
 * Decompiled with CFR 0.152.
 */
package pers.solid.brrp.v1.generator;

import com.mojang.serialization.MapCodec;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.data.models.BlockModelGenerators;
import net.minecraft.data.models.blockstates.BlockStateGenerator;
import net.minecraft.data.models.model.ModelTemplates;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pers.solid.brrp.v1.BRRPUtils;
import pers.solid.brrp.v1.api.RuntimeResourcePack;
import pers.solid.brrp.v1.generator.BlockResourceGenerator;
import pers.solid.brrp.v1.model.ModelJsonBuilder;
import pers.solid.brrp.v1.model.ModelUtils;

public class BRRPFenceBlock
extends FenceBlock
implements BlockResourceGenerator {
    public static final MapCodec<BRRPFenceBlock> CODEC = BRRPUtils.createCodecWithBaseBlock(BRRPFenceBlock.propertiesCodec(), BRRPFenceBlock::new);
    @Nullable
    public final Block baseBlock;

    public BRRPFenceBlock(@Nullable Block baseBlock, BlockBehaviour.Properties settings) {
        super(settings);
        this.baseBlock = baseBlock;
    }

    public BRRPFenceBlock(@NotNull Block baseBlock) {
        this(baseBlock, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)baseBlock));
    }

    @Override
    @Nullable
    public Block getBaseBlock() {
        return this.baseBlock;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public BlockStateGenerator getBlockStates() {
        ResourceLocation blockModelId = this.getBlockModelId();
        return BlockModelGenerators.createFence((Block)this, (ResourceLocation)blockModelId.brrp_suffixed("_post"), (ResourceLocation)blockModelId.brrp_suffixed("_side"));
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public ModelJsonBuilder getBlockModel() {
        return ModelUtils.createModelWithVariants(this, ModelTemplates.FENCE_POST);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void writeBlockModel(RuntimeResourcePack pack) {
        @NotNull ModelJsonBuilder blockModel = this.getBlockModel();
        ResourceLocation blockModelId = this.getBlockModelId();
        ModelUtils.writeModelsWithVariants(pack, blockModelId, blockModel, ModelTemplates.FENCE_POST, ModelTemplates.FENCE_SIDE);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public ModelJsonBuilder getItemModel() {
        return this.getBlockModel().parent(ModelTemplates.FENCE_INVENTORY);
    }

    @Override
    public RecipeBuilder getCraftingRecipe() {
        Item secondIngredient = this.getSecondIngredient();
        return this.baseBlock == null || secondIngredient == null ? null : (RecipeBuilder)ShapedRecipeBuilder.shaped((RecipeCategory)this.getRecipeCategory(), (ItemLike)this, (int)3).pattern("W#W").pattern("W#W").define(Character.valueOf('W'), (ItemLike)this.baseBlock).define(Character.valueOf('#'), (ItemLike)secondIngredient).criterionFromItem((ItemLike)this.baseBlock);
    }

    @Nullable
    public Item getSecondIngredient() {
        return Items.STICK;
    }

    @Override
    public RecipeCategory getRecipeCategory() {
        return (RecipeCategory)ITEM_TO_RECIPE_CATEGORY.getOrDefault((Object)this.asItem(), (Object)RecipeCategory.DECORATIONS);
    }

    public MapCodec<FenceBlock> codec() {
        return CODEC;
    }
}

