/*
 * Decompiled with CFR 0.152.
 */
package pers.solid.brrp.v1.generator;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.data.models.BlockModelGenerators;
import net.minecraft.data.models.blockstates.BlockStateGenerator;
import net.minecraft.data.models.model.ModelTemplates;
import net.minecraft.data.models.model.TextureMapping;
import net.minecraft.data.models.model.TextureSlot;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import org.jetbrains.annotations.NotNull;
import pers.solid.brrp.v1.generator.BlockResourceGenerator;
import pers.solid.brrp.v1.generator.TextureRegistry;
import pers.solid.brrp.v1.model.ModelJsonBuilder;
import pers.solid.brrp.v1.model.ModelUtils;

public class BRRPCubeBlock
extends Block
implements BlockResourceGenerator {
    public static final MapCodec<BRRPCubeBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BRRPCubeBlock.propertiesCodec(), (App)ResourceLocation.CODEC.fieldOf("parent").forGetter(o -> o.parent)).apply((Applicative)instance, (settings1, identifier) -> new BRRPCubeBlock((BlockBehaviour.Properties)settings1, (ResourceLocation)identifier, new TextureMapping())));
    public final ResourceLocation parent;
    public final TextureMapping textures;

    public BRRPCubeBlock(BlockBehaviour.Properties settings, ResourceLocation parent, TextureMapping textures) {
        super(settings);
        this.parent = parent;
        this.textures = textures;
    }

    public static BRRPCubeBlock cubeAll(BlockBehaviour.Properties settings, ResourceLocation allTexture) {
        return new BRRPCubeBlock(settings, ModelUtils.getId(ModelTemplates.CUBE_ALL), TextureMapping.cube((ResourceLocation)allTexture));
    }

    public static BRRPCubeBlock cubeBottomTop(BlockBehaviour.Properties settings, ResourceLocation topTexture, ResourceLocation sideTexture, ResourceLocation bottomTexture) {
        return new BRRPCubeBlock(settings, ModelUtils.getId(ModelTemplates.CUBE_BOTTOM_TOP), new TextureMapping().put(TextureSlot.TOP, topTexture).put(TextureSlot.SIDE, sideTexture).put(TextureSlot.BOTTOM, bottomTexture));
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public BlockStateGenerator getBlockStates() {
        return BlockModelGenerators.createSimpleBlock((Block)this.asBlock(), (ResourceLocation)this.getBlockModelId());
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public ModelJsonBuilder getBlockModel() {
        return ModelJsonBuilder.create(this.parent).setTextures(this.textures);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    @NotNull
    public ResourceLocation getTextureId(@NotNull TextureSlot textureKey) {
        ResourceLocation texture = TextureRegistry.getTexture(this, textureKey);
        if (texture != null) {
            return texture;
        }
        for (TextureSlot textureKey0 = textureKey; textureKey0 != null; textureKey0 = textureKey0.getParent()) {
            ResourceLocation texture0 = this.textures.get(textureKey0);
            if (texture0 == null) continue;
            return texture0;
        }
        return BlockResourceGenerator.super.getTextureId(textureKey);
    }

    @Override
    public RecipeCategory getRecipeCategory() {
        return (RecipeCategory)ITEM_TO_RECIPE_CATEGORY.getOrDefault((Object)this.asItem(), (Object)RecipeCategory.BUILDING_BLOCKS);
    }

    protected MapCodec<? extends BRRPCubeBlock> codec() {
        return CODEC;
    }
}

