/*
 * Decompiled with CFR 0.152.
 */
package pers.solid.brrp.v1.api;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.datafixers.util.Either;
import com.mojang.logging.LogUtils;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.Future;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.IntUnaryOperator;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.client.resources.metadata.animation.AnimationMetadataSection;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.data.models.blockstates.BlockStateGenerator;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.SmithingTransformRecipeBuilder;
import net.minecraft.data.recipes.SmithingTrimRecipeBuilder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.tags.TagBuilder;
import net.minecraft.tags.TagFile;
import net.minecraft.tags.TagKey;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.storage.loot.LootTable;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.lang3.function.FailableFunction;
import org.apache.commons.lang3.function.FailableRunnable;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.slf4j.Logger;
import pers.solid.brrp.v1.JsonSerializers;
import pers.solid.brrp.v1.api.JsonSerializable;
import pers.solid.brrp.v1.api.LanguageProvider;
import pers.solid.brrp.v1.impl.BRRPBlockLootTableGenerator;
import pers.solid.brrp.v1.impl.RuntimeResourcePackImpl;
import pers.solid.brrp.v1.model.ModelJsonBuilder;
import pers.solid.brrp.v1.tag.IdentifiedTagBuilder;

public interface RuntimeResourcePack
extends PackResources {
    public static final Path DEFAULT_OUTPUT = Paths.get("rrp.debug", new String[0]);
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().enableComplexMapKeySerialization().registerTypeHierarchyAdapter(LootTable.class, JsonSerializers.forCodec(LootTable.DIRECT_CODEC)).registerTypeHierarchyAdapter(Advancement.class, JsonSerializers.forCodec(Advancement.CODEC)).registerTypeHierarchyAdapter(TagFile.class, JsonSerializers.forCodec(TagFile.CODEC)).registerTypeHierarchyAdapter(Recipe.class, JsonSerializers.forCodec(Recipe.CODEC)).registerTypeHierarchyAdapter(JsonSerializable.class, JsonSerializable.SERIALIZER).registerTypeHierarchyAdapter(ResourceLocation.class, (Object)new ResourceLocation.Serializer()).registerTypeHierarchyAdapter(StringRepresentable.class, JsonSerializers.STRING_IDENTIFIABLE).registerTypeHierarchyAdapter(Vector3f.class, JsonSerializers.VECTOR_3F).registerTypeHierarchyAdapter(Either.class, JsonSerializers.EITHER).setPrettyPrinting().create();
    public static final Logger LOGGER = LogUtils.getLogger();

    @Contract(value="_ -> new")
    public static RuntimeResourcePack create(ResourceLocation id) {
        return new RuntimeResourcePackImpl(id);
    }

    @Contract(value="_, _ -> new")
    public static RuntimeResourcePack create(ResourceLocation id, @NotNull HolderLookup.Provider registryLookup) {
        return new RuntimeResourcePackImpl(id, registryLookup);
    }

    public static byte[] serialize(Object object, @NotNull Gson gson) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)stream, StandardCharsets.UTF_8);
        gson.toJson(object, (Appendable)writer);
        try {
            writer.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return stream.toByteArray();
    }

    public static byte[] defaultSerialize(Object object) {
        return RuntimeResourcePack.serialize(object, GSON);
    }

    default public byte[] serialize(Object object) {
        return RuntimeResourcePack.defaultSerialize(object);
    }

    @Contract(pure=true)
    public int getPackVersion();

    @Contract(mutates="this")
    public void setPackVersion(int var1);

    @Contract(mutates="this")
    public void setAllowsDuplicateResource(boolean var1);

    @ApiStatus.Experimental
    @Contract(mutates="this")
    public void addRecoloredImage(ResourceLocation var1, InputStream var2, IntUnaryOperator var3);

    @Contract(mutates="this")
    public byte[] addLang(ResourceLocation var1, byte[] var2);

    @Contract(mutates="this")
    default public byte[] addLang(ResourceLocation identifier, LanguageProvider lang) {
        return this.addLang(identifier, this.serialize(lang.content()));
    }

    @Contract(mutates="this")
    public byte[] addLootTable(ResourceLocation var1, byte[] var2);

    @Contract(mutates="this")
    default public byte[] addLootTable(ResourceLocation identifier, LootTable lootTable) {
        return this.addLootTable(identifier, this.serialize(lootTable));
    }

    @Contract(mutates="this")
    default public byte[] addLootTable(ResourceLocation identifier, LootTable.Builder lootTable) {
        return this.addLootTable(identifier, lootTable.build());
    }

    @Contract(mutates="this")
    public Future<byte[]> addAsyncResource(PackType var1, ResourceLocation var2, FailableFunction<ResourceLocation, byte[], Exception> var3);

    @Contract(mutates="this")
    public void addLazyResource(PackType var1, ResourceLocation var2, BiFunction<RuntimeResourcePack, ResourceLocation, byte[]> var3);

    @Contract(mutates="this")
    public byte[] addResource(PackType var1, ResourceLocation var2, byte[] var3);

    @Contract(mutates="this")
    public Future<byte[]> addAsyncRootResource(String var1, FailableFunction<String, byte[], Exception> var2);

    @Contract(mutates="this")
    public void addLazyRootResource(String var1, BiFunction<RuntimeResourcePack, String, byte[]> var2);

    @Contract(mutates="this")
    public byte[] addRootResource(String var1, byte[] var2);

    @Contract(mutates="this")
    public byte[] addAsset(ResourceLocation var1, byte[] var2);

    @Contract(mutates="this")
    public byte[] addData(ResourceLocation var1, byte[] var2);

    @Contract(mutates="this")
    public byte[] addBlockState(ResourceLocation var1, byte[] var2);

    @Contract(mutates="this")
    default public byte[] addBlockState(ResourceLocation id, @NotNull BlockStateGenerator state) {
        return this.addBlockState(id, this.serialize(state.get()));
    }

    @Contract(mutates="this")
    public byte[] addTexture(ResourceLocation var1, BufferedImage var2);

    @Contract(mutates="this")
    public byte[] addTag(ResourceLocation var1, byte[] var2);

    @Contract(mutates="this")
    default public byte[] addTag(ResourceLocation fullId, TagBuilder tagBuilder) {
        return this.addTag(fullId, this.serialize(new TagFile(tagBuilder.build(), false)));
    }

    @Contract(mutates="this")
    public <T> byte[] addTag(TagKey<T> var1, TagBuilder var2);

    @Contract(mutates="this")
    default public <T> byte[] addTag(IdentifiedTagBuilder<T> identifiedTagBuilder) {
        return this.addTag(TagKey.create((ResourceKey)identifiedTagBuilder.registry.key(), (ResourceLocation)identifiedTagBuilder.identifier), identifiedTagBuilder);
    }

    @Contract(mutates="this")
    public byte[] addAnimation(ResourceLocation var1, byte[] var2);

    @Contract(mutates="this")
    @Environment(value=EnvType.CLIENT)
    default public byte[] addAnimation(ResourceLocation id, AnimationMetadataSection animation) {
        return this.addAnimation(id, this.serialize(animation));
    }

    @Contract(mutates="this")
    public byte[] addRecipe(ResourceLocation var1, byte[] var2);

    @Contract(mutates="this")
    default public byte[] addRecipe(ResourceLocation id, Recipe<?> recipe) {
        return this.addRecipe(id, this.serialize(recipe));
    }

    @Contract(mutates="this")
    default public byte[] addRecipe(@NotNull RecipeHolder<?> recipeEntry) {
        return this.addRecipe(recipeEntry.id(), recipeEntry.value());
    }

    default public RecipeOutput getRecipeExporter() {
        return new RecipeOutput(){

            public void accept(ResourceLocation recipeId, Recipe<?> recipe, @Nullable AdvancementHolder advancement) {
                RuntimeResourcePack.this.addRecipe(recipeId, recipe);
                if (advancement != null) {
                    RuntimeResourcePack.this.addAdvancement(advancement);
                }
            }

            public Advancement.Builder advancement() {
                return Advancement.Builder.recipeAdvancement().parent(new AdvancementHolder(RecipeBuilder.ROOT_RECIPE_ADVANCEMENT, null));
            }
        };
    }

    @Contract(mutates="this")
    default public void addRecipeAndAdvancement(ResourceLocation recipeId, @NotNull RecipeBuilder recipeJsonBuilder) {
        recipeJsonBuilder.save(this.getRecipeExporter(), recipeId);
    }

    @Contract(mutates="this")
    default public void addRecipeAndAdvancement(ResourceLocation recipeId, @NotNull SmithingTransformRecipeBuilder recipeJsonBuilder) {
        recipeJsonBuilder.save(this.getRecipeExporter(), recipeId);
    }

    @Contract(mutates="this")
    default public void addRecipeAndAdvancement(ResourceLocation recipeId, @NotNull SmithingTrimRecipeBuilder recipeJsonBuilder) {
        recipeJsonBuilder.save(this.getRecipeExporter(), recipeId);
    }

    @Contract(mutates="this")
    default public byte[] addModel(ResourceLocation id, ModelJsonBuilder model) {
        return this.addModel(id, this.serialize(model));
    }

    @Contract(mutates="this")
    public byte[] addModel(ResourceLocation var1, byte[] var2);

    @Contract(mutates="this")
    default public byte[] addAdvancement(ResourceLocation id, Advancement.Builder advancement) {
        return this.addAdvancement(id, this.serialize(advancement.build(id).value()));
    }

    default public byte[] addAdvancement(ResourceLocation id, Advancement advancement) {
        return this.addAdvancement(id, this.serialize(advancement));
    }

    default public byte[] addAdvancement(@NotNull AdvancementHolder advancementEntry) {
        return this.addAdvancement(advancementEntry.id(), advancementEntry.value());
    }

    @Contract(mutates="this")
    public byte[] addAdvancement(ResourceLocation var1, byte[] var2);

    public Future<?> async(Consumer<RuntimeResourcePack> var1);

    default public void dumpToDefaultPath() {
        this.dump(DEFAULT_OUTPUT);
    }

    @Contract(mutates="param3")
    public void dumpInPath(Path var1, @Nullable PackType var2, int @Nullable [] var3);

    public void load(Path var1) throws IOException;

    public void load(ZipInputStream var1) throws IOException;

    default public void dump(@NotNull Path path) {
        String id = this.packId();
        this.dumpInPath(path.resolve(id.replace(':', '/')), null, null);
    }

    public void dump(ZipOutputStream var1) throws IOException;

    @Contract(pure=true)
    default public boolean hasRegenerationCallback() {
        return this.hasSidedRegenerationCallback(PackType.CLIENT_RESOURCES) || this.hasSidedRegenerationCallback(PackType.SERVER_DATA) || this.hasSidedRegenerationCallback(null);
    }

    @Contract(pure=true)
    public boolean hasSidedRegenerationCallback(@Nullable PackType var1);

    @Contract(mutates="this")
    public void setRegenerationCallback(FailableRunnable<InterruptedException> var1);

    @Contract(mutates="this")
    public void setSidedRegenerationCallback(@NotNull PackType var1, FailableRunnable<InterruptedException> var2);

    public void regenerate() throws InterruptedException;

    public void regenerateSided(@NotNull PackType var1) throws InterruptedException;

    @Contract(pure=true)
    public String packId();

    @Contract(mutates="this")
    public void clearResources(PackType var1);

    @Contract(mutates="this")
    public void clearResources();

    @Contract(mutates="this")
    public void clearRootResources();

    @Contract(pure=true)
    default public Component getDisplayName() {
        return Component.translatable((String)"brrp.pack.defaultName", (Object[])new Object[]{this.packId()});
    }

    @Contract(mutates="this")
    public void setDisplayName(Component var1);

    @Contract(pure=true)
    @Nullable
    public Component getDescription();

    @Contract(mutates="this")
    public void setDescription(Component var1);

    @Contract(pure=true)
    public int numberOfClientResources();

    @Contract(pure=true)
    public int numberOfServerData();

    @Contract(pure=true)
    public int numberOfRootResources();

    @Contract(pure=true)
    public HolderLookup.Provider getRegistryLookup();

    @Contract(pure=true)
    default public BlockLootSubProvider getBlockLootTableGenerator() {
        return new BRRPBlockLootTableGenerator(this.getRegistryLookup());
    }
}

