/*
 * Decompiled with CFR 0.152.
 */
package pers.solid.brrp.v1.api;

import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.Util;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.stats.StatType;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public interface LanguageProvider {
    @Contract(value="-> new")
    public static Impl<HashMap<String, String>> create() {
        return new Impl<HashMap<String, String>>(new HashMap());
    }

    @Contract(value="-> new")
    public static Impl<TreeMap<String, String>> createSorted() {
        return new Impl<TreeMap<String, String>>(new TreeMap());
    }

    @Contract(value="_ -> new")
    public static <T extends Map<String, String>> Impl<T> create(T content) {
        return new Impl<T>(content);
    }

    @Contract(mutates="this", value="_, _ -> this")
    public LanguageProvider add(@NotNull String var1, String var2);

    public Map<String, String> content();

    @Contract(mutates="this", value="_, _ -> this")
    default public LanguageProvider add(@NotNull Item item, String value) {
        return this.add(item.getDescriptionId(), value);
    }

    @Contract(mutates="this", value="_, _ -> this")
    default public LanguageProvider add(@NotNull Block block, String value) {
        return this.add(block.getDescriptionId(), value);
    }

    default public LanguageProvider add(@NotNull CreativeModeTab group, String value) {
        ComponentContents content = group.getDisplayName().getContents();
        if (content instanceof TranslatableContents) {
            TranslatableContents translatableTextContent = (TranslatableContents)content;
            return this.add(translatableTextContent.getKey(), value);
        }
        throw new UnsupportedOperationException("Cannot add language entry for ItemGroup (%s) as the display name is not translatable.".formatted(group.getDisplayName().getString()));
    }

    @Contract(mutates="this", value="_, _ -> this")
    default public LanguageProvider add(EntityType<?> entityType, String value) {
        return this.add(entityType.getDescriptionId(), value);
    }

    @Contract(mutates="this", value="_, _ -> this")
    default public LanguageProvider add(@NotNull ResourceKey<Enchantment> enchantment, String value) {
        return this.add(Util.makeDescriptionId((String)"enchantment", (ResourceLocation)enchantment.location()), value);
    }

    @Contract(mutates="this", value="_, _ -> this")
    default public LanguageProvider add(@NotNull Attribute entityAttribute, String value) {
        return this.add(entityAttribute.getDescriptionId(), value);
    }

    @Contract(mutates="this", value="_, _ -> this")
    default public LanguageProvider add(@NotNull StatType<?> statType, String value) {
        return this.add("stat_type." + BuiltInRegistries.STAT_TYPE.getKey(statType).toString().replace(':', '.'), value);
    }

    @Contract(mutates="this", value="_, _ -> this")
    default public LanguageProvider add(MobEffect statusEffect, String value) {
        return this.add(statusEffect.getDescriptionId(), value);
    }

    @Contract(mutates="this", value="_, _ -> this")
    default public LanguageProvider add(@NotNull ResourceLocation identifier, String value) {
        return this.add(identifier.toLanguageKey(), value);
    }

    @Contract(mutates="this", value="_ -> this")
    public LanguageProvider addAll(@NotNull Map<String, String> var1);

    @Contract(mutates="this", value="_ -> this")
    default public LanguageProvider addAll(LanguageProvider another) {
        return this.addAll(another.content());
    }

    @ApiStatus.Internal
    public record Impl<T extends Map<String, String>>(T content) implements LanguageProvider
    {
        @Override
        public Impl<T> add(@NotNull String key, String value) {
            this.content.put((String)key, (String)value);
            return this;
        }

        @Override
        public Impl<T> addAll(@NotNull Map<String, String> map) {
            this.content.putAll(map);
            return this;
        }
    }
}

