/*
 * Decompiled with CFR 0.152.
 */
package pers.solid.brrp.v1;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.BiFunction;
import net.fabricmc.api.EnvType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.models.model.ModelLocationUtils;
import net.minecraft.data.models.model.TextureSlot;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import pers.solid.brrp.v1.annotations.PreferredEnvironment;
import pers.solid.brrp.v1.generator.BlockResourceGenerator;
import pers.solid.brrp.v1.generator.ItemResourceGenerator;
import pers.solid.brrp.v1.generator.TextureRegistry;

public final class BRRPUtils {
    private BRRPUtils() {
    }

    @Contract(pure=true)
    public static ResourceLocation getItemId(@NotNull ItemLike item) {
        ResourceLocation resourceLocation;
        if (item instanceof ItemResourceGenerator) {
            ItemResourceGenerator generator = (ItemResourceGenerator)item;
            resourceLocation = generator.getItemId();
        } else {
            resourceLocation = BuiltInRegistries.ITEM.getKey((Object)item.asItem());
        }
        return resourceLocation;
    }

    @Contract(pure=true)
    @PreferredEnvironment(value=EnvType.CLIENT)
    public static ResourceLocation getItemModelId(@NotNull ItemLike item) {
        ResourceLocation resourceLocation;
        if (item instanceof ItemResourceGenerator) {
            ItemResourceGenerator generator = (ItemResourceGenerator)item;
            resourceLocation = generator.getItemModelId();
        } else {
            resourceLocation = ModelLocationUtils.getModelLocation((Item)item.asItem());
        }
        return resourceLocation;
    }

    public static ResourceLocation getBlockId(@NotNull Block block) {
        ResourceLocation resourceLocation;
        if (block instanceof BlockResourceGenerator) {
            BlockResourceGenerator generator = (BlockResourceGenerator)block;
            resourceLocation = generator.getBlockId();
        } else {
            resourceLocation = BuiltInRegistries.BLOCK.getKey((Object)block);
        }
        return resourceLocation;
    }

    @Contract(pure=true)
    @PreferredEnvironment(value=EnvType.CLIENT)
    public static ResourceLocation getBlockModelId(@NotNull Block block) {
        ResourceLocation resourceLocation;
        if (block instanceof BlockResourceGenerator) {
            BlockResourceGenerator generator = (BlockResourceGenerator)block;
            resourceLocation = generator.getBlockModelId();
        } else {
            resourceLocation = ModelLocationUtils.getModelLocation((Block)block);
        }
        return resourceLocation;
    }

    @Contract(pure=true)
    @PreferredEnvironment(value=EnvType.CLIENT)
    public static ResourceLocation getTextureId(@NotNull Block block, @NotNull TextureSlot textureKey) {
        if (block instanceof BlockResourceGenerator) {
            BlockResourceGenerator generator = (BlockResourceGenerator)block;
            return generator.getTextureId(textureKey);
        }
        ResourceLocation texture = TextureRegistry.getTexture(block, textureKey);
        if (texture != null) {
            return texture;
        }
        return BRRPUtils.getBlockId(block).brrp_prefixed("block/");
    }

    public static ResourceLocation getRecipeId(@NotNull ItemLike item) {
        if (item instanceof ItemResourceGenerator) {
            ItemResourceGenerator generator = (ItemResourceGenerator)item;
            return generator.getRecipeId();
        }
        return BRRPUtils.getItemId(item);
    }

    @Contract(pure=true)
    public static ResourceLocation getLootTableId(@NotNull Block block) {
        if (block instanceof BlockResourceGenerator) {
            BlockResourceGenerator generator = (BlockResourceGenerator)block;
            return generator.getLootTableId();
        }
        return BuiltInRegistries.BLOCK.getKey((Object)block).withPrefix("blocks/");
    }

    public static <B extends Block> MapCodec<B> createCodecWithBaseBlock(RecordCodecBuilder<B, BlockBehaviour.Properties> settingsCodec, BiFunction<Block, BlockBehaviour.Properties, B> function) {
        return RecordCodecBuilder.mapCodec(instance -> instance.group((App)BuiltInRegistries.BLOCK.byNameCodec().fieldOf("base_block").forGetter(rec$ -> ((BlockResourceGenerator)rec$).getBaseBlock()), (App)settingsCodec).apply((Applicative)instance, function));
    }
}

