/*
 * Decompiled with CFR 0.152.
 */
package pers.solid.brrp.v1;

import com.google.common.collect.Collections2;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.models.model.ModelTemplates;
import net.minecraft.data.models.model.TextureSlot;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.data.recipes.SingleItemRecipeBuilder;
import net.minecraft.data.recipes.SmithingTransformRecipeBuilder;
import net.minecraft.data.recipes.SmithingTrimRecipeBuilder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.function.FailableFunction;
import org.apache.commons.lang3.function.FailableRunnable;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.TestOnly;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pers.solid.brrp.v1.PlatformBridge;
import pers.solid.brrp.v1.RRPEventHelper;
import pers.solid.brrp.v1.api.LanguageProvider;
import pers.solid.brrp.v1.api.RuntimeResourcePack;
import pers.solid.brrp.v1.generator.BRRPCubeBlock;
import pers.solid.brrp.v1.generator.BRRPFenceBlock;
import pers.solid.brrp.v1.generator.BRRPFenceGateBlock;
import pers.solid.brrp.v1.generator.BRRPSlabBlock;
import pers.solid.brrp.v1.generator.BRRPStairsBlock;
import pers.solid.brrp.v1.generator.BRRPWallBlock;
import pers.solid.brrp.v1.model.ModelJsonBuilder;
import pers.solid.brrp.v1.model.ModelOverrideBuilder;
import pers.solid.brrp.v1.model.TransformationBuilder;
import pers.solid.brrp.v1.tag.IdentifiedTagBuilder;

@TestOnly
@ApiStatus.Internal
public class BRRPTest {
    private static final SoundType LAVA_SOUND_GROUP = new SoundType(1.0f, 1.0f, SoundEvents.BUCKET_EMPTY_LAVA, SoundEvents.LAVA_POP, SoundEvents.BUCKET_FILL_LAVA, SoundEvents.LAVA_POP, SoundEvents.POINTED_DRIPSTONE_DRIP_LAVA);
    public static final BRRPCubeBlock LAVA_BLOCK = BRRPTest.register(BRRPCubeBlock.cubeAll(BlockBehaviour.Properties.of().liquid().lightLevel(state -> 15).sound(LAVA_SOUND_GROUP), ResourceLocation.parse((String)"block/lava_still")), "lava_block");
    public static final BRRPStairsBlock LAVA_STAIRS = BRRPTest.register(new BRRPStairsBlock(LAVA_BLOCK), "lava_stairs");
    public static final BRRPSlabBlock LAVA_SLAB = BRRPTest.register(new BRRPSlabBlock(LAVA_BLOCK), "lava_slab");
    public static final BRRPFenceBlock LAVA_FENCE = BRRPTest.register(new BRRPFenceBlock(LAVA_BLOCK), "lava_fence");
    public static final BRRPFenceGateBlock LAVA_FENCE_GATE = BRRPTest.register(new BRRPFenceGateBlock(LAVA_BLOCK, WoodType.MANGROVE), "lava_fence_gate");
    public static final BRRPWallBlock LAVA_WALL = BRRPTest.register(new BRRPWallBlock(LAVA_BLOCK), "lava_wall");
    public static final BRRPCubeBlock SMOOTH_STONE = BRRPTest.register(BRRPCubeBlock.cubeBottomTop(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SMOOTH_STONE), ResourceLocation.parse((String)"block/smooth_stone"), ResourceLocation.parse((String)"block/smooth_stone_slab_side"), ResourceLocation.parse((String)"block/smooth_stone")), "smooth_stone");
    private static final RuntimeResourcePack PACK = RuntimeResourcePack.create(ResourceLocation.fromNamespaceAndPath((String)"brrp", (String)"test"));
    private static final Logger LOGGER = LoggerFactory.getLogger(BRRPTest.class);

    private static BlockItem blockItem(Block block) {
        BlockItem item = new BlockItem(block, new Item.Properties());
        PlatformBridge.getInstance().registerItem(BuiltInRegistries.BLOCK.getKey((Object)block), (Item)item);
        return item;
    }

    private static void refreshPack(boolean clientIncluded, boolean serverIncluded) {
        LOGGER.info("Generating resources for the development environment.");
        if (clientIncluded) {
            PACK.clearResources(PackType.CLIENT_RESOURCES);
            PACK.addLang(ResourceLocation.fromNamespaceAndPath((String)"brrp", (String)"en_us"), LanguageProvider.create().add(LAVA_BLOCK, "Lava Block (Development Environment Only)").add((Block)LAVA_STAIRS, "Lava Stairs (Development Environment Only)").add((Block)LAVA_SLAB, "Lava Slab (Development Environment Only)").add((Block)LAVA_FENCE, "Lava Fence (Development Environment Only)").add((Block)LAVA_FENCE_GATE, "Lava Fence Gate (Development Environment Only)").add((Block)LAVA_WALL, "Lava Wall (Development Environment Only)").add(SMOOTH_STONE, "Smooth Stone (Development Environment Only)"));
            PACK.addLang(ResourceLocation.fromNamespaceAndPath((String)"brrp", (String)"zh_cn"), LanguageProvider.create().add(LAVA_BLOCK, "\u7194\u5ca9\u65b9\u5757\uff08\u4ec5\u9650\u5f00\u53d1\u73af\u5883\uff09").add((Block)LAVA_STAIRS, "\u7194\u5ca9\u697c\u68af\uff08\u4ec5\u9650\u5f00\u53d1\u73af\u5883\uff09").add((Block)LAVA_SLAB, "\u7194\u5ca9\u53f0\u9636\uff08\u4ec5\u9650\u5f00\u53d1\u73af\u5883\uff09").add((Block)LAVA_FENCE, "\u7194\u5ca9\u6805\u680f\uff08\u4ec5\u9650\u5f00\u53d1\u73af\u5883\uff09").add((Block)LAVA_FENCE_GATE, "\u7194\u5ca9\u6805\u680f\u95e8\uff08\u4ec5\u9650\u5f00\u53d1\u73af\u5883\uff09").add((Block)LAVA_WALL, "\u7194\u5ca9\u5899\uff08\u4ec5\u9650\u5f00\u53d1\u73af\u5883\uff09").add(SMOOTH_STONE, "\u5e73\u6ed1\u77f3\u5934\uff08\u4ec5\u9650\u5f00\u53d1\u73af\u5883\uff09"));
            LanguageProvider twLang = LanguageProvider.create().add(LAVA_BLOCK, "\u7194\u5ca9\u65b9\u584a\uff08\u50c5\u9650\u958b\u767c\u74b0\u5883\uff09").add((Block)LAVA_STAIRS, "\u7194\u5ca9\u968e\u68af\uff08\u50c5\u9650\u958b\u767c\u74b0\u5883\uff09").add((Block)LAVA_SLAB, "\u7194\u5ca9\u534a\u78da\uff08\u50c5\u9650\u958b\u767c\u74b0\u5883\uff09").add((Block)LAVA_FENCE, "\u7194\u5ca9\u67f5\u6b04\uff08\u50c5\u9650\u958b\u767c\u74b0\u5883\uff09").add((Block)LAVA_FENCE_GATE, "\u7194\u5ca9\u67f5\u6b04\u9580\uff08\u50c5\u9650\u958b\u767c\u74b0\u5883\uff09").add((Block)LAVA_WALL, "\u7194\u5ca9\u58bb\uff08\u50c5\u9650\u958b\u767c\u74b0\u5883\uff09").add(SMOOTH_STONE, "\u5e73\u6ed1\u77f3\u982d\uff08\u50c5\u9650\u958b\u767c\u74b0\u5883\uff09");
            PACK.addLang(ResourceLocation.fromNamespaceAndPath((String)"brrp", (String)"zh_tw"), twLang);
            PACK.addLang(ResourceLocation.fromNamespaceAndPath((String)"brrp", (String)"zh_hk"), twLang.add((Block)LAVA_FENCE, "\u7194\u5ca9\u6b04\u6746\uff08\u50c5\u9650\u958b\u767c\u74b0\u5883\uff09").add((Block)LAVA_FENCE_GATE, "\u7194\u5ca9\u9598\u9580\uff08\u50c5\u9650\u958b\u767c\u74b0\u5883\uff09"));
        }
        if (serverIncluded) {
            PACK.clearResources(PackType.SERVER_DATA);
            IdentifiedTagBuilder stairs = (IdentifiedTagBuilder)((Object)IdentifiedTagBuilder.createBlock((TagKey<Block>)BlockTags.STAIRS).add((Block)LAVA_STAIRS));
            PACK.addTag(stairs);
            PACK.addTag(IdentifiedTagBuilder.createItemCopy((TagKey<Item>)ItemTags.STAIRS, stairs));
            IdentifiedTagBuilder slabs = (IdentifiedTagBuilder)((Object)IdentifiedTagBuilder.createBlock((TagKey<Block>)BlockTags.SLABS).add((Block)LAVA_SLAB));
            PACK.addTag(slabs);
            PACK.addTag(IdentifiedTagBuilder.createItemCopy((TagKey<Item>)ItemTags.SLABS, slabs));
            IdentifiedTagBuilder fences = (IdentifiedTagBuilder)((Object)IdentifiedTagBuilder.createBlock((TagKey<Block>)BlockTags.FENCES).add((Block)LAVA_FENCE));
            PACK.addTag(fences);
            PACK.addTag(IdentifiedTagBuilder.createItemCopy((TagKey<Item>)ItemTags.FENCES, fences));
            IdentifiedTagBuilder fenceGates = (IdentifiedTagBuilder)((Object)IdentifiedTagBuilder.createBlock((TagKey<Block>)BlockTags.FENCE_GATES).add((Block)LAVA_FENCE_GATE));
            PACK.addTag(fenceGates);
            PACK.addTag(IdentifiedTagBuilder.createItemCopy((TagKey<Item>)ItemTags.FENCE_GATES, fenceGates));
            IdentifiedTagBuilder walls = (IdentifiedTagBuilder)((Object)IdentifiedTagBuilder.createBlock((TagKey<Block>)BlockTags.WALLS).add((Block)LAVA_WALL));
            PACK.addTag(walls);
            PACK.addTag(IdentifiedTagBuilder.createItemCopy((TagKey<Item>)ItemTags.WALLS, walls));
            PACK.addTag((IdentifiedTagBuilder)((Object)IdentifiedTagBuilder.createBlock((TagKey<Block>)BlockTags.MINEABLE_WITH_PICKAXE).add(SMOOTH_STONE)));
            PACK.addRecipeAndAdvancement(ResourceLocation.fromNamespaceAndPath((String)"brrp", (String)"smooth_stone_slab"), (RecipeBuilder)((ShapedRecipeBuilder)((ShapedRecipeBuilder)ShapedRecipeBuilder.shaped(null, (ItemLike)Blocks.SMOOTH_STONE_SLAB, (int)6).pattern("###").define(Character.valueOf('#'), (ItemLike)SMOOTH_STONE).criterionFromItem((ItemLike)SMOOTH_STONE)).setCustomCraftingCategory(CraftingBookCategory.MISC)).setCustomRecipeCategory("brrp_custom"));
            PACK.addRecipeAndAdvancement(ResourceLocation.fromNamespaceAndPath((String)"brrp", (String)"smooth_stone_slab_from_stonecutting"), (RecipeBuilder)((SingleItemRecipeBuilder)SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{SMOOTH_STONE}), null, (ItemLike)Blocks.SMOOTH_STONE_SLAB).criterionFromItem((ItemLike)SMOOTH_STONE)).setCustomRecipeCategory("brrp_custom"));
            DataComponentPatch bedrockTestComponentChanges = DataComponentPatch.builder().set(DataComponents.FOOD, (Object)new FoodProperties.Builder().nutrition(20).saturationModifier(20.0f).alwaysEdible().fast().effect(new MobEffectInstance(MobEffects.WIND_CHARGED, 60), 1.0f).build()).set(DataComponents.ITEM_NAME, (Object)Component.literal((String)"Unobtainable!")).build();
            PACK.addRecipeAndAdvancement(ResourceLocation.fromNamespaceAndPath((String)"brrp", (String)"cook_bedrock"), (RecipeBuilder)((SimpleCookingRecipeBuilder)((SimpleCookingRecipeBuilder)SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{Items.BEDROCK}), null, (ItemLike)Items.BARRIER, (float)1000.0f, (int)2).setCustomRecipeCategory("brrp_custom")).criterionFromItem((ItemLike)Items.BEDROCK)).setComponentChanges(bedrockTestComponentChanges));
            PACK.addRecipeAndAdvancement(ResourceLocation.fromNamespaceAndPath((String)"brrp", (String)"unobtainable_shaped"), (RecipeBuilder)((ShapedRecipeBuilder)((ShapedRecipeBuilder)((ShapedRecipeBuilder)ShapedRecipeBuilder.shaped(null, (ItemLike)Items.BEDROCK).patterns(new String[]{"xx", "xx"}).define(Character.valueOf('x'), (ItemLike)Items.BEDROCK).setBypassesValidation(true)).setCustomRecipeCategory("brrp_custom")).setCustomCraftingCategory(CraftingBookCategory.MISC)).setComponentChanges(bedrockTestComponentChanges));
            PACK.addRecipeAndAdvancement(ResourceLocation.fromNamespaceAndPath((String)"brrp", (String)"unobtainable_shapeless"), (RecipeBuilder)((ShapelessRecipeBuilder)((ShapelessRecipeBuilder)((ShapelessRecipeBuilder)((ShapelessRecipeBuilder)ShapelessRecipeBuilder.shapeless(null, (ItemLike)Items.BEDROCK).requires((ItemLike)Items.STONE, 5).criterionFromItem((ItemLike)Items.STONE)).setCustomRecipeCategory("brrp_custom")).setBypassesValidation(true)).setCustomCraftingCategory(CraftingBookCategory.MISC)).setComponentChanges(bedrockTestComponentChanges));
            PACK.addRecipeAndAdvancement(ResourceLocation.fromNamespaceAndPath((String)"brrp", (String)"unobtainable_single_item"), (RecipeBuilder)((SingleItemRecipeBuilder)((SingleItemRecipeBuilder)SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{Items.STONE}), null, (ItemLike)Items.BEDROCK).setCustomRecipeCategory("brrp_custom")).setBypassesValidation(true)).setComponentChanges(bedrockTestComponentChanges));
            PACK.addRecipeAndAdvancement(ResourceLocation.fromNamespaceAndPath((String)"brrp", (String)"smithing_transform"), (SmithingTransformRecipeBuilder)((SmithingTransformRecipeBuilder)((SmithingTransformRecipeBuilder)SmithingTransformRecipeBuilder.smithing((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{Items.DIAMOND}), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{Items.STONE}), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{Items.LAPIS_LAZULI}), null, (Item)Items.BEDROCK).setCustomRecipeCategory("brrp_custom")).setBypassesValidation(true)).setComponentChanges(bedrockTestComponentChanges));
            PACK.addRecipeAndAdvancement(ResourceLocation.fromNamespaceAndPath((String)"brrp", (String)"smithing_trim"), (SmithingTrimRecipeBuilder)((SmithingTrimRecipeBuilder)SmithingTrimRecipeBuilder.smithingTrim((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{Items.DIAMOND}), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{Items.STONE}), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{Items.REDSTONE}), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS).setCustomRecipeCategory("brrp_custom")).setBypassesValidation(true));
        }
        LAVA_BLOCK.writeResources(PACK, clientIncluded, serverIncluded);
        LAVA_STAIRS.writeResources(PACK, clientIncluded, serverIncluded);
        LAVA_SLAB.writeResources(PACK, clientIncluded, serverIncluded);
        LAVA_FENCE.writeResources(PACK, clientIncluded, serverIncluded);
        LAVA_FENCE_GATE.writeResources(PACK, clientIncluded, serverIncluded);
        LAVA_WALL.writeResources(PACK, clientIncluded, serverIncluded);
        SMOOTH_STONE.writeResources(PACK, clientIncluded, serverIncluded);
        LOGGER.info("Resources generation finished for the development environment.");
    }

    @Contract(value="_,_ -> param1")
    private static <T extends Block> T register(T block, String name) {
        PlatformBridge.getInstance().registerBlock(ResourceLocation.fromNamespaceAndPath((String)"brrp", (String)name), block);
        return block;
    }

    public static void registerPacks() {
        BRRPTest.refreshPack(true, true);
        RRPEventHelper.BEFORE_VANILLA.registerPack(PACK);
        PACK.setDisplayName((Component)Component.translatable((String)"brrp.pack.test.name"));
        PACK.setDescription((Component)Component.translatable((String)"brrp.pack.test.description"));
        PACK.setSidedRegenerationCallback(PackType.CLIENT_RESOURCES, (FailableRunnable<InterruptedException>)((FailableRunnable)() -> BRRPTest.refreshPack(true, false)));
        PACK.setSidedRegenerationCallback(PackType.SERVER_DATA, (FailableRunnable<InterruptedException>)((FailableRunnable)() -> BRRPTest.refreshPack(false, true)));
        RuntimeResourcePack emptyPack = RuntimeResourcePack.create(ResourceLocation.fromNamespaceAndPath((String)"brrp", (String)"empty"));
        emptyPack.setDisplayName((Component)Component.translatable((String)"brrp.pack.empty.name"));
        emptyPack.setDescription((Component)Component.translatable((String)"brrp.pack.empty.description"));
        RRPEventHelper.BEFORE_VANILLA.registerPack(emptyPack);
        RuntimeResourcePack beforeUser = RuntimeResourcePack.create(ResourceLocation.fromNamespaceAndPath((String)"brrp", (String)"test_before_user"));
        beforeUser.setDisplayName((Component)Component.translatable((String)"brrp.pack.test_before_user.name"));
        beforeUser.setDescription((Component)Component.translatable((String)"brrp.pack.test_before_user.description"));
        beforeUser.addModel(ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"item/yellow_wool"), ModelJsonBuilder.create(ModelTemplates.FLAT_HANDHELD_ITEM).addTexture(TextureSlot.LAYER0, ResourceLocation.parse((String)"block/yellow_wool")));
        beforeUser.addAsyncResource(PackType.CLIENT_RESOURCES, ResourceLocation.parse((String)"models/item/gold_ingot.json"), (FailableFunction<ResourceLocation, byte[], Exception>)((FailableFunction)input -> {
            LOGGER.info("async resource!");
            return beforeUser.serialize(ModelJsonBuilder.create(ModelTemplates.FLAT_HANDHELD_ITEM).addTexture(TextureSlot.LAYER0, ResourceLocation.parse((String)"item/gold_ingot")).transformation(ItemDisplayContext.GROUND, new TransformationBuilder().translation(0.0f, 4.5f, 0.0f).scale(9.0f, 9.0f, 9.0f)));
        }));
        beforeUser.addLazyResource(PackType.CLIENT_RESOURCES, ResourceLocation.parse((String)"models/item/diamond.json"), (pack, identifier) -> {
            LOGGER.info("lazy resource!");
            return beforeUser.serialize(ModelJsonBuilder.create(ModelTemplates.FLAT_HANDHELD_ITEM).addTexture(TextureSlot.LAYER0, ResourceLocation.parse((String)"item/diamond")).transformation(ItemDisplayContext.GROUND, new TransformationBuilder().translation(0.0f, 4.5f, 0.0f).scale(10.85f, 10.85f, 10.6f)));
        });
        beforeUser.addLang(ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"en_us"), LanguageProvider.create().add(Blocks.YELLOW_WOOL, "The model is modified by a 'before-user' runtime resource pack."));
        beforeUser.addLootTable(Blocks.YELLOW_WOOL.getLootTable().location(), beforeUser.getBlockLootTableGenerator().createSingleItemTable((ItemLike)Blocks.YELLOW_WOOL, (NumberProvider)ConstantValue.exactly((float)3.0f)));
        beforeUser.addModel(ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"item/bow"), ModelJsonBuilder.create(ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"item/white_concrete")).addOverride(ModelOverrideBuilder.of(ResourceLocation.parse((String)"item/yellow_concrete"), ResourceLocation.parse((String)"pulling"), 1.0f)).addOverride(ModelOverrideBuilder.of(ResourceLocation.parse((String)"item/orange_concrete"), ResourceLocation.parse((String)"pulling"), 1.0f).addCondition(ResourceLocation.parse((String)"pull"), 0.65f)).addOverride(ModelOverrideBuilder.of(ResourceLocation.parse((String)"item/red_concrete"), ResourceLocation.parse((String)"pulling"), 1.0f).addCondition(ResourceLocation.parse((String)"pull"), 0.9f)));
        RRPEventHelper.BEFORE_USER.registerPack(beforeUser);
        RuntimeResourcePack test2 = RuntimeResourcePack.create(ResourceLocation.fromNamespaceAndPath((String)"brrp", (String)"test2"));
        test2.setSidedRegenerationCallback(PackType.CLIENT_RESOURCES, (FailableRunnable<InterruptedException>)((FailableRunnable)() -> {
            test2.clearResources(PackType.CLIENT_RESOURCES);
            for (int i = 0; i < 1024; ++i) {
                Thread.sleep(ThreadLocalRandom.current().nextLong(20L));
                test2.addAsset(ResourceLocation.fromNamespaceAndPath((String)"brrp", (String)("test/" + ThreadLocalRandom.current().nextInt())), new byte[16]);
            }
        }));
        test2.setSidedRegenerationCallback(PackType.SERVER_DATA, (FailableRunnable<InterruptedException>)((FailableRunnable)() -> {
            test2.clearResources(PackType.SERVER_DATA);
            for (int i = 0; i < 1024; ++i) {
                Thread.sleep(ThreadLocalRandom.current().nextLong(20L));
                test2.addData(ResourceLocation.fromNamespaceAndPath((String)"brrp", (String)("test/" + ThreadLocalRandom.current().nextInt())), new byte[16]);
            }
        }));
        RRPEventHelper.BEFORE_VANILLA.registerPack(test2);
    }

    static {
        Validate.validState((boolean)PlatformBridge.getInstance().isDevelopmentEnvironment(), (String)"The class 'BRRPDevelopment' should not be loaded outside of the development environment.", (Object[])new Object[0]);
        BRRPTest.blockItem(LAVA_BLOCK);
        BRRPTest.blockItem((Block)LAVA_STAIRS);
        BRRPTest.blockItem((Block)LAVA_SLAB);
        BRRPTest.blockItem((Block)LAVA_FENCE);
        BRRPTest.blockItem((Block)LAVA_FENCE_GATE);
        BRRPTest.blockItem((Block)LAVA_WALL);
        BRRPTest.blockItem(SMOOTH_STONE);
        LAVA_BLOCK.setRecipeCategory(RecipeCategory.BUILDING_BLOCKS);
        LAVA_STAIRS.setRecipeCategory(RecipeCategory.BUILDING_BLOCKS);
        LAVA_SLAB.setRecipeCategory(RecipeCategory.BUILDING_BLOCKS);
        LAVA_FENCE.setRecipeCategory(RecipeCategory.DECORATIONS);
        LAVA_FENCE_GATE.setRecipeCategory(RecipeCategory.DECORATIONS);
        LAVA_WALL.setRecipeCategory(RecipeCategory.DECORATIONS);
        SMOOTH_STONE.setRecipeCategory(RecipeCategory.BUILDING_BLOCKS);
        PlatformBridge.getInstance().setItemGroup(Collections2.transform(List.of(LAVA_BLOCK, LAVA_STAIRS, LAVA_SLAB, LAVA_FENCE, LAVA_FENCE_GATE, LAVA_WALL, SMOOTH_STONE), x$0 -> new ItemStack((ItemLike)x$0)));
    }
}

