/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.variables;

import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.rasanovum.viaromana.network.ViaRomanaModClientPacketHandler;
import net.rasanovum.viaromana.network.ViaRomanaModVariables;

public class PlayerVariableAccessor {
    public boolean isChartingPath(Entity entity) {
        return this.getVars((Entity)entity).ChartingPath;
    }

    public double getFadeAmount(Entity entity) {
        return this.getVars((Entity)entity).FadeAmount;
    }

    public boolean isFadeIncrease(Entity entity) {
        return this.getVars((Entity)entity).FadeIncrease;
    }

    public BlockPos getLastNodePos(Entity entity) {
        return this.getVars((Entity)entity).lastNodePos;
    }

    public boolean hasReceivedTutorial(Entity entity) {
        return this.getVars((Entity)entity).ReceivedTutorial;
    }

    public void setChartingPath(Entity entity, boolean value) {
        this.getVars((Entity)entity).ChartingPath = value;
    }

    public void setFadeAmount(Entity entity, double value) {
        this.getVars((Entity)entity).FadeAmount = value;
    }

    public void setFadeIncrease(Entity entity, boolean value) {
        this.getVars((Entity)entity).FadeIncrease = value;
    }

    public void setLastNodePos(Entity entity, BlockPos value) {
        this.getVars((Entity)entity).lastNodePos = value;
    }

    public void setReceivedTutorial(Entity entity, boolean value) {
        this.getVars((Entity)entity).ReceivedTutorial = value;
    }

    public void sync(Entity entity) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            this.getVars((Entity)player).syncToClient(player);
        }
    }

    public void save(Entity entity) {
        ServerPlayer player;
        if (entity instanceof ServerPlayer && (player = (ServerPlayer)entity).getServer() != null) {
            ViaRomanaModVariables.savePlayerVariablesToFile(player.getServer(), player.getUUID().toString(), this.getVars((Entity)player));
        }
    }

    public void syncAndSave(Entity entity) {
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT && this.isLocalPlayer(entity)) {
            ViaRomanaModClientPacketHandler.sendPlayerVariablesToServer(this.getVars(entity));
        } else {
            this.sync(entity);
            this.save(entity);
        }
    }

    private boolean isLocalPlayer(Entity entity) {
        if (FabricLoader.getInstance().getEnvironmentType() != EnvType.CLIENT) {
            return false;
        }
        return entity.getClass().getSimpleName().equals("LocalPlayer");
    }

    private ViaRomanaModVariables.PlayerVariables getVars(Entity entity) {
        return ViaRomanaModVariables.getPlayerVariables(entity);
    }

    public void savePlayerVariables(Entity entity) {
        this.save(entity);
    }

    public void loadPlayerVariables(Entity entity) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            ViaRomanaModVariables.loadPlayerVariablesFromFile(player);
        }
    }
}

