/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.util;

import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.rasanovum.viaromana.CommonConfig;
import net.rasanovum.viaromana.variables.VariableAccess;

public class PathUtils {
    public static float calculateNodeDistance(Entity entity) {
        if (entity == null) {
            return 0.0f;
        }
        BlockPos lastNodePos = VariableAccess.playerVariables.getLastNodePos(entity);
        double dx = entity.getX() - (double)lastNodePos.getX();
        double dy = entity.getY() - (double)lastNodePos.getY();
        double dz = entity.getZ() - (double)lastNodePos.getZ();
        return (float)Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    public static boolean isBlockValidPath(LevelAccessor world, BlockPos targetBlock) {
        if (world.isEmptyBlock(targetBlock)) {
            return false;
        }
        BlockState blockState = world.getBlockState(targetBlock);
        return blockState.is(TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.parse((String)"via_romana:path_block")));
    }

    public static float calculateInfrastructureQuality(LevelAccessor world, Entity entity) {
        if (entity == null) {
            return 0.0f;
        }
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos(entity.getX(), entity.getY(), entity.getZ());
        if (!entity.onGround()) {
            int startY = mutablePos.getY();
            while (world.isEmptyBlock((BlockPos)mutablePos)) {
                mutablePos.setY(mutablePos.getY() - 1);
                if (startY - mutablePos.getY() < 4) continue;
                return 0.0f;
            }
        }
        int surfaceY = mutablePos.getY();
        int checkRadius = CommonConfig.infrastructure_check_radius;
        int pathQuality = 0;
        int entityX = (int)Math.floor(entity.getX());
        int entityZ = (int)Math.floor(entity.getZ());
        for (int dx = -checkRadius; dx <= checkRadius; ++dx) {
            for (int dy = -checkRadius; dy <= checkRadius; ++dy) {
                for (int dz = -checkRadius; dz <= checkRadius; ++dz) {
                    mutablePos.set(entityX + dx, surfaceY + dy, entityZ + dz);
                    if (!PathUtils.isBlockValidPath(world, (BlockPos)mutablePos)) continue;
                    ++pathQuality;
                }
            }
        }
        float totalBlocksChecked = (float)Math.pow(checkRadius * 2 + 1, 2.0);
        return totalBlocksChecked == 0.0f ? 0.0f : (float)pathQuality / totalBlocksChecked;
    }

    public static float calculateClearance(LevelAccessor world, Entity entity) {
        if (entity == null) {
            return 0.0f;
        }
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos(entity.getX(), entity.getY(), entity.getZ());
        if (!entity.onGround()) {
            int startY = mutablePos.getY();
            while (world.isEmptyBlock((BlockPos)mutablePos)) {
                mutablePos.setY(mutablePos.getY() - 1);
                if (startY - mutablePos.getY() < 4) continue;
                return 0.0f;
            }
        }
        int surfaceY = mutablePos.getY();
        int clearance = 0;
        int entityX = (int)Math.floor(entity.getX());
        int entityZ = (int)Math.floor(entity.getZ());
        for (int y = surfaceY + 1; y <= surfaceY + 6; ++y) {
            mutablePos.set(entityX, y, entityZ);
            BlockState blockState = world.getBlockState((BlockPos)mutablePos);
            if (!world.isEmptyBlock((BlockPos)mutablePos) && !blockState.is(TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.parse((String)"minecraft:leaves")))) {
                return clearance;
            }
            ++clearance;
        }
        return 6.0f;
    }
}

