/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.util;

import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.rasanovum.viaromana.CommonConfig;
import net.rasanovum.viaromana.ViaRomana;
import net.rasanovum.viaromana.network.packets.PathGraphSyncPacket;
import net.rasanovum.viaromana.path.PathGraph;
import net.rasanovum.viaromana.storage.IPathStorage;
import net.rasanovum.viaromana.util.NetworkUtils;

public class PathSyncUtils {
    public static void syncPathGraphToAllPlayers(ServerLevel level) {
        try {
            IPathStorage storage = IPathStorage.get((Level)level);
            if (storage == null) {
                return;
            }
            PathGraph graph = storage.graph();
            if (CommonConfig.enable_surveyor_landmark && CommonConfig.enable_surveyor_landmark_coloring) {
                try {
                    graph.updateAllNetworkColors(level);
                }
                catch (NullPointerException e) {
                    ViaRomana.LOGGER.warn("Surveyor landmark system not ready yet, skipping network color update for sync");
                }
            }
            PathGraphSyncPacket packet = new PathGraphSyncPacket(graph);
            for (ServerPlayer player2 : level.getPlayers(player -> true)) {
                NetworkUtils.sendToPlayer((Player)player2, packet);
            }
            ViaRomana.LOGGER.info("Synced PathGraph with {} nodes to {} players", (Object)graph.size(), (Object)level.getPlayers(player -> true).size());
        }
        catch (Exception e) {
            ViaRomana.LOGGER.error("Failed to sync PathGraph to players in level " + String.valueOf(level.dimension().location()), (Throwable)e);
        }
    }

    public static void syncPathGraphToPlayer(ServerPlayer player) {
        try {
            ServerLevel level = player.serverLevel();
            IPathStorage storage = IPathStorage.get((Level)level);
            if (storage == null) {
                return;
            }
            PathGraphSyncPacket packet = new PathGraphSyncPacket(storage.graph());
            NetworkUtils.sendToPlayer((Player)player, packet);
            ViaRomana.LOGGER.debug("Synced PathGraph with {} nodes to player {}", (Object)storage.graph().size(), (Object)player.getName().getString());
        }
        catch (Exception e) {
            ViaRomana.LOGGER.error("Failed to sync PathGraph to player " + player.getName().getString(), (Throwable)e);
        }
    }

    public static void syncNetworkInvalidationToPlayers(ServerLevel level, int networkId) {
    }
}

