/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.teleport;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.rasanovum.viaromana.path.Node;
import net.rasanovum.viaromana.path.PathGraph;
import net.rasanovum.viaromana.storage.IPathStorage;
import net.rasanovum.viaromana.util.EffectUtils;
import net.rasanovum.viaromana.variables.VariableAccess;

public class TeleportHelper {
    public static Optional<BlockPos> findDestination(BlockEntity source, BlockEntity dest, Level level) {
        BlockPos sourcePos = source.getBlockPos();
        BlockPos destPos = dest.getBlockPos();
        PathGraph graph = IPathStorage.get(level).graph();
        Optional<Node> sourceNode = graph.getNodeBySignPos(sourcePos);
        Optional<Node> destNode = graph.getNodeBySignPos(destPos);
        if (sourceNode.isEmpty() || destNode.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(destNode.get().getBlockPos());
    }

    public static void cycle(LevelAccessor world, Entity entity) {
        double fadeAmount = VariableAccess.playerVariables.getFadeAmount(entity);
        boolean isIncreasing = VariableAccess.playerVariables.isFadeIncrease(entity);
        if (fadeAmount > 0.0 || fadeAmount == 0.0 && isIncreasing) {
            TeleportHelper.handleFadeEffect(world, entity);
            fadeAmount = VariableAccess.playerVariables.getFadeAmount(entity);
            if (fadeAmount >= 15.0) {
                VariableAccess.playerVariables.setFadeIncrease(entity, false);
                VariableAccess.playerVariables.syncAndSave(entity);
            }
            if (fadeAmount == 0.0 && !VariableAccess.playerVariables.isFadeIncrease(entity)) {
                VariableAccess.playerVariables.setFadeAmount(entity, 0.0);
                VariableAccess.playerVariables.setFadeIncrease(entity, false);
                VariableAccess.playerVariables.setLastNodePos(entity, BlockPos.ZERO);
                VariableAccess.playerVariables.syncAndSave(entity);
            }
        }
    }

    public static void effect(LevelAccessor world, Entity entity) {
        double fadeAmount = VariableAccess.playerVariables.getFadeAmount(entity);
        if (fadeAmount > 0.0) {
            double particleRadius = 4.0;
            if (world instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)world;
                serverLevel.sendParticles((ParticleOptions)ParticleTypes.ENCHANT, entity.getX() + Mth.nextDouble((RandomSource)RandomSource.create(), (double)-0.1, (double)0.1) * particleRadius, entity.getY() + fadeAmount * 0.15, entity.getZ() + Mth.nextDouble((RandomSource)RandomSource.create(), (double)-0.1, (double)0.1) * particleRadius, 32, Mth.nextDouble((RandomSource)RandomSource.create(), (double)-0.1, (double)0.1) * particleRadius, fadeAmount * 0.02, Mth.nextDouble((RandomSource)RandomSource.create(), (double)-0.1, (double)0.1) * particleRadius, 0.5);
            }
        }
    }

    private static void playFootstepSound(LevelAccessor world, BlockPos soundSource) {
        if (!(world instanceof Level)) {
            return;
        }
        Level level = (Level)world;
        BlockState blockState = world.getBlockState(soundSource);
        ResourceLocation soundId = BuiltInRegistries.SOUND_EVENT.getKey((Object)blockState.getSoundType().getStepSound());
        if (soundId == null) {
            soundId = ResourceLocation.parse((String)"minecraft:block.grass.step");
        }
        if (!level.isClientSide()) {
            level.playSound(null, soundSource, (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(soundId), SoundSource.BLOCKS, 0.2f, 1.0f);
        } else {
            level.playLocalSound((double)soundSource.getX(), (double)soundSource.getY(), (double)soundSource.getZ(), (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(soundId), SoundSource.BLOCKS, 0.2f, 1.0f, false);
        }
    }

    private static void handleFadeEffect(LevelAccessor world, Entity entity) {
        double fadeAmount = VariableAccess.playerVariables.getFadeAmount(entity);
        if (fadeAmount >= 0.0 && fadeAmount <= 15.0) {
            boolean isIncreasing;
            if (fadeAmount % 7.0 == 0.0) {
                TeleportHelper.playFootstepSound(world, entity.getOnPos());
            }
            double newFadeAmount = (isIncreasing = VariableAccess.playerVariables.isFadeIncrease(entity)) ? fadeAmount + 1.0 : fadeAmount - 1.0;
            newFadeAmount = Math.max(0.0, Math.min(15.0, newFadeAmount));
            VariableAccess.playerVariables.setFadeAmount(entity, newFadeAmount);
            VariableAccess.playerVariables.syncAndSave(entity);
            if (fadeAmount == 1.0) {
                EffectUtils.applyEffect(entity, "travellers_fatigue", world);
            }
        }
    }

    public static class TeleportDestination {
        public final BlockPos position;
        public final String name;
        public final double distance;
        public final Node.Icon icon;

        public TeleportDestination(BlockPos position, String name, double distance, Node.Icon icon) {
            this.position = position;
            this.name = name;
            this.distance = distance;
            this.icon = icon;
        }
    }
}

