/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.teleport;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.rasanovum.viaromana.CommonConfig;
import net.rasanovum.viaromana.core.LinkHandler;
import net.rasanovum.viaromana.network.packets.TeleportRequestC2S;
import net.rasanovum.viaromana.path.Node;
import net.rasanovum.viaromana.storage.IPathStorage;
import net.rasanovum.viaromana.variables.VariableAccess;

public class ServerTeleportHandler {
    public static void handleTeleportRequest(TeleportRequestC2S packet, ServerPlayer player) {
        ServerLevel level = player.serverLevel();
        IPathStorage storage = IPathStorage.get((Level)level);
        if (storage == null || !ServerTeleportHandler.validateOriginSign(level, packet.originSignPos())) {
            return;
        }
        storage.graph().getNodeAt(packet.destinationPos()).ifPresent(targetNode -> {
            VariableAccess.playerVariables.setLastNodePos((Entity)player, targetNode.getBlockPos());
            VariableAccess.playerVariables.setFadeAmount((Entity)player, 0.0);
            VariableAccess.playerVariables.setFadeIncrease((Entity)player, true);
            VariableAccess.playerVariables.syncAndSave((Entity)player);
        });
    }

    public static void executeTeleportation(ServerPlayer player) {
        BlockPos targetPos = VariableAccess.playerVariables.getLastNodePos((Entity)player);
        if (targetPos == null || targetPos.equals((Object)BlockPos.ZERO)) {
            return;
        }
        ServerLevel level = player.serverLevel();
        IPathStorage storage = IPathStorage.get((Level)level);
        if (storage == null) {
            return;
        }
        storage.graph().getNodeAt(targetPos).ifPresent(targetNode -> ServerTeleportHandler.performTeleportation(player, targetNode));
    }

    private static void performTeleportation(ServerPlayer player, Node targetNode) {
        ServerLevel level = player.serverLevel();
        BlockPos safePos = ServerTeleportHandler.findSafePosition(level, BlockPos.of((long)targetNode.getPos()));
        if (safePos == null) {
            player.displayClientMessage((Component)Component.translatable((String)"message.via_romana.unsafe"), true);
            VariableAccess.playerVariables.setFadeAmount((Entity)player, 0.0);
            VariableAccess.playerVariables.setFadeIncrease((Entity)player, false);
            VariableAccess.playerVariables.setLastNodePos((Entity)player, BlockPos.ZERO);
            VariableAccess.playerVariables.syncAndSave((Entity)player);
            return;
        }
        double x = (double)safePos.getX() + 0.5;
        double y = ServerTeleportHandler.getAccurateYPosition(level, safePos);
        double z = (double)safePos.getZ() + 0.5;
        Entity rootVehicle = player.getRootVehicle();
        if (rootVehicle != player && !ServerTeleportHandler.isValidTeleportEntity(rootVehicle)) {
            player.stopRiding();
            rootVehicle = player;
        }
        ServerTeleportHandler.teleportStack(rootVehicle, level, x, y, z);
    }

    private static void teleportStack(Entity rootEntity, ServerLevel level, double x, double y, double z) {
        HashMap passengerMap = new HashMap();
        ArrayList<Entity> allEntities = new ArrayList<Entity>();
        ArrayList<Object> toProcess = new ArrayList<Object>();
        toProcess.add(rootEntity);
        while (!toProcess.isEmpty()) {
            Entity current = (Entity)toProcess.remove(0);
            allEntities.add(current);
            List passengers = List.copyOf(current.getPassengers());
            if (passengers.isEmpty()) continue;
            passengerMap.put(current, passengers);
            toProcess.addAll(passengers);
        }
        rootEntity.ejectPassengers();
        HashMap<Entity, Entity> newEntityMap = new HashMap<Entity, Entity>();
        for (Entity oldEntity : allEntities) {
            Entity newEntity = ServerTeleportHandler.recreateAndTeleportEntity(oldEntity, level, x, y, z);
            if (newEntity == null) continue;
            newEntityMap.put(oldEntity, newEntity);
        }
        if (!passengerMap.isEmpty()) {
            level.getServer().tell((Runnable)new TickTask(3, () -> passengerMap.forEach((oldVehicle, oldPassengers) -> {
                Entity newVehicle = (Entity)newEntityMap.get(oldVehicle);
                if (newVehicle != null && newVehicle.isAlive()) {
                    oldPassengers.forEach(oldPassenger -> {
                        Entity newPassenger = (Entity)newEntityMap.get(oldPassenger);
                        if (newPassenger != null && newPassenger.isAlive()) {
                            newPassenger.startRiding(newVehicle, true);
                        }
                    });
                }
            })));
        }
    }

    private static Entity recreateAndTeleportEntity(Entity oldEntity, ServerLevel level, double x, double y, double z) {
        if (oldEntity.isRemoved()) {
            return null;
        }
        if (oldEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)oldEntity;
            player.teleportTo(level, x, y, z, player.getYRot(), player.getXRot());
            player.fallDistance = 0.0f;
            return player;
        }
        Entity newEntity = oldEntity.getType().create((Level)level);
        if (newEntity == null) {
            return null;
        }
        CompoundTag nbt = oldEntity.saveWithoutId(new CompoundTag());
        nbt.remove("Passengers");
        nbt.remove("UUID");
        newEntity.load(nbt);
        newEntity.moveTo(x, y, z, oldEntity.getYRot(), oldEntity.getXRot());
        level.addFreshEntity(newEntity);
        oldEntity.remove(Entity.RemovalReason.CHANGED_DIMENSION);
        return newEntity;
    }

    private static boolean validateOriginSign(ServerLevel level, BlockPos signPos) {
        boolean isValid = LinkHandler.isSignLinked((LevelAccessor)level, signPos);
        return isValid;
    }

    private static BlockPos findSafePosition(ServerLevel level, BlockPos center) {
        int dx = 0;
        while (dx <= 1) {
            int dz = 0;
            while (dz <= 1) {
                BlockPos checkPos = center.offset(dx, 0, dz);
                if (!ServerTeleportHandler.isHole(level, checkPos)) {
                    return checkPos;
                }
                dz = dz > 0 ? -dz : -dz + 1;
            }
            dx = dx > 0 ? -dx : -dx + 1;
        }
        return null;
    }

    private static boolean isHole(ServerLevel level, BlockPos pos) {
        for (int i = 0; i < 5; ++i) {
            BlockPos checkPos = pos.below(i);
            BlockState state = level.getBlockState(checkPos);
            if (state.isAir() || state.getCollisionShape((BlockGetter)level, checkPos, CollisionContext.empty()).isEmpty()) continue;
            return false;
        }
        return true;
    }

    private static double getAccurateYPosition(ServerLevel level, BlockPos pos) {
        for (int i = 0; i < 10; ++i) {
            BlockPos groundPos = pos.below(i);
            BlockState groundState = level.getBlockState(groundPos);
            VoxelShape shape = groundState.getCollisionShape((BlockGetter)level, groundPos, CollisionContext.empty());
            if (shape.isEmpty()) continue;
            return (double)groundPos.getY() + shape.max(Direction.Axis.Y);
        }
        return (double)pos.getY() + 1.0;
    }

    private static boolean isValidTeleportEntity(Entity entity) {
        String entityType = BuiltInRegistries.ENTITY_TYPE.getKey((Object)entity.getType()).toString();
        return !CommonConfig.invalid_entities.contains(entityType);
    }
}

