/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.tags;

import java.util.List;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.tags.TagBuilder;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.rasanovum.viaromana.CommonConfig;
import net.rasanovum.viaromana.ViaRomana;
import pers.solid.brrp.v1.api.RuntimeResourcePack;

public class TagGenerator {
    public static void generateAllTags(RuntimeResourcePack pack) {
        try {
            pack.clearResources(PackType.SERVER_DATA);
            TagKey pathBlockTagKey = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"via_romana", (String)"path_block"));
            TagKey warpBlockTagKey = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"via_romana", (String)"warp_block"));
            TagBuilder pathTagBuilder = TagGenerator.generatePathBlockTagBuilder();
            TagBuilder warpTagBuilder = TagGenerator.generateWarpBlockTagBuilder();
            pack.addTag(pathBlockTagKey, pathTagBuilder);
            pack.addTag(warpBlockTagKey, warpTagBuilder);
            ViaRomana.LOGGER.info("Successfully generated dynamic tags to runtime resource pack");
        }
        catch (Exception e) {
            ViaRomana.LOGGER.error("Failed to generate tag files", (Throwable)e);
        }
    }

    private static TagBuilder generatePathBlockTagBuilder() {
        TagBuilder tagBuilder = TagGenerator.generateBlockTagBuilder(CommonConfig.path_block_ids, CommonConfig.path_block_tags, CommonConfig.path_block_strings);
        return tagBuilder;
    }

    private static TagBuilder generateWarpBlockTagBuilder() {
        TagBuilder tagBuilder = TagGenerator.generateBlockTagBuilder(CommonConfig.warp_block_ids, CommonConfig.warp_block_tags, null);
        return tagBuilder;
    }

    private static TagBuilder generateBlockTagBuilder(List<String> explicitIds, List<String> tagStrings, List<String> searchStrings) {
        TagBuilder tagBuilder = TagBuilder.create();
        for (String blockId : explicitIds) {
            if (blockId.isEmpty() || TagGenerator.isBlacklistedBlock(blockId)) continue;
            try {
                ResourceLocation blockLocation = ResourceLocation.parse((String)blockId);
                tagBuilder.addElement(blockLocation);
            }
            catch (Exception e) {
                ViaRomana.LOGGER.warn("Invalid block ID in config: {}", (Object)blockId);
            }
        }
        for (String tagString : tagStrings) {
            if (tagString.isEmpty() || !TagGenerator.isModLoadedForTag(tagString) || TagGenerator.isBlacklistedBlock(tagString)) continue;
            try {
                ResourceLocation tagLocation = ResourceLocation.parse((String)tagString);
                tagBuilder.addTag(tagLocation);
            }
            catch (Exception e) {
                ViaRomana.LOGGER.warn("Invalid tag reference in config: {}", (Object)tagString);
            }
        }
        if (searchStrings != null && !searchStrings.isEmpty()) {
            block6: for (Block block : BuiltInRegistries.BLOCK) {
                ResourceLocation blockId = BuiltInRegistries.BLOCK.getKey((Object)block);
                String blockIdString = blockId.toString();
                if (TagGenerator.isBlacklistedBlock(blockIdString)) continue;
                for (String searchString : searchStrings) {
                    if (searchString.isEmpty() || !blockIdString.contains(searchString.toLowerCase())) continue;
                    tagBuilder.addElement(blockId);
                    continue block6;
                }
            }
        }
        return tagBuilder;
    }

    private static boolean isModLoadedForTag(String tagString) {
        try {
            ResourceLocation tagLocation = ResourceLocation.parse((String)tagString);
            String modId = tagLocation.getNamespace();
            return "minecraft".equals(modId) || FabricLoader.getInstance().isModLoaded(modId);
        }
        catch (Exception e) {
            ViaRomana.LOGGER.warn("Invalid tag format: '{}'", (Object)tagString);
            return false;
        }
    }

    private static boolean isBlacklistedBlock(String blockIdString) {
        for (String blacklistString : CommonConfig.block_string_blacklist) {
            if (blacklistString.isEmpty() || !blockIdString.contains(blacklistString.toLowerCase())) continue;
            ViaRomana.LOGGER.debug("Blacklisted block: '{}' from Via Romana block tag", (Object)blockIdString);
            return true;
        }
        return false;
    }
}

