/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.surveyor;

import folk.sisby.surveyor.WorldSummary;
import folk.sisby.surveyor.landmark.Landmark;
import folk.sisby.surveyor.landmark.Landmarks;
import folk.sisby.surveyor.landmark.WorldLandmarks;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.rasanovum.viaromana.CommonConfig;
import net.rasanovum.viaromana.ViaRomana;
import net.rasanovum.viaromana.path.Node;
import net.rasanovum.viaromana.surveyor.ViaRomanaLandmark;

public class ViaRomanaLandmarkManager {
    public static void initialize() {
        Landmarks.register(ViaRomanaLandmark.TYPE);
        ViaRomana.LOGGER.info("Initialized Via Romana Destination landmark type.");
    }

    public static void addDestinationLandmark(Level level, Node node) {
        if (!CommonConfig.enable_surveyor_landmark) {
            return;
        }
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        try {
            WorldSummary worldSummary = WorldSummary.of((Level)serverLevel);
            WorldLandmarks landmarks = worldSummary.landmarks();
            BlockPos nodePos = node.getBlockPos();
            if (landmarks.contains(ViaRomanaLandmark.TYPE, nodePos)) {
                landmarks.remove((Level)serverLevel, ViaRomanaLandmark.TYPE, nodePos);
            }
            if (node.getLinkType() != Node.LinkType.DESTINATION) {
                return;
            }
            ViaRomanaLandmark landmark = ViaRomanaLandmark.createDestination(serverLevel, node, nodePos);
            landmarks.put((Level)serverLevel, (Landmark)landmark);
        }
        catch (Exception e) {
            ViaRomana.LOGGER.warn("Failed to add destination landmark", (Throwable)e);
        }
    }

    public static void removeDestinationLandmark(Level level, Node node) {
        if (!CommonConfig.enable_surveyor_landmark) {
            return;
        }
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        try {
            WorldSummary worldSummary = WorldSummary.of((Level)serverLevel);
            WorldLandmarks landmarks = worldSummary.landmarks();
            BlockPos nodePos = node.getBlockPos();
            landmarks.remove((Level)serverLevel, ViaRomanaLandmark.TYPE, nodePos);
        }
        catch (Exception e) {
            ViaRomana.LOGGER.warn("Failed to remove destination landmark", (Throwable)e);
        }
    }
}

